/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.soc.controller.backup;

import com.xdja.log.analysis.aop.annoation.AopLog;
import com.xdja.safecenter.soc.controller.AbstractController;
import com.xdja.safecenter.soc.controller.HttpError;
import com.xdja.safecenter.soc.provider.backup.IQualityInspectionProvider;
import com.xdja.safecenter.soc.provider.backup.bean.BackupCardInfo;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class QualityInspectionController
extends AbstractController {
    @Autowired
    private IQualityInspectionProvider provider;

    @AopLog
    @RequestMapping(value={"/v1/backupCard/check/device"}, method={RequestMethod.GET})
    public Object checkDevice(HttpServletRequest req, HttpServletResponse resp) {
        this.logger.debug("\u6536\u5230\u9a8c\u8bc1\u68c0\u6d4b\u8bbe\u5907\u8eab\u4efd\u8bf7\u6c42");
        String cardNo = this.getChipID(req);
        if (!this.provider.checkDeviceIdentity(cardNo)) {
            this.logger.debug("\u9a8c\u8bc1\u68c0\u6d4b\u8bbe\u5907\u8eab\u4efd\u5931\u8d25\uff0c\u8bbe\u5907{}\u672a\u6388\u6743", (Object)cardNo);
            return HttpError.DEVICE_NOT_AUTHORIZATION.handle(resp);
        }
        this.logger.debug("\u9a8c\u8bc1\u68c0\u6d4b\u8bbe\u5907\u8eab\u4efd\u901a\u8fc7");
        return null;
    }

    @AopLog
    @RequestMapping(value={"/v1/backupCard/check/{sn}"}, method={RequestMethod.POST})
    public Object checkBackupCard(@PathVariable String sn, @RequestBody BackupCardInfo info, HttpServletRequest req, HttpServletResponse resp) {
        this.logger.debug("\u6536\u5230\u68c0\u6d4b\u5907\u4efd\u5361\u8bf7\u6c42");
        if (StringUtils.isBlank((CharSequence)sn) || null == info || StringUtils.isBlank((CharSequence)info.getbCode()) && StringUtils.isBlank((CharSequence)info.getrCode()) || StringUtils.isNotBlank((CharSequence)info.getbCode()) && StringUtils.isNotBlank((CharSequence)info.getrCode())) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
        }
        info.setSn(sn);
        int result = this.provider.checkBackupCard(this.getChipID(req), info);
        String resultMsg = "\u5907\u4efd\u5361\u68c0\u6d4b\u672a\u901a\u8fc7\uff0c\u539f\u56e0\uff1a{}";
        switch (result) {
            case 1: {
                this.logger.debug(resultMsg, (Object)"\u8bbe\u5907\u672a\u6388\u6743");
                return HttpError.DEVICE_NOT_AUTHORIZATION.handle(resp);
            }
            case 2: {
                this.logger.debug(resultMsg, (Object)"\u5907\u4efd\u5361\u4e0d\u5b58\u5728");
                return HttpError.BACKUP_CARD_NOT_EXIST.handle(resp);
            }
            case 3: {
                this.logger.debug(resultMsg, (Object)"\u5907\u4efd\u6821\u9a8c\u7801\u4e0d\u4e00\u81f4");
                return HttpError.BACKUP_CODE_NOT_ACCORDANCE.handle(resp);
            }
            case 4: {
                this.logger.debug(resultMsg, (Object)"\u6062\u590d\u6821\u9a8c\u7801\u4e0d\u4e00\u81f4");
                return HttpError.RESTORE_CODE_NOT_ACCORDANCE.handle(resp);
            }
            case 5: {
                this.logger.debug(resultMsg, (Object)"\u5907\u4efd\u5361\u5df2\u4f7f\u7528");
                return HttpError.BACKUP_CARD_ALREADY_USE.handle(resp);
            }
        }
        this.logger.debug("\u68c0\u6d4b\u5907\u4efd\u5361\u6210\u529f\uff0c\u5e8f\u5217\u53f7={}", (Object)sn);
        return null;
    }
}

