/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.soc.controller.reset;

import com.xdja.log.analysis.aop.annoation.AopLog;
import com.xdja.safecenter.soc.controller.AbstractController;
import com.xdja.safecenter.soc.controller.HttpError;
import com.xdja.safecenter.soc.provider.chip.IChipProvider;
import com.xdja.safecenter.soc.provider.chip.bean.ChipRequestReq;
import com.xdja.safecenter.soc.provider.chip.bean.RequestType;
import com.xdja.safecenter.soc.provider.pojo.ResultBean;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ChipResetPwdController
extends AbstractController {
    @Resource
    private IChipProvider chipProvider;

    @AopLog
    @RequestMapping(value={"/v1/password/reset/request/{dynamicCode}"}, method={RequestMethod.GET})
    public Object getResetRequest(@PathVariable String dynamicCode, HttpServletRequest req, HttpServletResponse resp) {
        this.logger.debug("\u6536\u5230\u82af\u7247\u91cd\u7f6e\u53e3\u4ee4\u8bf7\u6c42");
        if (StringUtils.isBlank((CharSequence)dynamicCode)) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
        }
        Map result = this.chipProvider.getChipRequest(this.getChipID(req), dynamicCode, RequestType.RESET_PWD);
        if (null == result || result.isEmpty()) {
            this.logger.debug("\u6ca1\u6709\u82af\u7247\u91cd\u7f6e\u53e3\u4ee4\u8bf7\u6c42");
            return HttpError.NOT_RESET_PWD_REQUEST.handle(resp);
        }
        this.logger.debug("\u83b7\u53d6\u82af\u7247\u91cd\u7f6e\u53e3\u4ee4\u8bf7\u6c42\u6267\u884c\u5b8c\u6210");
        return result;
    }

    @AopLog
    @RequestMapping(value={"/v1/password/reset/send/code"}, method={RequestMethod.POST})
    public Object sendResetSmsCode(HttpServletRequest req, HttpServletResponse resp) {
        this.logger.debug("\u6536\u5230\u53d1\u9001\u82af\u7247\u91cd\u7f6e\u53e3\u4ee4\u77ed\u4fe1\u9a8c\u8bc1\u7801\u8bf7\u6c42");
        int result = this.chipProvider.sendUnlockOrResetSmsCode(this.getChipID(req), RequestType.RESET_PWD);
        switch (result) {
            case 1: {
                this.logger.debug("\u53d1\u9001\u82af\u7247\u91cd\u7f6e\u53e3\u4ee4\u8bf7\u6c42\u77ed\u4fe1\u9a8c\u8bc1\u7801\u7ed3\u679c\uff1a\u77ed\u4fe1\u53d1\u9001\u6b21\u6570\u8d85\u9650");
                return HttpError.TRANSCEND_SMS_SEND_TIMES.handle(resp);
            }
            case 2: {
                this.logger.debug("\u53d1\u9001\u82af\u7247\u91cd\u7f6e\u53e3\u4ee4\u8bf7\u6c42\u77ed\u4fe1\u9a8c\u8bc1\u7801\u7ed3\u679c\uff1a\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
                return HttpError.FAIL_SEND_MESSAGE.handle(resp);
            }
            case 3: {
                this.logger.debug("\u53d1\u9001\u82af\u7247\u91cd\u7f6e\u53e3\u4ee4\u8bf7\u6c42\u77ed\u4fe1\u9a8c\u8bc1\u7801\u7ed3\u679c\uff1a\u82af\u7247\u672a\u7ed1\u5b9a\u624b\u673a\u53f7");
                return HttpError.CHIP_NOT_BIND_MOBILE.handle(resp);
            }
        }
        this.logger.debug("\u53d1\u9001\u82af\u7247\u91cd\u7f6e\u53e3\u4ee4\u77ed\u4fe1\u9a8c\u8bc1\u7801\u8bf7\u6c42\u6267\u884c\u5b8c\u6210");
        return null;
    }

    @AopLog
    @RequestMapping(value={"/v1/password/reset/request"}, method={RequestMethod.POST})
    public Object subResetRequest(@RequestBody ChipRequestReq req, HttpServletRequest request, HttpServletResponse resp) {
        this.logger.debug("\u6536\u5230\u63d0\u4ea4\u82af\u7247\u91cd\u7f6e\u53e3\u4ee4\u8bf7\u6c42");
        if (null == req || StringUtils.isBlank((CharSequence)req.getDynamicCode()) || StringUtils.isBlank((CharSequence)req.getSmsCode())) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
        }
        ResultBean result = this.chipProvider.subUnlockOrResetRequest(this.getChipID(request), req, RequestType.RESET_PWD);
        switch (result.getResult()) {
            case 1: {
                this.logger.debug("\u63d0\u4ea4\u82af\u7247\u91cd\u7f6e\u53e3\u4ee4\u8bf7\u6c42\u6267\u884c\u7ed3\u679c\uff1a\u65e0\u6548\u7684\u77ed\u4fe1\u9a8c\u8bc1\u7801");
                return HttpError.INVALID_CODE.handle(resp);
            }
            case 2: {
                this.logger.debug("\u63d0\u4ea4\u82af\u7247\u91cd\u7f6e\u53e3\u4ee4\u8bf7\u6c42\u6267\u884c\u7ed3\u679c\uff1a\u91cd\u7f6e\u53e3\u4ee4\u8bf7\u6c42\u5df2\u5b58\u5728");
                return HttpError.RESET_REQUEST_ALREADY_EXIST.handle(resp);
            }
        }
        this.logger.debug("\u63d0\u4ea4\u82af\u7247\u91cd\u7f6e\u53e3\u4ee4\u8bf7\u6c42\u6267\u884c\u5b8c\u6210");
        return result.getInfo();
    }

    @AopLog
    @RequestMapping(value={"/v1/password/reset/request/again"}, method={RequestMethod.POST})
    public Object againSubResetRequest(@RequestBody ChipRequestReq req, HttpServletRequest request, HttpServletResponse resp) {
        this.logger.debug("\u6536\u5230\u91cd\u65b0\u63d0\u4ea4\u82af\u7247\u91cd\u7f6e\u53e3\u4ee4\u8bf7\u6c42\u6267\u884c\u5b8c\u6210");
        if (null == req || StringUtils.isBlank((CharSequence)req.getDynamicCode())) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
        }
        ResultBean result = this.chipProvider.againSubUnlockOrResetRequest(this.getChipID(request), req.getDynamicCode(), RequestType.RESET_PWD);
        switch (result.getResult()) {
            case 2: {
                this.logger.debug("\u91cd\u65b0\u63d0\u4ea4\u82af\u7247\u91cd\u7f6e\u53e3\u4ee4\u8bf7\u6c42\u6267\u884c\u7ed3\u679c\uff1a\u91cd\u7f6e\u53e3\u4ee4\u8bf7\u6c42\u4e0d\u5b58\u5728");
                return HttpError.RESET_REQUEST_NOT_EXIST.handle(resp);
            }
        }
        this.logger.debug("\u91cd\u65b0\u63d0\u4ea4\u82af\u7247\u91cd\u7f6e\u53e3\u4ee4\u8bf7\u6c42\u6267\u884c\u5b8c\u6210");
        return result;
    }

    @AopLog
    @RequestMapping(value={"/v1/password/reset/{dynamicCode}/{camouflageCode}"}, method={RequestMethod.GET})
    public Object getDynamicUnlockCode(@PathVariable(value="dynamicCode") String dynamicCode, @PathVariable(value="camouflageCode") String camouflageCode, HttpServletRequest request, HttpServletResponse resp) {
        this.logger.debug("\u6536\u5230\u6839\u636e\u4f2a\u6388\u6743\u7801\u83b7\u53d6\u52a8\u6001\u6388\u6743\u7801\u8bf7\u6c42");
        if (StringUtils.isBlank((CharSequence)dynamicCode) || StringUtils.isBlank((CharSequence)camouflageCode)) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
        }
        Map result = this.chipProvider.getDynamicUnlockOrResetCode(this.getChipID(request), dynamicCode, camouflageCode, RequestType.RESET_PWD);
        if (null == result || result.isEmpty()) {
            this.logger.debug("\u6ca1\u6709\u67e5\u8be2\u5230\u52a8\u6001\u6388\u6743\u7801");
            return HttpError.NOT_QUERY_DYNAMIC_AUTH_CODE.handle(resp);
        }
        this.logger.debug("\u6839\u636e\u4f2a\u6388\u6743\u7801\u83b7\u53d6\u52a8\u6001\u6388\u6743\u7801\u8bf7\u6c42\u6267\u884c\u5b8c\u6210");
        return result;
    }
}

