/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.soc.controller.userinfo;

import com.xdja.log.analysis.aop.annoation.AopLog;
import com.xdja.safecenter.soc.controller.AbstractController;
import com.xdja.safecenter.soc.controller.HttpError;
import com.xdja.safecenter.soc.core.Constants;
import com.xdja.safecenter.soc.provider.pojo.ResultBean;
import com.xdja.safecenter.soc.provider.userinfo.IUserInfoProvider;
import com.xdja.safecenter.soc.provider.userinfo.bean.MobileReqBean;
import com.xdja.safecenter.soc.provider.userinfo.bean.MsgCodeBean;
import com.xdja.safecenter.soc.provider.userinfo.bean.UserInfoBean;
import com.xdja.safecenter.soc.provider.userinfo.bean.UserInfoRepBean;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserinfoController
extends AbstractController {
    @Resource
    private IUserInfoProvider userInfoProvider;

    @AopLog
    @RequestMapping(value={"/v1/identify"}, consumes={"application/json"}, method={RequestMethod.GET})
    public Object getIdentify(HttpServletRequest request, HttpServletResponse response) {
        this.logger.debug("\u83b7\u53d6\u82af\u7247\u5bf9\u5e94\u7684\u8eab\u4efd\u4fe1\u606f\u8bf7\u6c42");
        UserInfoRepBean bean = this.userInfoProvider.queryUserInfoByChipNo(this.getChipID(request));
        if (bean == null) {
            this.logger.debug("\u4e3a\u83b7\u53d6\u5230\u82af\u7247\u5bf9\u5e94\u7684\u8eab\u4efd\u4fe1\u606f chipID\uff1a" + this.getChipID(request));
            return HttpError.IDENTIFY_NOT_EXIST.handle(response);
        }
        this.logger.debug("\u83b7\u53d6\u82af\u7247\u5bf9\u5e94\u7684\u8eab\u4efd\u6267\u884c\u6210\u529f");
        return bean;
    }

    @AopLog
    @RequestMapping(value={"/v1/mobile/send/code"}, consumes={"application/json"}, method={RequestMethod.POST})
    public Object sendMsg(HttpServletRequest request, HttpServletResponse resp, @RequestBody MobileReqBean reqBean) {
        this.logger.debug("\u5f00\u59cb\u53d1\u9001\u7ed1\u5b9a\u624b\u673a\u53f7\u9a8c\u8bc1\u7801\u8bf7\u6c42");
        if (reqBean == null || StringUtils.isBlank((CharSequence)reqBean.getMobile())) {
            return HttpError.MISSING_REQUIRED_PARAMETERS.handle(resp);
        }
        String mobile = reqBean.getMobile();
        if (!this.checkMobile(mobile)) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
        }
        if (this.userInfoProvider.existBindMobile(this.getChipID(request))) {
            this.logger.debug("\u53d1\u9001\u7ed1\u5b9a\u624b\u673a\u53f7\u9a8c\u8bc1\u7801\u5931\u8d25, \u82af\u7247\u5df2\u7ed1\u5b9a\u624b\u673a\u53f7");
            return HttpError.CHIP_ALREADY_BIND_MOBILE.handle(resp);
        }
        int result = this.userInfoProvider.sendMsgCodeBind(this.getChipID(request), mobile);
        switch (result) {
            case 1: {
                this.logger.debug("\u53d1\u9001\u7ed1\u5b9a\u624b\u673a\u53f7\u77ed\u4fe1\u9a8c\u8bc1\u7801\u7ed3\u679c\uff1a\u77ed\u4fe1\u53d1\u9001\u6b21\u6570\u8d85\u9650");
                return HttpError.TRANSCEND_SMS_SEND_TIMES.handle(resp);
            }
            case 2: {
                this.logger.debug("\u53d1\u9001\u7ed1\u5b9a\u624b\u673a\u53f7\u77ed\u4fe1\u9a8c\u8bc1\u7801\u7ed3\u679c\uff1a\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
                return HttpError.FAIL_SEND_MESSAGE.handle(resp);
            }
            case 3: {
                this.logger.debug("\u53d1\u9001\u7ed1\u5b9a\u624b\u673a\u53f7\u77ed\u4fe1\u9a8c\u8bc1\u7801\u7ed3\u679c\uff1a\u82af\u7247\u672a\u7ed1\u5b9a\u624b\u673a\u53f7");
                return HttpError.CHIP_NOT_BIND_MOBILE.handle(resp);
            }
        }
        this.logger.debug("\u53d1\u9001\u7ed1\u5b9a\u624b\u673a\u53f7\u9a8c\u8bc1\u7801\u6267\u884c\u6210\u529f");
        return "";
    }

    @AopLog
    @RequestMapping(value={"/v1/mobile/bind"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public Object bindMobile(HttpServletRequest request, HttpServletResponse resp, @RequestBody MobileReqBean reqBean) {
        this.logger.debug("\u5f00\u59cb\u5904\u7406\u7ed1\u5b9a\u624b\u673a\u53f7\u8bf7\u6c42");
        if (reqBean == null || StringUtils.isBlank((CharSequence)reqBean.getSmsCode()) || StringUtils.isBlank((CharSequence)reqBean.getMobile())) {
            return HttpError.MISSING_REQUIRED_PARAMETERS.handle(resp);
        }
        if (!this.checkMobile(reqBean.getMobile())) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
        }
        if (this.userInfoProvider.checkMobileBindChipCount(reqBean.getMobile())) {
            this.logger.debug("\u7ed1\u5b9a\u624b\u673a\u53f7\u5931\u8d25\uff0c\u539f\u56e0\uff1a \u624b\u673a\u53f7\u7ed1\u5b9a\u82af\u7247\u6570\u91cf\u8fbe\u5230\u6700\u5927\u4e0a\u9650\u503c\uff1a{}", (Object)Constants.MOBILE_BIND_CHIP_COUNT);
            return HttpError.MOBILE_BIND_CHIP_COUNT_OVERRUN.handle(resp);
        }
        MsgCodeBean codeBean = this.userInfoProvider.getMsgCodeBind(this.getChipID(request));
        if (codeBean == null || !codeBean.getCode().equals(reqBean.getSmsCode())) {
            this.logger.debug("\u7ed1\u5b9a\u624b\u673a\u53f7\u5931\u8d25\uff0c\u9a8c\u8bc1\u7801\u65e0\u6548 mobile:{}, code:{}", (Object)reqBean.getMobile(), (Object)reqBean.getSmsCode());
            return HttpError.INVALID_CODE.handle(resp);
        }
        if (!codeBean.getMobile().equals(reqBean.getMobile())) {
            this.logger.debug("\u7ed1\u5b9a\u624b\u673a\u53f7\u5931\u8d25\uff0c\u624b\u673a\u53f7\u4e0d\u4e00\u81f4 mobile:{}, code:{}", (Object)reqBean.getMobile(), (Object)reqBean.getSmsCode());
            return HttpError.MOBILE_NOT_ACCORDANCE.handle(resp);
        }
        UserInfoBean bean = new UserInfoBean();
        bean.setChipId(this.getChipID(request));
        bean.setMobile(reqBean.getMobile());
        bean.setSn(this.getSN(request));
        this.userInfoProvider.doBindMobile(bean);
        this.logger.debug("\u5f3a\u5236\u7ed1\u5b9a\u624b\u673a\u53f7\u6267\u884c\u6210\u529f");
        return "";
    }

    @AopLog
    @RequestMapping(value={"/v1/mobile/bind/force"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public void bindMobileForce(HttpServletRequest request, HttpServletResponse response, @RequestBody MobileReqBean reqBean) {
        this.logger.debug("\u5f00\u59cb\u5904\u7406\u5f3a\u5236\u7ed1\u5b9a\u624b\u673a\u53f7\u8bf7\u6c42");
        if (reqBean == null || StringUtils.isBlank((CharSequence)reqBean.getSmsCode()) || StringUtils.isBlank((CharSequence)reqBean.getMobile())) {
            this.renderError(response, HttpError.MISSING_REQUIRED_PARAMETERS);
            return;
        }
        if (!this.checkMobile(reqBean.getMobile())) {
            this.renderError(response, HttpError.ILLEGAL_REQUEST_PARAMETER);
            return;
        }
        MsgCodeBean codeBean = this.userInfoProvider.getMsgCodeBind(this.getChipID(request));
        if (codeBean == null || !codeBean.getCode().equals(reqBean.getSmsCode())) {
            this.logger.debug("\u5f3a\u5236\u7ed1\u5b9a\u624b\u673a\u53f7\u5931\u8d25\uff0c\u9a8c\u8bc1\u7801\u65e0\u6548 mobile:{}, code:{}", (Object)reqBean.getMobile(), (Object)reqBean.getSmsCode());
            this.renderError(response, HttpError.INVALID_CODE);
            return;
        }
        if (!codeBean.getMobile().equals(reqBean.getMobile())) {
            this.logger.debug("\u5f3a\u5236\u7ed1\u5b9a\u624b\u673a\u53f7\u5931\u8d25\uff0c\u624b\u673a\u53f7\u4e0d\u4e00\u81f4 mobile:{}, code:{}", (Object)reqBean.getMobile(), (Object)reqBean.getSmsCode());
            this.renderError(response, HttpError.MOBILE_NOT_ACCORDANCE);
            return;
        }
        UserInfoBean bean = new UserInfoBean();
        bean.setChipId(this.getChipID(request));
        bean.setMobile(reqBean.getMobile());
        bean.setSn(this.getSN(request));
        this.userInfoProvider.doBindMobileForce(bean);
        this.logger.debug("\u5f3a\u5236\u7ed1\u5b9a\u624b\u673a\u53f7\u6267\u884c\u6210\u529f");
    }

    @AopLog
    @RequestMapping(value={"/v1/mobile/modify/send/code"}, consumes={"application/json"}, method={RequestMethod.POST})
    public Object sendModifyCode(HttpServletRequest request, HttpServletResponse resp, @RequestBody MobileReqBean reqBean) {
        this.logger.debug("\u5f00\u59cb\u5904\u7406\u53d1\u9001\u66f4\u6362\u624b\u673a\u53f7\u9a8c\u8bc1\u7801\u8bf7\u6c42");
        if (reqBean == null || StringUtils.isBlank((CharSequence)reqBean.getMobile())) {
            return HttpError.MISSING_REQUIRED_PARAMETERS.handle(resp);
        }
        String mobile = reqBean.getMobile();
        if (!this.checkMobile(mobile)) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
        }
        if (!this.userInfoProvider.existChip(this.getChipID(request))) {
            this.logger.debug("\u53d1\u9001\u66f4\u6362\u624b\u673a\u53f7\u77ed\u4fe1\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u539f\u56e0\uff1a \u82af\u7247\u4e0d\u5b58\u5728");
            return HttpError.CHIP_NOT_EXIST.handle(resp);
        }
        if (!this.userInfoProvider.existBindMobile(this.getChipID(request))) {
            this.logger.debug("\u53d1\u9001\u66f4\u6362\u624b\u673a\u53f7\u77ed\u4fe1\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u539f\u56e0\uff1a \u82af\u7247\u672a\u7ed1\u5b9a\u624b\u673a\u53f7");
            return HttpError.CHIP_NOT_BIND_MOBILE.handle(resp);
        }
        if (this.userInfoProvider.existMobileRelation(this.getChipID(request), mobile)) {
            this.logger.debug("\u53d1\u9001\u66f4\u6362\u624b\u673a\u53f7\u77ed\u4fe1\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a\u5f53\u524d\u82af\u7247,[chipId={},mobile={}]", (Object)this.getChipID(request), (Object)mobile);
            return HttpError.MOBILE_ALREADY_BIND.handle(resp);
        }
        int result = this.userInfoProvider.sendMsgCodeChange(this.getChipID(request), mobile);
        switch (result) {
            case 1: {
                this.logger.debug("\u53d1\u9001\u66f4\u6362\u624b\u673a\u53f7\u77ed\u4fe1\u9a8c\u8bc1\u7801\u7ed3\u679c\uff1a\u77ed\u4fe1\u53d1\u9001\u6b21\u6570\u8d85\u9650");
                return HttpError.TRANSCEND_SMS_SEND_TIMES.handle(resp);
            }
            case 2: {
                this.logger.debug("\u53d1\u9001\u66f4\u6362\u624b\u673a\u53f7\u77ed\u4fe1\u9a8c\u8bc1\u7801\u7ed3\u679c\uff1a\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
                return HttpError.FAIL_SEND_MESSAGE.handle(resp);
            }
        }
        this.logger.debug("\u53d1\u9001\u66f4\u6362\u624b\u673a\u53f7\u9a8c\u8bc1\u7801\u6267\u884c\u6210\u529f");
        return "";
    }

    @AopLog
    @RequestMapping(value={"/v1/mobile/modify"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public Object modifyMobile(HttpServletRequest request, HttpServletResponse resp, @RequestBody MobileReqBean reqBean) {
        this.logger.debug("\u5f00\u59cb\u5904\u7406\u66f4\u6362\u624b\u673a\u53f7\u8bf7\u6c42");
        if (reqBean == null || StringUtils.isBlank((CharSequence)reqBean.getSmsCode()) || StringUtils.isBlank((CharSequence)reqBean.getMobile())) {
            return HttpError.MISSING_REQUIRED_PARAMETERS.handle(resp);
        }
        if (!this.checkMobile(reqBean.getMobile())) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
        }
        if (this.userInfoProvider.checkMobileBindChipCount(reqBean.getMobile())) {
            this.logger.debug("\u66f4\u6362\u624b\u673a\u53f7\u5931\u8d25\uff0c\u539f\u56e0\uff1a  \u624b\u673a\u53f7\u7ed1\u5b9a\u82af\u7247\u6570\u91cf\u8fbe\u5230\u6700\u5927\u4e0a\u9650\u503c\uff1a{}", (Object)Constants.MOBILE_BIND_CHIP_COUNT);
            return HttpError.MOBILE_BIND_CHIP_COUNT_OVERRUN.handle(resp);
        }
        MsgCodeBean codeBean = this.userInfoProvider.getMsgCodeChange(this.getChipID(request));
        if (codeBean == null || !codeBean.getCode().equals(reqBean.getSmsCode())) {
            this.logger.debug("\u66f4\u6362\u624b\u673a\u53f7\u5931\u8d25\uff0c\u9a8c\u8bc1\u7801\u65e0\u6548 mobile:{}, code:{}", (Object)reqBean.getMobile(), (Object)reqBean.getSmsCode());
            return HttpError.INVALID_CODE.handle(resp);
        }
        if (!codeBean.getMobile().equals(reqBean.getMobile())) {
            this.logger.debug("\u66f4\u6362\u624b\u673a\u53f7\u5931\u8d25\uff0c\u624b\u673a\u53f7\u4e0d\u4e00\u81f4 mobile:{}, code:{}", (Object)reqBean.getMobile(), (Object)reqBean.getSmsCode());
            return HttpError.MOBILE_NOT_ACCORDANCE.handle(resp);
        }
        UserInfoBean bean = new UserInfoBean();
        bean.setChipId(this.getChipID(request));
        bean.setMobile(reqBean.getMobile());
        bean.setSn(this.getSN(request));
        this.userInfoProvider.doChangeMobile(bean);
        this.logger.debug("\u66f4\u6362\u624b\u673a\u53f7\u6267\u884c\u6210\u529f");
        return "";
    }

    @AopLog
    @RequestMapping(value={"/v1/mobile/modify/force"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public void modifyMobileForce(HttpServletRequest request, HttpServletResponse response, @RequestBody MobileReqBean reqBean) {
        this.logger.debug("\u5f00\u59cb\u5904\u7406\u53d1\u9001\u5f3a\u5236\u66f4\u6362\u624b\u673a\u53f7\u9a8c\u8bc1\u7801\u8bf7\u6c42");
        if (reqBean == null || StringUtils.isBlank((CharSequence)reqBean.getSmsCode()) || StringUtils.isBlank((CharSequence)reqBean.getMobile())) {
            this.renderError(response, HttpError.MISSING_REQUIRED_PARAMETERS);
            return;
        }
        if (!this.checkMobile(reqBean.getMobile())) {
            this.renderError(response, HttpError.ILLEGAL_REQUEST_PARAMETER);
            return;
        }
        MsgCodeBean codeBean = this.userInfoProvider.getMsgCodeChange(this.getChipID(request));
        if (codeBean == null || !codeBean.getCode().equals(reqBean.getSmsCode())) {
            this.logger.debug("\u5f3a\u5236\u66f4\u6362\u624b\u673a\u53f7\u5931\u8d25\uff0c\u9a8c\u8bc1\u7801\u65e0\u6548 mobile:{}, code:{}", (Object)reqBean.getMobile(), (Object)reqBean.getSmsCode());
            this.renderError(response, HttpError.INVALID_CODE);
            return;
        }
        if (!codeBean.getMobile().equals(reqBean.getMobile())) {
            this.logger.debug("\u5f3a\u5236\u66f4\u6362\u624b\u673a\u53f7\u5931\u8d25\uff0c\u624b\u673a\u53f7\u4e0d\u4e00\u81f4 mobile:{}, code:{}", (Object)reqBean.getMobile(), (Object)reqBean.getSmsCode());
            this.renderError(response, HttpError.MOBILE_NOT_ACCORDANCE);
            return;
        }
        UserInfoBean bean = new UserInfoBean();
        bean.setChipId(this.getChipID(request));
        bean.setMobile(reqBean.getMobile());
        bean.setSn(this.getSN(request));
        this.userInfoProvider.doChangeMobileForce(bean);
        this.logger.debug("\u53d1\u9001\u5f3a\u5236\u66f4\u6362\u624b\u673a\u53f7\u9a8c\u8bc1\u7801\u6267\u884c\u6210\u529f");
    }

    @AopLog
    @RequestMapping(value={"/v1/mobile/unbind"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public void delMobile(HttpServletRequest request, HttpServletResponse response, @RequestBody MobileReqBean reqBean) {
        this.logger.debug("\u5f00\u59cb\u5904\u7406\u5220\u9664\u6307\u5b9a\u624b\u673a\u53f7\u4e0e\u5f53\u524d\u82af\u7247\u7ed1\u5b9a\u5173\u7cfb\u8bf7\u6c42");
        if (!this.checkMobile(reqBean.getMobile())) {
            this.renderError(response, HttpError.ILLEGAL_REQUEST_PARAMETER);
            return;
        }
        this.userInfoProvider.delMobile(this.getChipID(request), reqBean.getMobile());
        this.logger.debug("\u5220\u9664\u6307\u5b9a\u624b\u673a\u53f7\u4e0e\u5f53\u524d\u82af\u7247\u7ed1\u5b9a\u5173\u7cfb\u6267\u884c\u6210\u529f");
    }

    @AopLog
    @RequestMapping(value={"/v1/mobile/multi/send/code"}, consumes={"application/json"}, method={RequestMethod.POST})
    public Object sendBindCodeMulti(HttpServletRequest request, HttpServletResponse resp, @RequestBody MobileReqBean reqBean) {
        this.logger.debug("\u5f00\u59cb(\u65b0)\u53d1\u9001\u7ed1\u5b9a\u624b\u673a\u53f7\u9a8c\u8bc1\u7801\u8bf7\u6c42");
        if (reqBean == null || StringUtils.isBlank((CharSequence)reqBean.getMobile())) {
            return HttpError.MISSING_REQUIRED_PARAMETERS.handle(resp);
        }
        String mobile = reqBean.getMobile();
        if (!this.checkMobile(mobile)) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
        }
        if (this.userInfoProvider.existBindMobile(this.getChipID(request))) {
            this.logger.debug("(\u65b0)\u53d1\u9001\u7ed1\u5b9a\u624b\u673a\u53f7\u9a8c\u8bc1\u7801\u5931\u8d25, \u82af\u7247\u5df2\u7ed1\u5b9a\u624b\u673a\u53f7");
            return HttpError.CHIP_ALREADY_BIND_MOBILE.handle(resp);
        }
        ResultBean resultBean = new ResultBean();
        resultBean.setResult(0);
        if (this.userInfoProvider.checkMobileBindChipCount(reqBean.getMobile())) {
            this.logger.debug("(\u65b0)\u53d1\u9001\u7ed1\u5b9a\u624b\u673a\u53f7\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u539f\u56e0\uff1a \u624b\u673a\u53f7\u7ed1\u5b9a\u82af\u7247\u6570\u91cf\u8fbe\u5230\u6700\u5927\u4e0a\u9650\u503c\uff1a{}", (Object)Constants.MOBILE_BIND_CHIP_COUNT);
            HashMap<String, Integer> info = new HashMap<String, Integer>();
            info.put("count", Constants.MOBILE_BIND_CHIP_COUNT);
            resultBean.setResult(1);
            resultBean.setInfo(info);
            return resultBean;
        }
        int result = this.userInfoProvider.sendMsgCodeBind(this.getChipID(request), mobile);
        switch (result) {
            case 1: {
                this.logger.debug("(\u65b0)\u53d1\u9001\u7ed1\u5b9a\u624b\u673a\u53f7\u77ed\u4fe1\u9a8c\u8bc1\u7801\u7ed3\u679c\uff1a\u77ed\u4fe1\u53d1\u9001\u6b21\u6570\u8d85\u9650");
                return HttpError.TRANSCEND_SMS_SEND_TIMES.handle(resp);
            }
            case 2: {
                this.logger.debug("(\u65b0)\u53d1\u9001\u7ed1\u5b9a\u624b\u673a\u53f7\u77ed\u4fe1\u9a8c\u8bc1\u7801\u7ed3\u679c\uff1a\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
                return HttpError.FAIL_SEND_MESSAGE.handle(resp);
            }
            case 3: {
                this.logger.debug("(\u65b0)\u53d1\u9001\u7ed1\u5b9a\u624b\u673a\u53f7\u77ed\u4fe1\u9a8c\u8bc1\u7801\u7ed3\u679c\uff1a\u82af\u7247\u672a\u7ed1\u5b9a\u624b\u673a\u53f7");
                return HttpError.CHIP_NOT_BIND_MOBILE.handle(resp);
            }
        }
        this.logger.debug("\u53d1\u9001(\u65b0)\u7ed1\u5b9a\u624b\u673a\u53f7\u9a8c\u8bc1\u7801\u6267\u884c\u6210\u529f");
        return resultBean;
    }

    @AopLog
    @RequestMapping(value={"/v1/mobile/multi/bind"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public Object bindMobileMulti(HttpServletRequest request, HttpServletResponse resp, @RequestBody MobileReqBean reqBean) {
        this.logger.debug("\u5f00\u59cb\u5904\u7406(\u65b0)\u7ed1\u5b9a\u624b\u673a\u53f7\u8bf7\u6c42");
        if (reqBean == null || StringUtils.isBlank((CharSequence)reqBean.getSmsCode()) || StringUtils.isBlank((CharSequence)reqBean.getMobile())) {
            return HttpError.MISSING_REQUIRED_PARAMETERS.handle(resp);
        }
        if (!this.checkMobile(reqBean.getMobile())) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
        }
        ResultBean resultBean = new ResultBean();
        resultBean.setResult(0);
        if (this.userInfoProvider.checkMobileBindChipCount(reqBean.getMobile())) {
            this.logger.debug("(\u65b0)\u7ed1\u5b9a\u624b\u673a\u53f7\u5931\u8d25\uff0c\u539f\u56e0\uff1a \u624b\u673a\u53f7\u7ed1\u5b9a\u82af\u7247\u6570\u91cf\u8fbe\u5230\u6700\u5927\u4e0a\u9650\u503c\uff1a{}", (Object)Constants.MOBILE_BIND_CHIP_COUNT);
            HashMap<String, Integer> info = new HashMap<String, Integer>();
            info.put("count", Constants.MOBILE_BIND_CHIP_COUNT);
            resultBean.setResult(1);
            resultBean.setInfo(info);
            return resultBean;
        }
        MsgCodeBean codeBean = this.userInfoProvider.getMsgCodeBind(this.getChipID(request));
        if (codeBean == null || !codeBean.getCode().equals(reqBean.getSmsCode())) {
            this.logger.debug("(\u65b0)\u7ed1\u5b9a\u624b\u673a\u53f7\u5931\u8d25\uff0c\u9a8c\u8bc1\u7801\u65e0\u6548 mobile:{}, code:{}", (Object)reqBean.getMobile(), (Object)reqBean.getSmsCode());
            return HttpError.INVALID_CODE.handle(resp);
        }
        if (!codeBean.getMobile().equals(reqBean.getMobile())) {
            this.logger.debug("(\u65b0)\u7ed1\u5b9a\u624b\u673a\u53f7\u5931\u8d25\uff0c\u624b\u673a\u53f7\u4e0d\u4e00\u81f4 mobile:{}, code:{}", (Object)reqBean.getMobile(), (Object)reqBean.getSmsCode());
            return HttpError.MOBILE_NOT_ACCORDANCE.handle(resp);
        }
        UserInfoBean bean = new UserInfoBean();
        bean.setChipId(this.getChipID(request));
        bean.setMobile(reqBean.getMobile());
        bean.setSn(this.getSN(request));
        this.userInfoProvider.doBindMobile(bean);
        this.logger.debug("(\u65b0)\u7ed1\u5b9a\u624b\u673a\u53f7\u6267\u884c\u6210\u529f");
        return resultBean;
    }

    @AopLog
    @RequestMapping(value={"/v1/mobile/multi/modify/send/code"}, consumes={"application/json"}, method={RequestMethod.POST})
    public Object sendModifyCodeMulti(HttpServletRequest request, HttpServletResponse resp, @RequestBody MobileReqBean reqBean) {
        this.logger.debug("\u5f00\u59cb\u5904\u7406(\u65b0)\u53d1\u9001\u66f4\u6362\u624b\u673a\u53f7\u9a8c\u8bc1\u7801\u8bf7\u6c42");
        if (reqBean == null || StringUtils.isBlank((CharSequence)reqBean.getMobile())) {
            return HttpError.MISSING_REQUIRED_PARAMETERS.handle(resp);
        }
        String mobile = reqBean.getMobile();
        if (!this.checkMobile(mobile)) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
        }
        if (!this.userInfoProvider.existChip(this.getChipID(request))) {
            this.logger.debug("(\u65b0)\u53d1\u9001\u66f4\u6362\u624b\u673a\u53f7\u77ed\u4fe1\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u539f\u56e0\uff1a \u82af\u7247\u4e0d\u5b58\u5728");
            return HttpError.CHIP_NOT_EXIST.handle(resp);
        }
        if (!this.userInfoProvider.existBindMobile(this.getChipID(request))) {
            this.logger.debug("(\u65b0)\u53d1\u9001\u66f4\u6362\u624b\u673a\u53f7\u77ed\u4fe1\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u539f\u56e0\uff1a \u82af\u7247\u672a\u7ed1\u5b9a\u624b\u673a\u53f7");
            return HttpError.CHIP_NOT_BIND_MOBILE.handle(resp);
        }
        if (this.userInfoProvider.existMobileRelation(this.getChipID(request), mobile)) {
            this.logger.debug("(\u65b0)\u53d1\u9001\u66f4\u6362\u624b\u673a\u53f7\u77ed\u4fe1\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a\u5f53\u524d\u82af\u7247,[chipId={},mobile={}]", (Object)this.getChipID(request), (Object)mobile);
            return HttpError.MOBILE_ALREADY_BIND.handle(resp);
        }
        ResultBean resultBean = new ResultBean();
        resultBean.setResult(0);
        if (this.userInfoProvider.checkMobileBindChipCount(reqBean.getMobile())) {
            this.logger.debug("(\u65b0)\u53d1\u9001\u66f4\u6362\u624b\u673a\u53f7\u77ed\u4fe1\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u539f\u56e0\uff1a  \u624b\u673a\u53f7\u7ed1\u5b9a\u82af\u7247\u6570\u91cf\u8fbe\u5230\u6700\u5927\u4e0a\u9650\u503c\uff1a{}", (Object)Constants.MOBILE_BIND_CHIP_COUNT);
            HashMap<String, Integer> info = new HashMap<String, Integer>();
            info.put("count", Constants.MOBILE_BIND_CHIP_COUNT);
            resultBean.setResult(1);
            resultBean.setInfo(info);
            return resultBean;
        }
        int result = this.userInfoProvider.sendMsgCodeChange(this.getChipID(request), mobile);
        switch (result) {
            case 1: {
                this.logger.debug("(\u65b0)\u53d1\u9001\u66f4\u6362\u624b\u673a\u53f7\u77ed\u4fe1\u9a8c\u8bc1\u7801\u7ed3\u679c\uff1a\u77ed\u4fe1\u53d1\u9001\u6b21\u6570\u8d85\u9650");
                return HttpError.TRANSCEND_SMS_SEND_TIMES.handle(resp);
            }
            case 2: {
                this.logger.debug("(\u65b0)\u53d1\u9001\u66f4\u6362\u624b\u673a\u53f7\u77ed\u4fe1\u9a8c\u8bc1\u7801\u7ed3\u679c\uff1a\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
                return HttpError.FAIL_SEND_MESSAGE.handle(resp);
            }
        }
        this.logger.debug("(\u65b0)\u53d1\u9001\u66f4\u6362\u624b\u673a\u53f7\u9a8c\u8bc1\u7801\u6267\u884c\u6210\u529f");
        return resultBean;
    }

    @AopLog
    @RequestMapping(value={"/v1/mobile/multi/modify"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public Object modifyMobileMulti(HttpServletRequest request, HttpServletResponse resp, @RequestBody MobileReqBean reqBean) {
        this.logger.debug("\u5f00\u59cb\u5904\u7406(\u65b0)\u66f4\u6362\u624b\u673a\u53f7\u8bf7\u6c42");
        if (reqBean == null || StringUtils.isBlank((CharSequence)reqBean.getSmsCode()) || StringUtils.isBlank((CharSequence)reqBean.getMobile())) {
            return HttpError.MISSING_REQUIRED_PARAMETERS.handle(resp);
        }
        if (!this.checkMobile(reqBean.getMobile())) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
        }
        ResultBean resultBean = new ResultBean();
        resultBean.setResult(0);
        if (this.userInfoProvider.checkMobileBindChipCount(reqBean.getMobile())) {
            this.logger.debug("(\u65b0)\u66f4\u6362\u624b\u673a\u53f7\u5931\u8d25\uff0c\u539f\u56e0\uff1a  \u624b\u673a\u53f7\u7ed1\u5b9a\u82af\u7247\u6570\u91cf\u8fbe\u5230\u6700\u5927\u4e0a\u9650\u503c\uff1a{}", (Object)Constants.MOBILE_BIND_CHIP_COUNT);
            HashMap<String, Integer> info = new HashMap<String, Integer>();
            info.put("count", Constants.MOBILE_BIND_CHIP_COUNT);
            resultBean.setResult(1);
            resultBean.setInfo(info);
            return resultBean;
        }
        MsgCodeBean codeBean = this.userInfoProvider.getMsgCodeChange(this.getChipID(request));
        if (codeBean == null || !codeBean.getCode().equals(reqBean.getSmsCode())) {
            this.logger.debug("(\u65b0)\u66f4\u6362\u624b\u673a\u53f7\u5931\u8d25\uff0c\u9a8c\u8bc1\u7801\u65e0\u6548 mobile:{}, code:{}", (Object)reqBean.getMobile(), (Object)reqBean.getSmsCode());
            return HttpError.INVALID_CODE.handle(resp);
        }
        if (!codeBean.getMobile().equals(reqBean.getMobile())) {
            this.logger.debug("(\u65b0)\u66f4\u6362\u624b\u673a\u53f7\u5931\u8d25\uff0c\u624b\u673a\u53f7\u4e0d\u4e00\u81f4 mobile:{}, code:{}", (Object)reqBean.getMobile(), (Object)reqBean.getSmsCode());
            return HttpError.MOBILE_NOT_ACCORDANCE.handle(resp);
        }
        UserInfoBean bean = new UserInfoBean();
        bean.setChipId(this.getChipID(request));
        bean.setMobile(reqBean.getMobile());
        bean.setSn(this.getSN(request));
        this.userInfoProvider.doChangeMobile(bean);
        this.logger.debug("(\u65b0)\u66f4\u6362\u624b\u673a\u53f7\u6267\u884c\u6210\u529f");
        return resultBean;
    }
}

