package com.xdja.api;


import android.os.Handler;
import android.util.Log;

import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.cryptodev.driver.chipmanager.ChipManagerDriver;
import com.xdja.cryptodev.driver.xdja.XdjaDevDriver;
import com.xdja.sslvpn.sslvpnJNI;
import com.xdja.sslvpn.sslvpn_callback;
import com.xdja.sslvpn.sslvpn_cert;
import com.xdja.sslvpn.sslvpn_cert_type;
import com.xdja.sslvpn.sslvpn_device_type;
import com.xdja.util.CertUtil;


/**
 * Created by xingjianqiang on 2019/2/13.
 */

public abstract class SSLVPNCallback extends sslvpn_callback {

    private static final String THIS_FILE = "SSLVPNCallback";
    private Handler mHandler = new Handler();

    @Override
    public String dev_get_pin(int sessionId, int devType, int role) {
        return null;
    }

    @Override
    public final void notify_user(final int sessionId, final int deviceId, int role) {
        CryptoDevType cryptoDevType = sslvpn_device_type.lookupCryptoDevType(deviceId);
        final CryptoInstance instance = CryptoDevManager.getInstance().createInstance(ChipManagerDriver.DRIVER_NAME, cryptoDevType);
        int status = -1;

        boolean deviceAvail = false;

        if (instance != null) {
            status = instance.open();
            if (status == 0) {
                deviceAvail = true;
            }
        }
        if (!deviceAvail) {
            if (deviceId == sslvpn_device_type.SSLVPN_DEVICE_CHIP.getValue()) {
                Log.e(THIS_FILE, "No device found");
                notify_no_device(sessionId);
            } else {
                mHandler.post(new Runnable() {
                    @Override
                    public void run() {
                        // not last device call dev next
                        sslvpnJNI.session_dev_next(sessionId, deviceId);
                    }
                });
            }
        } else {
            // device exists
            SessionConfig config = SSLVPNApi.getInstance().getSessionMap().get(sessionId);
            final sslvpn_cert sign_cert = sslvpn_cert.create_sslvpn_cert();
            final sslvpn_cert exch_cert = sslvpn_cert.create_sslvpn_cert();
            
            int container = config.getContainer();
            if (config.getCertType() == SessionConfig.CERT_SIGN) {
                status = instance.readCert(XdjaDevDriver.getSignCertFidOfContainer(container), sign_cert.getCert_buf(), sign_cert.getCert_len_array());
                int type = CertUtil.parseCertType(sign_cert.getCert_buf(), sign_cert.getCert_len_array()[0]);
                sign_cert.setCert_len(sign_cert.getCert_len_array()[0]);
                sign_cert.setCert_type(type == CertUtil.CERT_TYPE_RSA ? sslvpn_cert_type.SSLVPN_CERT_TYPE_RSA.getValue() :
                        sslvpn_cert_type.SSLVPN_CERT_TYPE_SM2.getValue());
                if (type == CertUtil.CERT_TYPE_RSA) {
                    int bits = CertUtil.getRsaPubkeyBits(sign_cert.getCert_buf(), sign_cert.getCert_len_array()[0]);
                    sign_cert.setPubkey_bits(bits);
                } else {
                    sign_cert.setPubkey_bits(CertUtil.CERT_SM2_BITS);
                }
            } else {
                status = instance.readCert(XdjaDevDriver.getExchCertFidOfContainer(container), exch_cert.getCert_buf(), exch_cert.getCert_len_array());
                int type = CertUtil.parseCertType(exch_cert.getCert_buf(), exch_cert.getCert_len_array()[0]);
                exch_cert.setCert_len(exch_cert.getCert_len_array()[0]);
                exch_cert.setCert_type(type == CertUtil.CERT_TYPE_RSA ? sslvpn_cert_type.SSLVPN_CERT_TYPE_RSA.getValue() :
                        sslvpn_cert_type.SSLVPN_CERT_TYPE_SM2.getValue());
                if (type == CertUtil.CERT_TYPE_RSA) {
                    int bits = CertUtil.getRsaPubkeyBits(exch_cert.getCert_buf(), exch_cert.getCert_len_array()[0]);
                    exch_cert.setPubkey_bits(bits);
                } else {
                    exch_cert.setPubkey_bits(CertUtil.CERT_SM2_BITS);
                }
            }

            mHandler.post(new Runnable() {
                @Override
                public void run() {
                    sslvpnJNI.session_dev_pin_success(sessionId, deviceId, instance.getCardId(), "111111", sign_cert, exch_cert);
                }
            });

            }


        }



    /**
     * 没有找到加密设备
     * @param sessionId
     */
    public abstract void notify_no_device(int sessionId);

}
