package com.xdja.sslvpn;

/**
 * Created by xingjianqiang on 2017/12/18.
 * Project : safeclient.android
 * Email : xingjianqiang@xdja.com
 */

/**
 * sslvpn模块错误码
 */
public class SSLVPNErrorCode {

    public static final int SSLVPN_OK = 0;

    public static final int SSLVPN_ERRNO_START = 170000;
    public static final int SSLVPN_ERRNO_END = 219999;

    public static final int SSLVPN_BASE_ERROR = SSLVPN_ERRNO_START + 1;

    // sslvpn module error(171000 ~ 171999)
    public static final int SSLVPN_MDL_HANDLE_FAILED                        =(SSLVPN_ERRNO_START+1000);   //  句柄无效
    public static final int SSLVPN_MDL_PARAM_FAILED                         =(SSLVPN_ERRNO_START+1001);   //  参数无效
    public static final int SSLVPN_MDL_CARD_NONIN                           =(SSLVPN_ERRNO_START+1002);   //  安全卡未初始化或未认证
    public static final int SSLVPN_MDL_THREADSTART_FAILED                   =(SSLVPN_ERRNO_START+1003);   //  工作线程启动失败

    // sslvpn network error(172000 ~ 172999)
    public static final int SSLVPN_NET_SOCK_ERROR                           =(SSLVPN_ERRNO_START+2000);   //  网络异常
    public static final int SSLVPN_IP_INVALID                               =(SSLVPN_ERRNO_START+2001);   //  IP地址无效
    public static final int SSLVPN_CONN_ERROR                               =(SSLVPN_ERRNO_START+2002);   //  连接错误
    public static final int SSLVPN_SEND_DATA_ERROR                          =(SSLVPN_ERRNO_START+2003);   //  发送数据失败
    public static final int SSLVPN_NET_REC_DATA_ERROR                       =(SSLVPN_ERRNO_START+2004);   //  接收数据失败
    public static final int SSLVPN_NET_REC_TIMEOUT                          =(SSLVPN_ERRNO_START+2005);   //  接收数据超时
    public static final int SSLVPN_NET_NO_PPP                               =(SSLVPN_ERRNO_START+2006);   //  没有建立拨号连接
    public static final int SSLVPN_NET_PPP_FAILD                            =(SSLVPN_ERRNO_START+2007);   //  拨号连接错误
    public static final int SSLVPN_NET_PPP_DISCONN                          =(SSLVPN_ERRNO_START+2008);   //  拨号连接已经断开
    public static final int SSLVPN_NET_DATA_BIG                             =(SSLVPN_ERRNO_START+2009);   //  数据过大
    public static final int SSLVPN_NET_DATA_INVALID                         =(SSLVPN_ERRNO_START+2010);   //  数据无效
    public static final int SSLVPN_NET_DATABUF_MIN                          =(SSLVPN_ERRNO_START+2011);   //  接收数据
    public static final int SSLVPN_NET_REMOTE_DISCONN                       =(SSLVPN_ERRNO_START+2012);   //  远程主机强行关闭
    public static final int SSLVPN_NET_DISCONNECT                           =(SSLVPN_ERRNO_START+2013);   //  系统无可用网络
    public static final int SSLVPN_CONNECT_TIMEOUT                          =(SSLVPN_ERRNO_START+2014);   //  系统无可用网络
    public static final int SSLVPN_RESOLVE_GATEWAY_ADDRESS_FAILED           =(SSLVPN_ERRNO_START+2015);   //  解析网关地址失败


    // sslvpn verify error(173000 ~ 173999)
    public static final int SSLVPN_BAD_OPTION_ERROR                         =(SSLVPN_ERRNO_START+3000);  //  选项解析失败
    public static final int SSLVPN_NO_OPTION_ERROR                          =(SSLVPN_ERRNO_START+3001);  //  缺少必需的选项
    public static final int SSLVPN_HANDSHAKE_ERROR                          =(SSLVPN_ERRNO_START+3002);  //  SSL握手错误
    public static final int SSLVPN_CLTHELLO_ERROR                           =(SSLVPN_ERRNO_START+3003);  //  客户端CLIENTHELLO错误
    public static final int SSLVPN_SVRHELLO_ERROR                           =(SSLVPN_ERRNO_START+3004);  //  服务端SERVERHELLO错误
    public static final int SSLVPN_GETROOTCERT_ERROR                        =(SSLVPN_ERRNO_START+3005);  //  读取根证书错误
    public static final int SSLVPN_GETSVRCERT_ERROR                         =(SSLVPN_ERRNO_START+3006);  //  读取服务器证书错误
    public static final int SSLVPN_VERIFYSERVERCERT_ERROR                   =(SSLVPN_ERRNO_START+3007);  //  验证服务器证书失败
    public static final int SSLVPN_GETSVRPUBKEY_ERROR                       =(SSLVPN_ERRNO_START+3008);  //  取服务端公钥
    public static final int SSLVPN_CERT_UNSUPPERED                          =(SSLVPN_ERRNO_START+3009);  //  证书不被支持
    public static final int SSLVPN_CERT_REVOKED                             =(SSLVPN_ERRNO_START+3010);  //  证书已经撤消
    public static final int SSLVPN_CERT_EXPIRED                             =(SSLVPN_ERRNO_START+3011);  //  证书过期
    public static final int SSLVPN_CERT_UNKNOWN                             =(SSLVPN_ERRNO_START+3012);  //  证书不可信
    public static final int SSLVPN_UNKNOWN_CA                               =(SSLVPN_ERRNO_START+3013);  //  未知CA
    public static final int SSLVPN_CERT_FROZEN                              =(SSLVPN_ERRNO_START+3014);  //  证书被冻结
    public static final int SSLVPN_SVRKEYEXCHANGE_ERROR                     =(SSLVPN_ERRNO_START+3015);  //  服务端密钥交换错误
    public static final int SSLVPN_CLTCERTREQ_ERROR                         =(SSLVPN_ERRNO_START+3016);  //  客户端证书请求错误
    public static final int SSLVPN_GETCLTCERT_ERROR                         =(SSLVPN_ERRNO_START+3017);  //  取客户端证书失败
    public static final int SSLVPN_CLTCERTVERIFY_ERROR                      =(SSLVPN_ERRNO_START+3018);  //  客户端证书校验错误
    public static final int SSLVPN_CLTCERTINVALID_ERROR                     =(SSLVPN_ERRNO_START+3019);  //  客户端证书无效
    public static final int SSLVPN_CERT_NOT_YET_VALID_ERROR                 =(SSLVPN_ERRNO_START+3020);  //  证书还未到有效开始时间
    public static final int SSLVPN_CLTCIPHERSPEC_ERROR                      =(SSLVPN_ERRNO_START+3021);  //  客户端交换加密算法失败
    public static final int SSLVPN_CLTKEYEXCHANGE_ERROR                     =(SSLVPN_ERRNO_START+3022);  //  客户端交换密钥错误
    public static final int SSLVPN_TRANSMASTERSECRET_ERROR                  =(SSLVPN_ERRNO_START+3023);  //  转换主密钥失败
    public static final int SSLVPN_SECRETMEMALLO_ERROR                      =(SSLVPN_ERRNO_START+3024);  //  密钥分配内存失败
    public static final int SSLVPN_CHANGECIPHERSPAC_ERROR                   =(SSLVPN_ERRNO_START+3025);  //  交换加密说明错误
    public static final int SSLVPN_TIME_ERROR                               =(SSLVPN_ERRNO_START+3026);  //  SSL协商时间校验失败，请确认系统当前时间
    public static final int SSLVPN_FINISHED_ERROR                           =(SSLVPN_ERRNO_START+3027);  //  结束消息错误
    public static final int SSLVPN_SVRCIPHERSPEC_ERROR                      =(SSLVPN_ERRNO_START+3028);  //  交换加密说明失败
    public static final int SSLVPN_ENCRYPTDATA_ERROR                        =(SSLVPN_ERRNO_START+3029);  //  加密数据失败
    public static final int SSLVPN_DECRYPTDATA_ERROR                        =(SSLVPN_ERRNO_START+3030);  //  解密数据失败
    public static final int SSLVPN_HASHCHECK_ERROR                          =(SSLVPN_ERRNO_START+3031);  //  摘要检验出错
    public static final int SSLVPN_SERIVCE_UNESTABLISH                      =(SSLVPN_ERRNO_START+3032);  //  针对浙江电信项目,网关返回0x13 标记当前客户端服务未开通
    public static final int SSLVPN_GROUP_UNESTABLISH                        =(SSLVPN_ERRNO_START+3033);  //  针对浙江电信项目,标记当前客户集团服务未开通
    public static final int SSLVPN_RECORDMAC_BAD                            =(SSLVPN_ERRNO_START+3034);  //  传输过程记录标签无效
    public static final int SSLVPN_MESSAGE_UNEXPECTED                       =(SSLVPN_ERRNO_START+3035);  //  记录消息无效


    // sslvpn application error(174000 ~ 174999)
    public static final int SSLVPN_CHECK_CLIENT_FAILED                      =(SSLVPN_ERRNO_START+4000);   //  检测终端信息失败//ACL格式不对，可能网关没配置监听端口
    public static final int SSLVPN_CLIENT_INFO_FAILD                        =(SSLVPN_ERRNO_START+4001);   //  终端状态认证失败
    public static final int SSLVPN_CLIENT_NO_POWERS                         =(SSLVPN_ERRNO_START+4002);   //  终端无任何权限
    public static final int SSLVPN_TF_VERIFY_FAILED                         =(SSLVPN_ERRNO_START+4003);   //  安全TF卡认证失败
    public static final int SSLVPN_START_SSL_FAILED                         =(SSLVPN_ERRNO_START+4004);   //  启动SSL认证服务失败
    public static final int SSLVPN_VERIFY_TFID_FAILED                       =(SSLVPN_ERRNO_START+4100);   //  TF卡号校验失败
    public static final int SSLVPN_VERIFY_IMEI_FAILED                       =(SSLVPN_ERRNO_START+4101);   //  手机IMEI校验失败
    public static final int SSLVPN_VERIFY_IMSI_FAILED                       =(SSLVPN_ERRNO_START+4102);   //  IMSI校验失败
    public static final int SSLVPN_INFOCOLLECT_WAITAUDIT                    =(SSLVPN_ERRNO_START+4103);   //  信息已收集，待审核
    public static final int SSLVPN_VERIFY_INTERFACE_ERROR                   =(SSLVPN_ERRNO_START+4104);   //  认证接口未知错误
    public static final int SSLVPN_USERINFO_NOEXIST                         =(SSLVPN_ERRNO_START+4105);   //  用户信息不存在
    public static final int SSLVPN_SERVICE_PAUSE                            =(SSLVPN_ERRNO_START+4106);   //  服务暂停状态
    public static final int SSLVPN_BIND_VERIFY_FAIL                         =(SSLVPN_ERRNO_START+4107);   //  三方绑定验证(上传)失败
    public static final int SSLVPN_UNKNOWN_ISBIND                           =(SSLVPN_ERRNO_START+4108);   //  未知是否绑定,待扩展
    public static final int SSLVPN_MESSAGE_FORMAT_FAIL                      =(SSLVPN_ERRNO_START+4109);   //  三方信息认证失败消息格式不全
    public static final int SSLVPN_DEVICE_NONE                              =(SSLVPN_ERRNO_START+4111);   //  检测不到加密设备

    public static final int SSLVPN_TAP_START_FAILED                         =220010;   //  虚拟网卡启动失败
    public static final int SSLVPN_TAP_SETIP_FAILED                         =(SSLVPN_ERRNO_START+4201);   //  虚拟网卡IP设置失败
    public static final int SSLVPN_TAP_ROUTE_FAILED                         =(SSLVPN_ERRNO_START+4202);   //  添加路由信息失败
    public static final int SSLVPN_TAP_ADD_DNS_FAILED                       =(SSLVPN_ERRNO_START+4203);   //  添加dns失败

    public static final int SSLVPN_TP_NOT_READY                             =(SSLVPN_ERRNO_START+4300);   //  ssl transport is not ready
    public static final int SSLVPN_SERVER_HEARTBEAT_TIMEOUT                 =(SSLVPN_ERRNO_START+4301);   //  get server heartbeat timeout
    public static final int SSLVPN_USER_CANCELED                            =(SSLVPN_ERRNO_START+4302);   //  user cancel connect
    public static final int SSLVPN_TSC_BUFFER_IN_PROGRESS                   =(SSLVPN_ERRNO_START+4303);   //  需要继续接收TSC数据
    public static final int SSLVPN_CLIENT_CERT_CONFIG_ERROR                 =(SSLVPN_ERRNO_START+4304);   //  客户端CA或者证书配置错误
    public static final int SSLVPN_LOAD_PRIKEY_ERROR                        =(SSLVPN_ERRNO_START+4306);   //  load prikey error
    public static final int SSLVPN_CLIENT_NO_CERT                           =(SSLVPN_ERRNO_START+4307);   //  客户端证书不存在

    // xssl error(175000 ~ 175999)
    public static final int SSLVPN_XSSL_E_INVAL                             =(SSLVPN_ERRNO_START+5001);   //  invalid argument
    public static final int SSLVPN_XSSL_E_NOENT                             =(SSLVPN_ERRNO_START+5002);   //  no entry, not found
    public static final int SSLVPN_XSSL_E_NOMEM                             =(SSLVPN_ERRNO_START+5003);   //  no memory
    public static final int SSLVPN_XSSL_E_NIMPL                             =(SSLVPN_ERRNO_START+5004);   //  no implement
    public static final int SSLVPN_XSSL_E_INTAL                             =(SSLVPN_ERRNO_START+5005);   //  intal error
    public static final int SSLVPN_XSSL_E_CANCEL                            =(SSLVPN_ERRNO_START+5006);   //  canceled
    public static final int SSLVPN_XSSL_E_EXIST                             =(SSLVPN_ERRNO_START+5007);   //  already exist
    public static final int SSLVPN_XSSL_E_2LONG                             =(SSLVPN_ERRNO_START+5008);   //  too long
    public static final int SSLVPN_XSSL_E_BADMSG                            =(SSLVPN_ERRNO_START+5009);   //  bad msg, wrong data
    public static final int SSLVPN_XSSL_E_CRYPTO                            =(SSLVPN_ERRNO_START+5010);   //  crypto calc error
    public static final int SSLVPN_XSSL_E_FULL                              =(SSLVPN_ERRNO_START+5011);   //  buffer or queue is full
    public static final int SSLVPN_XSSL_E_INPROGRESS                        =(SSLVPN_ERRNO_START+5012);   //  operation now in progress
    public static final int SSLVPN_XSSL_E_AGAIN                             =(SSLVPN_ERRNO_START+5101);   //  try again
    public static final int SSLVPN_XSSL_E_ACCESS                            =(SSLVPN_ERRNO_START+5102);   //  access denied
    public static final int SSLVPN_XSSL_E_UNEXPECT                          =(SSLVPN_ERRNO_START+5103);   //  unexpect msg, can ignore
    public static final int SSLVPN_XSSL_E_NEEDSEND                          =(SSLVPN_ERRNO_START+5104);   //  have data need send
    public static final int SSLVPN_XSSL_E_SHUTDOWN                          =(SSLVPN_ERRNO_START+5105);   //  xssl should shutdown
    public static final int SSLVPN_XSSL_E_TYPE                              =(SSLVPN_ERRNO_START+5110);   //  bad record type
    public static final int SSLVPN_XSSL_E_VERSION                           =(SSLVPN_ERRNO_START+5111);   //  bad protocol version
    public static final int SSLVPN_XSSL_E_ILLEGAL                           =(SSLVPN_ERRNO_START+5112);   //  illegal param
    public static final int SSLVPN_XSSL_E_MAC_CRYPTO                        =(SSLVPN_ERRNO_START+5113);   //  mac crypto error
    public static final int SSLVPN_XSSL_E_MAC_UNMATCH                       =(SSLVPN_ERRNO_START+5114);   //  mac unmatch
    public static final int SSLVPN_XSSL_E_PADDING                           =(SSLVPN_ERRNO_START+5115);   //  padding error


    //系统网络错误
    public static final int SLLVPN_PERR_REFUSE_CONNECT                          = 120111;                 //peer Connection refused
    public static final int SLLVPN_NET_ERROR                                    = 120110;
    public static final int SSLVPN_NO_ROUTE_TO_HOST                             = 120113;

}
