package com.xdja.sslvpn;

import java.util.ArrayList;

/**
 * Created by xingjianqiang on 2017/12/18.
 * Project : safeclient.android
 * Email : xingjianqiang@xdja.com
 */

public class SSLVPNSessionInfo {

    private int id;

    private int transportMode;
    // 错误码
    private int lastErrorCode;

    // 通道建立时间
    private long startTime;

    // 通道是否建立成功
    private boolean established;

    // 被保护子网
    private ArrayList<TunRouteInfo> subnetList = new ArrayList<>();

    // 监听端口
    private ArrayList<ForwardAclRule> forwardAclList = new ArrayList<>();

    // 接收数据大小（字节）
    private long recvSize;

    // 发送数据大小（字节）
    private long sendSize;

    private int reconnectCount;

    //网络延迟
    private int networkDelay;

    //底层协议
    private int protocol;

    //卡号
    private String cardId;
    // 设备变化是否重连
    private boolean reconnectOnDevChanged;

    // 当前状态
    private int state;


    public int getState() {
        return state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getCardId() {
        return cardId;
    }

    public void setCardId(String cardId) {
        this.cardId = cardId;
    }


    public boolean isReconnectOnDevChanged() {
        return reconnectOnDevChanged;
    }

    public void setReconnectOnDevChanged(boolean reconnectOnDevChanged) {
        this.reconnectOnDevChanged = reconnectOnDevChanged;
    }

    public String getSubnet(){
        StringBuilder subnetBuilder = new StringBuilder();
        if (transportMode == sslvpn_session_mode.SSLVPN_TRANSPORT_MODE_TUN.getValue()||transportMode== sslvpn_session_mode.SSLVPN_TRANSPORT_MODE_ALL.getValue()) {
            for (int i=0;i<subnetList.size();i++) {
                TunRouteInfo routeInfo = subnetList.get(i);
                subnetBuilder.append(routeInfo.getAddr());
                subnetBuilder.append("/");
                subnetBuilder.append(routeInfo.getPrefixLen());
                if (i < (subnetList.size()-1)) {
                    subnetBuilder.append("\n");
                }
            }
        }
        return subnetBuilder.toString();
    }

    public String getForwardAcl(){
        StringBuilder aclBuilder = new StringBuilder();
        if (transportMode == sslvpn_session_mode.SSLVPN_TRANSPORT_MODE_FORWARD.getValue()||transportMode== sslvpn_session_mode.SSLVPN_TRANSPORT_MODE_ALL.getValue()) {
            for (int i=0;i<forwardAclList.size();i++) {
                ForwardAclRule rule = forwardAclList.get(i);
                aclBuilder.append(rule.getListenPort());
                if (i < (forwardAclList.size()-1))
                    aclBuilder.append(",");
            }
        }
        return aclBuilder.toString();
    }

    public int getTransportMode() {
        return transportMode;
    }

    public void setTransportMode(int transportMode) {
        this.transportMode = transportMode;
    }

    public boolean isEstablished() {
        return established;
    }

    public void setEstablished(boolean established) {
        this.established = established;
    }

    public ArrayList<TunRouteInfo> getSubnetList() {
        return subnetList;
    }

    public void addTunRoute(String ipAddress, int prefixLen) {
        TunRouteInfo tunRouteInfo = new TunRouteInfo();
        tunRouteInfo.setAddr(ipAddress);
        tunRouteInfo.setPrefixLen(prefixLen);
        tunRouteInfo.setAddSuccessed(true);
        subnetList.add(tunRouteInfo);
    }

    public void addForwardAcl(int port) {
        ForwardAclRule forwardAclRule = new ForwardAclRule();
        forwardAclRule.setListenPort(port);
        forwardAclRule.setAddSuccessed(true);
        forwardAclList.add(forwardAclRule);
    }

    public ArrayList<ForwardAclRule> getForwardAclList() {
        return forwardAclList;
    }

    public long getRecvSize() {
        return recvSize;
    }

    public void setRecvSize(int recvSize) {
        this.recvSize = recvSize;
    }

    public long getSendSize() {
        return sendSize;
    }

    public void setSendSize(int sendSize) {
        this.sendSize = sendSize;
    }

    public int getReconnectCount() {
        return reconnectCount;
    }

    public void setReconnectCount(int reconnectCount) {
        this.reconnectCount = reconnectCount;
    }

    public int getNetworkDelay() {
        return networkDelay;
    }

    public void setNetworkDelay(int networkDelay) {
        this.networkDelay = networkDelay;
    }

    public int getLastErrorCode() {
        return lastErrorCode;
    }

    public void setLastErrorCode(int lastErrorCode) {
        this.lastErrorCode = lastErrorCode;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public long getStartTime() {
        return startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public int getProtocol() {
        return protocol;
    }

    public void setProtocol(int protocol) {
        this.protocol = protocol;
    }

    @Override
    public String toString() {
        return "SSLVPNSessionInfo{" +
                "id=" + id +
                ", transportMode=" + transportMode +
                ", lastErrorCode=" + lastErrorCode +
                ", startTime=" + startTime +
                ", established=" + established +
                ", subnetList=" + subnetList +
                ", forwardAclList=" + forwardAclList +
                ", recvSize=" + recvSize +
                ", sendSize=" + sendSize +
                ", reconnectCount=" + reconnectCount +
                ", networkDelay=" + networkDelay +
                ", protocol=" + protocol +
                ", reconnectOnDevChanged=" + reconnectOnDevChanged +
                '}';
    }
}
