package com.xdja.sslvpn;

import java.util.List;

/**
 * Created by xingjianqiang on 2017/12/1.
 * Project : safeclient.android
 * Email : xingjianqiang@xdja.com
 */

public class sslvpnJNI {

    // load library
    static {
        System.loadLibrary("tun");
        System.loadLibrary("sslvpn_jni");
        System.loadLibrary("xcrypto_java");
    }

    /**
     * sslvpn系统创建
     * @return
     */
    public static native int sslvpn_create();

    /**
     * sslvpn初始化配置，并启动工作线程
     * @param vpn_cfg
     * @param logging_config
     * @return
     */
    public static native int sslvpn_init(sslvpn_config vpn_cfg, sslvpn_logging_config logging_config, sslvpn_callback reciever);

    /**
     * sslvpn创建session
     * @param session_config session配置
     * @param p_session_id 返回创建session的id（用于操作session）
     * @return
     */
    public static native int sslvpn_session_create(sslvpn_session_config session_config,
                                            sslvpn_transport_config transport_config,
                                            sslvpn_device_config[] device_config,
                                            int[] p_session_id);

    public static native void sslvpn_reconfigure_logging(sslvpn_logging_config logging_config);
    /**
     * 连接session
     * @param session_id
     * @return
     */
    public static native int sslvpn_session_connect(int session_id);

    public static native int sslvpn_session_connect_domain(int session_id, String ip);

    /**
     * 停止session
     * @param session_id
     * @return
     */
    public static native int sslvpn_session_stop(int session_id, int cause);

    /**
     * 销毁session
     * @param session_id
     * @return
     */
    public static native int sslvpn_session_destroy(int session_id);

    /**
     * 停止所有session
     * @return
     */
    public static native int sslvpn_session_stop_all();
    /**
     * 销毁sslvpn
     * @return
     */
    public static native int sslvpn_destroy();

    /**
     * 获取session信息
     * @param session_id
     * @param session_info
     * @return
     */
    public static native int session_get_info(int session_id, SSLVPNSessionInfo session_info);


    public static native void session_dev_pin_success(int session_id, int dev_type,
                                                      String cardId, String pin, sslvpn_cert sign_cert, sslvpn_cert exch_cert);
    public static native void session_dev_next(int session_id, int dev_type);

    /**
     * 告知底层session无可用加密设备
     * @param session_id
     */
    public static native void session_dev_none(int session_id);


    /**
     * 获取错误码对应的错误描述信息
     * @param code 错误码
     * @return 错误描述
     */
    public static native String sslvpn_get_error_text(int code);

    public static native void sslvpn_get_data_status(long[] recvSize, long[] sendSize);


    /**
     * 网络切换或者屏幕点亮触发session重连
     * @param session_id
     */
    public static native void sslvpn_session_reconnect(int session_id, boolean networkSwitched);

    /**
     * 网络切换或者屏幕点亮出发所有session重连
     * @param networkSwitched
     */
    public static native void sslvpn_session_reconnect_all(boolean networkSwitched);

    public static native int sslvpn_get_native_key(byte[] native_key);

    /**
     * 同步日志文件
     */
    public static native void sslvpn_flush_log();

    public static native int sslvpn_set_sessionIpList(int session_id, List<sslvpn_serverip_config> ipist);

}
