package com.xdja.sslvpn;

import com.xdja.cryptodev.CryptoDevType;

/**
 * Created by xingjianqiang on 2018/4/10.
 */

public enum sslvpn_device_type {

    SSLVPN_DEVICE_CHIP(1) {
        @Override
        CryptoDevType getType(int deviceId) {
            return CryptoDevType.DEV_TYPE_Chip;
        }
    },
    SSLVPN_DEVICE_TF(2) {
        @Override
        CryptoDevType getType(int deviceId) {
            return CryptoDevType.DEV_TYPE_SdCard;
        }
    },
    SSLVPN_DEVICE_COVER(3) {
        @Override
        CryptoDevType getType(int deviceId) {
            return CryptoDevType.DEV_TYPE_SimKey;
        }
    },
    SSLVPN_DEVICE_SOFT(4) {
        @Override
        CryptoDevType getType(int deviceId) {
            return CryptoDevType.DEV_TYPE_Soft;
        }
    };

    int value;

    sslvpn_device_type(int i) {
        this.value = i;
    }

    public int getValue() {
        return value;
    }

    abstract CryptoDevType getType(int deviceId);

    public static CryptoDevType lookupCryptoDevType(int deviceId){
        CryptoDevType defaultDevType = CryptoDevType.DEV_TYPE_Chip;
        for(sslvpn_device_type type : sslvpn_device_type.values()){
            if(type.getValue() == deviceId){
                defaultDevType = type.getType(deviceId);
                break;
            }
        }
        return defaultDevType;
    }

}
