package com.xdja.sslvpn;

import android.content.Context;
import android.telephony.TelephonyManager;
import android.util.Log;

import com.xdja.SafeKey.JNIAPI;

import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.cryptodev.driver.chipmanager.ChipManagerDriver;
import com.xdja.cryptodev.driver.xdja.XdjaDevDriver;

/**
 * Created by wanghao on 2017/12/22.
 * 终端信息上报对象
 * 构造对应的终端信息，传递给底层接口
 */

public class sslvpn_terminal_callback {

    private static final String THIS_FILE = "terminal_callback";

    public static String getImsi(){
        Context context = SSLVPNModule.getInstance().getContext();
        String imsi = "000000000000000";
        if(context == null){
            return imsi;
        }
        TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        if (telephonyManager.getSimState() != TelephonyManager.SIM_STATE_READY) {
            return imsi;
        } else {
            imsi = telephonyManager.getSubscriberId();
        }
        return imsi;
    }

    public static String getImei(){
        Context context = SSLVPNModule.getInstance().getContext();
        String imei = "000000000000000";
        if(context == null){
            return imei;
        }
        TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        String deviceId = telephonyManager.getDeviceId();
        if(deviceId == null){
            return imei;
        }else{
            imei = deviceId;
        }
        return imei;
    }

    public static String getOS(){
        return "ANDROID";
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder buf = new StringBuilder(bytes.length * 2);
        for(byte b : bytes) { // 使用String的format方法进行转换
            buf.append(String.format("%02x", new Integer(b & 0xff)));
        }

        return buf.toString();
    }

    public static String getProjectTag(String cardId, String pin) {
        int ret;
        byte[] tag = new byte[64];
        CryptoInstance instance = CryptoDevManager.getInstance().createInstance(cardId);
        if (instance == null) {
            Log.e(THIS_FILE, "Card id " + cardId + " NOT exist!");
            return null;
        }

        ret = instance.open();
        if (ret != 0) {
            Log.e(THIS_FILE, "Card " + cardId + " open failed, return " + ret);
            return null;
        }

        ret = instance.verifyPIN(pin, JNIAPI.ROLE_A); // TODO 看此处到底使用什么角色
        if (ret != 0) {
            Log.e(THIS_FILE, "Pin failed return " + ret);
            instance.destroy();
            return null;
        }

        // test
//        String TEST_TAG = "WHSJ";
//        byte[] taghash = new byte[32];
//        ret = chipInstance.SM3(TEST_TAG.getBytes(), TEST_TAG.length(), taghash);
//        if (ret != 0) {
//            Log.e(THIS_FILE, "SM3 hash failed " + CryptoDevManager.getInstance().getErrorText(ret));
//            instance.destroy();
//            return null;
//        }
//
//        String taghashStr = bytesToHexString(taghash);
//
//        Log.d(THIS_FILE, "Taghashstr: " + taghashStr);
//        ret = instance.writeFile(XdjaDevDriver.PROJECT_TAG_FID, 0, XdjaDevDriver.PROJECT_TAG_LENGTH, taghashStr.getBytes());
//        if (ret != 0) {
//            Log.e(THIS_FILE, "Write file return " + ret);
//            instance.destroy();
//            return null;
//        }

        ret = instance.readFile(XdjaDevDriver.PROJECT_TAG_FID, 0, XdjaDevDriver.PROJECT_TAG_LENGTH, tag);
        if (ret != 0) {
            Log.e(THIS_FILE, "Read project tag error, reason " + CryptoDevManager.getInstance().getErrorText(ret));
            instance.reset();
            instance.destroy();
            return null;
        }

        String tagStr = new String(tag);
        Log.d(THIS_FILE, "Get project tag " + tagStr);
        return tagStr;

    }

}
