package com.xdja.sslvpn.utils;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.os.Build;

/**
 * Created by xingjianqiang on 2017/12/5.
 * Project : safeclient.android
 * Email : xingjianqiang@xdja.com
 */

public class Compatibility {
    private Compatibility(){}

    private static final String THIS_FILE = "Compat";

    public static int getApiLevel() {
        return android.os.Build.VERSION.SDK_INT;
    }

    public static boolean isCompatible(int apiLevel) {
        return android.os.Build.VERSION.SDK_INT >= apiLevel;
    }

    /**
     * Wrapper to set alarm at exact time
     * @see android.app.AlarmManager#setExact(int, long, PendingIntent)
     */
    @TargetApi(Build.VERSION_CODES.KITKAT)
    public static void setExactAlarm(AlarmManager alarmManager, int alarmType, long firstTime,
                                     PendingIntent pendingIntent) {
        if(isCompatible(Build.VERSION_CODES.KITKAT)) {
            alarmManager.setExact(alarmType, firstTime, pendingIntent);
        }else {
            alarmManager.set(alarmType, firstTime, pendingIntent);
        }
    }
}
