package com.xdja.sslvpn.utils;

import android.os.PowerManager;
import android.util.Log;

import java.util.HashSet;

/**
 * Created by xingjianqiang on 2017/12/5.
 * Project : safeclient.android
 * Email : xingjianqiang@xdja.com
 */

public class SSLVPNWakeLock {
    private static final String THIS_FILE = "SSLVPNWakeLock";
    private PowerManager mPowerManager;
    private PowerManager.WakeLock mWakeLock;
    private PowerManager.WakeLock mTimerWakeLock;
    private HashSet<Object> mHolders = new HashSet<Object>();

    public SSLVPNWakeLock(PowerManager powerManager) {
        mPowerManager = powerManager;
    }

    /**
     * Release this pin_locked and reset all holders
     */
    public synchronized void reset() {
        mHolders.clear();
        release(null);
        if( mWakeLock != null ) {
            while(mWakeLock.isHeld()) {
                mWakeLock.release();
            }
            Log.v(THIS_FILE, "~~~ hard reset wakelock :: still held : " + mWakeLock.isHeld());
        }
    }

    public synchronized void acquire(long timeout) {
        if (mTimerWakeLock == null) {
            mTimerWakeLock = mPowerManager.newWakeLock(
                    PowerManager.PARTIAL_WAKE_LOCK, "SSLVPNWakeLock.timer");
            mTimerWakeLock.setReferenceCounted(true);
        }
        mTimerWakeLock.acquire(timeout);
    }

    public synchronized void acquire(Object holder) {
        mHolders.add(holder);
        if (mWakeLock == null) {
            mWakeLock = mPowerManager.newWakeLock(
                    PowerManager.PARTIAL_WAKE_LOCK, "SSLVPNWakeLock");
        }
        if (!mWakeLock.isHeld()) mWakeLock.acquire();
        Log.v(THIS_FILE, "acquire wakelock: holder count="
                + mHolders.size());
    }

    public synchronized void release(Object holder) {
        mHolders.remove(holder);
        if ((mWakeLock != null) && mHolders.isEmpty()
                && mWakeLock.isHeld()) {
            mWakeLock.release();
        }

        Log.v(THIS_FILE, "onDestroy wakelock: holder count="
                + mHolders.size());
    }
}
