package com.xdja.tun;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.VpnService;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.support.annotation.RequiresApi;
import android.util.Log;

import com.xdja.util.AppSHAUtil;
import com.xdja.util.DnsServerDetector;

import java.io.IOException;
import java.util.ArrayList;

/**
 * Created by xingjianqiang on 2017/11/23.
 * Project : sslvpn-client
 * Email : xingjianqiang@xdja.com
 */

public class TunProxy {

    private TunVpnService.BuilderFactory factory;
    private VpnService.Builder builder;
    private ParcelFileDescriptor parcelFileDescriptor = null;
    public static PendingIntent pendingIntent = null;
    private static final int INVALID_TUN_FD = -1;

    private static final int TUN_FAILED = -1;
    private static final int TUN_SUCCESS = 0;

    private boolean vpnShowing = false;
    private boolean needRestart = false;
    private static Context context = null;

    private static final String THIS_FILE = "TunProxy";
    private static TunProxy proxy = null;
    private TunProxy(){}



    public boolean isVPNDialogShowing() {
        return vpnShowing;
    }

    public void setVPNDialogShowing(boolean isShowing) {
        vpnShowing = isShowing;
    }

    public static TunProxy getInstance() {
        if (proxy == null) {
            Intent intent = new Intent(context, VpnConfirmActivity.class);
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(intent);
            proxy = new TunProxy();
        }
        return proxy;
    }

    /**
     * 设置tunproxy上下文
     * @param c context
     */
    public static void setAppContext(Context c) {
        context = c;
    }

    public void setBuilderFactory(TunVpnService.BuilderFactory factory) {
        this.factory = factory;
    }

    private int init() {
        //TODO 用户不允许启动虚拟网卡，应做相应的处理，并且TunVPNService 不应该在Application的时候启动
        if (factory == null)
        {
            return TUN_FAILED;
        }
        builder = factory.createBuilder();
        return TUN_SUCCESS;
    }


    private int addAddress(String address, int prefixLen) {
        try {
            Log.d(THIS_FILE, "TUN add address " + address + "/" + prefixLen);
            builder.addAddress(address, prefixLen);
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
            return TUN_FAILED;
        }

        return TUN_SUCCESS;
    }

    private int addRoute(String address, int prefixLen) {
        try {
            Log.d(THIS_FILE, "TUN add route " + address + "/" + prefixLen);
            builder.addRoute(address, prefixLen);
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
            return TUN_FAILED;
        }
        return TUN_SUCCESS;
    }

    private int addDnsServer(String address) {
        try {
            Log.d(THIS_FILE, "TUN add dns server " + address);
            builder.addDnsServer(address);
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
            return TUN_FAILED;
        }
        return TUN_SUCCESS;
    }
    private int addDnsServerFinish()
    {
        DnsServerDetector dnsServerDetector = new DnsServerDetector(context);
        String[] servers = dnsServerDetector.getServers();
        for (int i=0; i<servers.length; i++)
        {
            builder.addDnsServer(servers[i]);
        }
        return TUN_SUCCESS;
    }

    private int setMtu(int mtu) {
        try {
            Log.d(THIS_FILE, "TUN set MTU " + mtu);
            builder.setMtu(mtu);
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
            return TUN_FAILED;
        }

        return TUN_SUCCESS;
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    private void processAppAclWhiteList(ArrayList<AppAcl> aclList) {
        try {
            // 添加本包名
            builder.addAllowedApplication(context.getPackageName());
            Log.d(THIS_FILE, "add safeclient to white list");
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

        if (aclList.isEmpty()) {
            Log.d(THIS_FILE, "White list empty");
            return;
        }

        for(AppAcl acl:aclList) {
            if (AppSHAUtil.pkgHashIsexist(context, acl.getPackageName(), acl.getHash())) {
                try {
                    builder.addAllowedApplication(acl.getPackageName());
                } catch (PackageManager.NameNotFoundException e) {
                    e.printStackTrace();
                }
            } else {
                Log.e(THIS_FILE, "packge " + acl.getPackageName() + " hash " + acl.getHash() + " not found is system");
            }
        }
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    private void processAppAclBlackList(ArrayList<AppAcl> aclList) {
        if (aclList.isEmpty()) {
            Log.d(THIS_FILE, "Black list empty");
            return;
        }

        for(AppAcl acl:aclList) {
            if (AppSHAUtil.pkgHashIsexist(context, acl.getPackageName(), acl.getHash())) {
                try {
                    builder.addDisallowedApplication(acl.getPackageName());
                } catch (PackageManager.NameNotFoundException e) {
                    e.printStackTrace();
                }
            } else {
                Log.e(THIS_FILE, "packge " + acl.getPackageName() + " hash " + acl.getHash() + " not found is system");
            }
        }
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    private int addAppAclList(ArrayList<AppAcl> aclList, int appAclType) {
        // process list
        if (appAclType == 1) {
            processAppAclWhiteList(aclList);
        } else if (appAclType == 0){
            processAppAclBlackList(aclList);
        } else {
            Log.d(THIS_FILE, "Do nothing!!! app acl type " + appAclType);
        }
        return 0;
    }


    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    private int addAppAcl(String hash, String pkgname, String common, int iswhite)
    {
        if (AppSHAUtil.pkgHashIsexist(context,pkgname, hash) == true) {
            try {
            if (iswhite == 1) {
                    builder.addAllowedApplication(pkgname);
            }else {
                builder.addDisallowedApplication(pkgname);
            }
            } catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        return TUN_SUCCESS;
    }

    private int establish(int[] tunFd) {
        try {
            if (parcelFileDescriptor != null) {
                return TUN_FAILED;
            }

            parcelFileDescriptor = builder.setSession("vpnsession").setConfigureIntent(pendingIntent).establish();
            tunFd[0] = parcelFileDescriptor.getFd();
            needRestart = false;
        } catch (Exception e) {
            e.printStackTrace();
            return TUN_FAILED;
        }

        return TUN_SUCCESS;
    }

    private void close() {
        // close tun
        if (parcelFileDescriptor != null) {
            try {
                parcelFileDescriptor.close();
                parcelFileDescriptor = null;
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        builder = null;
    }

    public boolean needRestart() {
        return needRestart;
    }

    public void setNeedRestart(boolean need) {
        this.needRestart = need;
    }


}
