package com.xdja.tun;

import android.content.Intent;
import android.util.Log;

import com.xdja.sslvpn.sslvpnJNI;

public class TunVpnService extends android.net.VpnService {

    private static final String THIS_FILE = "VpnService";
    private BuilderFactory factory = new BuilderFactory();

    public class BuilderFactory {
        public Builder createBuilder() {
            return new Builder();
        }
    }

    @Override
    public void onCreate() {
        TunProxy.getInstance().setBuilderFactory(factory);
        super.onCreate();
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        return super.onStartCommand(intent, flags, startId);
    }

    @Override
    public void onRevoke() {
        Log.e(THIS_FILE, "TunVpnService onRevoke");
        TunProxy.getInstance().setNeedRestart(true);
        sslvpnJNI.sslvpn_session_reconnect_all(true);
        super.onRevoke();
    }
}
