package com.xdja.tun;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.util.Log;

public class VpnConfirmActivity extends Activity {

    private static final String TAG = "VpnConfirmActivity";
    private static final int START_VPN = 0;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        this.getWindow().getDecorView().setBackgroundColor(Color.TRANSPARENT);
        // start vpn bindService
        Intent intent = android.net.VpnService.prepare(this);
        if (intent != null) {
            if (!TunProxy.getInstance().isVPNDialogShowing()) {
                startActivityForResult(intent, START_VPN);
                TunProxy.getInstance().setVPNDialogShowing(true);
            } else { // VPN dialog is showing
                finish();
            }
        } else {
            onActivityResult(START_VPN, RESULT_OK, null);
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        setVisible(true);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);

        if (requestCode == START_VPN) {
            TunProxy.getInstance().setVPNDialogShowing(false);
            if (resultCode != RESULT_OK) {
                Log.e(TAG, "User reject tun permission!!!");
            } else {
                Intent intent = new Intent(this, TunVpnService.class);
                startService(intent);

            }
        }
        finish();
    }
}
