package com.xdja.util;


import android.text.TextUtils;
import android.util.Log;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;

/**
 * Created by xingjianqiang on 2018/9/28.
 */

public class CertUtil {
    public static final int CERT_TYPE_UNKOWN = 0;
    public static final int CERT_TYPE_RSA = 1;
    public static final int CERT_TYPE_SM2 = 2;
    public static final int CERT_SM2_BITS = 256;

//    public static final String SM2_ALG_PARAM_ID = "1.2.156.10197.1.301";
//    public static final String RSA_ALG_ID = "1.2.840.113549.1.1.1";

    private static final String THIS_FILE = "CertUtil";

    /**
     * 判断证书类型是RSA还是SM2
     * @param certBuf 证书buffer
     * @param certLength 证书buffer长度
     * @return
     */
    public static int parseCertType(byte[] certBuf, int certLength) {
        ByteArrayInputStream in = new ByteArrayInputStream(certBuf, 0, certBuf.length);

        X509Certificate x509 = null;
        try {
            x509 = (X509Certificate) CertificateFactory.getInstance("X.509", "BC").generateCertificate(in);
            in.close();
        } catch (Exception e) {
            e.printStackTrace();
            try {
                in.close();
            } catch (IOException e1) {
                e1.printStackTrace();
            }
        }

        if (x509 != null) {
            String alg = x509.getSigAlgName();
            Log.d(THIS_FILE, "Cert alg name ==== " + alg);
            if (!TextUtils.isEmpty(alg)) {
                if (alg.contains("RSA")) {
                    return CERT_TYPE_RSA;
                } else if (alg.contains("SM2")) {
                    return CERT_TYPE_SM2;
                }
            }
        }
        return CERT_TYPE_SM2;
    }


    /***/
    public static int getRsaPubkeyBits(byte[] cert, int certlen)
    {

        ByteArrayInputStream in = new ByteArrayInputStream(cert, 0, certlen);

        X509Certificate x509;
        try {
            x509 = (X509Certificate) CertificateFactory.getInstance("X.509").generateCertificate(in);
            in.close();
        } catch (Exception e) {
            return 1024;
        }
        RSAPublicKey key = (RSAPublicKey) x509.getPublicKey();
        BigInteger inte = key.getModulus();
        // key = x509.getPublicKey();
        return inte.bitLength();
    }
}
