package com.xdja.autoupdate;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.content.pm.PackageManager.NameNotFoundException;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Environment;
import com.xdja.safeclient.utils.Log;

import android.view.WindowManager;
import android.widget.Toast;

import com.xdja.safeclient.Function;
import com.xdja.safeclient.R;
import com.xdja.safeclient.utils.Compatibility;
import com.xdja.safeclient.utils.StringUtil;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import static com.xdja.safeclient.utils.StringUtil.getStringRes;

public class SCAutoUpdate {
    /**
     * Called when the activity is first created.
     */

    // 本地版本信息
    public static String serverIP = ""; // 升级服务器IP
    public static String serverPort = "";// 升级服务端端口
    private static String factory = ""; // 手机厂商
    private static String mod = ""; // 手机型号
    private static String os = ""; // 手机操作系统
    private static String soft = ""; // 升级软件名称
    private static String username = "";// 用户
    private static ArrayList<SCVersionInfo> verList = new ArrayList<SCVersionInfo>();// 版本历史升级列表

    // 升级配置信息
    private static String version = ""; // 最新版本号
    private static String date = ""; // 版本发布时间
    private static String comment = ""; // 注释信息
    private static String updatetag = "";// 更新类型
    // private String deleteDb = "";// 是否删除数据库checkCode
    // private String checkCode = "";// 版本内容校验码

    private String tempversion = "";

    private static ArrayList<SCFileInfo> fileList = new ArrayList<SCFileInfo>();

    public static SCUpdateSocket sl = null;// 网络监听
    public static Context context = null;
    // public final static String shared_prefs =
    // "data/data/com.xdja.mxtchat/shared_prefs/mxtchat.xml";
    // public static UpdateListener uplisten = null;
    //public static final String localDir = "/data/data/" + UserCache.packageName;

    public static String packageName = "";
    public static String privateDir = "";


    private static String TAG = "SCAutoUpdate";


    //private static boolean flag = false; // 记录是否正在执行标识
    private static AtomicInteger atomicInteger = new AtomicInteger(0);
    /**
     * 调用升级程序入口
     *
     * @return
     */
    /*public static void updateStart(Context context) {

        if (!flag) {
            packageName = context.getPackageName();
            privateDir = context.getFilesDir().getPath();
            SCAutoUpdate.context = context;
            SCAutoUpdate g = new SCAutoUpdate();


            CheckVerTask checktask = g.new CheckVerTask(false);
            checktask.execute();
            flag = true;

        }

    }*/

    static boolean isMainActivity = false;

    public static void updateStart(Context context, boolean isShowDialog,boolean isMain){
        updateStart(context,isShowDialog);
        isMainActivity = isMain;
    }

    /**
     * 调用升级程序入口
     *
     * @return
     */
    public static void updateStart(Context context, boolean isShowDialog) {
        packageName = context.getPackageName();
        privateDir = context.getFilesDir().getPath();
        SCAutoUpdate.context = context;

        if (isShowDialog == false) {
            if (updateSilence() == true) {
                Log.d(TAG, "need update");
                return;
            } else {
                Log.d(TAG, "not update");
            }
        }

        if(atomicInteger.get() == 0){
            SCAutoUpdate g = new SCAutoUpdate();
            CheckVerTask checktask = g.new CheckVerTask(isShowDialog);
            checktask.execute();
        }else{
            Log.i(TAG,"check is running");
        }
    }

    private static boolean updateSilence() {

        // 解析文件
        ParseVersionInfo(privateDir + "/ClientVer.xml");

        File file = new File(privateDir + "/update_s.xml");
        if (file.exists() == false) {
            Log.d(TAG, "update_s.xml not exists");
            return false;
        }

        boolean res = ParseConfigInfo("update_s.xml");// 解析升级配置信息
        if (res == false) {
            // 删除update_s.xml文件
            file.delete();
            // "解析update_s.xml失败");
            //flag = false;
            Log.e(TAG, "ParseConfigInfo failed");

            return false;
        }

        String verName = "";
        try {
            verName = context.getPackageManager().getPackageInfo(context.getPackageName(), 0).versionName;
        } catch (NameNotFoundException e) {
            e.printStackTrace();
        }

        Log.d(TAG, "version = " + version);
        Log.d(TAG, "verName = " + verName);

        String[] tmpVerName = verName.split("\\.");
        String[] tmpVersion = version.split("\\.");

        Log.d(TAG, "tmpVersion.length = " + tmpVersion.length);
        Log.d(TAG, "tmpVerName.length = " + tmpVerName.length);

        boolean isNeedUpdate = false;
        if (tmpVerName.length != tmpVersion.length) {
            isNeedUpdate = true;
        } else {
            for (int i = 0; i < tmpVerName.length; i++) {
                Log.d(TAG, "Version[" + i + "] = " + tmpVersion[i]);
                Log.d(TAG, "VerName[" + i + "] = " + tmpVerName[i]);
                if (Integer.parseInt(tmpVersion[i]) > Integer.parseInt(tmpVerName[i])) {
                    isNeedUpdate = true;
                    break;
                }
            }
        }

        if (isNeedUpdate == true) {
            Log.d(TAG, "install package....");
            // 执行升级文件
            int fileListNum = fileList.size();

            for (int i = 0; i < fileListNum; i++) {
                if (i != fileListNum - 1) {
                    //flag = false;
                    return false;
                }
                final SCFileInfo fi = fileList.get(i);

                Log.d(TAG, "fi.filename = " + fi.filename);

                File updateFile = new File(privateDir + "/" + fi.filename);
                if (updateFile.exists() == false) {
                    Log.d(TAG, fi.filename + " not exists");
                    return false;
                }

                // 利用校验码进行校验证
                try {
                    String Code = getHash(privateDir + "/" + fi.filename, "MD5");
                    if (!Code.equals(fi.checkCode)) {
                        file.delete();
                        Log.d(TAG, "文件内容校验失败，请重新下载！");
                        return false;
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }

                if (updatetag.equals("0")) {

                    // 解决退去程序后，检测死机问题
                    if (context == null) {
                        //flag = false;
                        if (sl != null) {// 关闭本次连接
                            sl.close();
                            sl = null;
                        }
                    } else {

                        Intent intent = new Intent(Intent.ACTION_VIEW);
                        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                        intent.setDataAndType(Uri.fromFile(new File(privateDir + "/" + fi.filename)),
                                "application/vnd.android.package-archive");
                        context.startActivity(intent);
                        //flag = false;

                    }

                } else {
                    Intent intent = new Intent(Intent.ACTION_VIEW);
                    intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                    intent.setDataAndType(Uri.fromFile(new File(privateDir + "/" + fi.filename)), "application/vnd.android.package-archive");
                    context.startActivity(intent);
                    // uplisten.handerResult("-4");
                    //flag = false;
                }

            }

            // 删除update_s.xml文件
            //file.delete();

            // 写入版本升级文件
            SCVersionInfo ver = new SCVersionInfo();
            ver.version = version;
            ver.date = date;
            ver.note = comment;
            verList.add(ver);
            ReWriteVersionInfo(privateDir + "/ClientVer.xml");

        } else {
            // 删除升级文件
            int fileListNum = fileList.size();

            for (int i = 0; i < fileListNum; i++) {
                if (i != fileListNum - 1) {
                    //flag = false;
                    return false;
                }
                final SCFileInfo fi = fileList.get(i);

                Log.d(TAG, "delete file : " + fi.filename);

                File updateFile = new File(privateDir + "/" + fi.filename);
                if (updateFile.exists() == false) {
                    Log.d(TAG, fi.filename + " not exists");
                } else {
                    updateFile.delete();
                }
            }

            return false;
        }

        return true;
    }


    /**
     * 创建本地版本信息
     */
    @SuppressWarnings("static-access")
    public static void CreateVersionInfo(Context mContext, String filename) {

        if (!(new File(filename).exists())) {

            InputStream in = null;
            FileOutputStream out = null;

            try {
                in = (InputStream) mContext.getResources().getAssets().open("ClientVer.xml");
                out = mContext.openFileOutput("ClientVer.xml", mContext.MODE_PRIVATE);
                byte[] buffer = new byte[8192];
                int count = 0;
                // 开始复制文件
                while ((count = in.read(buffer)) > 0) {
                    out.write(buffer, 0, count);
                    out.flush();
                }
                in.close();
                out.close();
            } catch (Exception ioe) {
                ioe.printStackTrace();
                SCUpdateFunc.popAlert(mContext, StringUtil.getStringRes(context, R.string.update), mContext.getString(R.string.init_version_failed));
            }

        }

    }

    /**
     * 关闭socket，退出升级程序
     */
    public static void CloseSocket(Context mContext, String filename) {

        if (sl != null) {
            sl.close();
            sl = null;
        }

    }

    /*
     * 解析aserts里面得到ClientVer.xml中mod,判断是否需要删除版本文件，shared_prefs下文件，与数据库
     */
    public static String getAssertClientVerInfo(Context mContext) {

        String mod = "";
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            InputStream in = (InputStream) mContext.getResources().getAssets().open("ClientVer.xml");
            ;
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();

            NodeList nodeList = root.getElementsByTagName("Mod");
            if (nodeList.item(0).getFirstChild() != null) {
                mod = nodeList.item(0).getFirstChild().getNodeValue();// 取升级软件名称
            }

        } catch (Exception ex) {
            ex.printStackTrace();
        } finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
        return mod;
    }

    /*
     * 解析assertxml文件中的某个值
     */
    public static String getAssertUpdateInfo(Context mContext, String filename, String attribute) {

        String mod = "";
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            InputStream in = (InputStream) mContext.getResources().getAssets().open(filename);
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();

            NodeList nodeList = root.getElementsByTagName(attribute);
            if (nodeList.item(0).getFirstChild() != null) {
                mod = nodeList.item(0).getFirstChild().getNodeValue();// 取升级软件名称
            }

        } catch (Exception ex) {
            ex.printStackTrace();
        } finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
        return mod;
    }

    /**
     * 删除文件夹
     *
     * @return true删除文件夹成功，false删除文件夹失败
     */
    public static boolean deleteDir(File dirFile) {
        // System.out.println("entry " + dirFile.getAbsolutePath());
        boolean flag = false;
        File fileArray[] = dirFile.listFiles();
        if (fileArray == null) {// 文件夹为空，删除文件夹
            return dirFile.delete();
        } else {// 文件不为空
            for (File fp : fileArray) {
                if (fp.isFile()) {// 删除文件夹中文件
                    if (!fp.delete()) {
                        return false;
                    }
                } else {// 删除文件夹中文件夹
                    flag = deleteDir(fp);
                    if (!flag) {// 删除文件夹失败
                        return false;
                    } else {// 删除文件夹中文件和文件夹成功
                        flag = fp.delete();// 删除文件夹本身
                        if (!flag) {
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

	/*
     * 删除数据库mxt.mp3文件
	 */

    public static void delUserdata(Context context, String fileDir) {

        String verName = "";
        try {
            verName = context.getPackageManager().getPackageInfo(context.getPackageName(), 0).versionName;
        } catch (NameNotFoundException e) {
            e.printStackTrace();
        }

        CreateVersionInfo(context, fileDir + "/ClientVer.xml");// 生成客服端文件
        // 解析文件
        ParseVersionInfo(fileDir + "/ClientVer.xml");
        String phonetype = getAssertClientVerInfo(context);

        // 如果mod不一致，删除数据库，clientver，及/data/data/com.xdja.mxt/files文件下文件，
        // /data/data/com.xdja.mxt/shared_prefs/mxt.xml文件
        if (!phonetype.equals("") && !phonetype.equals(mod)) {

            clearTempDate(fileDir);

            return;
        }

        SharedPreferences sharePre = context.getSharedPreferences("mxtchat", 0);
        String versionCode = sharePre.getString("versionCode", "");

        if (verName.equals(versionCode)) {
            return;
        }

        if (verList.size() > 0) {
            SCVersionInfo vi = verList.get((verList.size() - 1));
            if (verName.equals(vi.version)) {

                // 记录版本号，保证升级一个版本只删除一次数据库，删除安装程序
                try {
                    Editor share = context.getSharedPreferences("mxtchat", 0).edit();
                    share.putString("versionCode", verName);
                    share.commit();

                    String delDb = sharePre.getString("DeleteDb", "");

                    String fname = sharePre.getString("MainFileName", "");
                    if (!fname.equals("")) {
                        File tfile = new File(fileDir + "/" + fname);
                        if (tfile.exists()) {

                            tfile.delete();
                        }
                    }

                    if (delDb.equals("1")) {
                        clearTempDate(fileDir);
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }

            }
        }

        // 删除升级配置文件
        // updateDeleteVer( context, fileDir);

    }

    /*
     * 清除所有临时文件
     */
    public static void clearTempDate(String fileDir) {
        // 删除htc手机数据库添加
        // File file = new File(shared_prefs);
        // if (file.exists()) {
        // file.delete();
        // }

        // deleteDbfileTfcard();

        File file = new File(privateDir + "/databases" + "/mysql.db3");

        if (file.exists()) {
            // Dao dao = new Dao(context);
            // dao.deleteAllData();
            file.delete();
        }

        File dir = new File(privateDir);
        // 删除文件夹下的文件
        deleteDir(dir);
    }

    /*
     * 升级删除版本信息,解决升级版本配置信息修改问题
     */
    public static void updateDeleteVer(Context context, String filedir) {

        String delver = getAssertUpdateInfo(context, "Update.xml", "DeleteVer");
        SharedPreferences sharePre = context.getSharedPreferences("mxtchat", 0);
        String oldDelver = sharePre.getString("DeleteVer", "");
        // 第一次为空
        if (oldDelver.equals("") || (!delver.equals("") && !delver.equals(oldDelver))) {

            File file = new File(filedir + "/ClientVer.xml");
            if (file.exists()) {
                file.delete();
            }

            CreateVersionInfo(context, filedir + "/ClientVer.xml");// 生成客服端文件
            Editor share = context.getSharedPreferences("mxtchat", 0).edit();
            share.putString("DeleteVer", delver);
            share.commit();
            return;
        }

    }

    /*
     * 解析版本信息
     */
    public static void ParseVersionInfo(String filename) {

        verList.clear(); // 在未配置升级信息强进入升级程序会有数据，故清空数据。
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            FileInputStream in = new FileInputStream(filename);
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();

            NodeList nodeList = root.getElementsByTagName("ServerIP");
            if (nodeList.item(0).getFirstChild() != null) {

                serverIP = nodeList.item(0).getFirstChild().getNodeValue();// 取升级服务器IP

//				String gwip = nodeList.item(0).getFirstChild().getNodeValue();// 取升级服务器IP
//				
//				try {  
//					Log.d(TAG,"gwip = " + gwip);
//					if (!gwip.equals("")) {
//						InetAddress inetAddress = InetAddress.getByName(gwip);
//						
//						if (inetAddress == null) {
//							serverIP = "";
//							Log.e(TAG,"get InetAddress By Name failed");
//						}
//						else {
//							Log.d(TAG,"serverIP = " + inetAddress.getHostAddress());
//							serverIP = inetAddress.getHostAddress();
//						}
//					}
//		        } catch (UnknownHostException e) { 
//		        	e.printStackTrace();
//		        	serverIP = "";
//		        	Log.e(TAG,"get serverIP By Name failed");
//		        } 
            }

            nodeList = root.getElementsByTagName("ServerPort");
            if (nodeList.item(0).getFirstChild() != null) {
                serverPort = nodeList.item(0).getFirstChild().getNodeValue();// 取升级服务器Port
            }

            nodeList = root.getElementsByTagName("Factory");
            if (nodeList.item(0).getFirstChild() != null) {
                factory = nodeList.item(0).getFirstChild().getNodeValue();// 取手机厂商
            }

            nodeList = root.getElementsByTagName("Mod");
            if (nodeList.item(0).getFirstChild() != null) {
                mod = nodeList.item(0).getFirstChild().getNodeValue();// 取手机型号
            }

            nodeList = root.getElementsByTagName("OS");
            if (nodeList.item(0).getFirstChild() != null) {
                os = nodeList.item(0).getFirstChild().getNodeValue();// 取手机系统
            }

            nodeList = root.getElementsByTagName("Soft");
            if (nodeList.item(0).getFirstChild() != null) {
                soft = nodeList.item(0).getFirstChild().getNodeValue();// 取升级软件名称
            }

            nodeList = root.getElementsByTagName("UserName");
            if (nodeList.item(0).getFirstChild() != null) {
                username = nodeList.item(0).getFirstChild().getNodeValue();// 取用户名
            }

            nodeList = root.getElementsByTagName("Ver");// 取升级版本历史信息
            int nodeNum = nodeList.getLength();

            Element childElement = null;
            NodeList childList = null;

            for (int i = 0; i < nodeNum; i++) {
                SCVersionInfo vi = new SCVersionInfo();
                childElement = (Element) nodeList.item(i);
                childList = childElement.getElementsByTagName("Version");
                vi.version = childList.item(0).getFirstChild().getNodeValue();// 取版本信息

                childList = childElement.getElementsByTagName("Date");
                vi.date = childList.item(0).getFirstChild().getNodeValue();// 取版本信息

                childList = childElement.getElementsByTagName("Note");
                if (childList.item(0).getFirstChild() != null) {
                    vi.note = childList.item(0).getFirstChild().getNodeValue();// 取版本信息
                }
                verList.add(vi);// 添加版本信息到链表中
            }

        } catch (Exception ex) {
            ex.printStackTrace();
        } finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
    }

    /*
     * 解析版本升级确认信息
     */
    private int ParseConfirmInfo(byte[] confirmInfo) {
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream stream = new ByteArrayInputStream(confirmInfo);
            doc = docBuilder.parse(stream);
            Element root = doc.getDocumentElement();

            NodeList nodeList = root.getElementsByTagName("Result");
            if (nodeList.item(0).getFirstChild() != null) {
                String result = nodeList.item(0).getFirstChild().getNodeValue();// 取版本升级确认信息
                return Integer.parseInt(result);
            } else {
                return -1;
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        } finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
    }

    /*
     * 解析版本升级配置信息
     */
    private static boolean ParseConfigInfo(String filename) {
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        boolean res = false;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            FileInputStream in = new FileInputStream(privateDir + "/" + filename);
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();

            NodeList nodeList = root.getElementsByTagName("Version");
            if (nodeList.item(0).getFirstChild() != null) {
                version = nodeList.item(0).getFirstChild().getNodeValue();// 取升级版本号
            }

            nodeList = root.getElementsByTagName("Date");
            if (nodeList.item(0).getFirstChild() != null) {
                date = nodeList.item(0).getFirstChild().getNodeValue();// 取升级版本发布时间
            }

            nodeList = root.getElementsByTagName("Comment");
            if (nodeList.item(0).getFirstChild() != null) {
                comment = nodeList.item(0).getFirstChild().getNodeValue();// 取升级版本注释信息
            }

            nodeList = root.getElementsByTagName("UpdateTag");
            if (nodeList.item(0).getFirstChild() != null) {
                updatetag = nodeList.item(0).getFirstChild().getNodeValue();// 取升级版本更新类型
            }

            nodeList = root.getElementsByTagName("File");// 取升级版本文件列表
            int nodeNum = nodeList.getLength();

            Element childElement = null;
            NodeList childList = null;
            fileList.clear();
            for (int i = 0; i < nodeNum; i++) {
                SCFileInfo fi = new SCFileInfo();
                childElement = (Element) nodeList.item(i);
                childList = childElement.getElementsByTagName("RPath");
                if (childList.item(0).getFirstChild() != null) {
                    fi.rpath = childList.item(0).getFirstChild().getNodeValue();// 远程文件所在路径
                }

                childList = childElement.getElementsByTagName("LPath");
                if (childList.item(0).getFirstChild() != null) {
                    fi.lpath = childList.item(0).getFirstChild().getNodeValue();// 本地文件所在路径
                }

                childList = childElement.getElementsByTagName("FName");
                if (childList.item(0).getFirstChild() != null) {
                    fi.filename = childList.item(0).getFirstChild().getNodeValue();// 文件名
                }

                childList = childElement.getElementsByTagName("CheckCode");
                if (childList.item(0).getFirstChild() != null) {
                    fi.checkCode = childList.item(0).getFirstChild().getNodeValue().toLowerCase();// 校验码
                }

                childList = childElement.getElementsByTagName("DeleteDb");
                if (childList.item(0).getFirstChild() != null) {
                    fi.deleteDb = childList.item(0).getFirstChild().getNodeValue();// 删除数据库
                }

                childList = childElement.getElementsByTagName("FSize");
                if (childList.item(0).getFirstChild() != null) {
                    fi.filesize = Integer.parseInt(childList.item(0).getFirstChild().getNodeValue());// 文件大小
                }

                childList = childElement.getElementsByTagName("Action");
                if (childList.item(0).getFirstChild() != null) {
                    fi.action = Integer.parseInt(childList.item(0).getFirstChild().getNodeValue());// 动作类型
                }

                childList = childElement.getElementsByTagName("State");
                if (childList.item(0).getFirstChild() != null) {
                    fi.state = Integer.parseInt(childList.item(0).getFirstChild().getNodeValue());// 当前状态
                }

                childList = childElement.getElementsByTagName("CSize");
                if (childList.item(0).getFirstChild() != null) {
                    fi.csize = Integer.parseInt(childList.item(0).getFirstChild().getNodeValue());// 当前已经下载大小
                }
                fileList.add(fi);// 添加文件信息到链表中
            }
            res = true;

        } catch (Exception ex) {
            ex.printStackTrace();
            res = false;

        } finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
        return res;

    }


    /*
     * 解析版本临时配置信息
     */
    private boolean ParseTempInfo(String filename) {
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        boolean res = false;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            FileInputStream in = new FileInputStream(privateDir + "/" + filename);
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();

            NodeList nodeList = root.getElementsByTagName("Version");
            if (nodeList.item(0).getFirstChild() != null) {
                tempversion = nodeList.item(0).getFirstChild().getNodeValue();// 取升级版本号
            }

            res = true;

        } catch (Exception ex) {
            ex.printStackTrace();
            res = false;

        } finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
        return res;

    }

    /**
     * 重写版本信息
     */
    public static void ReWriteVersionInfo(String filename) {
        java.lang.StringBuffer verstr = new StringBuffer();
        verstr.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        verstr.append("<Root>");

        verstr.append("<ServerIP>" + serverIP + "</ServerIP>");
        verstr.append("<ServerPort>" + serverPort + "</ServerPort>");
        verstr.append("<Factory>" + factory + "</Factory>");
        verstr.append("<Mod>" + mod + "</Mod>");
        verstr.append("<OS>" + os + "</OS>");
        verstr.append("<Soft>" + soft + "</Soft>");
        verstr.append("<UserName>" + username + "</UserName>");
        int verListNum = verList.size();
        SCVersionInfo vi = null;
        for (int i = 0; i < verListNum; i++) {// 版本升级历史信息
            vi = verList.get(i);
            verstr.append("<Ver>");
            verstr.append("<Version>" + vi.version + "</Version>");
            verstr.append("<Date>" + vi.date + "</Date>");
            verstr.append("<Note>" + vi.note + "</Note>");
            verstr.append("</Ver>");
        }

        verstr.append("</Root>");

        SCUpdateFunc.WriteFile(filename, verstr.toString(), false);// 初始化客户端版本信息
    }

    /**
     * 重写版本升级配置信息
     */
    private void ReWriteConfigInfo(String filename) {
        java.lang.StringBuffer getfile = new StringBuffer();
        getfile.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        getfile.append("<Root>");

        getfile.append("<Version>" + version + "</Version>");
        getfile.append("<Date>" + date + "</Date>");
        getfile.append("<Comment>" + comment + "</Comment>");
        getfile.append("<UpdateTag>" + updatetag + "</UpdateTag>");

        getfile.append("<Files>");

        int fileListNum = fileList.size();
        SCFileInfo fi = null;
        for (int i = 0; i < fileListNum; i++) {// 文件列表
            fi = fileList.get(i);
            getfile.append("<File>");
            getfile.append("<RPath>" + fi.rpath + "</RPath>");
            getfile.append("<LPath>" + fi.lpath + "</LPath>");
            getfile.append("<FName>" + fi.filename + "</FName>");
            getfile.append("<FSize>" + fi.filesize + "</FSize>");
            getfile.append("<Action>" + fi.action + "</Action>");
            getfile.append("<State>" + fi.state + "</State>");
            getfile.append("<CSize>" + fi.csize + "</CSize>");
            getfile.append("<DeleteDb>" + fi.deleteDb + "</DeleteDb>");
            getfile.append("<CheckCode>" + fi.checkCode + "</CheckCode>");

            getfile.append("</File>");
        }

        getfile.append("</Files>");
        getfile.append("</Root>");

        SCUpdateFunc.WriteFile(filename, getfile.toString(), false);// 重写版本升级配置信息
    }

    /**
     * 强制升级提示
     */

    private void doNewVersionForceUpdate() {

        StringBuffer sb = new StringBuffer();
        sb.append(context.getString(R.string.have_new_version));
        sb.append(version + ",");
        sb.append(comment);
        sb.append(context.getString(R.string.force_update_or_quit));
        Dialog dialog = new AlertDialog.Builder(context).setTitle(R.string.update_software).setMessage(sb.toString())
                // 设置内容
                .setPositiveButton(StringUtil.getStringRes(context, R.string.update),// 设置确定按钮
                        new DialogInterface.OnClickListener() {

                            public void onClick(DialogInterface dialog, int which) {

                                GetFileTask getfiletask = new GetFileTask();
                                getfiletask.execute();
                                dialog.dismiss();// 关闭进度对话框
                            }
                        }).setNegativeButton(StringUtil.getStringRes(context, R.string.exit), new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int whichButton) {

                        dialog.dismiss();// 关闭进度对话框

                        //flag = false;
                        // fix by zhaoxiaolong 20160530 bugid:12839
                        Function.exitApp(context);

                    }
                }).create();// 创建
        dialog.setCancelable(false);
        // 显示对话框
        dialog.show();
    }

    /**
     * 新版本下载提示信息
     */

    private void doNewVersionUpdate() {

        StringBuffer sb = new StringBuffer();
        sb.append(context.getString(R.string.have_new_version));
        sb.append(version + ",");
        sb.append(comment);
        sb.append(context.getString(R.string.confirm_update));
        Dialog dialog = new AlertDialog.Builder(context).setTitle(StringUtil.getStringRes(context, R.string.update_software)).setMessage(sb.toString())
                // 设置内容
                .setPositiveButton(StringUtil.getStringRes(context, R.string.update),// 设置确定按钮
                        new DialogInterface.OnClickListener() {

                            public void onClick(DialogInterface dialog, int which) {

                                GetFileTask getfiletask = new GetFileTask();
                                getfiletask.execute();
                                dialog.dismiss();// 关闭进度对话框
                            }
                        }).setNegativeButton(R.string.dont_update, new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int whichButton) {

                        // uplisten.handerResult("-1");// 暂不更新
                        dialog.dismiss();// 关闭进度对话框
                        //flag = false;

                    }
                }).create();// 创建
        dialog.setCancelable(false);

        // 解决升级偶尔出现可能崩溃的bug. Add by xjq, 2017-5-11 09:20:57
        dialog.getWindow().setType(WindowManager.LayoutParams.TYPE_SYSTEM_ALERT);
        // 显示对话框
        dialog.show();
    }

    private void doNewVersionUpdateSilence() {

        SilenceGetFileTask getfiletask = new SilenceGetFileTask();
        getfiletask.execute();

    }

    /**
     * 下载升级信息任务
     */
    private class CheckVerTask extends AsyncTask<String, Integer, String> {
        private ProgressDialog pDialog = null;
        private boolean isShowDialog = false;

        public CheckVerTask(boolean isShowDialog) {
            Log.d(TAG, "CheckVerTask, isShowDialog = " + isShowDialog);
            this.isShowDialog = isShowDialog;
        }

        protected void onPreExecute() {
            Log.d(TAG, "onPreExecute, isShowDialog = " + isShowDialog);
            atomicInteger.incrementAndGet();
            if (isShowDialog) {
                pDialog = new ProgressDialog(context);
                pDialog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
                pDialog.setTitle(context.getString(R.string.connecting));
                pDialog.setMessage(context.getString(R.string.check_new_version));
                pDialog.setCancelable(false);
                //使用系统标记的dialog
                pDialog.getWindow().setType(WindowManager.LayoutParams.TYPE_SYSTEM_ALERT);
                // 如果当前登录界面是顶端窗口
                pDialog.show();
            }
        }

        @Override
        protected void onCancelled() {
            super.onCancelled();
            if(atomicInteger.get() != 0) {
                atomicInteger.decrementAndGet();
            }
        }

        protected String doInBackground(String... params) {

            try {

                CreateVersionInfo(context, privateDir + "/ClientVer.xml");// 生成客服端文件

                // 解析文件
                ParseVersionInfo(privateDir + "/ClientVer.xml");

                // 修正记录的版本升级列表，如果版本相等不修正，若不等就删除最后一个节点
                String verName = "";
                try {
                    verName = context.getPackageManager().getPackageInfo(context.getPackageName(), 0).versionName;
                } catch (NameNotFoundException e) {
                    e.printStackTrace();
                }
                if (verList.size() > 0) {
                    SCVersionInfo vi = verList.get((verList.size() - 1));

                    if ((!verName.equals(vi.version)) && (verList.size() > 1)) {

                        verList.remove(verList.size() - 1);
                        ReWriteVersionInfo(privateDir + "/ClientVer.xml");

                    }
                }
                StringBuffer checkVer = new StringBuffer();
                checkVer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                checkVer.append("<Root>");

                checkVer.append("<Req>checkver</Req>");
                checkVer.append("<Factory>" + factory + "</Factory>");
                checkVer.append("<Mod>" + mod + "</Mod>");
                checkVer.append("<OS>" + os + "</OS>");
                checkVer.append("<Soft>" + soft + "</Soft>");
                checkVer.append("<Version>" + verName + "</Version>");
                checkVer.append("<UserName>" + username + "</UserName>");

                checkVer.append("</Root>");

                if (serverIP.equals("")) {
                    return context.getString(R.string.update_module_server_address_empty);
                }

                if (serverPort.equals("")) {
                    return context.getString(R.string.update_module_server_port_empty);
                }

                // add by zhaoxiaolong 2016-05-17
                String hostIP = getHostAddress(serverIP);
                if (hostIP == null) {
                    return context.getString(R.string.update_module_host_error);
                }

                sl = new SCUpdateSocket(hostIP, Integer.parseInt(serverPort));

                int nres = sl.connect();
                if (nres != 0) {
                    sl = null;
                    return context.getString(R.string.update_module_connect_server_error);
                }

                nres = sl.sendData(checkVer.toString());
                if (nres != 0) {
                    return context.getString(R.string.update_module_send_data_failed);
                }

                // String result = sl.recvData();
                byte[] result = sl.recvData();
                if (result == null) {
                    return context.getString(R.string.receive_data_time_out);
                } else {
                    nres = ParseConfirmInfo(result);
                    switch (nres) {
                        case 0:
                            result = sl.recvData();
                            if (result == null) {
                                return "接收升级配置信息超时";
                            } else {
                                // 解决断点续传停止后，跨版本无法升级问题
                                new File(privateDir + "/update_temp.xml").delete();
                                if (new File(privateDir + "/update_s.xml").exists()) {
                                    SCUpdateFunc.WriteFile(privateDir + "/update_temp.xml", result, false);
                                } else {
                                    SCUpdateFunc.WriteFile(privateDir + "/update_s.xml", result, false);// 把升级配置信息写入本地文件update_s.xml
                                }

                            }
                            break;
                        case 1:
                            return context.getString(R.string.all_file_newest);
                        case 2:
                            return context.getString(R.string.no_config);
                        case 3:
                            return context.getString(R.string.search_upgrade_config_failed);
                        case 4:
                            return context.getString(R.string.upgrade_config_file_not_exist);
                        case -1:
                            return context.getString(R.string.read_upgrade_info_failed);
                    }
                }

                return null;
            } catch (Exception ex) {
                ex.printStackTrace();
                return context.getString(R.string.unknown_error);
            }

        }

        protected void onPostExecute(String result) {
            atomicInteger.decrementAndGet();
            if(context instanceof Activity){
                if(((Activity)context).isFinishing() || ((Activity)context).isDestroyed()){
                    Log.i(TAG,"log----------activity is destroyed");
                }else{
                    if (pDialog != null) {
                        pDialog.dismiss();// 关闭进度对话框
                    }
                }
            }
            if (result != null) {// 申请验证或下载升级信息失败
                // 没有版本更新
                if(!isMainActivity){
                    if (isShowDialog) {
                        Toast.makeText(context, result, Toast.LENGTH_SHORT).show();
                        //flag = false;
                    } else {
                        Log.d(TAG, "CheckVerTask, result = " + result);
                        //flag = false;
                    }
                }else{
                    Log.d(TAG, "main act without tips" );
                    isMainActivity = false;
                    //flag = false;
                }
            } else { // 申请验证和下载升级信息成功

                File file = new File(privateDir + "/update_s.xml");
                File temfile = new File(privateDir + "/update_temp.xml");

                boolean res = ParseConfigInfo("update_s.xml");// 解析升级配置信息
                if (res == false) {
                    // 删除update_s.xml文件
                    file.delete();
                    // uplisten.handerResult("-2");// 解析update_s.xml失败
                    // //XdjaPrintLog.i("check version info",
                    // "解析update_s.xml失败");
                    //flag = false;
                    return;
                }

                // 解决断点续传停止后，跨版本无法升级问题
                if (temfile.exists()) {
                    if (ParseTempInfo("update_temp.xml")) {

                        if (!tempversion.equals(version)) {

                            file.delete();

                            SharedPreferences sharePre = context.getSharedPreferences("mxtchat", 0);
                            String fname = sharePre.getString("MainFileName", "");
                            if (!fname.equals("")) {
                                File tfile = new File(privateDir + "/" + fname);
                                if (tfile.exists()) {
                                    tfile.delete();
                                }
                            }
                            temfile.renameTo(file);

                            boolean r = ParseConfigInfo("update_s.xml");// 解析升级配置信息
                            if (r == false) {
                                // 删除update_s.xml文件
                                file.delete();
                                // uplisten.handerResult("-2");//
                                // 解析update_s.xml失败
                                // //XdjaPrintLog.i("check version info",
                                // "解析update_s.xml失败");
                                //flag = false;
                                return;
                            }
                        } else {
                            temfile.delete();
                        }
                    } else {
                        // 删除update_temp.xml文件
                        temfile.delete();
                        // uplisten.handerResult("-2");// 解析update_temp.xml失败
                        // //Log.i("check version info", "解析update_temp.xml失败");
                        //flag = false;
                        return;
                    }

                }
                // 解决退去程序后，检测死机问题
                if (context == null) {
                    //flag = false;
                    if (sl != null) {// 关闭本次连接
                        sl.close();
                        sl = null;
                    }
                    return;
                }

                if (updatetag.equals("0") || isShowDialog == false) {
                    if (sl != null) {// 关闭本次连接
                        sl.close();
                        sl = null;
                    }
                    if (isShowDialog == true) {
                        doNewVersionUpdate(); // 提示版本升级
                    } else {
                        doNewVersionUpdateSilence();
                    }
                } else {
                    doNewVersionForceUpdate();

                    // GetFileTask getfiletask = new GetFileTask();
                    // getfiletask.execute();
                }
            }
        }
    }

    /**
     * 下载升级文件任务
     */
    private class GetFileTask extends AsyncTask<String, Integer, String> {
        private ProgressDialog pDialog = null;

        protected void onPreExecute() {

            // 解决退去程序后，检测死机问题
            if (context == null) {
                //flag = false;
                if (sl != null) {// 关闭本次连接
                    sl.close();
                    sl = null;
                }
                return;
            }

            pDialog = new ProgressDialog(context);
            pDialog.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
            if (updatetag.equals("0")) {
                pDialog.setTitle(getStringRes(context, R.string.alert));
                pDialog.setMessage(context.getString(R.string.downloading_wait));
            } else {
                pDialog.setTitle(getStringRes(context, R.string.alert));
                pDialog.setMessage(getStringRes(context, R.string.downloading_wait));
                // pDialog.setTitle("发现新版本:" + version + ",进行强制升级");
                // pDialog.setMessage(comment);
            }

            // pDialog.setMessage("正在下载升级文件,请稍候");
            if (updatetag.equals("0")) {
                pDialog.setButton(getStringRes(context, R.string.negative), new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int i) {
                        dialog.cancel();
                        if (sl != null) {
                            sl.close();
                            sl = null;
                        }

                    }
                });
            }

            // 设置ProgressDialog 进度条进度
            pDialog.setMax(100);
            // 设置ProgressDialog 的进度条是否不明确
            pDialog.setIndeterminate(false);

            // 设置ProgressDialog 是否可以按退回按键取消
            pDialog.setCancelable(false);
            pDialog.show();

        }

        protected void onPostExecute(String obj) {
            pDialog.dismiss();// 关闭进度对话框
            if (sl != null) {// 关闭本次连接
                sl.close();
                sl = null;
            }

            String result = obj;

            if (result != null) {// 下载升级文件失败
                // //XdjaPrintLog.i("file download fail info", result);
                try {
                    // 解决退去程序后，检测死机问题
                    if (context == null) {
                        //flag = false;
                        if (sl != null) {// 关闭本次连接
                            sl.close();
                            sl = null;
                        }
                        return;
                    }

                    AlertDialog alert = new AlertDialog.Builder(context).setTitle(getStringRes(context, R.string.alert)).setMessage(R.string.download_failed)
                            .setNeutralButton(getStringRes(context, R.string.positive), new DialogInterface.OnClickListener() {
                                public void onClick(DialogInterface dlg, int which) {
                                    // 文件下载失败
                                    // if (updatetag.equals("0")) {

                                    // flag = false;
                                    // }
                                    //flag = false;
                                }
                            }).create();
                    alert.setCancelable(false);
                    alert.show();

                } catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(e.getMessage());
                }
            } else {
                // 执行升级文件
                int fileListNum = fileList.size();

                for (int i = 0; i < fileListNum; i++) {
                    if (i != fileListNum - 1) {
                        //flag = false;
                        return;
                    }
                    final SCFileInfo fi = fileList.get(i);
                    if (updatetag.equals("0")) {

                        // 解决退去程序后，检测死机问题
                        if (context == null) {
                            //flag = false;
                            if (sl != null) {// 关闭本次连接
                                sl.close();
                                sl = null;
                            }
                        } else {

                            // 更新
                            AlertDialog dialog = new AlertDialog.Builder(context).setTitle(getStringRes(context, R.string.alert)).setMessage(R.string.upgrade_choice)
                                    .setPositiveButton(StringUtil.getStringRes(context, R.string.upgrade), new DialogInterface.OnClickListener() {

                                        public void onClick(DialogInterface dialog, int which) {

                                            Intent intent = new Intent(Intent.ACTION_VIEW);
                                            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                                            intent.setDataAndType(Uri.fromFile(new File(privateDir + "/" + fi.filename)),
                                                    "application/vnd.android.package-archive");
                                            context.startActivity(intent);
                                            //flag = false;
                                            // uplisten.handerResult("-4");

                                        }
                                    }).setNegativeButton(R.string.upgrade_later, new DialogInterface.OnClickListener() {

                                        public void onClick(DialogInterface dialog, int which) {
                                            // uplisten.handerResult("-1");//
                                            // 下次升级
                                            //flag = false;
                                        }
                                    }).setNeutralButton(R.string.delete_file, new DialogInterface.OnClickListener() {

                                        public void onClick(DialogInterface dialog, int which) {

                                            Dialog dia = new AlertDialog.Builder(context).setTitle(getStringRes(context, R.string.alert)).setMessage(R.string.delete_upgrade_file_or_not)
                                                    // 设置内容
                                                    .setPositiveButton(getStringRes(context, R.string.positive),// 设置确定按钮
                                                            new DialogInterface.OnClickListener() {

                                                                public void onClick(DialogInterface dialog, int which) {
                                                                    File file = new File(privateDir + "/" + fi.filename);
                                                                    file.delete();
                                                                    dialog.dismiss();// 关闭进度对话框
                                                                    // uplisten.handerResult("-1");//
                                                                    // 下次升级
                                                                    //flag = false;
                                                                }
                                                            }).setNegativeButton(getStringRes(context, R.string.negative), new DialogInterface.OnClickListener() {
                                                        public void onClick(DialogInterface dialog, int whichButton) {

                                                            dialog.dismiss();// 关闭进度对话框
                                                            // uplisten.handerResult("-1");//
                                                            // 下次升级
                                                            //flag = false;

                                                        }
                                                    }).create();// 创建
                                            // 显示对话框
                                            dia.show();
                                            dia.setCancelable(false);

                                        }
                                    }).create();
                            dialog.setCancelable(false);
                            try {
                                Activity activity = (Activity)context;
                                if (!activity.isFinishing()) {
                                    dialog.show();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                    } else {
                        Intent intent = new Intent(Intent.ACTION_VIEW);
                        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                        intent.setDataAndType(Uri.fromFile(new File(privateDir + "/" + fi.filename)), "application/vnd.android.package-archive");
                        context.startActivity(intent);
                        // uplisten.handerResult("-4");
                        //flag = false;
                    }

                }

                // 删除update_s.xml文件
                File file = new File(privateDir + "/update_s.xml");
                file.delete();
                // 写入版本升级文件
                SCVersionInfo ver = new SCVersionInfo();
                ver.version = version;
                ver.date = date;
                ver.note = comment;
                verList.add(ver);
                ReWriteVersionInfo(privateDir + "/ClientVer.xml");

            }
        }

        protected void onProgressUpdate(Integer... values) {
            // 更新进度
            // pDialog.setMessage("正在下载升级文件" + fName);
            pDialog.setProgress(values[0]);

        }

        @Override
        protected String doInBackground(String... params) {

            try {
                int nres = -1;
                if (updatetag.equals("0")) {

                    // if (sl == null) {// 未连接网络

                    if (serverIP.equals("")) {
                        return getStringRes(context, R.string.update_module_server_address_empty);
                    }
                    if (serverPort.equals("")) {
                        return getStringRes(context, R.string.update_module_server_port_empty);
                    }

                    // fix by zhaoxiaolong 2016-05-17
                    String hostIP = getHostAddress(serverIP);
                    if (hostIP == null) {
                        return getStringRes(context, R.string.update_module_host_error);
                    }

                    sl = new SCUpdateSocket(hostIP, Integer.parseInt(serverPort));
                    nres = sl.connect();
                    if (nres != 0) {
                        sl = null;
                        ReWriteConfigInfo(privateDir + "/update_s.xml");// 重写版本升级配置信息
                        return context.getString(R.string.connect_update_server_failed);
                    }
                }

                // }

                int fileListNum = fileList.size();
                // 如果update_s.xml文件，更新文件信息为空，就删除掉，认为是无效的update_s.xml文件。
                // 写update_s.xml文件没有写完全会出现该情况。
                if (fileListNum == 0) {
                    File file = new File(privateDir + "/update_s.xml");
                    file.delete();
                    return context.getString(R.string.all_file_newest);
                }

                for (int i = 0; i < fileListNum; i++) {
                    SCFileInfo fi = fileList.get(i);

                    if (i == fileListNum - 1) {

                        Editor share = context.getSharedPreferences("mxtchat", 0).edit();
                        share.putString("MainFileName", fi.filename); // 识别程序的文件名，以后删除用，否则会永久不删除
                        share.putString("DeleteDb", fi.deleteDb); // 是否删除数据库文件
                        share.commit();
                    }
                    // 防止连续追加文件
                    if (fi.csize == 0 || fi.csize == fi.filesize) {

                        File file = new File(privateDir + "/" + fi.filename);
                        // 后台现在完毕没有安装的情形，第二次登录进行安装
                        if (file.exists()) {
                            try {
                                String Code = getHash(privateDir + "/" + fi.filename, "MD5");
                                // //XdjaPrintLog.i("checkcode", Code);
                                if (!Code.equals(fi.checkCode)) {
                                    file.delete();
                                    // //XdjaPrintLog.i("checkcode", Code);
                                    return context.getString(R.string.verify_failed_redownload);
                                }

                                return null;
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }

                    }

                    if (fi.csize < fi.filesize) {
                        // 得到文件大小，与update_s.xml记录的已经下载的文件进行比较，如果不一致
                        // 按照实际大小计算

                        File dF = new File(privateDir + "/" + fi.filename);
                        if (dF.exists()) {
                            if (dF.length() != fi.csize) {
                                fi.csize = (int) dF.length();
                            }
                        }

                        java.lang.StringBuffer getfile = new StringBuffer();
                        getfile.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                        getfile.append("<Root>");

                        getfile.append("<Req>getfile</Req>");
                        getfile.append("<RPath>" + fi.rpath + "</RPath>");
                        getfile.append("<LPath>" + fi.lpath + "</LPath>");
                        getfile.append("<FName>" + fi.filename + "</FName>");

                        getfile.append("<FSize>" + fi.filesize + "</FSize>");
                        getfile.append("<FPos>" + fi.csize + "</FPos>");
                        getfile.append("</Root>");

                        nres = sl.sendData(getfile.toString());
                        if (nres != 0) {
                            ReWriteConfigInfo(privateDir + "/update_s.xml");// 重写版本升级配置信息
                            return context.getString(R.string.upgrade_request_failed);
                        }

                        // String result = sl.recvData();
                        byte[] result = sl.recvData();
                        if (result == null) {
                            ReWriteConfigInfo(privateDir + "/update_s.xml");// 重写版本升级配置信息
                            return context.getString(R.string.receive_upgrade_param_timeout);
                        } else {
                            int res = ParseConfirmInfo(result);
                            boolean flag = true;
                            File file = new File(privateDir + "/update_s.xml");
                            File tfile = new File(privateDir + "/" + fi.filename);
                            switch (res) {
                                case 0:

                                    while (fi.csize < fi.filesize) {

                                        byte[] data = new byte[fi.filesize - fi.csize];
                                        int currentLen = 0;

                                        try {
                                            if (sl == null) {
                                                return context.getString(R.string.socket_close);
                                            }
                                            currentLen = sl.sin.read(data, 0, fi.filesize - fi.csize);
                                        } catch (Exception e) {
                                            e.printStackTrace();
                                            return context.getString(R.string.receive_upgrade_data_timeout);
                                        }

                                        if (currentLen == -1) {
                                            ReWriteConfigInfo(privateDir + "/update_s.xml");// 重写版本升级配置信息
                                            return getStringRes(context, R.string.receive_upgrade_data_timeout);
                                        } else {
                                            fi.csize += currentLen;
                                            publishProgress((int) ((fi.csize / (float) fi.filesize) * 100));
                                            // //XdjaPrintLog.i("fi.csize------fi.filesize",
                                            // fi.csize + "------" + fi.filesize +
                                            // "百分比："
                                            // + (int) ((fi.csize / (float)
                                            // fi.filesize)
                                            // * 100));
                                            FileOutputStream out = null;
                                            try {
                                                String tempStr = privateDir + "/" + fi.filename;
                                                out = new FileOutputStream(tempStr, true);
                                                out.write(data, 0, currentLen);
                                                out.flush();
                                                out.close();
                                            } catch (Exception e) {
                                                e.printStackTrace();
                                                // //XdjaPrintLog.i("file download fail info",
                                                // "文件写入错误");
                                                tfile.delete();
                                                fi.state = 0;
                                                fi.csize = 0;
                                                ReWriteConfigInfo(privateDir + "/update_s.xml");// 重写版本升级配置信息
                                                return context.getString(R.string.write_upgrade_file_error);
                                            }

                                            // 修改文件给与其他包读的权限
                                            if ((flag == true) && (tfile.exists() == true)) {

                                                try {
                                                    Runtime.getRuntime().exec("chmod 644 " + privateDir + "/" + fi.filename);
                                                    flag = false;
                                                    // //XdjaPrintLog.i("change ",
                                                    // "权限修改成功");
                                                } catch (Exception e) {
                                                    flag = true;
                                                    // //XdjaPrintLog.i("change ",
                                                    // "权限修改失败");
                                                    e.printStackTrace();
                                                }

                                            }

                                            if (fi.csize >= fi.filesize) {
                                                fi.state = 2; // 文件处理完毕
                                                ReWriteConfigInfo(privateDir + "/update_s.xml");// 重写版本升级配置信息
                                                // 利用校验码进行校验证
                                                try {
                                                    String Code = getHash(privateDir + "/" + fi.filename, "MD5");
                                                    if (!Code.equals(fi.checkCode)) {
                                                        // //XdjaPrintLog.i("checkcode",
                                                        // Code);
                                                        tfile.delete();
                                                        file.delete();
                                                        return getStringRes(context, R.string.verify_failed_redownload);

                                                    }
                                                } catch (Exception e) {
                                                    e.printStackTrace();
                                                }

                                                break;
                                            } else {
                                                fi.state = 1; // 文件正在处理
                                                ReWriteConfigInfo(privateDir + "/update_s.xml");// 重写版本升级配置信息
                                            }
                                        }
                                    }
                                    // //XdjaPrintLog.i("ffile size", "文件大小为" +
                                    // tfile.length());

                                    break;
                                case 1:
                                    // 删除update_s.xml文件,否则一次不成功就保留该文件无法更新。
                                    file.delete();
                                    return context.getString(R.string.file_not_exist);
                                case 2:
                                    file.delete();
                                    return context.getString(R.string.read_file_failed);
                                case 3:
                                    file.delete();
                                    return context.getString(R.string.file_size_unmatch);
                                case 4:
                                    file.delete();
                                    return context.getString(R.string.offset_invalid);
                                case 5:
                                    file.delete();
                                    return context.getString(R.string.param_unmatch);
                            }
                        }
                    }
                }

                return null;
            } catch (Exception ex) {
                ex.printStackTrace();
                ReWriteConfigInfo(privateDir + "/update_s.xml");
                return context.getString(R.string.network_error);
            }
        }
    }


    /**
     * 静默下载升级文件任务
     */
    private class SilenceGetFileTask extends AsyncTask<String, Integer, String> {

        protected void onPreExecute() {

            // 解决退去程序后，检测死机问题
            if (context == null) {
                //flag = false;
                if (sl != null) {// 关闭本次连接
                    sl.close();
                    sl = null;
                }
                return;
            }

        }

        protected void onPostExecute(String obj) {

            if (sl != null) {// 关闭本次连接
                sl.close();
                sl = null;
            }

            String result = obj;

            if (result != null) {// 下载升级文件失败
                // //XdjaPrintLog.i("file download fail info", result);
                Log.d(TAG, "file download fail ," + result);
                //flag = false;
                try {
                    // 解决退去程序后，检测死机问题
                    if (context == null) {
                        //flag = false;
                        if (sl != null) {// 关闭本次连接
                            sl.close();
                            sl = null;
                        }
                        return;
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(e.getMessage());
                }
            } else {
                Log.d(TAG, "file download success");
                //flag = false;


            }
        }

        @Override
        protected String doInBackground(String... params) {

            try {
                int nres = -1;
                //if (updatetag.equals("0")) {

                // if (sl == null) {// 未连接网络

                if (serverIP.equals("")) {
                    return getStringRes(context, R.string.update_module_server_address_empty);
                }
                if (serverPort.equals("")) {
                    return getStringRes(context, R.string.update_module_server_port_empty);
                }

                // fix by zhaoxiaolong 2016-05-17
                String hostIP = getHostAddress(serverIP);
                if (hostIP == null) {
                    return getStringRes(context, R.string.update_module_host_error);
                }

                // 转发模式升级连接本地地址
                sl = new SCUpdateSocket(hostIP, Integer.parseInt(serverPort));
                nres = sl.connect();
                if (nres != 0) {
                    sl = null;
                    ReWriteConfigInfo(privateDir + "/update_s.xml");// 重写版本升级配置信息
                    return getStringRes(context, R.string.update_module_connect_server_error);
                }
                //}

                int fileListNum = fileList.size();
                // 如果update_s.xml文件，更新文件信息为空，就删除掉，认为是无效的update_s.xml文件。
                // 写update_s.xml文件没有写完全会出现该情况。
                if (fileListNum == 0) {
                    File file = new File(privateDir + "/update_s.xml");
                    file.delete();
                    return getStringRes(context, R.string.all_file_newest);
                }

                for (int i = 0; i < fileListNum; i++) {
                    SCFileInfo fi = fileList.get(i);

                    if (i == fileListNum - 1) {

                        Editor share = context.getSharedPreferences("mxtchat", 0).edit();
                        share.putString("MainFileName", fi.filename); // 识别程序的文件名，以后删除用，否则会永久不删除
                        share.putString("DeleteDb", fi.deleteDb); // 是否删除数据库文件
                        share.commit();
                    }
                    // 防止连续追加文件
                    if (fi.csize == 0 || fi.csize == fi.filesize) {

                        File file = new File(privateDir + "/" + fi.filename);
                        // 后台现在完毕没有安装的情形，第二次登录进行安装
                        if (file.exists()) {
                            try {
                                String Code = getHash(privateDir + "/" + fi.filename, "MD5");
                                // //XdjaPrintLog.i("checkcode", Code);
                                if (!Code.equals(fi.checkCode)) {
                                    file.delete();
                                    // //XdjaPrintLog.i("checkcode", Code);
                                    return getStringRes(context, R.string.verify_failed_redownload);
                                }
                                return null;
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }

                    }

                    if (fi.csize < fi.filesize) {
                        // 得到文件大小，与update_s.xml记录的已经下载的文件进行比较，如果不一致
                        // 按照实际大小计算

                        File dF = new File(privateDir + "/" + fi.filename);
                        if (dF.exists()) {
                            if (dF.length() != fi.csize) {
                                fi.csize = (int) dF.length();
                            }
                        }

                        java.lang.StringBuffer getfile = new StringBuffer();
                        getfile.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                        getfile.append("<Root>");

                        getfile.append("<Req>getfile</Req>");
                        getfile.append("<RPath>" + fi.rpath + "</RPath>");
                        getfile.append("<LPath>" + fi.lpath + "</LPath>");
                        getfile.append("<FName>" + fi.filename + "</FName>");

                        getfile.append("<FSize>" + fi.filesize + "</FSize>");
                        getfile.append("<FPos>" + fi.csize + "</FPos>");
                        getfile.append("</Root>");

                        if (sl == null) {
                            Log.e(TAG, "sl is null");
                            return "inner error";
                        }

                        nres = sl.sendData(getfile.toString());
                        if (nres != 0) {
                            ReWriteConfigInfo(privateDir + "/update_s.xml");// 重写版本升级配置信息
                            return getStringRes(context, R.string.upgrade_request_failed);
                        }

                        // String result = sl.recvData();
                        byte[] result = sl.recvData();
                        if (result == null) {
                            ReWriteConfigInfo(privateDir + "/update_s.xml");// 重写版本升级配置信息
                            return getStringRes(context, R.string.receive_upgrade_param_timeout);
                        } else {
                            int res = ParseConfirmInfo(result);
                            boolean flag = true;
                            File file = new File(privateDir + "/update_s.xml");
                            File tfile = new File(privateDir + "/" + fi.filename);
                            switch (res) {
                                case 0:

                                    while (fi.csize < fi.filesize) {

                                        byte[] data = new byte[fi.filesize - fi.csize];
                                        int currentLen = 0;

                                        try {
                                            if (sl == null) {
                                                return getStringRes(context, R.string.socket_close);
                                            }
                                            currentLen = sl.sin.read(data, 0, fi.filesize - fi.csize);
                                        } catch (Exception e) {
                                            e.printStackTrace();
                                            return getStringRes(context, R.string.receive_upgrade_data_timeout);
                                        }

                                        if (currentLen == -1) {
                                            ReWriteConfigInfo(privateDir + "/update_s.xml");// 重写版本升级配置信息
                                            return getStringRes(context, R.string.receive_upgrade_data_timeout);
                                        } else {
                                            fi.csize += currentLen;
                                            publishProgress((int) ((fi.csize / (float) fi.filesize) * 100));
                                            // //XdjaPrintLog.i("fi.csize------fi.filesize",
                                            // fi.csize + "------" + fi.filesize +
                                            // "百分比："
                                            // + (int) ((fi.csize / (float)
                                            // fi.filesize)
                                            // * 100));
                                            FileOutputStream out = null;
                                            try {
                                                String tempStr = privateDir + "/" + fi.filename;
                                                out = new FileOutputStream(tempStr, true);
                                                out.write(data, 0, currentLen);
                                                out.flush();
                                                out.close();
                                            } catch (Exception e) {
                                                e.printStackTrace();
                                                // //XdjaPrintLog.i("file download fail info",
                                                // "文件写入错误");
                                                tfile.delete();
                                                fi.state = 0;
                                                fi.csize = 0;
                                                ReWriteConfigInfo(privateDir + "/update_s.xml");// 重写版本升级配置信息
                                                return StringUtil.getStringRes(context, R.string.write_upgrade_file_error);
                                            }

                                            // 修改文件给与其他包读的权限
                                            if ((flag == true) && (tfile.exists() == true)) {

                                                try {
                                                    Runtime.getRuntime().exec("chmod 644 " + privateDir + "/" + fi.filename);
                                                    flag = false;
                                                    // //XdjaPrintLog.i("change ",
                                                    // "权限修改成功");
                                                } catch (Exception e) {
                                                    flag = true;
                                                    // //XdjaPrintLog.i("change ",
                                                    // "权限修改失败");
                                                    e.printStackTrace();
                                                }

                                            }

                                            if (fi.csize >= fi.filesize) {
                                                fi.state = 2; // 文件处理完毕
                                                ReWriteConfigInfo(privateDir + "/update_s.xml");// 重写版本升级配置信息
                                                // 利用校验码进行校验证
                                                try {
                                                    String Code = getHash(privateDir + "/" + fi.filename, "MD5");
                                                    if (!Code.equals(fi.checkCode)) {
                                                        // //XdjaPrintLog.i("checkcode",
                                                        // Code);
                                                        tfile.delete();
                                                        file.delete();
                                                        return getStringRes(context, R.string.verify_failed_redownload);

                                                    }
                                                } catch (Exception e) {
                                                    e.printStackTrace();
                                                }

                                                break;
                                            } else {
                                                fi.state = 1; // 文件正在处理
                                                ReWriteConfigInfo(privateDir + "/update_s.xml");// 重写版本升级配置信息
                                            }
                                        }
                                    }

                                    //执行升级文件
                                    if(Compatibility.isZhengZhouShiju()){
                                        Intent intent = new Intent(Intent.ACTION_VIEW);
                                        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                                        intent.setDataAndType(Uri.fromFile(new File(privateDir + "/" + fi.filename)),
                                                "application/vnd.android.package-archive");
                                        context.startActivity(intent);
                                    }
                                    // //XdjaPrintLog.i("ffile size", "文件大小为" +
                                    // tfile.length());

                                    break;
                                case 1:
                                    // 删除update_s.xml文件,否则一次不成功就保留该文件无法更新。
                                    file.delete();
                                    return context.getString(R.string.file_not_exist);
                                case 2:
                                    file.delete();
                                    return context.getString(R.string.read_file_failed);
                                case 3:
                                    file.delete();
                                    return context.getString(R.string.file_size_unmatch);
                                case 4:
                                    file.delete();
                                    return context.getString(R.string.offset_invalid);
                                case 5:
                                    file.delete();
                                    return context.getString(R.string.param_unmatch);
                            }
                        }
                    }
                }

                return null;
            } catch (Exception ex) {
                ex.printStackTrace();
                ReWriteConfigInfo(privateDir + "/update_s.xml");
                return getStringRes(context, R.string.network_error);
            }
        }
    }

    //解析域名 . add by zhaoxiaolong 2016-05-17
    private static String getHostAddress(String domain) {

        if (domain == null) {
            Log.e(TAG, "domain is null");
            return null;
        }

        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(new String(domain));
            if (inetAddress == null) {
                Log.e(TAG, "get InetAddress By Name failed");
                return null;
            }

        } catch (UnknownHostException e) {
            e.printStackTrace();
            Log.e(TAG, "Unknow Domain Name:" + domain);
            return null;
        }
        Log.d(TAG, "Update Addr:" + inetAddress.getHostAddress());
        return inetAddress.getHostAddress();
    }


    /**
     * 获取升级服务器配置
     *
     * @param fileDir 文件路径
     */
    public static ArrayList<String> GetUpdateConfig(Context mCon, String fileDir) {
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        ArrayList<String> IP_Port = new ArrayList<String>();
        String updateIP = "";
        String updatePort = "";

        CreateVersionInfo(mCon, fileDir + "/ClientVer.xml");

        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            FileInputStream in = new FileInputStream(fileDir + "/" + "/ClientVer.xml");
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getElementsByTagName("ServerIP");
            if (nodeList.item(0).getFirstChild() != null) {
                updateIP = nodeList.item(0).getFirstChild().getNodeValue();// 取升级服务器IP
            }
            nodeList = root.getElementsByTagName("ServerPort");
            if (nodeList.item(0).getFirstChild() != null) {
                updatePort = nodeList.item(0).getFirstChild().getNodeValue();// 取升级服务器Port
            }
            IP_Port.add(updateIP);
            IP_Port.add(updatePort);
            in.close();
        } catch (Exception ex) {
            ex.printStackTrace();

        } finally {

            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
        return IP_Port;

    }

    /**
     * 修改升级服务器配置
     *
     * @param fileDir
     */
    public static void SetUpdateConfig(String fileDir, String updateIP, String updatePort) {

        // 解析文件
        try {
            ParseVersionInfo(fileDir + "/ClientVer.xml");

            serverIP = updateIP;

            serverPort = updatePort;

            ReWriteVersionInfo(fileDir + "/ClientVer.xml");
        } catch (Exception ex) {
            ex.printStackTrace();

        }

    }

    public static void deleteDbfileTfcard() {
        /* 判断SD Card是否插入 */
        boolean sdCardExit = false;
        sdCardExit = Environment.getExternalStorageState().equals(android.os.Environment.MEDIA_MOUNTED);
        /* 取得SD Card路径做为录音的文件位置 */
        if (sdCardExit) {

            File dbfile = new File(Environment.getExternalStorageDirectory() + "/MXTCHAT/mxt.mp3");
            if (dbfile.exists()) {
                dbfile.delete();
            }

        }
    }

    public static String getHash(String fileName, String hashType) throws Exception {

        InputStream fis;
        fis = new FileInputStream(fileName);// 读取文件
        byte[] buffer = new byte[1024];
        MessageDigest md5 = MessageDigest.getInstance(hashType);
        int numRead = 0;
        while ((numRead = fis.read(buffer)) > 0) {
            md5.update(buffer, 0, numRead);
        }
        fis.close();
        return toHexString(md5.digest());
    }

    public static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; i++) {
            sb.append(hexChar[(b[i] & 0xf0) >>> 4]);
            sb.append(hexChar[b[i] & 0x0f]);
        }
        return sb.toString();
    }

    public static char[] hexChar = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

}
