package com.xdja.key.chipmanager;

import android.util.Pair;

import com.xdja.SafeKey.XDJA_SM2_PARAM;
import com.xdja.key.KeyDevInfo;
import com.xdja.key.KeyWrapper;
import com.xdja.multichip.jniapi.JarJniApiProxy;
import com.xdja.multichip.jniapi.JarMultiJniApiManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.utils.Log;
import com.xdja.sslvpn.CONSTANT;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by xingjianqiang on 2017/9/13.
 * Project : safeclient.android.origin
 * Email : xingjianqiang@xdja.com
 */

public class ChipManagerWrapper {


    private ChipManagerWrapper(){}
    private static ChipManagerWrapper instance = null;
    private JarMultiJniApiManager jniApiManager = JarMultiJniApiManager.getInstance();
    private MyApplication application = MyApplication.myApplication;
    private static final String THIS_FILE = "ChipManagerWrapper";
    private List<KeyDevInfo> keyList = new ArrayList<>();

    public static ChipManagerWrapper getInstance() {
        if (instance == null)
            instance = new ChipManagerWrapper();

        return instance;
    }


    private List<KeyDevInfo> enumDevice() {
        //1.获取设备所连接的所有芯片的信息
        keyList.clear();
        Pair<Integer, List<JniApiParam>> all = null;



        // check chip manager is installed or not
//        if (!Function.isPackageExist_v2(MyApplication.myApplication, CONSTANT.CHIP_MANAGER_PACKAGE_NAME)) {
//            return keyList;
//        }

        long timeout = 3000;
        long startTime = System.currentTimeMillis();
        long currentTime;
        do {

            try {
                all = jniApiManager.getAll(application);
            } catch (IllegalArgumentException e) {
                e.printStackTrace();
                Function.startChipManagerActivity(MyApplication.myApplication);
                try {
                    Thread.sleep(200);
                } catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                currentTime = System.currentTimeMillis();
                continue;
            }

            break;

        } while((currentTime-startTime)<timeout);

        if (all == null) {
            Log.e(THIS_FILE, "Invoke chip manager error");
            return keyList;
        }

        if (all.first != 0) {
            Log.e(THIS_FILE, "Get devices error. ret " + all.first);
            return keyList;
        }
        Log.d(THIS_FILE, "Get devices total count " + all.second.size());
        for(JniApiParam jp:all.second) {
            if (jp == null)
                continue;

            KeyDevInfo keyDevInfo = new KeyDevInfo();
            keyDevInfo.setDriver(KeyWrapper.CHIP_MANAGER_DRIVER_NAME);
            keyDevInfo.setCardId(jp.cardId);

            Log.d(THIS_FILE, "Device card id " + jp.cardId);
            Log.d(THIS_FILE, "Device type = " + jp.chipType);

            if (jp.chipType == JniApiParam.TYPE_ONBOARD) {
                keyDevInfo.setType(KeyWrapper.KEY_TYPE_CHIP);
            } else if (jp.chipType == JniApiParam.TYPE_BLUETOOTH) {
                keyDevInfo.setType(KeyWrapper.KEY_TYPE_BLUETOOTH);
            } else if (jp.chipType == JniApiParam.TYPE_TF) {
                keyDevInfo.setType(KeyWrapper.KEY_TYPE_TF);
            } else if (jp.chipType == JniApiParam.TYPE_COVERED) {
                keyDevInfo.setType(KeyWrapper.KEY_TYPE_SIM);
            }
            keyList.add(keyDevInfo);

        }

        return keyList;

    }

    JarJniApiProxy getProxy(String cardId) {
        Pair<Integer, JarJniApiProxy> jniProxyPair = jniApiManager.make(application, cardId);
        if (jniProxyPair.first == 0) {
            return jniProxyPair.second;
        }
        return null;
    }

    private int verifyPIN(JarJniApiProxy proxy, int role, byte[] pin) {
        Log.d(THIS_FILE, "role = " + role);
        return proxy.VerifyPIN(role, pin, pin.length);
    }

    private int getCardID(JarJniApiProxy proxy, byte[] cardId, int[] len) {
        Pair<Integer, String> pair = proxy.getCardId();
        if (pair.first != 0) {
            return pair.first;
        }

        len[0] = pair.second.length();
        System.arraycopy(pair.second.getBytes(), 0, cardId, 0, len[0]);
        return 0;
    }

    private int readCert(JarJniApiProxy proxy, byte[] fid, byte[] cert, int[] len) {
        return proxy.ReadCert(fid, cert, len);
    }

    private int readFile(JarJniApiProxy proxy, byte[] fid, int pos, int len, byte[] out) {
        return proxy.ReadFile(fid, pos, len, out);
    }

    private int RSAPrikeyCalc(JarJniApiProxy proxy, byte[] fid, int bits, byte[] data, int size, byte[] out, int[] outSize) {
        return proxy.RSAPriKeyCalc(fid, data, size, out, outSize);
    }

    private int SM2Sign(JarJniApiProxy proxy, byte[] pubfid, byte[] prifid, int dataType, byte[] dataIn, int inLen, byte[] signData, int[] signDataLen ) {
        int ret = proxy.SM2Sign(pubfid, prifid, dataType, dataIn, inLen, signData, signDataLen);
        Log.d(THIS_FILE, "SM2 sign ret " + ret);
        return ret;
    }

    private int getSM2Param(JarJniApiProxy proxy, XDJA_SM2_PARAM sm2Param) {
        return proxy.GetSM2Param(sm2Param);
    }

    private int getSM2ID(JarJniApiProxy proxy, byte[] id, int[] len) {
        return proxy.GetSM2Id(id, len);
    }

}
