package com.xdja.key.koal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.IBinder;
import android.os.RemoteException;

import com.mpt.aidlservice.Base64;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.utils.Log;

import java.util.List;
import java.util.Locale;

import kl.cds.constant.SignMethod;
import koal.cert.tools.ByteBuf;
import koal.cert.tools.ICertManager;
import koal.cert.tools.ResultBean;

/**
 * Created by xingjianqiang on 2018/4/28.
 */

public class KoalKey {
    private static KoalKey instance = null;
    private Context context = null;
    private ICertManager certManager;
    private static final String THIS_FILE = "KoalKey";

    private KoalKey() {
    }

    public static KoalKey getInstance() {
        if (instance == null) {
            instance = new KoalKey();

        }
        return instance;
    }

    private ServiceConnection conn = new ServiceConnection() {
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            Log.d(THIS_FILE, "Koal service connected");
            certManager = ICertManager.Stub.asInterface(service);
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            certManager = null;
        }
    };

    private void bindService() {
        Function.runOnMainThread(new Runnable() {
            @Override
            public void run() {
                Intent intent = new Intent();
                intent.setAction("koal.cert.tools.CertManagerService");
                intent.setComponent(new ComponentName("kl.cds", "kl.cds.service.CertManagerService"));
                Log.d(THIS_FILE, "start to call bind service");
                context.bindService(intent, conn, Context.BIND_AUTO_CREATE);
            }
        });
    }

    public boolean checkService() {
        context = MyApplication.myApplication;
        bindService();
        return true;
    }


    public List<String> getCertList() {
        if (certManager == null) {
            return null;
        }

        try {
            return certManager.SOF_GetUserList();
        } catch (RemoteException e) {
            e.printStackTrace();
        }

        return null;
    }

    public int open() {
        return 0;
    }

    public int close() {
        context.unbindService(conn);
        return 0;
    }

    private void logError(ResultBean resultBean) {
        if (ResultBean.OPER_SUC != resultBean.getErrorCode()) {
            Log.d(THIS_FILE, String.format(Locale.CHINA, "failed!errorCode:%d message:%s detail:%s"
                    , resultBean.getErrorCode(), resultBean.getMessage(), resultBean.getDetail()));
        }
    }

    public int verifyPIN(String certPath, String pwd) {
        if (certManager == null) {
            Log.e(THIS_FILE, "Cert manager null!");
            return -1;
        }
        try {
            ResultBean resultBean = certManager.SOF_Login(certPath, pwd);
            logError(resultBean);
            return resultBean.getErrorCode();
        } catch (RemoteException e) {
            e.printStackTrace();
            return -2;
        }
    }


    public int readCert(String certPath, int isSign, byte[] certBuf, int[] certLen) {
        if (certManager == null) {
            Log.e(THIS_FILE, "Cert manager null!");
            return -1;
        }

        try {
            String b64cert;
            if (isSign == 1) {
                b64cert = certManager.SOF_ExportUserCert(certPath);
            } else {
                b64cert = certManager.SOF_ExportExChangeUserCert(certPath);
            }
            byte[] cert = Base64.decode(b64cert);
            certLen[0] = cert.length;
            System.arraycopy(cert, 0, certBuf, 0, cert.length);
            return 0;
        } catch (RemoteException e) {
            e.printStackTrace();
        }

        return -2;
    }


    public int RSAPrikeyCalc(byte[] input, int inputLen, byte[] output, int[] outputLen) {
        if (certManager == null) {
            Log.e(THIS_FILE, "Cert manager null!");
            return -1;
        }
        ResultBean resultBean = null;
        try {
            byte[] inputBuf = new byte[inputLen];
            System.arraycopy(input, 0, inputBuf, 0, inputLen);
            ByteBuf localSignDataByte = new ByteBuf();
            String str = Base64.encodeBytes(inputBuf);
            resultBean = certManager.SKF_NakedSignData(inputBuf, localSignDataByte);
            if (ResultBean.OPER_SUC != resultBean.getErrorCode()) {
                logError(resultBean);
                return resultBean.getErrorCode();
            }

            byte[] result = localSignDataByte.getByte();
            outputLen[0] = result.length;
            System.arraycopy(result, 0, output, 0, result.length);
            return 0;
        } catch (RemoteException e) {
            e.printStackTrace();
        }


//        try {
//            ResultBean resultBean = certManager.SOF_SetSignMethod(SignMethod.SGD_SHA1_RSA.getType());
//            if (ResultBean.OPER_SUC != resultBean.getErrorCode()) {
//                logError(resultBean);
//                return resultBean.getErrorCode();
//            }
//
//            byte[] inputBuf = new byte[inputLen];
//            System.arraycopy(input, 0, inputBuf, 0, inputLen);
//            ByteBuf localSignDataByte = new ByteBuf();
//            resultBean = certManager.SOF_SignData(inputBuf, localSignDataByte);
//            if (ResultBean.OPER_SUC != resultBean.getErrorCode()) {
//                logError(resultBean);
//                return resultBean.getErrorCode();
//            }
//
//            byte[] result = localSignDataByte.getByte();
//            outputLen[0] = result.length;
//            System.arraycopy(result, 0, output, 0, result.length);
//            return 0;
//
//        } catch (RemoteException e) {
//            e.printStackTrace();
//        }

        return -2;
    }

    public int SM2Sign(byte[] input, int inputLen, byte[] output, int[] outputLen) {
        if (certManager == null) {
            Log.e(THIS_FILE, "Cert manager null!");
            return -1;
        }
        ResultBean resultBean = null;
        try {
            byte[] inputBuf = new byte[inputLen];
            System.arraycopy(input, 0, inputBuf, 0, inputLen);
            ByteBuf localSignDataByte = new ByteBuf();
            resultBean = certManager.SKF_NakedSignData(inputBuf, localSignDataByte);
            if (ResultBean.OPER_SUC != resultBean.getErrorCode()) {
                logError(resultBean);
                return resultBean.getErrorCode();
            }

            byte[] result = localSignDataByte.getByte();
            outputLen[0] = result.length;
            System.arraycopy(result, 0, output, 0, result.length);
            return 0;
        } catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }
}