package com.xdja.key.longmai;

import android.content.Context;

import com.longmai.security.plugin.SOF_DeviceLib;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.utils.Log;
import com.xdja.safeclient.utils.LogUtil;
import com.xdja.safeclient.utils.ToastUtil;
import com.xdja.sslvpn.CONSTANT;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

/**
 * Created by xingjianqiang on 2018/4/14.
 */

public class LMWrapper {
    private Context context = null;
    private static final String THIS_FILE = "LMWrapper";
    private static LMWrapper instance = null;
    private LMWrapper(){}

    public static LMWrapper getInstance() {
        if (instance == null){
            instance = new LMWrapper();
        }
        return instance;
    }

    public int loadDriver() {
        context = MyApplication.myApplication;
        List<String> longmai_init_param = new ArrayList<>();
        try {
            DocumentBuilder domBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document xml = domBuilder.parse(context.getAssets().open("longmai_config.xml"));
            Element root = xml.getDocumentElement();
            NodeList _drivers = root.getElementsByTagName("driver");
            for (int i = 0; i < _drivers.getLength(); i++) {
                Element driver = (Element) _drivers.item(i);
                if (driver.getAttribute("name").equals(CONSTANT.LONGMAI_SDCARD_DRVIER_NAME)) {
                    LogUtil.d(THIS_FILE, "id:" + driver.getAttribute("id"));
                    LogUtil.d(THIS_FILE, "name:" + driver.getAttribute("name"));
                    LogUtil.d(THIS_FILE, "class:" + driver.getAttribute("class"));
                    LogUtil.d(THIS_FILE, "describe:" + driver.getAttribute("describe"));
                    longmai_init_param.add(driver.getAttribute("id"));
                    longmai_init_param.add(driver.getAttribute("name"));
                    longmai_init_param.add(driver.getAttribute("class"));
                    longmai_init_param.add(driver.getAttribute("describe"));
                    break;
                }
            }
        } catch (Exception e) {
            Log.e(THIS_FILE, "Get sdcard driver failed");
            e.printStackTrace();
            return -1;
        }
        int ret = SOF_DeviceLib.SOF_LoadLibrary(context, longmai_init_param.get(0), longmai_init_param.get(1),
                longmai_init_param.get(2), longmai_init_param.get(3));
        if (ret != 0) {
            Log.e(THIS_FILE,"Load driver failed. Return "+ SOF_DeviceLib.SOF_GetLastError());
            return ret;
        }

        return 0;
    }

    public List<String> enumDevices() {
        int ret;
        List<String> devices = new ArrayList<String>();
        loadDriver();
        ret = SOF_DeviceLib.SOF_EnumDevices(context, devices);
        if (ret != 0) {
            Log.e(THIS_FILE, "SOF Enum devices failed. Return " + SOF_DeviceLib.SOF_GetLastError());
            return null;
        }
        return devices;
    }

    public List<String> enumApplications() {
        int ret;
        List<String> appNames = new ArrayList<String>();
        ret = SOF_DeviceLib.SOF_EnumApplication(appNames);
        if (ret != 0) {
            SOF_DeviceLib.SOF_Disconnect();
            Log.e(THIS_FILE, "SOF enum application failed. err " + SOF_DeviceLib.SOF_GetLastError());
            return null;
        }

        if (appNames.size() <= 0) {
            SOF_DeviceLib.SOF_Disconnect();
            Log.e(THIS_FILE, "No applicaiton found");
            return null;
        }

        Log.d(THIS_FILE, "Enum application " + appNames);
        return appNames;
    }

    public String getDeviceId(String deviceName) {
        int ret;
        ret = SOF_DeviceLib.SOF_Connect(deviceName, "");
        if (ret != 0) {
            Log.d(THIS_FILE, "SOF connect failed. Return " + SOF_DeviceLib.SOF_GetLastError());
            return "";
        }

        byte[] label = new byte[128];
        byte[] serialNumber = new byte[128];
        int[] version = new int[1];
        ret = SOF_DeviceLib.SOF_GetDeviceInfo(label, serialNumber, version);
        if(ret != 0){
            Log.e(THIS_FILE, "SOF get device info failed. err " + SOF_DeviceLib.SOF_GetLastError());
            return "";
        }

        return new String(serialNumber, 0, 16);

    }
}
