package com.xdja.providers.safetfprovider;

import java.io.UnsupportedEncodingException;
import java.security.Key;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;

import com.xdja.SafeKey.XDJA_SM2_PARAM;
import com.xdja.key.KeyErrno;
import com.xdja.key.KeyWrapper;
import com.xdja.key.covercard.CoverCardWrapper;
import com.xdja.safeclient.BuildConfig;
import com.xdja.safeclient.event.EventManager;
import com.xdja.safeclient.utils.ExpireUtil;
import com.xdja.safeclient.utils.Log;

import android.widget.Toast;

import com.google.gson.Gson;
import com.safetf.CertDetailInfo;
import com.safetf.SafeTF;
import com.xdja.SafeKey.JNIAPI;
import com.xdja.bean.VendorInfoJson;
import com.xdja.safeclient.CardOperation;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.TunVpnService;
import com.xdja.safeclient.VerifyTime;
import com.xdja.safeclient.VpnService;
import com.xdja.safeclient.StartVpnActivity;
import com.xdja.sslvpn.CONSTANT;
import com.xdja.sslvpn.SslvpnStatus;

import org.json.JSONException;
import org.json.JSONObject;

public class SafetfContentProvider extends ContentProvider {
    private final static int ANDROID_4_4_2 = 19;

    private JNIAPI mSafeKey = new JNIAPI();
    private int mHandle = 0;

    /**
     * 通过卡接口收发数据失败，有可能是安全卡掉电引起。
     */
    private final static int XKR_IO_FAILED = -2;

    /**
     * 接口参数错误
     */
    public final static int XKR_INVALID_PARA = -9;

    /**
     * Log tag is this file
     */
    private static final String THIS_FILE = "SafetfContentProvider";


    private boolean blockMainThread = false;

    private String TAG = "SafetfContentProvider";

    HandlerThread handlerThread = new HandlerThread("provider_thread");

    private Handler myHandler;

    class MyHandler extends Handler {
        public MyHandler(Looper looper) {
            super(looper);
        }
    }
    ;

    @Override
    public boolean onCreate() {
        Log.e(TAG, "Init key module.");
        if (!BuildConfig.isAAR) {
            Function.initKeyModule(false);
        }

        handlerThread.start();
        myHandler = new MyHandler(handlerThread.getLooper());
        return false;
    }


    @Override
    public Cursor query(Uri uri, String[] projection, String selection,
                        String[] selectionArgs, String sortOrder) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public String getType(Uri uri) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public Bundle call(String method, String arg, Bundle extras) {
        Log.d("app", "method = " + method);
        Bundle ret = null;
        if (method.equals(SafetfContentPrividerUtil.METHOD_STARTSAFECLIENT)) {
            ret = startSafeClient();
        } else if (method.equals(SafetfContentPrividerUtil.METHOD_VERIFYPIN)) {
            ret = verifyPIN(extras);
        } else if (method.equals(SafetfContentPrividerUtil.METHOD_SM1)) {
            ret = sm1(extras);
        } else if (method.equals(SafetfContentPrividerUtil.METHOD_RSAPRIKEYCALC)) {
            ret = rsaPriKeyCalc(extras);
        } else if (method.equals(SafetfContentPrividerUtil.METHOD_SM2SIGN)) { // SM2签名
            ret = sm2Sign(extras);
        } else if (method.equals(SafetfContentPrividerUtil.METHOD_GET_SM2_ID)) {
            ret = getSM2ID();
        } else if (method.equals(SafetfContentPrividerUtil.METHOD_GET_SM2_PARAM)) {
            ret = getSM2Param();
        } else if (method.equals(SafetfContentPrividerUtil.METHOD_GETSAFECARDID)) {
            //获取警员编号
            ret = getSafeCardID();
        } else if (method.equals(SafetfContentPrividerUtil.METHOD_GETPOLICEMANID)) {
            //获取警员编号
            ret = getPolicemanID();
        } else if (method.equals(SafetfContentPrividerUtil.METHOD_GET_LAST_VERIFY_TIME)) {
            //获取上次认证成功的时间
            ret = getLastVerifyTime();
        } else if (method.equals(SafetfContentPrividerUtil.METHOD_GET_VENDOR_INFO)) {
            // 获取厂商信息（json）
            ret = getVendorInfo();
        } else if (method.equals(SafetfContentPrividerUtil.METHOD_GET_VPN_TUNNEL_STATE)) {
            // 获取vpn连接状态
            ret = getVPNTunnelState();
        } else if (method.equals(SafetfContentPrividerUtil.METHOD_GET_MONITOR_SERVER_ADDRESS)) {
            // 获取监听的服务器地址
            ret = getMonitorServerAddress();
        } else if (method.equals(SafetfContentPrividerUtil.METHOD_CHECK_WEAK_PASSWD)) {
            // 当前是否弱密码
            ret = checkWeakPassWD();
        } else if (method.equals(SafetfContentPrividerUtil.METHOD_PASSWORD_ENTER)) {
            // 尝试验证密码
            ret = passwordEnter(extras);
        } else if (method.equals(SafetfContentPrividerUtil.METHOD_READ_DEFAULT_CERT)) {
            // 获取默认证书
            ret = getDefaultCert();
        } else if (method.equals(SafetfContentPrividerUtil.METHOD_GET_DEFAULT_CERT_SN)) {
            // 获取默认证书SN
            ret = readDefaultCertSN();

        } else if (method.equals(SafetfContentPrividerUtil.METHOD_EXCUTE_CMD)) {
            // 执行CMD命令
            ret = excuteCmd(extras);
        } else if (method.equals(SafetfContentPrividerUtil.METHOD_READFILE)) {
            // read file
            ret = readFile(extras);
        } else if (method.equals(SafetfContentPrividerUtil.METHOD_READCERT)) {
            // read cert
            ret = readCert(extras);
        } else if (method.equals(SafetfContentPrividerUtil.METHOD_KILL_SAFECLIENT)) {
            ret = killClient();
        } else {
            ret = new Bundle();
            ret.putInt("ret", JNIAPI.XKR_NOT_SUPPORT);
        }
        return ret;
    }

    @Override
    public Uri insert(Uri uri, ContentValues values) {
        return null;
    }

    @Override
    public int delete(Uri uri, String selection, String[] selectionArgs) {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public int update(Uri uri, ContentValues values, String selection,
                      String[] selectionArgs) {
        // TODO Auto-generated method stub
        return 0;
    }

    private int startTunVpn() {
        try {
            Intent intent = new Intent(getContext(), StartVpnActivity.class);
            intent.setFlags(Intent.FLAG_ACTIVITY_BROUGHT_TO_FRONT
                    | Intent.FLAG_ACTIVITY_NEW_TASK);
            //intent.setComponent(componetName);
            getContext().startActivity(intent);

            if (MyApplication.myApplication.sslClientConfig.getTransportMode() == 1) {
                Log.d(THIS_FILE, "Current mode tun, need to sleep 500 ms to ensure start success");
                Thread.sleep(500);
            }
        } catch (Exception e) {
            e.printStackTrace();
            Log.e(TAG, "startActivity StartVpnActivity failed");
            return -1;
        }

        return 0;
    }

    public Bundle startSafeClient() {
        Bundle retBundle = new Bundle();


   /*     if (BuildConfig.enableExpired) {
            boolean expired = ExpireUtil.validExpiredDate(getContext());
            if (!expired) {
                retBundle.putInt("ret", -1);
                return retBundle;
            }
        }*/

        int ret;
        ret = startTunVpn();
        retBundle.putInt("ret", ret);
        return retBundle;
    }
    //end

    //卡库版本接口
    public Bundle getVersion() {
        Bundle retBundle = new Bundle();
        byte[] version = new byte[256];
        int[] versionLen = new int[1];
        int ret = -1;
        // TODO add logic
        retBundle.putInt("ret", ret);
        return retBundle;
    }

    //验证pin码
    public Bundle verifyPIN(final Bundle inBundle) {
        final Bundle retBundle = new Bundle();
        final int ret[] = new int[1];
        ret[0] = -1;
        final Object lock = new Object();

        synchronized (lock) {
            myHandler.post(new Runnable() {
                @Override
                public void run() {
                    int role = inBundle.getInt("pinrole", -1);
                    if (role == -1) {
                        String pinStr = inBundle.getString("pin");
                        Log.d(THIS_FILE, "This is from FORWARD Client invoke");
                        ret[0] = KeyWrapper.getInstance().verifyPIN(pinStr);
                        retBundle.putInt("ret", ret[0]);
                    } else {
                        // try parse param by old interface
                        byte[] pin = inBundle.getByteArray("pin");
                        ret[0] = KeyWrapper.getInstance().xdjaKeyVerifyPIN(new String(pin), role);
                        retBundle.putInt("ret", KeyErrno.errParseToXdja(ret[0]));
                    }
                    synchronized (lock) {
                        lock.notify();
                    }
                }
            });

            try {
                lock.wait();
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        return retBundle;
    }

    //对称算法
    //sm1运算
    public Bundle sm1(Bundle inBundle) {
        Bundle retBundle = new Bundle();
        byte[] datain = inBundle.getByteArray("datain");
        int inlen = inBundle.getInt("inlen");
        int flag = inBundle.getInt("flag");
        int kid = inBundle.getInt("kid");
        byte[] iv = inBundle.getByteArray("iv");

        int ret = -1;
        byte[] dataout = new byte[inlen];
        ret = mSafeKey.SM1(mHandle, datain, inlen, flag, dataout, (byte) kid, iv);

        if (ret == 0) {
            retBundle.putByteArray("result", dataout);
        }
        retBundle.putInt("ret", ret);
        return retBundle;
    }


    public Bundle rsaPriKeyCalc(Bundle inBundle) {
        Bundle retBundle = new Bundle();

        int ret = -1;
        byte[] dataout;
        int bits = inBundle.getInt("bits");
        int inlen = inBundle.getInt("inlen");
        byte[] datain = inBundle.getByteArray("datain");
        int[] outlen = new int[1];

        if (bits != 0) {// forward client
            dataout = new byte[bits / 8];
            ret = KeyWrapper.getInstance().RSAPrikeyCalc(bits, datain, inlen, dataout, outlen);
        } else { // old interface
            byte[] fid = inBundle.getByteArray("fid");
            dataout = new byte[inlen];
            ret = KeyWrapper.getInstance().xdjaRSAPrikeyCalc(fid, datain, inlen, dataout, outlen);
        }

        if (ret == 0) {
            retBundle.putByteArray("result", dataout);
        }

        retBundle.putInt("ret", KeyErrno.errParseToXdja(ret));
        return retBundle;
    }

    /**
     * 以下描述摘自邮件
     * 我们XKF_RSASign函数接口接收两种格式数据：
     * 1. datatype=SIGN_HASH时，传入20字节的SHA1摘要结果，传入COS，COS内部按PKCS#1签名数据格式填充；
     * 2. datatype=SIGN_NOHASH时，传入要签名的数据，接口内部对数据进行SHA1数据摘要，得到20字节摘要结果，传入COS，COS内部按PKCS#1签名数据格式填充；
     * <p/>
     * COS内部PKCS#1签名数据填充格式如下：
     * 0x00 || 0x01 || PS || 0x00 || T
     * <p/>
     * 其中:
     * 1. 共128字节（RSA1024）或者256字节（RSA2048）
     * PS为105个（RSA1024）或者233个（RSA2048）0xff
     * T为20个字节的SHA1摘要值
     * <p/>
     * 问题原因很可能是T值包含DER编码头：\x30\x21\x30\x09\x06\x05\x2b\x0e\x03\x02\x1a\x05\x00\x04\x14
     * 即：PS值为90个（RSA1024）或者218个（RSA2048）0xff，T为15个字节头+20个字节SHA1摘要值
     *
     * @param inBundle
     * @return
     */
    public Bundle rsaSignWithoutDER(Bundle inBundle) {
        Bundle retBundle = new Bundle();
        int bits = inBundle.getInt("bits");
        byte[] prifid = inBundle.getByteArray("prifid");
        int datatype = inBundle.getInt("datatype");//NO_HASH是1
        byte[] datain = inBundle.getByteArray("datain");
        int inlen = inBundle.getInt("inlen");
        byte[] digest = inBundle.getByteArray("digest");

        byte[] sha1Value = new byte[20];

        boolean NO_HASH = datatype == 1;

        if (NO_HASH) {//NO_HASH
            //sha1摘要结果
            int sha1Success = -1;
            sha1Success = mSafeKey.SHA1(mHandle, datain, inlen, sha1Value);

            //sha1摘要失败
            if (sha1Success != 0) {
                Toast.makeText(getContext(), R.string.sha1_digest_error, Toast.LENGTH_SHORT).show();
                retBundle.putInt("ret", sha1Success);
                return retBundle;
            }
        } else {
            // TODO: 2017/1/9 0009 判断摘要值长度
            if (digest == null) {
                Toast.makeText(getContext(), R.string.digest_error, Toast.LENGTH_SHORT).show();
            }
        }
        //1024代表RSA1024,2048代表RSA2048
        byte[] PS = CardOperation.genPSValue(bits == 1024);
        if (NO_HASH) {
            datain = CardOperation.formatPKCS(PS, sha1Value);
        } else {
            datain = CardOperation.formatPKCS(PS, digest);
        }

        int ret = -1;
        byte[] dataout = new byte[256];
        int[] outlen = new int[1];

        //RSA1024是128位，RSA2048是256位
        int inLength = bits == 1024 ? 128 : 256;

        ret = mSafeKey.RSAPriKeyCalc(mHandle, prifid, datain, inLength, dataout, outlen);

        if (ret == 0) {
            byte[] result = new byte[outlen[0]];
            System.arraycopy(dataout, 0, result, 0, result.length);
            retBundle.putByteArray("result", result);
        }
        retBundle.putInt("ret", ret);
        return retBundle;
    }


    //================================SM2 Method===================Start===================
    // sm2 sign
    public Bundle sm2Sign(Bundle inBundle) {
        final Bundle retBundle = new Bundle();
        final int ret[] = new int[1];
        ret[0] = -1;
        final Object lock = new Object();

        final byte[] pubfid = inBundle.getByteArray("pubfid");
        final byte[] prifid = inBundle.getByteArray("prifid");
        final int datatype = inBundle.getInt("datatype");
        final byte[] datain = inBundle.getByteArray("datain");
        final int inlen = inBundle.getInt("inlen");

        final int ishashed = inBundle.getInt("ishashed");

        final byte[] dataout = new byte[64];
        final int[] outlen = new int[1];

        synchronized (lock) {
            myHandler.post(new Runnable() {
                @Override
                public void run() {
                    if (pubfid != null && prifid != null) { // old interface
                        ret[0] = KeyWrapper.getInstance().xdjaSM2Sign(pubfid, prifid, datatype, datain, inlen, dataout, outlen);
                    } else { // forward client
                        ret[0] = KeyWrapper.getInstance().SM2Sign(ishashed, datain, inlen, dataout, outlen);
                    }

                    if (ret[0] == 0) {
                        retBundle.putByteArray("result", dataout);
                    }
                    synchronized (lock) {
                        lock.notify();
                    }
                }
            });

            try {
                lock.wait();
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        retBundle.putInt("ret", KeyErrno.errParseToXdja(ret[0]));
        return retBundle;
    }

    public Bundle getSM2Param() {
        Bundle result = new Bundle();
        int ret;
        XDJA_SM2_PARAM sm2Param = new XDJA_SM2_PARAM();
        ret = KeyWrapper.getInstance().getSM2Param(sm2Param);

        if (ret == 0) {
            result.putParcelable("result", sm2Param);
        }
        result.putInt("ret", ret);
        return result;
    }

    public Bundle getSM2ID() {
        Bundle result = new Bundle();
        int ret;
        byte[] id = new byte[128];
        int[] len = new int[1];

        ret = KeyWrapper.getInstance().getSM2ID(id, len);
        if (ret == 0) {
            result.putByteArray("id", id);
            result.putInt("len", len[0]);
        }

        result.putInt("ret", ret);
        return result;
    }


    public Bundle getSafeCardID() {

        final Bundle retBundle = new Bundle();

        final int ret[] = new int[1];
        ret[0] = -1;
        final byte[] cardIdArray = new byte[64];
        final int[] cardIdLen = new int[1];
        final Object lock = new Object();

        synchronized (lock) {
            myHandler.post(new Runnable() {
                @Override
                public void run() {
                    ret[0] = KeyWrapper.getInstance().getSN(cardIdArray, cardIdLen);
                    String cardId = null;
                    if (ret[0] == 0) {
                        cardId = new String(cardIdArray, 0, cardIdLen[0]);
                        Log.d(TAG, "Card id " + cardId);
                    }

                    retBundle.putString("result", cardId);
                    synchronized (lock) {
                        lock.notify();
                    }
                }
            });

            try {
                lock.wait();
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        return retBundle;


    }

    //获取警员编号  TODO 需要通过统一卡模块实现此接口
    public Bundle getPolicemanID() {
        Bundle retBundle = new Bundle();

        int[] handle = new int[2];
        int ret = -1;
        byte[] fid = {0x00, (byte) 0x9A};

        int dataLen = 0;
        byte[] pDataLen = new byte[2];

        String policemanID = "";

        if (0 != ret) {
            Log.e("SafetfContentProvider", "getPolicemanID, OpenDev faild,  ret = " + ret);
            return null;
        }

        ret = mSafeKey.ReadFile(handle[0], fid, 0, 2, pDataLen);

        if (ret != 0) {
            Log.e("SafetfContentProvider", "getPolicemanID , get pDataLen failed, ret = " + ret);
            mSafeKey.CloseDev(handle[0]);
            return null;
        }

        dataLen = byteToInt(pDataLen, 2);

        Log.d("SafetfContentProvider", "dataLen = " + dataLen);

        if (dataLen <= 0) {
            Log.e("SafetfContentProvider", "dataLen = " + dataLen);
            mSafeKey.CloseDev(handle[0]);
            return null;
        }

        byte[] pData = new byte[dataLen];

        ret = mSafeKey.ReadFile(handle[0], fid, 2, dataLen, pData);

        if (ret != 0) {
            Log.e("SafetfContentProvider", "getPolicemanID , get pData failed, ret = " + ret);
            mSafeKey.CloseDev(handle[0]);
            return null;
        }

        mSafeKey.CloseDev(handle[0]);

        try {
            policemanID = new String(pData, 0, dataLen, "gbk");

            Log.d("SafetfContentProvider", "policemanID = " + policemanID);

            retBundle.putString("result", policemanID);
        } catch (UnsupportedEncodingException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

        return retBundle;
    }

    public Bundle getLastVerifyTime() {
        Bundle bundle = new Bundle();
        long last = VerifyTime.readLastVerifyTime(getContext());
        Log.d("认证时间", "读取到的认证时间" + last);
        bundle.putLong("lastVerifyTime", last);
        return bundle;
    }


    public Bundle getVPNTunnelState() {
        Bundle bundle = new Bundle();

        bundle.putBoolean("result", Function.isVPNConnected());

        return bundle;
    }

    public Bundle getMonitorServerAddress() {

        Bundle bundle = new Bundle();
        int res = -1;
        String serverAddr = null;

        MyApplication myApplication = MyApplication.myApplication;

        JSONObject json = new JSONObject();
        try {
            json.put("jsonrpc", "2.0");
            json.put("id", "1");

            JSONObject result = new JSONObject();

            JSONObject serveraddress = new JSONObject();

            if (!Function.isVPNConnected()) {
                result.put("res", "FAILED");
                Log.d(TAG, "safeVerifySuccess false");
            } else {
                result.put("res", "OK");
                Log.d("AidlService", "safeVerifySuccess true");

                if (0 == myApplication.sslClientConfig.transportMode) {

                    SslvpnStatus sslvpnStatus = new SslvpnStatus();

                    if (myApplication.sslvpn != null) {
                        res = myApplication.sslvpn.getStatus(sslvpnStatus);

                        serveraddress.put("monitorserverip", "127.0.0.1");
                        if (res == 0 && sslvpnStatus != null) {
                            serveraddress.put("monitorserverporxyport", sslvpnStatus.monitorserverporxyport);
                            serveraddress.put("monitorserverporxyport1", sslvpnStatus.monitorserverporxyport1);
                        }
                        serveraddress.put("tunelmode", "101");

                    } else {
                        result.put("res", "FAILED");
                    }
                } else {
                    final SslvpnStatus sslvpnStatus = new SslvpnStatus();
                    blockMainThread = true;
                    int count = 0;

                    new Thread() {
                        public void run() {
                            getCurSslvpnStatus(sslvpnStatus);
                            blockMainThread = false;
                        }
                    }.start();

                    while (blockMainThread) {
                        if (count > 30) {
                            break;
                        }

                        count++;

                        try {
                            Thread.sleep(100);
                        } catch (InterruptedException e) {
                            // TODO Auto-generated catch block
                            e.printStackTrace();
                        }
                    }

                    if (sslvpnStatus != null) {
                        serveraddress.put("monitorserverip", sslvpnStatus.monitorSrvIp);
                        serveraddress.put("realPort", sslvpnStatus.monitorserverporxyport);
                        serveraddress.put("realPort1", sslvpnStatus.monitorserverporxyport1);
                    }
                    serveraddress.put("tunelmode", "100");
                }
            }

            result.put("serveraddress", serveraddress);
            json.put("result", result);


            serverAddr = json.toString();
            Log.d("AidlService", "getMonitorServerAddress : " + serverAddr);

            bundle.putString("result", serverAddr);
        } catch (JSONException e) {
            bundle.putString("result", "");
        }

        return bundle;
    }

    /**
     * 获取厂商信息
     *
     * @return
     */
    private String buildVendorInfo() {

        String versionStr = null;
        String vendorInfo = null;
        Gson gson = new Gson();
        byte[] version = new byte[256];
        int[] versionLen = new int[1];

        VendorInfoJson vendorinfojosn = new VendorInfoJson();

        int ret = -1;
        ret = mSafeKey.GetVersion(version, versionLen);
        if (ret == 0) {
            versionStr = new String(version, 0, versionLen[0]);
        }

        // 厂商名称
        vendorinfojosn.getResult().getVendorinfo().setVendor("xdja");
        // 卡库版本信息
        vendorinfojosn.getResult().getVendorinfo().setVersion(versionStr);
        // 扩展信息
        vendorinfojosn.getResult().getVendorinfo().setExtendinfo("");
        // josn id
        vendorinfojosn.setId(2);
        // 获取卡库版本号结果
        if (TextUtils.isEmpty(versionStr)) {
            vendorinfojosn.getResult().setRes("FAILED");
        } else {
            vendorinfojosn.getResult().setRes("OK");
        }

        vendorInfo = gson.toJson(vendorinfojosn);

        Log.d("AidlService", "getVendorInfo : " + vendorInfo);

        return vendorInfo;
    }

    public Bundle getVendorInfo() {
        Bundle bundle = new Bundle();
        bundle.putString("result", buildVendorInfo());
        return bundle;
    }

    /**
     * 检查是否弱密码，没有输入过默认为弱密码 xjq 2017-01-18 19:19:36
     *
     * @return
     */
    public Bundle checkWeakPassWD() {
        Bundle bundle = new Bundle();
        boolean isWeak;

        MyApplication application = MyApplication.myApplication;
        if (application == null) {
            isWeak = true;
        } else {
            isWeak = application.isWeakPassWD;
        }

        bundle.putBoolean("result", isWeak);
        return bundle;
    }

    public Bundle passwordEnter(Bundle inBundle) {
        String testPin = inBundle.getString("pin", "");
        Bundle bundle = new Bundle();
        MyApplication application = MyApplication.myApplication;
        int role = 0x01; // 警务上的默认角色
        int ret = -1;

        if (TextUtils.isEmpty(testPin)) {
            bundle.putBoolean("result", false);
            return bundle;
        }

        if (application != null) {
            role = application.sslClientConfig.getRole();
            if (role != 0x01 && role != 0x11) {
                byte[] defaultCertId = application.sslClientConfig.getCertId();
                role = Function.generateRole(defaultCertId);
            }
        }

        ret = mSafeKey.VerifyPIN(mHandle, role, testPin.getBytes(), testPin.length());

        bundle.putBoolean("result", ret == 0);

        return bundle;
    }

    /**
     * 获取默认证书的SN号
     *
     * @return
     */
    public Bundle readDefaultCertSN() {
        Bundle bundle = new Bundle();
        MyApplication application = MyApplication.myApplication;
        int nres = -1;
        CertDetailInfo certDetailInfo = null;
        SafeTF tf = new SafeTF();

        byte[] fid = new byte[]{0x00, 0x29}; // 警务项目默认证书ID

        if (application != null) {
            if (application.sslClientConfig != null) {
                fid = application.sslClientConfig.getCertId();
                Log.d(TAG, "CertId :" + fid[0] + fid[1]);
            }
        }

        certDetailInfo = new CertDetailInfo();

        nres = tf.GetCertDetailInfo(mHandle, fid, certDetailInfo);

        Log.d(THIS_FILE, "handle = " + mHandle + "Get cert detail info ret " + nres);

        bundle.putInt("ret", nres);
        bundle.putString("result", nres == 0 ? certDetailInfo.sn : "");
        return bundle;
    }


    //xdja 读文件
    public Bundle readFile(Bundle inBundle) {
        final Bundle retBundle = new Bundle();
        final byte[] fid = inBundle.getByteArray("fid");
        final int readpos = inBundle.getInt("readpos");
        final int readlen = inBundle.getInt("readlen");
        final int ret[] = new int[1];
        ret[0] = -1;
        final byte[] dataout = new byte[readlen];
        final Object lock = new Object();

        synchronized (lock) {
            myHandler.post(new Runnable() {
                @Override
                public void run() {
                    ret[0] = KeyWrapper.getInstance().xdjaKeyReadFile(fid, readpos, readlen, dataout);
                    if (ret[0] == 0) {
                        retBundle.putByteArray("result", dataout);
                    }
                    synchronized (lock) {
                        lock.notify();
                    }
                }
            });

            try {
                lock.wait();
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }


        retBundle.putInt("ret", KeyErrno.errParseToXdja(ret[0]));
        return retBundle;
    }

    public Bundle killClient() {
        Bundle bundle = new Bundle();
        Log.e(THIS_FILE, "Force kill safeclient");
        MyApplication.myApplication.getHandler().post(new Runnable() {
            @Override
            public void run() {
                Function.exitApp(MyApplication.myApplication);
            }
        });

        bundle.putInt("ret", 0);
        return bundle;
    }

    //xdja read cert
    public Bundle readCert(Bundle inBundle) {
        final Bundle retBundle = new Bundle();
        final byte[] fid = inBundle.getByteArray("fid");
        final int ret[] = new int[1];
        ret[0] = -1;
        final Object lock = new Object();

        final byte[] certbuf = new byte[2048];
        final int[] certlen = new int[1];

        synchronized (lock) {
            myHandler.post(new Runnable() {
                @Override
                public void run() {
                    ret[0] = KeyWrapper.getInstance().xdjaKeyReadCert(fid, certbuf, certlen);

                    if (ret[0] == 0) {
                        byte[] result = new byte[certlen[0]];
                        System.arraycopy(certbuf, 0, result, 0, result.length);
                        retBundle.putByteArray("result", result);
                    }
                    synchronized (lock) {
                        lock.notify();
                    }
                }

            });


            try {
                lock.wait();
            } catch (InterruptedException e) {
                e.printStackTrace();
            }

        }
        retBundle.putInt("ret", KeyErrno.errParseToXdja(ret[0]));
        return retBundle;
    }

    /**
     * 获取配置的证书（DER格式）
     *
     * @return
     */
    public Bundle getDefaultCert() {
        Bundle bundle = new Bundle();
        MyApplication application = MyApplication.myApplication;
        int ret = -1;

        byte[] fid; // 警务项目默认证书ID
        byte[] certBuf = new byte[2048];
        int[] certLen = new int[1];

        if (application != null) {
            if (application.sslClientConfig != null) {
                fid = application.sslClientConfig.getCertId();
                Log.d(TAG, "CertId :" + fid[0] + fid[1]);
            }
        }
        ret = KeyWrapper.getInstance().readSignCert(certBuf, certLen);
        if (ret == 0) {
            byte[] result = new byte[certLen[0]];
            System.arraycopy(certBuf, 0, result, 0, result.length);
            bundle.putByteArray("result", result);
        }

        bundle.putInt("ret", ret);
        return bundle;
    }


    public Bundle excuteCmd(Bundle inBundle) {
        MyApplication application = MyApplication.myApplication;
        Bundle outBundle = new Bundle();

        String cmd = inBundle.getString("cmd");

        if (application != null && application.sslvpn != null) {
            outBundle.putInt("ret", 0);
            outBundle.putString("result", application.sslvpn.excuteOuterCmd(cmd));
        } else {
            outBundle.putInt("ret", -1);
        }

        return outBundle;
    }

    public static int byteToInt(byte[] b, int len) {

        int mask = 0xff;
        int temp = 0;
        int n = 0;
        for (int i = 0; i < len; i++) {
            n <<= 8;
            temp = b[i] & mask;
            n |= temp;
        }
        return n;
    }


    /**
     * @param sslvpnStatus
     */
    private void getCurSslvpnStatus(SslvpnStatus sslvpnStatus) {

        String temp = null;
        int vpnstatelen = 0;
        byte[] vpnstate = new byte[4096];

        MyApplication myApplication = MyApplication.myApplication;

        if (myApplication == null) { // app 未初始化
            sslvpnStatus.monitorSrvIp = "";
            return;
        }

//        if (myApplication.havingRootPermission) {
//            if (VpnService.sock == null) {
//                sslvpnStatus.monitorSrvIp = "";
//                return;
//            }
//            VpnService.sock.sendData(CONSTANT.CMD_GET_CUR_STATE);
//
//            vpnstatelen = VpnService.sock.recvData(vpnstate);
//        } else
        {
            if (TunVpnService.sock == null) {
                sslvpnStatus.monitorSrvIp = "";
                return;
            }
            TunVpnService.sock.sendData(CONSTANT.CMD_GET_CUR_STATE);

            vpnstatelen = TunVpnService.sock.recvData(vpnstate);
        }

        Log.d("AidlService", "vpnstatelen = " + vpnstatelen);


        if (vpnstatelen <= 0) {
            Log.d("AidlService", "vpnstatelen = " + vpnstatelen);
            sslvpnStatus.monitorSrvIp = "";
            return;
        }

        temp = new String(vpnstate, 0, vpnstatelen);

        Log.d("AidlService", "temp = " + temp);

        String[] arrayStr = temp.split("#");

        if (arrayStr.length < 6) {
            Log.d("AidlService", "arrayStr.length = " + arrayStr.length);
            return;
        }

        sslvpnStatus.monitorserverporxyport = arrayStr[3];

        sslvpnStatus.monitorserverporxyport1 = arrayStr[4];

        sslvpnStatus.monitorSrvIp = arrayStr[5];

    }

}
