package com.xdja.safeclient;

import com.google.common.primitives.Bytes;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;

/**
 * Description:卡操作一些相关的常量和方法
 * Created by zjc on 2017/1/9 0009.
 */
public class CardOperation {

    //SHA1算法的DER编码头
    public static final byte[] DER_SHA1_HEAD =
            {0x30, 0x21, 0x30, 0x09, 0x06,
                    0x05, 0x2b, 0x0e, 0x03, 0x02,
                    0x1a, 0x05, 0x00, 0x04, 0x14};

    /**
     * * COS内部PKCS#1签名数据填充格式如下：
     * 0x00 || 0x01 || PS || 0x00 || T
     * PS是若干个0xff值
     * T是SHA1算法DER编码头 + 20字节SHA1摘要
     *
     * @param ps
     * @param sha1Value
     * @return
     */
    public static final byte[] formatPKCS(byte[] ps, byte[] sha1Value) {
        List<Byte> value = new ArrayList<Byte>();
        value.add(Byte.decode("0x00"));
        value.add(Byte.decode("0x01"));
        value.addAll(Bytes.asList(ps));
//        Function.printByteToHex("SafeClient PS", ps);
        value.add(Byte.decode("0x00"));
        //T的组成是15位固定字节头 + 20为SHA1摘要值
        value.addAll(Bytes.asList(DER_SHA1_HEAD));
        value.addAll(Bytes.asList(sha1Value));

        byte[] result = Bytes.toArray(value);
//        Function.printByteToHex("SafeClient PKCS", result);
        return result;
    }

    public static final int RSA_1024_COUNT = 90;
    public static final int RSA_2048_COUNT = 218;

    public static final byte PS_BYTE = (byte) 0xff;

    /**
     * 生成COS内部PKCS#1签名数据所需的byte[]，就是若干个0xff
     *
     * @param isRSA1024 如果是调用RSA1024，则为90个；RSA2018为218个
     * @return PS数组
     */
    public static byte[] genPSValue(boolean isRSA1024) {
        int count = isRSA1024 ? RSA_1024_COUNT : RSA_2048_COUNT;

        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < count; i++) {
            out.write(PS_BYTE);
        }
        return out.toByteArray();
    }

}
