package com.xdja.safeclient;

import com.xdja.key.KeyDevInfo;
import com.xdja.key.KeyModuleStateListener;
import com.xdja.key.KeyWrapper;
import com.xdja.key.covercard.CoverCardWrapper;
import com.xdja.safeclient.utils.ToastUtil;
import com.xdja.sslvpn.SSLVPN;

import android.app.Service;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;

import com.xdja.safeclient.utils.Log;

public class P11InterfaceService extends Service {
	private String TAG = "P11InterfaceService";
	@Override
	public IBinder onBind(Intent intent) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void onCreate() {
		// TODO Auto-generated method stub
		super.onCreate();
		Log.d(TAG, "onCreate");

		new Thread(new Runnable() {
			@RequiresApi(api = Build.VERSION_CODES.LOLLIPOP_MR1)
			public void run() {
				//启动xdjakeyservice
				if (!TextUtils.isEmpty(MyApplication.myApplication.getDevPath()) || Function.hasXdjaChip()) {
					Log.d(TAG, "Start xdja key server");
					SSLVPN.startXdjaKeyService(getPackageName(), KeyWrapper.XDJA_KEY, null);
				} else {
					Log.d(TAG, "Start cover key server");
					SSLVPN.startXdjaKeyService(getPackageName(), KeyWrapper.COVER_KEY, CoverCardWrapper.getInstance());
				}
			}
		}).start();
	}

	@Override
	public void onDestroy() {
		// TODO Auto-generated method stub
		super.onDestroy();
		Log.d(TAG, "onDestroy");
		SSLVPN.stopXdjaKeyService();
	}

}
