package com.xdja.safeclient;

import android.content.Context;
import android.content.SharedPreferences;

import com.xdja.safeclient.utils.Log;

/**
 * Description:西安移动警务通要求：认证成功时记录时间
 * Created by zjc on 2017/1/10 0010.
 * 因为这个是西安市移动警务通的特殊需求，只记录SP的值并通过CP调用，不牵扯其它的改变
 * 所以不用在Compact里面进行判断
 */
public class VerifyTime {

    public static final String TAG = "VerifyTime";

    /**
     * 记录此次认证成功的时间
     *
     * @param context
     */
    public static void writeVerifyTime(Context context) {
        long current = System.currentTimeMillis();
        SharedPreferences sharedPreferences = context.getSharedPreferences("SafeClientConfig", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong("time", current);
        editor.commit();

        Log.d(TAG, "verify success, current " + current + "");
    }

    /**
     * 获取上次认证成功的时间
     *
     * @param context
     * @return
     */
    public static long readLastVerifyTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("SafeClientConfig", 0);
        long last = sharedPreferences.getLong("time", 0);
        return last;
    }

    /**
     * 记录此次认证是否成功
     *
     * @param context
     * @return
     */
    public static void writeVerifySuccess(Context context, boolean success) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("SafeClientConfig", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean("verifyState", success);
        editor.commit();
        Log.d(TAG, "the result of current verify" + success);
    }


    /**
     * 获取上次认证是否成功
     *
     * @param context
     * @return
     */
    public static boolean readLastVerifySuccess(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("SafeClientConfig", 0);
        boolean lastVerifySuccess = sharedPreferences.getBoolean("verifyState", false);
        return lastVerifySuccess;
    }


}
