package com.xdja.safeclient;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.telephony.TelephonyManager;
import android.view.WindowManager;

import com.safetf.SafeTF;
import com.squareup.otto.Subscribe;
import com.xdja.autoupdate.SCAutoUpdate;
import com.xdja.datapersistence.DataPersistence;
import com.xdja.key.KeyWrapper;
import com.xdja.safeclient.activity.SafeVerifyActivity;
import com.xdja.safeclient.bean.SafeVerifyStageInfo;
import com.xdja.safeclient.constant.IntentParam;
import com.xdja.safeclient.ottoobj.ExitAppEvent;
import com.xdja.safeclient.ottoobj.StopVpnEvent;
import com.xdja.safeclient.utils.Compatibility;
import com.xdja.safeclient.utils.Log;
import com.xdja.safeclient.utils.OttoUtil;
import com.xdja.safeclient.utils.StringUtil;
import com.xdja.safeclient.utils.ToastUtil;
import com.xdja.sslvpn.CONSTANT;
import com.xdja.sslvpn.SSLVPN;
import com.xdja.sslvpn.SocketListener;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

import static com.xdja.safeclient.utils.StringUtil.getStringRes;

public class VpnService extends Service {
    private static final String TAG = "VpnService";
    public static final int FORWARD_MODE = 0;
    public static final int TUNNEL_MODE = 1;
    public int connect = 0;
    public static SocketListener sock = null;
    public byte[] vpnstate = new byte[2048];
    public int vpnstatelen = 0;

    public static String issuccess = null;
    public String prestage = "";//ssl前一阶段
    static public String curstage = ""; // ssl当前阶段

    //	static public boolean startService = false;// 服务是否启动
    static public boolean stopService = false;// 服务是否停止完毕
    static public String errorState = "";// 错误状态

    private static String errorInfo = "";  //三码绑定错误信息
    private static int errorInfoFlag = 0;   //0不显示，1显示
    private static NotificationManager nm = null;

    static public List<SafeVerifyStageInfo> sslStageList = new ArrayList<SafeVerifyStageInfo>(); // ssl状态
    static public boolean safeVerifySuccess = false;

    public MyApplication myApplication = null;

    BroadcastReceiver sdcardBroadCastReceiver = null;
    private BroadcastReceiver screenBroadCastReceiver = null;

    // add by zhaoxiaolong 2016-09-56
    private static boolean screenOn = true;

    public static boolean startflag = false; //如果为true，点击桌面图标，跳过登陆页面进入认证页面。

    String serverIP = null;
    int serverPort = 0;
    byte[] gatewayIp = null;
    byte[] gatewayIp2 = null;
    byte[] gatewayIp3 = null;
    int gatewayPort = 0;

    String safePin = null;

    public static Object xlock = new Object();

    private Thread vpnSrvThread = null;
    public static int vpnSrvThreadStartFlag = 0;

    public static VpnService vpnObject = null;

    @Override
    public IBinder onBind(Intent arg0) {
        return null;
    }

    @Override
    public void onCreate() {
        super.onCreate();

        OttoUtil.register(this);

        myApplication = (MyApplication) getApplication();
        //每次服务启动的时候，清除状态，重新记录认证时间
        Log.d("认证时间", "VPNService onCreate 重置认证标识");
        VerifyTime.writeVerifySuccess(this, false);

        startWatchingDevice();

        startWatchingScreen();

        screenOn = true;
        vpnObject = this;
//		startflag = true;

        myApplication.initDevState();

        if (myApplication.propertiesConfig != null && myApplication.propertiesConfig.getIsWakeLock() == 1) {
            Function.getWakeLock();
        }

        errorInfoFlag = 0;
        errorInfo = "";

    }

	/* add by majp 2013-12-03 start bug id 1374 */

    private void checkSDCardState(Context context, Intent intent) {
        Log.d("VpnService", "getExternalStorageState : " + Environment.getExternalStorageState());

//		if (VpnService.startService == false) {
        if (Function.getSafeVpnState(getApplicationContext()) == false) {
            return;
        }

        //startflag = false;

        safeVerifySuccess = false;
        VpnService.errorState = getStringRes(this, R.string.card_eject);
        SafeVerifyStageInfo stageInfo = new SafeVerifyStageInfo();

        stageInfo.name = getStringRes(this, R.string.safe_verify);
        stageInfo.error = VpnService.errorState;
        stageInfo.result = getStringRes(this, R.string.fail);
        sslStageList.add(stageInfo);

        showVpnState(R.drawable.seq_off, getResources().getString(R.string.safe_client), VpnService.errorState);// 显示离线状态
        if (FORWARD_MODE == myApplication.sslClientConfig.transportMode)//转发模式
        {
            if (myApplication.sslvpn != null) {
                myApplication.sslvpn.stopService();// 停止服务
                myApplication.sslvpn.release();
                myApplication.sslvpn = null;
                synchronized (xlock) {
                    if (sock != null) {
                        sock.close();
                        sock = null;
                    }
                }
            }
//			VpnService.startService = false; 
            Function.setSafeVpnState(getApplicationContext(), false);
            VpnService.stopService = true;
        } else {
            // 沈阳中兴A2015手机不需要做下面操作 Add by xjq, 2017-01-06 08:55:09
            if (Compatibility.getAreaVersion() != Compatibility.AREA_VERSION_LIAONING_SHENGTING_BASE) {
                synchronized (xlock) {
                    if (sock != null) {
                        sock.sendData(CONSTANT.CMD_EXIT);
                        sock.close();
//					VpnService.startService = false; 
                        Function.setSafeVpnState(getApplicationContext(), false);
                        VpnService.stopService = true;
                        sock = null;
                    }
                }
            }

        }

        // sd卡被移除，需要做处理 Add by xjq, 2017-01-06 08:46:46
        Compatibility.onSDCardEject();

        Log.d("VpnService", "SDCard EJECT");

    }

    private void startWatchingScreen() {

        screenBroadCastReceiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                String[] pin = new String[2];

                String action = intent.getAction();

                if (action == null) {
                    return;
                }

                Log.d("VpnService", "screenBroadCastReceiver onReceive " + action);

                if (Intent.ACTION_SCREEN_ON.equals(action)) {
                    if (myApplication.sslvpn != null && myApplication.sslClientConfig != null) {
                        Function.startVpnActivity(context);
                        screenOn = true;
                        myApplication.sslvpn.guardianLearn(GuardianHelper.guardian_option.G_OPT_SCREEN_ON.ordinal(), 0);
                    }
                } else if (Intent.ACTION_SCREEN_OFF.equals(action)) {
                    if (myApplication.sslvpn != null) {
                        screenOn = false;
                        myApplication.sslvpn.guardianLearn(GuardianHelper.guardian_option.G_OPT_SCREEN_OFF.ordinal(), 0);
                    }
                }
            }
        };

        final IntentFilter filter = new IntentFilter();
        filter.addAction(Intent.ACTION_SCREEN_OFF);
        filter.addAction(Intent.ACTION_SCREEN_ON);
        registerReceiver(screenBroadCastReceiver, filter);
    }

    private void stopWatchingScreen() {
        if (screenBroadCastReceiver != null) {
            unregisterReceiver(screenBroadCastReceiver);
        }
    }

    private void startWatchingDevice() {

        sdcardBroadCastReceiver = new BroadcastReceiver() {

            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();

                Log.d("VpnService", "onReceive " + action);
                Log.d("VpnService", "onReceive " + intent.getData());

                if (intent.getData().toString().contains("udisk")) {
                    Log.d("VpnService", "onReceive " + "igore second sdcard eject");
                    return;
                }

                if (Intent.ACTION_MEDIA_EJECT.equals(action)) {
//                    if (MyApplication.devOpenFlag != MyApplication.OPEN_DEV_BY_PATH) {
//                        Log.d(TAG, "Current use tf. Don't stop service");
//                        return;
//                    }
                    checkSDCardState(context, intent);
                }

            }
        };

        IntentFilter sdcardFilter = new IntentFilter();
        sdcardFilter.addAction(Intent.ACTION_MEDIA_EJECT);
        sdcardFilter.addDataScheme("file");
        registerReceiver(sdcardBroadCastReceiver, sdcardFilter);
    }

    private void stopWatchingDevice() {
        //unregisterReceiver(deviceBroadCastReceiver);
        if (sdcardBroadCastReceiver != null) {
            unregisterReceiver(sdcardBroadCastReceiver);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();

        stopForeground(true);
        curstage = "";// ssl当前状态
        errorState = "";// 错误状态

        startflag = false;

        errorInfoFlag = 0;
        errorInfo = "";

        GuardianHelper.cancleOnceAlarm(getApplicationContext());

        Log.d("VpnService", "middle onDestroy");

        if (myApplication.propertiesConfig != null && myApplication.propertiesConfig.getIsWakeLock() == 1) {
            Function.releaseWakeLock();
        }

        //温州市局需求，网关地址和端口由第三方应用传入 2014.05.07 start

        if (serverIP != null) {
            myApplication.sslClientConfig.setGateWayIp(gatewayIp);
            myApplication.sslClientConfig.setGateWayIp2(gatewayIp2);
            myApplication.sslClientConfig.setGateWayIp3(gatewayIp3);

            myApplication.sslClientConfig.setGateWayPort(gatewayPort);
        }
        //温州市局需求，网关地址和端口由   第三方应用传入 2014.05.07 end

        if (FORWARD_MODE == myApplication.sslClientConfig.transportMode)//转发模式
        {
            if (myApplication.sslvpn != null) {
                myApplication.sslvpn.stopService();
                myApplication.sslvpn.release();
                myApplication.sslvpn = null;
                synchronized (xlock) {
                    if (sock != null) {
                        sock.close();
                        sock = null;
                    }
                }
            }

            Log.d("VpnService", "onDestroy OK");
            Function.setSafeVpnState(getApplicationContext(), false);
            safeVerifySuccess = false;
        }
        //隧道模式
        else {
            new Thread(new Runnable() {
                public void run() {
                    synchronized (xlock) {
                        if (sock != null) {
                            sock.sendData(CONSTANT.CMD_EXIT);
                            //网络断开后重新连接，点击停止，再点击启用后无任何提示
                            byte[] state = new byte[1024];
                            int statelen = sock.recvData(state);
                            if (statelen > 0) {
                                Log.d("VpnService", "state = " + new String(state, 0, statelen));
                            }
                            //
                            sock.close();
                            sock = null;
                        }
                    }
//					startService = false;
                    Function.setSafeVpnState(getApplicationContext(), false);
                    safeVerifySuccess = false;
                }

                ;
            }).start();

        }

        stopWatchingDevice();

        stopWatchingScreen();

        if (myApplication.propertiesConfig.getmDisableFlag() == 1) {
            myApplication.disableFlag = 0;
        }

        // add by zhaoxiaolong 20160604 如果用户点击停止按钮，则清楚通知栏消息
        if (nm != null) {
            nm.cancel(1);
        }

        VerifyTime.writeVerifySuccess(this, false);
        Log.d("认证时间", "VPNService onDestroy 重置认证标识");

        VpnService.stopService = true;

        OttoUtil.unRegister(this);

    }

    @Override
    public void onStart(Intent intent, int startId) {
        super.onStart(intent, startId);

        //检查海棠服务
//		if(!Function.checkHitomservice(getApplicationContext())) {
//			Function.popSystemAlert(getApplicationContext(), "提示", CONSTANT.HitomserviceNOTEXSIT,null);
//			return;
//		}

        //避免多次启动安全认证
//		if (!startService) {
        if (!Function.getSafeVpnState(getApplicationContext())) {
            //温州市局需求，网关地址和端口由第三方应用传入 2014.05.07 start
            serverIP = null;
            serverPort = 0;
            try {
                serverIP = intent.getStringExtra("ServerIP");
                //fix by zhaoxiaolong 20160525
                serverPort = intent.getIntExtra("ServerPort", myApplication.sslClientConfig.gateWayPort);

                if (serverIP != null) {
                    Log.d("VpnService", "serverIP = " + serverIP);
                    Log.d("VpnService", "serverPort = " + serverPort);
                    gatewayIp = myApplication.sslClientConfig.getGateWayIp();
                    gatewayIp2 = myApplication.sslClientConfig.getGateWayIp2();
                    gatewayIp3 = myApplication.sslClientConfig.getGateWayIp3();
                    gatewayPort = myApplication.sslClientConfig.getGateWayPort();

                    myApplication.sslClientConfig.setGateWayIp(serverIP.getBytes());
                    myApplication.sslClientConfig.setGateWayIp2(serverIP.getBytes());
                    myApplication.sslClientConfig.setGateWayIp3(serverIP.getBytes());

                    myApplication.sslClientConfig.setGateWayPort(serverPort);
                }
            } catch (NullPointerException e) {

            }
            //温州市局需求，网关地址和端口由第三方应用传入 2014.05.07 end

            //广东财政厅，烽火第三方应用需求，传入PIN码, 2014.08.21 start
            if (intent != null) {
                safePin = null;
                safePin = intent.getStringExtra("SafePin");
                try {
                    if (safePin != null) {
                        Log.d("VpnService", "putin safePin by intent, safePin = " + safePin);
                        myApplication.sslClientConfig.setPin(safePin.getBytes());

                        if (myApplication.propertiesConfig.getIgnoreLogin() != 0) {
                            //保存pin码标识
                            SharedPreferences sharedPreferences = getSharedPreferences("SafeClientConfig", 0);
                            Editor editor = sharedPreferences.edit(); // 提交保存pin码标志
                            editor.putString("savepin", "true");
                            editor.commit();

                            //持久化存储pin码
                            String privatePath = getFilesDir().getPath();
//                            DataPersistence dp = new DataPersistence(this, privatePath + "/datapersistence");
                            DataPersistence dp = DataPersistence.getInstance(this);
                            dp.addData("pin", safePin.getBytes());

                        }
                    } else {
                        Log.d("VpnService", "not putin safePin by intent ");
                    }
                } catch (NullPointerException e) {

                }
            }
            //广东财政厅，烽火第三方应用需求，传入PIN码, 2014.08.21 end

            VpnService.sslStageList.clear();

            if (SafeVerifyActivity.myAdapter != null) {
                SafeVerifyActivity.myAdapter.notifyDataSetChanged();
            }

//			if (SafeVerifyActivity.selfStartFlag == false) {
//			if (MyApplication.selfStartFlag == false) {
            if (Function.getSafeVpnState(getApplicationContext()) == false) {
                VpnService.sslStageList.clear();

                if (SafeVerifyActivity.myAdapter != null) {
                    SafeVerifyActivity.myAdapter.notifyDataSetChanged();
                }

//				for (Activity activity:myApplication.activityList) {
//					activity.finish();
//				}
//				
//				myApplication.activityList.clear();
            }


//			startService = true;
            Function.setSafeVpnState(getApplicationContext(), true);
            stopService = false;
            setRole();

//			if (FORWARD_MODE == myApplication.sslClientConfig.transportMode)//转发模式
//			{
//				startSslvpn();
//			}
//			else if (TUNNEL_MODE == myApplication.sslClientConfig.transportMode)//隧道模式
//			{
//				startTunSslvpn();
//			}

            checkOtherSafeClient();
        }
    }

    private void setRole() {
        int role = myApplication.sslClientConfig.getRole();
        if (role != 0x01 && role != 0x11) {
            byte[] defaultCertId = myApplication.sslClientConfig.getCertId();
            role = Function.generateRole(defaultCertId);
            myApplication.sslClientConfig.setRole(role);
        }
    }

    private void checkOtherSafeClient() {

        if (Function.isServiceWork(this, "com.xdja.safeclient.tun.video.TunVpnService")) {

            AlertDialog.Builder builder = new AlertDialog.Builder(getApplicationContext());
            builder.setTitle(StringUtil.getStringRes(this, R.string.alert));
            builder.setMessage(getResources().getText(R.string.otherclientrunning));
            builder.setPositiveButton(StringUtil.getStringRes(this, R.string.positive), new DialogInterface.OnClickListener() {

                @Override
                public void onClick(DialogInterface dialog, int which) {
                    Function.stopOtherSafeClient(getApplicationContext());

                    if (FORWARD_MODE == myApplication.sslClientConfig.transportMode)//转发模式
                    {
                        startSslvpn();
                    }
                    //启动VPNservice的肯定是转发模式，一下的代码是系统没有VPN Service框架、且有Root权限时执行的代码
//                    else if (TUNNEL_MODE == myApplication.sslClientConfig.transportMode)//隧道模式
//                    {
//                        startTunSslvpn();
//                    }
                }
            });
            builder.setNegativeButton(StringUtil.getStringRes(this, R.string.negative), new DialogInterface.OnClickListener() {

                @Override
                public void onClick(DialogInterface dialog, int which) {
                    Intent itt = new Intent();
                    itt.setClassName(MyApplication.packageName, "com.xdja.safeclient.VpnService");
                    stopService(itt);
                    //add by mjp version: 4.1.0.6048
                    System.exit(0);
                }

            });

            Dialog dialog = builder.create();
            dialog.getWindow().setType(WindowManager.LayoutParams.TYPE_SYSTEM_ALERT);
            dialog.show();
        } else {
            if (FORWARD_MODE == myApplication.sslClientConfig.transportMode)//转发模式
            {
                startSslvpn();
            }
            //启动VPNservice的肯定是转发模式，一下的代码是系统没有VPN Service框架、且有Root权限时执行的代码
//            else if (TUNNEL_MODE == myApplication.sslClientConfig.transportMode)//隧道模式
//            {
//                startTunSslvpn();
//            }
        }
    }

    public String GetICCID(SafeTF tf, int hHandle) {
        int nres;
        String iccid = "";
        byte[] pDataOut = new byte[20];
        byte[] fid = {0x00, 0x07};
        byte[] appid = {0x09, 0x21};
        byte[] rootappid = {0x3F, 0x00};

        nres = tf.SelectApp(hHandle, appid);// 切换目录
        if (nres != 0) {
            Log.d("VpnService", "SelectApp,0x0921 failed");
            nres = tf.ReadCardBinFile(hHandle, fid, 0, 10, pDataOut);
        } else {
            nres = tf.ReadCardBinFile(hHandle, fid, 0, 10, pDataOut);

            nres = tf.SelectApp(hHandle, rootappid);//  切换目录
        }

        for (int i = 0; i < 10; i++) {
            iccid += String.format("%02X", pDataOut[i]);
        }

        Log.d("VpnService", "iccid = " + iccid);

        return iccid;
    }

    public String GetTerminalInfo(Context context, byte[] terminalInfo, int[] terminalInfoLen) {
        String strTermInfo = "";
        String cardSN = "";
        String iccid = "";
        TelephonyManager manager = (TelephonyManager) context
                .getSystemService(Context.TELEPHONY_SERVICE);

        String imsi = "000000000000000";// 默认sim卡号
        if (manager.getSimState() != TelephonyManager.SIM_STATE_READY) {
            //没有插入sim卡使用默认sim卡号
        } else {
            imsi = manager.getSubscriberId(); // 获取IMSI号
        }

        String imei = manager.getDeviceId(); // 获取IMEI号

        try {
            if (0 == myApplication.sslClientConfig.getCertMode()) {//硬证书
                byte[] cardId = new byte[64];
                int[] cardIdLen = new int[1];
                int ret = KeyWrapper.getInstance().getSN(cardId, cardIdLen);
                if (ret == 0) {
                    cardSN = new String(cardId, 0, cardIdLen[0]);
                } else {
                    return KeyWrapper.StatusCode.getComment(ret);
                }
            } else {
                cardSN = "0000000000000000000000000000000000000000000000000000000000000000";
            }

            strTermInfo = "ANDROID;" + cardSN + ";" + imei + ";" + imsi + ";" + iccid;

            Log.d("VpnService", "strTermInfo = " + strTermInfo);

            terminalInfoLen[0] = strTermInfo.getBytes().length;

            System.arraycopy(strTermInfo.getBytes(), 0, terminalInfo, 0,
                    terminalInfoLen[0]);
        } catch (Exception e) {
            Log.d(TAG, "Covercard failed." + e.getMessage());
            return getStringRes(this, R.string.gen_terminal_info_failed);
        }

        return "";
    }

    private boolean setGateWayIp() {

        if (myApplication.sslClientConfig == null) {
            Log.e("VpnService", "myApplication.sslClientConfig == null");
            return false;
        }

        try {
            String gwip = new String(myApplication.sslClientConfig.getGateWayIp());
            Log.d("VpnService", "gwip = " + gwip);
            if (!gwip.equals("")) {
                InetAddress inetAddress = InetAddress.getByName(gwip);

                if (inetAddress == null) {
                    Log.e("VpnService", "get InetAddress By Name failed");
                } else {
                    Log.d("VpnService", "GateWayIp = " + inetAddress.getHostAddress());
                    myApplication.sslClientConfig.setGateWayIp(inetAddress.getHostAddress().getBytes());
                }
            }
        } catch (UnknownHostException e) {
            e.printStackTrace();
            Log.e("VpnService", "get GateWayIp By Name failed");
        }

        try {
            String gwip2 = new String(myApplication.sslClientConfig.getGateWayIp2());
            Log.d("VpnService", "gwip2 = " + gwip2);
            if (!gwip2.equals("")) {
                InetAddress inetAddress2 = InetAddress.getByName(gwip2);

                if (inetAddress2 == null) {
                    Log.e("VpnService", "get InetAddress2 By Name failed");
                } else {
                    Log.d("VpnService", "GateWayIp2 = " + inetAddress2.getHostAddress());
                    myApplication.sslClientConfig.setGateWayIp2(inetAddress2.getHostAddress().getBytes());
                }
            }
        } catch (UnknownHostException e) {
            e.printStackTrace();
            Log.e("VpnService", "get GateWayIp2 By Name failed");
        }

        try {

            String gwip3 = new String(myApplication.sslClientConfig.getGateWayIp3());
            Log.d("VpnService", "gwip3 = " + gwip3);
            if (!gwip3.equals("")) {
                InetAddress inetAddress3 = InetAddress.getByName(gwip3);

                if (inetAddress3 == null) {
                    Log.e("VpnService", "get InetAddress3 By Name failed");
                } else {
                    Log.d("VpnService", "GateWayIp3 = " + inetAddress3.getHostAddress());
                    myApplication.sslClientConfig.setGateWayIp3(inetAddress3.getHostAddress().getBytes());
                }
            }
        } catch (UnknownHostException e) {
            e.printStackTrace();
            Log.e("VpnService", "get GateWayIp2 By Name failed");
            return false;
        }

        return true;
    }

    public void startSslvpn() {

        new Thread(new Runnable() {

            @Override
            public void run() {
                int nres = -1;
                Looper.prepare();
                //吉林交警换卡需求
                if (myApplication.propertiesConfig.getIsBigThan4G() != 0
                        && !Function.isSDTotalSizeBigThan4G(Function.getSDTotalSize(myApplication.getApplicationContext()))) {
                    errorState = getStringRes(VpnService.this, R.string.safe_card_version_unmatched);
                    showVpnState(R.drawable.seq_off, getResources().getString(R.string.safe_client), errorState);//显示离线状态
//					startService = false;
                    Function.setSafeVpnState(getApplicationContext(), false);
                    safeVerifySuccess = false;
                    stopService = true;
                    return;
                }
                //吉林交警换卡需求

                byte[] terminalInfo = new byte[256];
                int[] terminalInfoLen = {0};

                String strRes = GetTerminalInfo(myApplication.getApplicationContext(), terminalInfo, terminalInfoLen);

                if (!strRes.equals("")) {
                    errorState = strRes;
                    showVpnState(R.drawable.seq_off, getResources().getString(R.string.safe_client), errorState);//显示离线状态
//					startService = false;
                    Function.setSafeVpnState(getApplicationContext(), false);
                    safeVerifySuccess = false;
                    stopService = true;
                    return;
                }

                // 获取卡号成功后，再初始化sslvpn xjq, 2017-6-17 17:06:42
                if (myApplication.sslvpn != null) {
                    myApplication.sslvpn.stopService();
                    myApplication.sslvpn.release();
                    myApplication.sslvpn = null;
                }
                myApplication.sslvpn = new SSLVPN();
                myApplication.sslClientConfig.setTerminalInfo(terminalInfo);
                myApplication.sslClientConfig.setNetType(
                        GuardianHelper.getNetWorkType(myApplication.getApplicationContext()).ordinal());

                setGateWayIp();

                Log.d("VpnService", "" + new String(myApplication.sslClientConfig.getDevPath()));
                nres = myApplication.sslvpn.setParam(myApplication.sslClientConfig);

                if (nres != 0) {
                    if (nres == -1134) {
                        errorState = getStringRes(VpnService.this, R.string.no_cert);
                    } else {
                        errorState = getStringRes(VpnService.this, R.string.invalid_param);
                    }

                    showVpnState(R.drawable.seq_off, getResources().getString(R.string.safe_client), errorState);//显示离线状态
//					startService = false;
                    Function.setSafeVpnState(getApplicationContext(), false);
                    safeVerifySuccess = false;
                    stopService = true;
                    return;
                }

                startflag = true;

                int connectRet = 0;

                synchronized (xlock) {
                    if (sock == null) {
                        //modify by wangyue
                        sock = new SocketListener("127.0.0.1", myApplication.sslClientConfig.getPrivatePort());
                    }
                    if (sock != null) {
                        Log.d("VpnService", "check cmd port");
                        connectRet = sock.connect();
                    }
                }

                if (connectRet == 0) {
                    Log.d("VpnService", "cmd port already bind, service alread started");
                } else {

                    if (myApplication.sslvpn != null) {
                        nres = myApplication.sslvpn.startService();

                        if (nres != 0) {
                            errorState = getStringRes(VpnService.this, R.string.start_service_failed);
                            showVpnState(R.drawable.seq_off, getResources().getString(R.string.safe_client), getStringRes(VpnService.this, R.string.start_service_failed));//显示离线状态
//						startService = false;
                            Function.setSafeVpnState(getApplicationContext(), false);
                            safeVerifySuccess = false;
                            stopService = true;
                            return;
                        }
                    }
                }

                vpnSrvThreadStartFlag = 1;

                synchronized (xlock) {
                    if (sock == null) {
                        //modify by wangyue
                        sock = new SocketListener("127.0.0.1", myApplication.sslClientConfig.getPrivatePort());
                    }
                    if (sock != null) {
                        if (connectRet != 0) {
                            nres = sock.connect();
                        } else {
                            nres = connectRet;
                        }
                    }
                }

                long ctime = System.currentTimeMillis();
                // 连接本地服务
                while (nres != 0) {
                    if (System.currentTimeMillis() - ctime > 3000) {
                        Log.e("VpnService", "connect to 127.0.0.1:" + myApplication.sslClientConfig.getPrivatePort() + " failed");
                        errorState = getStringRes(VpnService.this, R.string.connect_service_failed);
                        showVpnState(R.drawable.seq_off, getResources().getString(R.string.safe_client), getStringRes(VpnService.this, R.string.connect_service_failed));// 显示离线状态
                        synchronized (xlock) {
                            if (sock != null) {
                                sock.close(); // 关闭socket
                                sock = null;
                            }
                        }
                        myApplication.sslvpn.stopService();// 停止服务
//						startService = false;
                        Function.setSafeVpnState(getApplicationContext(), false);
                        safeVerifySuccess = false;
                        stopService = true;
                        return;
                    }
                    synchronized (xlock) {
                        if (sock != null) {
                            nres = sock.connect();
                        }
                    }
                    try {
                        Thread.sleep(1000);
                    } catch (Exception ex) {

                    }
                }
                // 向本地发送查询命令
                synchronized (xlock) {
                    if (sock != null) {
                        sock.sendData(CONSTANT.CMD_START);
                        vpnstatelen = sock.recvData(vpnstate);
                    }
                }


                if (!Function.getSafeVpnState(getApplicationContext())) {
                    //*****************************************************************************************//
                    stopService = true;
                    SafeVerifyActivity.startService = false;
                    vpnSrvThreadStartFlag = 0;
                }
                synchronized (xlock) {
                    if (sock == null) {
                        stopService = true;
                        SafeVerifyActivity.startService = false;
                        vpnSrvThreadStartFlag = 0;
                    }
                }
                if (vpnstatelen > 0) {
//					Message message = new Message();
//					message.what = 1;
//					mHandler.sendMessage(message);
                }
                /*
                while (true) {

					if (!Function.getSafeVpnState(getApplicationContext())) {
						Log.d("VpnService","break vpnservice thread");
						break;
					}
					
					
					synchronized (xlock) {
						if (sock == null) {
							Log.e(TAG, "socket object is null");
							break;
						}
	
						//sock.sendData(CONSTANT.CMD_GET_STATE);
						vpnstatelen = sock.recvData(vpnstate);
						Log.v( TAG, "************recv*********************" );
						String temp = null;
					}
					
					// fix by zhaoiaolong MATE8 手机休眠会断开本地socket连接 2016-05-13
					if(vpnstatelen == -1 && Function.getSafeVpnState(getApplicationContext())){
						// 重连本地服务端口
						synchronized (xlock) {
							if (sock != null) {
								nres = sock.connect();
							}
						}
						// 多次重连，直到成功或者超时
						ctime = System.currentTimeMillis();
						while (nres != 0) {
							// 服务已经停止，不再重连
							if(!Function.getSafeVpnState(getApplicationContext())){
								break;
							}
							if (System.currentTimeMillis() - ctime > 3000) {
								Log.e(TAG, "reconnect to 127.0.0.1:"+myApplication.sslClientConfig.getPrivatePort()+" failed");
						
								synchronized (xlock) {
									if (sock != null) {
										Log.e(TAG, "close socket");
										sock.close(); // 只关闭socket,不置null
									}
								}
								
								break;  // 退出重连
							}
							// 重连
							synchronized (xlock) {
								if (sock != null) {
									nres = sock.connect();
								}
							}
						}
					}
					
					Message message = new Message();
					message.what = 1;
					mHandler.sendMessage(message);
					
//					try {
//						Thread.sleep(500);
//					} catch (InterruptedException e) {
//					}
				}
				stopService = true;
				SafeVerifyActivity.startService = false;
				vpnSrvThreadStartFlag = 0;
				*/
            }
        }).start();

    }

    /**
     * 以root执行命令
     *
     * @param cmd 要执行的命令
     * @return
     */
    public int execRootCmdSilent(String cmd) {
        int result = -1;
        DataOutputStream dos = null;
        String strSuTool = null;

        if (myApplication.propertiesConfig.getmSuOrXdsu() == 0) {
            strSuTool = "su";
            Log.i("VpnService", "su");
        } else {
            strSuTool = "xdsu xdja";
            Log.i("VpnService", "xdsu xdja");
        }

        try {
            Process p = Runtime.getRuntime().exec(strSuTool);
            dos = new DataOutputStream(p.getOutputStream());

            dos.writeBytes(cmd + "\n");
            dos.flush();
            dos.writeBytes("exit\n");
            dos.flush();
            p.waitFor();
            result = p.exitValue();
            Log.i("VpnService", cmd);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (dos != null) {
                try {
                    dos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }


    /**
     * 启动隧道模式sslvpn
     */
//    public void startTunSslvpn() {
//        new Thread(new Runnable() {
//            public void run() {
//                int nres = 0;
//                String tuncontrol = null;
//
//                File pageInternal = getFilesDir();
//                String internalFilesDir = "/data/data/com.xdja.safeclient/files/";
//                if (pageInternal != null) {
//                    internalFilesDir = pageInternal.getPath();
//                    Log.d("MyApplication", "getFilesDir = " + internalFilesDir);
//                }
//
//                if (myApplication.propertiesConfig.getmArmOrX86() == 0) {
//                    tuncontrol = internalFilesDir + "/tuncontrol";
//                } else {
//                    //tuncontrol = "/data/data/com.xdja.safeclient/files/tuncontrol_x86";
//                    tuncontrol = internalFilesDir + "/tuncontrol";
//                }
//
//                byte[] terminalInfo = "ANDROID;".getBytes();
//
//                myApplication.sslClientConfig.setTerminalInfo(terminalInfo);
//
//                String configInfo = myApplication.sslClientConfig.formatSslClientConfig();
//
//                try {
//                    // 给控制程序赋可执行权限并以root用户运行该程序
//                    Runtime.getRuntime().exec("chmod 771 " + tuncontrol);
//                    execRootCmdSilent(tuncontrol + " " + configInfo + " &");
//                } catch (Exception e) {
//                    Log.d("VpnService", "execRootCmdSilent , failed");
//                    return;
//                }
//                synchronized (xlock) {
//                    //modify by wangyue
//                    sock = new SocketListener("127.0.0.1", myApplication.sslClientConfig.getPrivatePort());
//
//                    if (sock != null) {
//                        nres = sock.connect();
//                    }
//                }
//
//                Long ctime = System.currentTimeMillis();
//                while (nres != 0) {
////					if (!startService) {
//                    if (!Function.getSafeVpnState(getApplicationContext())) {
//                        break;
//                    }
//                    if (System.currentTimeMillis() - ctime > 11 * 1000) {
//                        errorState = getStringRes(VpnService.this, R.string.connect_service_failed);
//                        showVpnState(R.drawable.seq_off, getResources().getString(R.string.safe_client), getStringRes(VpnService.this, R.string.connect_service_failed));// 显示离线状态
//
//                        stopService = true;
//                        Log.d("VpnService", "CmdSilent connect failed");
//
//                        synchronized (xlock) {
//                            if (sock != null) {
//                                sock.close(); // 关闭socket
//                                sock = null;
//                            }
//                        }
//
//                        return;
//                    }
//                    synchronized (xlock) {
//                        if (sock != null) { //点击停止时sock会被释放
//                            nres = sock.connect();
//                        }
//                    }
//                }
//
//                synchronized (xlock) {
//                    if (sock != null) {
//                        sock.sendData(CONSTANT.CMD_START);
//                        vpnstatelen = sock.recvData(vpnstate);
//                    }
//                }
//
//                while (true) {
////					if (!startService) {
//                    if (!Function.getSafeVpnState(getApplicationContext())) {
//                        break;
//                    }
//
//                    synchronized (xlock) {
//                        if (sock == null) {
//                            break;
//                        }
//                        //sock.sendData(CONSTANT.CMD_GET_STATE);
//
//                        vpnstatelen = sock.recvData(vpnstate);
//                    }
//
//                    Message message = new Message();
//                    message.what = 1;
//                    mHandler.sendMessage(message);
//
//                    try {
//                        Thread.sleep(1000);
//                    } catch (InterruptedException e) {
//                    }
//                }
//
//                stopService = true;
//                SafeVerifyActivity.startService = false;
//            }
//
//            ;
//        }).start();
//    }

    private Handler mHandler = new Handler() {
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1:
                    showState();
                    break;
                case 2:
                    vpnstatelen = msg.getData().getInt("len");
                    vpnstate = msg.getData().getByteArray("content");
                    showState();
            }
        }

        ;
    };

    public void stateChange(byte[] state, int len) {
        Log.v(TAG, "++++++++++++");
//		vpnstate = state.getBytes();
//		vpnstatelen = len;
        Message message = new Message();
        message.what = 2;
        Bundle bundle = new Bundle();
        bundle.putInt("len", len);
        bundle.putByteArray("content", state);
//		bundle.putString( "content", state );
        message.setData(bundle);
        mHandler.sendMessage(message);
//		Intent sendIntent = new Intent("com.xdja.safeclient.statechange");
//		sendIntent.putExtra( "content",  state);
//		sendBroadcast( sendIntent );
    }

    private void saveCertifyTime(String data) {

        if (myApplication.sslvpn == null) {
            Log.d(VerifyTime.TAG, "sslvpn is null");
            return;
        }

        String[] state = data.split(" ");
        String success = state[0];
        String stage = state[1];
//		String errorCode = state[2];

        if (!success.equals("OK")) {
            VerifyTime.writeVerifySuccess(this, false);
//			Log.d("认证时间", "认证失败" + success + ":" + stage);
        }

        if (success.equals("OK") && stage.equals("100")) {
//			Log.d("认证时间", "认证成功" + success + ":" + stage);

            //如果上次认证失败或者清除了认证标识，则此次需要存储时间
            if (!VerifyTime.readLastVerifySuccess(this)) {
                VerifyTime.writeVerifyTime(this);
                //无论是否存储认证时间，都要记录此次认证成功
                VerifyTime.writeVerifySuccess(this, true);
            } else {
                //上次认证成功，此次不再认证（这种情况下是在同一次认证过程中的多次认证）
            }


        }
    }

    /**
     * 以通知方式显示Vpn认证过程中状态
     */
    public void showState() {

        saveCertifyTime(new String(vpnstate, 0, vpnstatelen));

        if (vpnstatelen < 0) {
            Log.d("VpnService", "vpnstatelen = " + vpnstatelen);
            return;
        }

        if (screenOn == false) {
            //return ;
        }

        // add by zhaoxiaolong 20160604
        if (startflag == false) {
            Log.d("VpnService", "service stop, give up status show");
            return;
        }

        int firstindex = 0;
        int lastindex = 0;
        String stageStatus = "";
        String errorStatus = "";
        String errorCode = "";
        String temp = null;
        temp = new String(vpnstate, 0, vpnstatelen);

        try {
        /*
            firstindex = temp.indexOf((int) ' '); // 查找空格第一次出现位置
			lastindex = temp.lastIndexOf((int) ' ');// 查找空格最后一次出现位置

			issuccess = temp.substring(0, firstindex);
			curstage = temp.substring(firstindex + 1, lastindex);
			
			errorStatus = new String(vpnstate, lastindex + 1, vpnstatelen - lastindex - 1, "gbk");
			*/

            String[] arrState = temp.split(" ");
            issuccess = arrState[0];
            curstage = arrState[1];
            errorCode = arrState[2];
            // fix by zhaoxiaolong 2016-05-18
            // 踢人下线错误码为 -1510
            if (Integer.parseInt(errorCode) == -1510) {
                errorStatus = arrState[3];

                if (!errorInfo.equals(errorStatus)) {
                    errorInfoFlag = 1;
                } else {
                    errorInfoFlag = 0;
                }

                errorInfo = errorStatus;
                Log.d("VpnService", "errorInfo: " + errorInfo);
            } else {
                // 英文描述有多个空格，所以不能通过定位最后一个空格的方式来确定描述
//                lastindex = temp.lastIndexOf((int) ' ');// 查找空格最后一次出现位置

                // 查找第三次空格出现的下标 xjq,2017-02-10 14:25:54
                // 格式：OK/FAILED stage code errString  所以需要定位第三个空格的位置
                lastindex = StringUtil.getCharacterPosition(temp, " ", 3);
                errorStatus = new String(vpnstate, lastindex + 1, vpnstatelen - lastindex - 1, "utf8");
            }

        } catch (Exception e) {
            Log.d("VpnService", "vpnstate :" + temp + " len :" + temp.length());
            Log.d("VpnService", "firstindex: " + firstindex);
            Log.d("VpnService", "lastindex: " + lastindex);
            return;
        }

//		Log.d("VpnService", "curstage: " + curstage);
//		Log.d("VpnService", "issuccess: " + issuccess);
//		Log.d("VpnService", "errorStatus: " + errorStatus);
        // fix by zhaoxiaolong 20160604 解决辅警提示不及时的问题
        if (curstage.compareTo(prestage) != 0 || errorInfoFlag == 1) {
            prestage = curstage;
            SafeVerifyStageInfo stageInfo = new SafeVerifyStageInfo();

            if (curstage.compareTo("20") == 0) {
                stageInfo.name = getString(R.string.init_safe_component);
            } else if (curstage.compareTo("30") == 0) {
                stageInfo.name = getString(R.string.connect_to_safe_gateway);
            } else if (curstage.compareTo("40") == 0) {
                stageInfo.name = StringUtil.getStringRes(this, R.string.safe_verify);
            } else if (curstage.compareTo("50") == 0) {
                stageInfo.name = getString(R.string.bind_verify_info);
            } else if (curstage.compareTo("60") == 0) {
                stageInfo.name = getString(R.string.start_service);
            } else if (curstage.compareTo("100") == 0) {
                if (myApplication.sslClientConfig.transportMode == 0) {
                    stageInfo.name = getString(R.string.safe_tunnel_via_trans_mode);
                } else {
                    stageInfo.name = getString(R.string.safe_tunnel_via_tunnel_mode);
                }
            } else {
                return;
            }

            if (issuccess.compareTo("OK") == 0) {
                stageInfo.result = getStringRes(VpnService.this, R.string.success);
                stageStatus = stageInfo.name + stageInfo.result;
            } else {
                stageInfo.result = getStringRes(VpnService.this, R.string.fail);
            }
            stageInfo.error = errorStatus;

            VpnService.sslStageList.add(stageInfo);

            if (SafeVerifyActivity.myAdapter != null) {
                SafeVerifyActivity.myAdapter.notifyDataSetChanged();
            }

            if (issuccess.compareTo("OK") == 0) {// 成功状态
                if (curstage.compareTo("100") == 0) {

                    errorInfoFlag = 0;
                    errorInfo = "";

                    if (nm != null) {
                        nm.cancel(1);
                    }

                    safeVerifySuccess = true;
                    VpnService.errorState = "";
                    showVpnState(R.drawable.seq_on, getResources().getString(R.string.safe_client), stageStatus);// 显示在线状态图标

                    //隧道模式，执行脚本，配置虚拟网卡IP和路由
                    if (myApplication.sslClientConfig.transportMode != 0) {
                        String ifconfig = "/data/data/com.xdja.safeclient/files/ifconfig.sh";
                        try {
                            // 给控制程序赋可执行权限并以root用户运行该程序
                            execRootCmdSilent("chmod 771 " + ifconfig);
                            execRootCmdSilent(ifconfig);
                        } catch (Exception e) {
                            Log.d("VpnService", "execRootCmdSilent " + ifconfig + " failed");
                            e.printStackTrace();
                            return;
                        }
                    } else {
                        //后台自动升级 ，只支持转发模式
                        if (Build.VERSION.SDK_INT >= 10) {
                            SCAutoUpdate.updateStart(this, false);//调用升级模块
                        }
                    }
                } else {
                    connect += 1;
                    if (connect > 4) {
                        connect = 1;
                    }
                    switch (connect) {
                        case 1:
                            showVpnState(R.drawable.seq_conn1, getResources().getString(R.string.safe_client), stageStatus);// 显示连接中图标
                            break;

                        case 2:
                            showVpnState(R.drawable.seq_conn2, getResources().getString(R.string.safe_client), stageStatus);// 显示连接中图标
                            break;

                        case 3:
                            showVpnState(R.drawable.seq_conn3, getResources().getString(R.string.safe_client), stageStatus);// 显示连接中图标
                            break;

                        case 4:
                            showVpnState(R.drawable.seq_conn4, getResources().getString(R.string.safe_client), stageStatus);// 显示连接中图标
                            break;
                    }
                }
            }
            //失败状态
            else {
                Log.d("VpnService", "curstage: " + curstage);
                Log.d("VpnService", "issuccess: " + issuccess);
                Log.d("VpnService", "errorStatus: " + errorStatus);

                safeVerifySuccess = false;
                VpnService.errorState = errorStatus;
                showVpnState(R.drawable.seq_off, getResources().getString(R.string.safe_client), errorStatus);// 显示离线状态


                if (errorInfoFlag == 1) {
                    showVpnErrorInfo(R.drawable.tf_locked, getResources().getString(R.string.safe_client), errorInfo);// 显示离线状态
                }

            }

        }
//        Log.d(TAG, issuccess);
    }


    /**
     * 显示vpn认证过程中状态
     */
    public void showVpnState(int icon, String title, String text) {
        if (myApplication.propertiesConfig.getNotification() == 0) {
            //Notification notification = new Notification(icon, null, System.currentTimeMillis());
            Intent intent = new Intent(this, SafeVerifyActivity.class);
            intent.putExtra(IntentParam.FLAG_START_FROM_NOTIFICATION, true);
            Notification.Builder builder = new Notification.Builder(this);
            builder.setSmallIcon(icon);
            builder.setWhen(System.currentTimeMillis());
            PendingIntent pendingIntent = PendingIntent.getActivity(this, 0, intent, 0);
            builder.setContentIntent(pendingIntent);
            builder.setContentTitle(title);
            builder.setContentText(text);
            startForeground(Notification.FLAG_ONGOING_EVENT, builder.build());//设置服务为前台

            /*PendingIntent contentIntent = PendingIntent.getActivity(this, 0, intent, 0);
            notification.flags = Notification.FLAG_ONGOING_EVENT;// 正在运行
            notification.setLatestEventInfo(this, title, text, contentIntent);
            startForeground(Notification.FLAG_ONGOING_EVENT, notification);//设置服务为前台*/
        }
    }

    private void showVpnErrorInfo(int icon, String title, String text) {
        nm = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);


        Notification.Builder builder = new Notification.Builder(this);
        builder.setSmallIcon(icon);
        builder.setWhen(System.currentTimeMillis());
        PendingIntent pendingIntent = PendingIntent.getActivity(this, 0, new Intent(this, SafeVerifyActivity.class), 0);
        builder.setContentIntent(pendingIntent);
        builder.setContentTitle(title);
        builder.setContentText(text);
        //startForeground(Notification.FLAG_ONGOING_EVENT, builder.build());//设置服务为前台
        nm.notify(1, builder.build());

       /* Notification nt = new Notification(icon, null, System.currentTimeMillis());
        PendingIntent pi = PendingIntent.getActivity(this, 0, new Intent(this, SafeVerifyActivity.class), 0);
        nt.setLatestEventInfo(this, title, text, pi);
        nm.notify(1, nt);*/
    }

    @SuppressWarnings(value = "unused")
    @Subscribe
    public void handleExitAppEvent(ExitAppEvent event) {
        handleStopVpnServiceEvent(new StopVpnEvent());
    }

    @SuppressWarnings(value = "unused")
    @Subscribe
    public void handleStopVpnServiceEvent(StopVpnEvent event) {
        boolean success = stopService(IntentParam.stopTunVpn(this));

        if (success) {
            Function.setSafeVpnState(getApplicationContext(), false);
            stopService = true;
            sslStageList.clear();
        } else {
            ToastUtil.show(this, R.string.stop_service_failed);
        }

    }


}
