package com.xdja.safeclient.activity;


import android.os.Build;
import android.os.Bundle;
import com.xdja.safeclient.utils.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.safeclient.BuildConfig;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.architecture.BaseActivity;
import com.xdja.safeclient.config.SslClientConfig;
import com.xdja.safeclient.config.UpgradeConfig;
import com.xdja.safeclient.utils.Compatibility;

import static com.xdja.safeclient.utils.StringUtil.*;

public class ConnectSetActivity extends BaseActivity {
    public EditText et_gatewayIp = null;
    public EditText et_gatewayIp2 = null;
    public EditText et_gatewayIp3 = null;
    public EditText et_gatewayPort = null;
    public EditText et_upgradeIp = null;
    public EditText et_upgradePort = null;
    public EditText et_connectTimeout = null;
    public EditText et_retryconnectCount = null;

    public MyApplication myApplication = null;
    public SslClientConfig sslClientConfig = null;
    public UpgradeConfig upgradeConfig = null;

    //    private String[] TransModeStr = {"转发模式", "隧道模式"};
    private String[] TransModeStr;

    private int iTransMode = 0;
    private Spinner spinnerTransMode = null;

    //    private String[] CertTypeStr = {"交换证书", "签名证书"};
    private String[] CertTypeStr = null;

    private int iCertType = 0;
    private Spinner spinnerCertType = null;

    private String mPropertiesPath = null;

    private LinearLayout mTransModeLinearLayout = null;
    private LinearLayout mCertTypeLinnearLayout = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_connectset);

        TransModeStr = new String[]{getStringRes(this, R.string.mode_trans), getStringRes(this, R.string.mode_tunnel)};
        CertTypeStr = new String[]{getStringRes(this, R.string.exchange_cert), getStringRes(this, R.string.sign_cert)};


        et_gatewayIp = (EditText) findViewById(R.id.et_gw_ip1);
        et_gatewayIp2 = (EditText) findViewById(R.id.et_gw_ip2);
        et_gatewayIp3 = (EditText) findViewById(R.id.et_gw_ip_3);
        et_gatewayPort = (EditText) findViewById(R.id.et_gw_port);
        et_upgradeIp = (EditText) findViewById(R.id.et_upgrade_ip);
        et_upgradePort = (EditText) findViewById(R.id.et_upgrade_port);
        et_connectTimeout = (EditText) findViewById(R.id.et_connect_timeout);
        et_retryconnectCount = (EditText) findViewById(R.id.et_retry_count);

        mLeftBtn = (ImageView) findViewById(R.id.titlebar_leftbtn);
        mRightBtn = (ImageView) findViewById(R.id.titlebar_rightbtn);
        mTitleText = (TextView) findViewById(R.id.titlebar_text);

        mTransModeLinearLayout = (LinearLayout) findViewById(R.id.ll_trans_mode);
        mCertTypeLinnearLayout = (LinearLayout) findViewById(R.id.certtype_linearlayout);

        initLeftBtn();

        initTitleText();

        initRightBtn();

        myApplication = (MyApplication) getApplication();
        //add by zhaoxiaolong  2016-05-18, fix bugid 12826
        myApplication.readSslclientConfigFile();

        sslClientConfig = myApplication.sslClientConfig;
        upgradeConfig = myApplication.upgradeConfig;

        String gatewayIp = new String(sslClientConfig.getGateWayIp());
        String gatewayIp2 = "";
        if (sslClientConfig.getGateWayIp2() == null || sslClientConfig.getGateWayIp2().equals("")) {
            gatewayIp2 = "";
        } else {
            gatewayIp2 = new String(sslClientConfig.getGateWayIp2());
        }
        String gatewayIp3 = "";
        if (sslClientConfig.getGateWayIp3() == null || sslClientConfig.getGateWayIp3().equals("")) {
            gatewayIp3 = "";
        } else {
            gatewayIp3 = new String(sslClientConfig.getGateWayIp3());
        }
        String gatewayPort = Integer.toString(sslClientConfig.gateWayPort);
        String connectTimeout = Integer.toString(sslClientConfig.connectTimeOut);
        String retryconnectCount = Integer.toString(sslClientConfig.retryConnectCount);

        String upgradeIp = upgradeConfig.getServerIp();
        String upgradePort = upgradeConfig.getServerPort();

        et_gatewayIp.setText(gatewayIp);
        et_gatewayIp2.setText(gatewayIp2);
        et_gatewayIp3.setText(gatewayIp3);
        et_gatewayPort.setText(gatewayPort);
        et_connectTimeout.setText(connectTimeout);
        et_retryconnectCount.setText(retryconnectCount);

        et_upgradeIp.setText(upgradeIp);
        et_upgradePort.setText(upgradePort);

        //取properties配置文件路径
        mPropertiesPath = this.getFilesDir().getAbsolutePath() + "/" + "conf.properties";

        initSpiner(spinnerTransMode, R.id.transport_mode_spinner, TransModeStr);

        initSpiner(spinnerCertType, R.id.cert_type_spinner, CertTypeStr);

        if (myApplication.propertiesConfig.getmShowTransportModeSet() == 0) {
            mTransModeLinearLayout.setVisibility(LinearLayout.GONE);
        } else {
            mTransModeLinearLayout.setVisibility(LinearLayout.VISIBLE);
        }

        if (myApplication.propertiesConfig.getmShowCertTypeSet() == 0) {
            mCertTypeLinnearLayout.setVisibility(LinearLayout.GONE);
        } else {
            mCertTypeLinnearLayout.setVisibility(LinearLayout.VISIBLE);
        }
    }

    protected void initTitleText() {
        super.initTitleText();
        mTitleText.setText(R.string.connectset);
    }

    protected void initRightBtn() {
        super.initRightBtn();

        mRightBtn.setVisibility(View.VISIBLE);
        mRightBtn.setBackgroundResource(R.drawable.save);

        mRightBtn.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                save();
            }
        });
    }

    /**
     * 初始化下拉列表
     *
     * @param spinner
     * @param id
     * @param str
     * @return
     */
    private Spinner initSpiner(Spinner spinner, int id, String[] strArray) {
        ArrayAdapter<String> adapter = null;

        spinner = (Spinner) findViewById(id);

        adapter = new ArrayAdapter<String>(this, R.layout.spinner_item_select, strArray);

        adapter.setDropDownViewResource(R.layout.spinner_item_dropdown);

        spinner.setAdapter(adapter);

        if (R.id.transport_mode_spinner == id) {
            Log.d("ConnectSetActivity", "init transport_mode_spinner " + strArray[sslClientConfig.getTransportMode()]);
            iTransMode = sslClientConfig.getTransportMode();
            spinner.setSelection(iTransMode);
        } else if (R.id.cert_type_spinner == id) {
            /* 取配置文件中证书类型  0：交换证书 1：签名证书 */
            iCertType = myApplication.propertiesConfig.getmCertType();
            Log.d("ConnectSetActivity", "loadProperties, iCertType = " + iCertType);

            spinner.setSelection(iCertType);
        }

        //spinner.setOnItemSelectedListener(new SpinnerItemSelected());
        spinner.setOnItemSelectedListener(new OnItemSelectedListener() {

            @Override
            public void onItemSelected(AdapterView<?> arg0, View v, int position,
                                       long arg3) {
                // TODO Auto-generated method stub
                int id = arg0.getId();
                if (R.id.transport_mode_spinner == id) {
                    Log.d("ConnectSetActivity", "transport_mode_spinner checked " + arg0.getItemAtPosition(position).toString());
                    //sslClientConfig.setLogLevel(position);
                    iTransMode = position;
                    if (iTransMode == 1) {
                        Toast.makeText(arg0.getContext(), getStringRes(ConnectSetActivity.this, R.string.tunnel_mode_failed_cz_version_unmatched), Toast.LENGTH_SHORT).show();
                    }
                } else if (R.id.cert_type_spinner == id) {
                    iCertType = position;
                }

            }

            @Override
            public void onNothingSelected(AdapterView<?> arg0) {
            }
        });

        return spinner;
    }

    /**
     * 保存连接设置信息
     */
    public void save() {
        String gatewayIp = et_gatewayIp.getText().toString();
        String gatewayIp2 = et_gatewayIp2.getText().toString();
        String gatewayIp3 = et_gatewayIp3.getText().toString();
        String gatewayPort = et_gatewayPort.getText().toString();
        String upgradeIp = et_upgradeIp.getText().toString();
        String upgradePort = et_upgradePort.getText().toString();
        String connectTimeout = et_connectTimeout.getText().toString();
        String retryconnectCount = et_retryconnectCount.getText().toString();

        if (gatewayIp == null || gatewayIp.equals("")) {
            Toast.makeText(this, getStringRes(this, R.string.gateway1_empty), Toast.LENGTH_SHORT).show();
            return;
        }

        if (!checkIP(gatewayIp)) {
            Toast.makeText(this, getStringRes(this, R.string.gateway1_format_error), Toast.LENGTH_SHORT).show();
            return;
        }

        if (!(gatewayIp2 == null || gatewayIp2.equals("")) && !checkIP(gatewayIp2)) {
            Toast.makeText(this, getStringRes(this, R.string.gateway2_format_error), Toast.LENGTH_SHORT).show();
            return;
        }

        if (!(gatewayIp3 == null || gatewayIp3.equals("")) && !checkIP(gatewayIp3)) {
            Toast.makeText(this, getStringRes(this, R.string.gateway3_format_error), Toast.LENGTH_SHORT).show();
            return;
        }

        if (gatewayPort == null || gatewayPort.equals("")) {
            Toast.makeText(this, getStringRes(this, R.string.gateway_port_empty), Toast.LENGTH_SHORT).show();
            return;
        }

        if (!checkPort(Integer.parseInt(gatewayPort))) {
            Toast.makeText(this, getStringRes(this, R.string.gateway_port_format_error), Toast.LENGTH_SHORT).show();
            return;
        }

        if (upgradeIp == null || upgradeIp.equals("")) {
            Toast.makeText(this, getStringRes(this, R.string.update_server_address_empty), Toast.LENGTH_SHORT).show();
            return;
        }

//        if (!checkIP(upgradeIp)) {
//            Toast.makeText(this, getStringRes(this, R.string.update_server_address_format_error), Toast.LENGTH_SHORT).show();
//            return;
//        }

        if (upgradePort == null || upgradePort.equals("")) {
            Toast.makeText(this, getStringRes(this, R.string.update_server_port_empty), Toast.LENGTH_SHORT).show();
            return;
        }

        if (!checkPort(Integer.parseInt(upgradePort))) {
            Toast.makeText(this, getStringRes(this, R.string.update_server_port_format_error), Toast.LENGTH_SHORT).show();
            return;
        }

        if (connectTimeout == null || connectTimeout.equals("")) {
            Toast.makeText(this, getStringRes(this, R.string.connect_timeout_empty), Toast.LENGTH_SHORT).show();
            return;
        }

        if (retryconnectCount == null || retryconnectCount.equals("")) {
            Toast.makeText(this, getStringRes(this, R.string.reconnect_count_empty), Toast.LENGTH_SHORT).show();
            return;
        }


        //保存sslclient配置信息
        sslClientConfig.setGateWayIp(gatewayIp.getBytes());
        sslClientConfig.setGateWayIp2(gatewayIp2.getBytes());
        sslClientConfig.setGateWayIp3(gatewayIp3.getBytes());
        sslClientConfig.setGateWayPort(Integer.parseInt(gatewayPort));
        sslClientConfig.setConnectTimeOut(Integer.parseInt(connectTimeout));
        sslClientConfig.setRetryConnectCount(Integer.parseInt(retryconnectCount));
        sslClientConfig.setTransportMode(iTransMode);
        myApplication.writeSslclientConfigFile();

        //保存Properties配置文件
        myApplication.propertiesConfig.setmCertType(iCertType);
        myApplication.propertiesConfig.savePropertiesConfig(mPropertiesPath);


        //保存升级配置信息
        upgradeConfig.setServerIp(upgradeIp);
        upgradeConfig.setServerPort(upgradePort);
        myApplication.writeUpgradeConfigFile();

        Toast.makeText(this, getStringRes(this, R.string.save_success), Toast.LENGTH_SHORT).show();
        finish();
    }


    public boolean checkIP(String strIP) {
        String regex = "((?:(?:25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))\\.){3}(?:25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d))))";
        return strIP.matches(regex);
    }

    public boolean checkPort(int port) {
        if (1 <= port && port <= 65535) {
            return true;
        } else {
            return false;
        }
    }
//
//    @Subscribe
//    @CallSuper
//    @Override
//    public void handleExitAppEvent(ExitAppEvent event) {
//        super.handleExitAppEvent(event);
//    }
//
//    @Subscribe
//    @CallSuper
//    @Override
//    public void handleFinishEvent(FinishActivityEvent event) {
//        super.handleFinishEvent(event);
//    }

}
