package com.xdja.safeclient.activity;

import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.xdja.autoupdate.SCAutoUpdate;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.TunVpnService;
import com.xdja.safeclient.VpnService;
import com.xdja.safeclient.architecture.BaseActivity;
import com.xdja.safeclient.utils.Log;

public class SetActivity extends BaseActivity implements OnClickListener {

    ImageView btn_titleLeft = null;
    TextView tv_title = null;

    LinearLayout ll_lookStatus = null;
    LinearLayout ll_certSet = null;
    LinearLayout ll_flowSum = null;
    LinearLayout ll_historyRecord = null;
    LinearLayout ll_logSet = null;
    LinearLayout ll_switch_language = null;
    LinearLayout ll_upgrade = null;
    LinearLayout ll_about = null;

    Button btn_exit = null;
    MyApplication myApplication = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_set);

        btn_titleLeft = (ImageView) findViewById(R.id.titlebar_leftbtn);
        tv_title = (TextView) findViewById(R.id.titlebar_text);

        ll_lookStatus = (LinearLayout) findViewById(R.id.lookstatus);
        ll_certSet = (LinearLayout) findViewById(R.id.certset);
        ll_flowSum = (LinearLayout) findViewById(R.id.flowsum);
        ll_historyRecord = (LinearLayout) findViewById(R.id.historyrecord);
        ll_logSet = (LinearLayout) findViewById(R.id.logset);
        ll_switch_language = (LinearLayout) findViewById(R.id.switch_language);
        ll_upgrade = (LinearLayout) findViewById(R.id.upgrade);
        ll_about = (LinearLayout) findViewById(R.id.about);
        btn_exit = (Button) findViewById(R.id.exit);

        btn_titleLeft.setOnClickListener(this);
        tv_title.setText(getString(R.string.set));

        ll_lookStatus.setOnClickListener(this);
        ll_certSet.setOnClickListener(this);
        ll_flowSum.setOnClickListener(this);
        ll_historyRecord.setOnClickListener(this);
        ll_logSet.setOnClickListener(this);
        ll_upgrade.setOnClickListener(this);
        ll_switch_language.setOnClickListener(this);
        ll_about.setOnClickListener(this);
        btn_exit.setOnClickListener(this);

        myApplication = (MyApplication) getApplication();
        myApplication.activityList.add(this);

        myApplication.topActivity = this;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (KeyEvent.KEYCODE_BACK == keyCode) {
            myApplication.activityList.remove(this);
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public void onClick(View arg0) {
        int viewId = arg0.getId();
        Intent intent = null;
        boolean safeVerifySuccess = false;
        if(viewId == R.id.titlebar_leftbtn){
            finish();
        }
        if(viewId == R.id.lookstatus){
//            if (myApplication.sslClientConfig.transportMode == 0
//                    || myApplication.havingRootPermission == true) {
            if (myApplication.sslClientConfig.transportMode == 0) {
                Log.d("SetActivity", "safeVerifySuccess : " + VpnService.safeVerifySuccess);
                safeVerifySuccess = VpnService.safeVerifySuccess;
            }
            //隧道模式
            else {
                safeVerifySuccess = TunVpnService.safeVerifySuccess;
            }

            if (safeVerifySuccess) {
                intent = new Intent();
                intent.setClass(SetActivity.this, CurrentStatusActivity.class);
                startActivity(intent);
            }
        }
        if(viewId == R.id.certset){
            intent = new Intent();
            intent.setClass(SetActivity.this, CertSetActivity.class);
            startActivity(intent);
        }
        if(viewId == R.id.flowsum){
            intent = new Intent();
            intent.setClass(SetActivity.this, TrafficStatisticsActivity.class);
            startActivity(intent);
        }
        if(viewId == R.id.historyrecord){
            intent = new Intent();
            intent.setClass(SetActivity.this, HistoryRecordActivity.class);
            startActivity(intent);
        }
        if(viewId == R.id.logset){
            intent = new Intent();
            intent.setClass(SetActivity.this, LogSetupActivity.class);
            startActivity(intent);
        }
        if(viewId == R.id.switch_language){
            intent = new Intent();
            intent.setClass(SetActivity.this, SwitchLanguageActivity.class);
            startActivity(intent);
        }
        if(viewId == R.id.upgrade){
            SCAutoUpdate.updateStart(SetActivity.this, true);//调用升级模块
        }
        if(viewId == R.id.about){
            intent = new Intent(SetActivity.this, AboutActivity.class);
            startActivity(intent);
        }
        if(viewId == R.id.exit){
            Function.exitApp(this);
        }
    }

//    @Subscribe
//    @CallSuper
//    @Override
//    public void handleExitAppEvent(ExitAppEvent event) {
//        super.handleExitAppEvent(event);
//    }
//
//    @Subscribe
//    @CallSuper
//    @Override
//    public void handleFinishEvent(FinishActivityEvent event) {
//        super.handleFinishEvent(event);
//    }

}
