package com.xdja.safeclient.activity;

import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.xdja.autoupdate.SCAutoUpdate;
import com.xdja.bean.SettingBean;
import com.xdja.safeclient.BuildConfig;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.TunVpnService;
import com.xdja.safeclient.VpnService;
import com.xdja.safeclient.adapter.SettingAdapter;
import com.xdja.safeclient.architecture.BaseActivity;

import java.util.ArrayList;
import java.util.List;

public class SettingActivity extends BaseActivity implements SettingAdapter.OnItemClickListener,View.OnClickListener {

    List<SettingBean> settingList;

    SettingAdapter adapter;
    //@BindView(R.id.menu_list)
    RecyclerView menuList;
    //@BindView(R2.id.log_out)
    Button logOut;

    //@BindView(R2.id.titlebar_leftbtn)
    ImageView titlebarLeftbtn;
    //@BindView(R2.id.titlebar_text)
    TextView titlebarText;
    //@BindView(R2.id.titlebar_rightbtn)
    ImageView titlebarRightbtn;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_setting);
        //ButterKnife.bind(this);
        initView();
        initTitleBar();

        settingList = new ArrayList<>();
        initSettingList();
        adapter = new SettingAdapter(this, settingList, this);

        LinearLayoutManager layoutManager = new LinearLayoutManager(this);
        menuList.setLayoutManager(layoutManager);

        menuList.setAdapter(adapter);

        MyApplication.myApplication.activityList.add(this);
        MyApplication.myApplication.topActivity = this;
    }

    public void initView(){
        menuList = (RecyclerView )findViewById(R.id.menu_list);
        logOut = (Button) findViewById(R.id.log_out);
        titlebarLeftbtn = (ImageView )findViewById(R.id.titlebar_leftbtn);
        titlebarText = (TextView )findViewById(R.id.titlebar_text);
        titlebarRightbtn = (ImageView )findViewById(R.id.titlebar_rightbtn);

        titlebarLeftbtn.setOnClickListener(this);
        titlebarRightbtn.setOnClickListener(this);
        logOut.setOnClickListener(this);
    }


    private void initTitleBar() {
        titlebarText.setText(R.string.set);

    }

    private void initSettingList() {
        settingList.add(new SettingBean(R.drawable.lookstatus, R.string.lookstatus, CurrentStatusActivity.class));
        settingList.add(new SettingBean(R.drawable.certset, R.string.certset, CertSetActivity.class));
        settingList.add(new SettingBean(R.drawable.flow_statistics, R.string.flowsum, TrafficStatisticsActivity.class));
        settingList.add(new SettingBean(R.drawable.log, R.string.logset, LogSetupActivity.class));

        if (!BuildConfig.isAAR) {
            settingList.add(new SettingBean(R.drawable.switch_language, R.string.switch_language, SwitchLanguageActivity.class));
            settingList.add(new SettingBean(R.drawable.upgrade, R.string.upgrade, null));
        }

        settingList.add(new SettingBean(R.drawable.seq_off, R.string.network_check, NetworkCheckActivity.class));
        settingList.add(new SettingBean(R.drawable.set_about, R.string.about, AboutActivity.class));
    }

    @Override
    public void onClick(SettingBean bean) {
        int activityName = bean.getNameResId();
        if(activityName == R.string.upgrade){
            SCAutoUpdate.updateStart(this, true);//调用升级模块
        }else
        if(activityName == R.string.lookstatus){
            if (VpnService.safeVerifySuccess || TunVpnService.safeVerifySuccess) {
                launchActivity(bean.getActivity());
            }
        }else{
            launchActivity(bean.getActivity());
        }
    }

    private void launchActivity(Class activity) {
        Intent intent = new Intent(this, activity);
        startActivity(intent);
    }


    @Override
    public void onClick(View v) {
        if(v.getId() == R.id.titlebar_leftbtn){
            finish();
        }
        if(v.getId() == R.id.log_out){
            Function.exitApp(this);
        }
    }
}
