package com.xdja.safeclient.activity;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.os.Bundle;

import com.xdja.key.KeyModuleStateListener;
import com.xdja.key.KeyWrapper;
import com.xdja.safeclient.utils.Log;

import com.xdja.safeclient.Function;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.TunVpnService;
import com.xdja.safeclient.VpnService;
import com.xdja.safeclient.utils.Compatibility;
import com.xdja.safeclient.utils.LogUtil;

/**
 * 这个Activity只是启动Service的跳转，没有界面
 */
public class StartVpnActivity extends Activity {
    private String TAG = "StartVpnActivity";
    MyApplication myApplication = null;

    String SafePin = null;
    // add by zhaoxiaolong
    private String ServerIP = null;
    private int ServerPort = -1;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        myApplication = (MyApplication) getApplication();

        SafePin = getIntent().getStringExtra("SafePin");
        if (SafePin != null) {
            LogUtil.d(TAG, SafePin);
        }
        ServerIP = getIntent().getStringExtra("ServerIP");
        ServerPort = getIntent().getIntExtra("ServerPort", -1);

//        if (VpnService.TUNNEL_MODE == myApplication.sslClientConfig.transportMode) {
//            myApplication.havingRootPermission = Function.getRootAhth();
//        }

        if (KeyWrapper.getInstance().getState() == KeyWrapper.State.INITIALIZING) {
            Log.d(TAG, "Key module is init in progress. Wait!");
            KeyWrapper.getInstance().addKeyModuleStateListener(new KeyModuleStateListener() {
                @Override
                public void onStateChanged(int curState) {
                    switch (curState) {
                        case KeyWrapper.State.INIT_KEY_FAILED:
                        case KeyWrapper.State.NO_KEY:
                            KeyWrapper.getInstance().removeKeyModuleStateListener(this);
                            break;
                        case KeyWrapper.State.READY:
                            Log.d(TAG, "Start safeclient now");
                            KeyWrapper.getInstance().removeKeyModuleStateListener(this);
//                            if (myApplication.sslClientConfig.getTransportMode() == 0
//                                    || myApplication.havingRootPermission == true) {
                            if (myApplication.sslClientConfig.getTransportMode() == 0){
                                startVpnService();
                            }else {
                                startTunVpnService();
                            }
                            break;
                    }
                }
            });
        } else {
//            if (myApplication.sslClientConfig.getTransportMode() == 0
//                    || myApplication.havingRootPermission == true) {
            if (myApplication.sslClientConfig.getTransportMode() == 0){
                startVpnService();
            } else {
                startTunVpnService();
            }
        }

    }


    @Override
    protected void onActivityResult(int request, int result, Intent data) {
        if (RESULT_OK == result) {
            Log.d(TAG, "onActivityResult , user permit");

            Intent ittTunVpn = new Intent(this, TunVpnService.class);
//            ittTunVpn.setClassName(CONSTANT.PackageName, "com.xdja.safeclient.TunVpnService");

            // add by zhaoxiaolong 2016-05-16 ,bugid: 12859
            if (SafePin != null) {
                ittTunVpn.putExtra("SafePin", SafePin);
            }

            if (ServerIP != null) {
                ittTunVpn.putExtra("ServerIP", ServerIP);
            }

            if (ServerPort != -1) {
                ittTunVpn.putExtra("ServerPort", ServerPort);
            }

            ComponentName name = startService(ittTunVpn);

            if (name == null) {
                Log.d(TAG, "start TunVpnService failed");
            } else {
                Log.d(TAG, "start TunVpnService success " + name.toString());
            }
        } else {
            Log.d(TAG, "onActivityResult , user not permit");
        }


        // xjq
        Compatibility.onStartedByThirdApp(this);

        //系统对话框选择之后就可以将此Activity 销毁了
        finish();
    }


    public void startTunVpnService() {
        Log.d(TAG, "prepare...");
        Intent itt = android.net.VpnService.prepare(this);

        if (itt != null) {
            Log.d(TAG, "startActivityForResult...");
            startActivityForResult(itt, 0);
        } else {
            Log.d(TAG, "onActivityResult...");
            onActivityResult(0, RESULT_OK, null);
        }
    }

    public void startVpnService() {
        Intent ittTunVpn = new Intent(this, VpnService.class);
//        ittTunVpn.setClassName(CONSTANT.PackageName, "com.xdja.safeclient.VpnService");

        if (SafePin != null) {
            ittTunVpn.putExtra("SafePin", SafePin);
        }

        // add by zhaoxiaolong 2016-05-17
        if (ServerIP != null) {
            ittTunVpn.putExtra("ServerIP", ServerIP);
        }

        if (ServerPort != -1) {
            ittTunVpn.putExtra("ServerPort", ServerPort);
        }

        ComponentName name = startService(ittTunVpn);

        if (name == null) {
            Log.d(TAG, "start VpnService failed");
        } else {
            Log.d(TAG, "start VpnService success " + name.toString());
        }

        finish();
    }

}
