package com.xdja.safeclient.activity.sz;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;

import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.TunVpnService;
import com.xdja.safeclient.VpnService;
import com.xdja.safeclient.utils.FileUtil;
import com.xdja.safeclient.utils.Log;
import com.xdja.sslvpn.CONSTANT;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 此Activity是深圳版本适配
 * 使用者是烽火科技公司
 * 之前他们使用的是UDP版本，现在要用TCP新版进行替换
 * 因为原先他们的接口是com.xdja.sjj1320client.ui.StartVpnActivity
 * 和com.xdja.sjj1320client.ui.StartVpnActivity来调用startActivity()
 * 进行启动和停止服务
 * 为了让他们的代码在使用新版安全客户端时不用修改
 * 故用此类
 */
public class StopVpnActivity extends Activity {

    public static final String TAG = "wanghao";


    private String mLogFileName = "call_stop_safeclient.log";
    private String filePath;
    File externalFilesDir;
    File targetFile;

    MyApplication myApplication;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.i(TAG, "烽火  调用  stopVpnActivty");
        myApplication = (MyApplication)getApplication();
        buildPrivateLogPath();
        buildTargetLogPath();

        stopVpnService();

        FileUtil.copeFile(new File(filePath),targetFile);
        finish();

    }

    void buildPrivateLogPath(){
        String appPrivatePath = this.getFilesDir().getAbsolutePath() + "/";
        File dirPath = new File(appPrivatePath);
        if(!dirPath.exists()){
            dirPath.mkdirs();
        }
        filePath = dirPath.getAbsolutePath()+"/"+mLogFileName;
    }

    void buildTargetLogPath(){
        externalFilesDir = getExternalFilesDir(null);
        if(externalFilesDir != null){
            targetFile = new File(externalFilesDir.getPath() + "/" + mLogFileName);
        }else{
            com.xdja.safeclient.utils.Log.i(TAG,"buildTargetLogPath---------externalFilesDir error");
            writeData("---------buildTargetLogPath-->externalFilesDir error");
        }
    }



    private void stopVpnService() {
        //转发模式
        if (VpnService.FORWARD_MODE == myApplication.sslClientConfig.transportMode) {
            Log.i(TAG, "-------------转发模式");
            writeData("-------------转发模式");
            Intent intent = new Intent(this, VpnService.class);
            boolean bool = stopService(intent);
            if(bool){
                Log.i(TAG, "-------------转发模式关闭service success");
                writeData("-------------转发模式关闭service success");
                setResult(RESULT_OK);
            }else{
                Log.i(TAG, "-------------转发模式关闭service failure");
                writeData("-------------转发模式关闭service failure");
                setResult(RESULT_CANCELED);
            }
        }else {
            Log.i(TAG, "-------------隧道模式");
            writeData("-------------隧道模式");
            boolean bool = stopTunVpnService();
            if(bool){
                Log.i(TAG, "-------------隧道模式关闭service success");
                writeData("-------------隧道模式关闭service success");
                setResult(RESULT_OK);
            }else {
                Log.i(TAG, "-------------隧道模式关闭service failure");
                writeData("-------------隧道模式关闭service failure");
                setResult(RESULT_CANCELED);
            }
        }
    }

    boolean stopTunVpnService() {
        boolean bool = true;
        try {
            if (TunVpnService.mInterface != null) {
                TunVpnService.mInterface.close();
                TunVpnService.mInterface = null;
                if (TunVpnService.tunVpnObj != null) {
                    TunVpnService.tunVpnObj.destroyBuilder();
                }
            }
            if (myApplication.sslvpn != null) {
                myApplication.sslvpn.closeTunFd();
            }
            Intent intent = new Intent(this,TunVpnService.class);
            stopService(intent);
        } catch (Exception e) {
            bool = false;
            e.printStackTrace();
        }
        return bool;
    }


    private void writeData(String content){
        FileOutputStream fos = null;
        BufferedWriter bw = null;
        try {
            fos = new FileOutputStream(filePath, true);
            bw = new BufferedWriter(new OutputStreamWriter(fos));
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timeline = dateFormat.format(new Date());
            bw.write(timeline + " :" + content + "\r\n");
            bw.flush();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (bw != null) {
                    bw.close();//关闭缓冲流
                }
                if(fos != null){
                    fos.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

}
