package com.xdja.safeclient.bean;

import android.support.annotation.NonNull;

import com.xdja.safeclient.utils.LocaleUtil;

import java.io.Serializable;
import java.util.Locale;

/**
 * Description:存储语言的显示名称和语种Locale
 * Created by Administrator on 2017/2/9 0009.
 */
public class LanguageBean implements Serializable {

    private String name;

    private Locale locale;

    /**
     * 跟随系统
     */
    private boolean auto = false;

    public LanguageBean(String name) {
        this.name = name;
        this.locale = LocaleUtil.parseLocale(name);
    }

    public LanguageBean(String name, @NonNull Locale locale) {
        this.name = name;
        this.locale = locale;
    }

    public LanguageBean(String name, Locale locale, boolean auto) {
        this.name = name;
        this.locale = locale;
        this.auto = auto;
    }

    public String getName() {
        return name;
    }

    public Locale getLocale() {
        return locale;
    }

    public boolean isAuto() {
        return auto;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof LanguageBean) {
            return this.name.equals(((LanguageBean) o).name) && this.locale.equals(((LanguageBean) o).locale);
        } else {
            return super.equals(o);
        }
    }
}
