package com.xdja.safeclient.bean;

import com.xdja.safeclient.utils.Log;

/**
 * Description:从TrafficStatistics中拆分出来
 * Created by zjc on 2017/1/12 0012.
 */
public class TrafficTable {
    public TrafficTable() {
        super();
        this.mStartDate = "";
        this.mEndDate = "";
        this.mTrafficUp = 0;
        this.mTrafficDown = 0;
    }

    public TrafficTable(int mStartYear, int mStartMonth, int mStartDay,
                        int mEndYear, int mEndMonth, int mEndDay) {
        super();
        this.mStartDate = String.format("%04d", mStartYear) + "-"
                + String.format("%02d", mStartMonth) + "-"
                + String.format("%02d", mStartDay);
        this.mEndDate = String.format("%04d", mEndYear) + "-"
                + String.format("%02d", mEndMonth) + "-"
                + String.format("%02d", mEndDay);
        this.mTrafficUp = 0;
        this.mTrafficDown = 0;
    }

    public String getmStartDate() {
        return mStartDate;
    }

    public void setmStartDate(String mStartDate) {
        this.mStartDate = mStartDate;
    }

    public String getmEndDate() {
        return mEndDate;
    }

    public void setmEndDate(String mEndDate) {
        this.mEndDate = mEndDate;
    }

    public float getmTrafficUp() {
        return mTrafficUp;
    }

    /**
     * 设置mTrafficUp，单位MB
     *
     * @param mTrafficUp 单位B
     */
    public void setmTrafficUp(int mTrafficUp) {
        this.mTrafficUp = ((float) mTrafficUp) / 1024 / 1024;
        Log.d("TrafficStatistics", "mTrafficUp : " + this.mTrafficUp + "(" + mTrafficUp + ")");
    }

    public float getmTrafficDown() {
        return mTrafficDown;
    }

    /**
     * 设置mTrafficDown，单位MB
     *
     * @param mTrafficDown 单位B
     */
    public void setmTrafficDown(int mTrafficDown) {
        this.mTrafficDown = ((float) mTrafficDown) / 1024 / 1024;
        Log.d("TrafficStatistics", "mTrafficDown : " + this.mTrafficDown + "(" + mTrafficDown + ")");
    }

    private String mStartDate;
    private String mEndDate;
    private float mTrafficUp;
    private float mTrafficDown;


}