package com.xdja.safeclient.config;


import com.xdja.safeclient.MyApplication;
import com.xdja.sslvpn.CONSTANT;

public class SslClientConfig {
	public final static int DEBUG_MODE = 0;//调试模式
	public final static int RELEASE_MODE = 1;//发布模式
	public final static int HARD_CERT = 0;//硬证书
	public final static int SOFT_CERT = 1;//软证书
	public final static int NO_CERT = 2;//无证书
	
	public int transportMode;//传输模式模式0端口转发，1隧道转发
	public int certMode;//证书模式
	public byte[] caPath;//根证书路径
	public byte[] gateWayIp;//网关地址1
	public byte[] gateWayIp2;//网关地址2
	public byte[] gateWayIp3;//网关地址3
	public int gateWayPort;//网关端口
	//add by wangyue 20160719
	public int privatePort;//内部使用端口      
	
	public byte[] pin;//用户口令 
	public int role;//用户角色
	public int cipherSuit;//加密套件
	public int connectTimeOut;//连接超时时间
	public int retryConnectCount;//重连次数
	public byte[] certId;  //证书Id
	public byte[] pubkeyId;//公钥Id
	public byte[] prikeyId;//私钥Id	
    public byte[] terminalInfo;//终端信息
	
	public int logSwitch;//日志开关
	public int logLevel; //日志级别
	public int logFileSize;//日志文件大小
	
	public byte[] privDir;

	public int mixNum;

	public int mixDeno;
	
	public int aclVersion;

	public int sdkVersion;
	
	public byte[] devPath;
	
	public int devOpenFlag;

	public int tunFd;
	
	//网络类型
	public int netType; 
	
	public int getNetType() {
		return netType;
	}

	public void setNetType(int netType) {
		this.netType = netType;
	}
	
	public int getAclVersion() {
		return aclVersion;
	}

	public void setAclVersion(int aclVersion) {
		this.aclVersion = aclVersion;
	}
	
	public int getTunFd() {
		return tunFd;
	}

	public void setTunFd(int tunFd) {
		this.tunFd = tunFd;
	}

	public int getSdkVersion() {
		return sdkVersion;
	}

	public void setSdkVersion(int sdkVersion) {
		this.sdkVersion = sdkVersion;
	}

	public byte[] getDevPath() {
		return devPath;
	}

	public void setDevPath(byte[] devPath) {
		this.devPath = devPath;
	}
	
	public int getDevOpenFlag() {
		return devOpenFlag;
	}

	public void setDevOpenFlag(int devOpenFlag) {
		this.devOpenFlag = devOpenFlag;
	}
	
	public int getLogSwitch() {
		return logSwitch;
	}

	public void setLogSwitch(int logSwitch) {
		this.logSwitch = logSwitch;
	}

	public int getLogLevel() {
		return logLevel;
	}

	public void setLogLevel(int logLevel) {
		this.logLevel = logLevel;
	}

	public int getLogFileSize() {
		return logFileSize;
	}

	public void setLogFileSize(int logFileSize) {
		this.logFileSize = logFileSize;
	}
	
	public byte[] getPrivDir() {
		return privDir;
	}

	public void setPrivDir(byte[] privDir) {
		this.privDir = privDir;
	}

	public int getMixNum() {
		return mixNum;
	}

	public void setMixNum(int mixNum) {
		this.mixNum = mixNum;
	}
	
	public int getMixDeno() {
		return mixDeno;
	}

	public void setMixDeno(int mixDeno) {
		this.mixDeno = mixDeno;
	}
	
	public int getTransportMode() {
		return transportMode;
	}

	public void setTransportMode(int transportMode) {
		this.transportMode = transportMode;
	}

	public int getCertMode() {
		return certMode;
	}

	public void setCertMode(int certMode) {
		this.certMode = certMode;
	}

	public byte[] getTerminalInfo() {
		return terminalInfo;
	}


	public void setTerminalInfo(byte[] terminalInfo) {
		this.terminalInfo = terminalInfo;
	}

	public byte[] getCaPath() {
		return caPath;
	}

	public void setCaPath(byte[] caPath) {
		this.caPath = caPath;
	}

	public byte[] getGateWayIp() {
		return gateWayIp;
	}

	public byte[] getGateWayIp2() {
		return gateWayIp2;
	}
	
	public byte[] getGateWayIp3() {
		return gateWayIp3;
	}
	
	public void setGateWayIp(byte[] gateWayIp) {
		this.gateWayIp = gateWayIp;
	}

	public void setGateWayIp2(byte[] gateWayIp) {
		this.gateWayIp2 = gateWayIp;
	}
	
	public void setGateWayIp3(byte[] gateWayIp) {
		this.gateWayIp3 = gateWayIp;
	}
	
	public int getGateWayPort() {
		return gateWayPort;
	}

	public void setGateWayPort(int gateWayPort) {
		this.gateWayPort = gateWayPort;
	}
	
	
	//add by wangyue start 20160719 
	public int getPrivatePort() {
		return privatePort;
	}
	public void setPrivatePort(int privatePort) {
		this.privatePort = privatePort;
	}
	//add by wangyue end   20160719

	public byte[] getPin() {
		return pin;
	}

	public void setPin(byte[] pin) {
		this.pin = pin;
	}

	public int getRole() {
		return role;
	}

	public void setRole(int role) {
		this.role = role;
	}

	public int getCipherSuit() {
		return cipherSuit;
	}

	public void setCipherSuit(int cipherSuit) {
		this.cipherSuit = cipherSuit;
	}

	public int getConnectTimeOut() {
		return connectTimeOut;
	}

	public void setConnectTimeOut(int connectTimeOut) {
		this.connectTimeOut = connectTimeOut;
	}

	public int getRetryConnectCount() {
		return retryConnectCount;
	}

	public void setRetryConnectCount(int retryConnectCount) {
		this.retryConnectCount = retryConnectCount;
	}

	public byte[] getCertId() {
		return certId;
	}

	public void setCertId(byte[] certId) {
		this.certId = certId;
	}

	public byte[] getPubkeyId() {
		return pubkeyId;
	}

	public void setPubkeyId(byte[] pubkeyId) {
		this.pubkeyId = pubkeyId;
	}

	public byte[] getPrikeyId() {
		return prikeyId;
	}

	public void setPrikeyId(byte[] prikeyId) {
		this.prikeyId = prikeyId;
	}

	public SslClientConfig(String temp) {
		pin = "111111".getBytes();
		role = 1;
	}
	
	public SslClientConfig() {
		transportMode = 0;
		certMode = HARD_CERT;
		caPath = MyApplication.myApplication.getFilesDir().getPath().getBytes();
		gateWayIp = "192.168.13.78".getBytes();
		gateWayIp2 = "".getBytes();
		gateWayIp3 = "".getBytes();
		gateWayPort = 3001;
		pin = "111111".getBytes();
		role = 1;
		cipherSuit = 3;
		connectTimeOut = 5;
		retryConnectCount = 10000;
		certId = new byte[2];
		pubkeyId = new byte[2];
		prikeyId = new byte[2];
		certId[0] = 0x00;
		certId[1] = 0x29;
		pubkeyId[0] = 0x00;
		pubkeyId[1] = 0x2a;
		prikeyId[0] = 0x00;
		prikeyId[1] = 0x2b;
		//terminalInfo = "ANDROID;11111111111111111111111111111111".getBytes();
		logSwitch = 1;//日志开关
		logLevel = 1; //日志级别
		logFileSize =1;//日志文件大小

		mixNum = 1;

		mixDeno = 1;
		
		aclVersion = 2;
	}
	
	public String formatSslClientConfig() {
		StringBuffer configInfo = new StringBuffer();
		configInfo.append("\"");
		configInfo.append(transportMode + "#");
		configInfo.append(certMode + "#");
		configInfo.append(new String(caPath)  + "#");
		configInfo.append(new String(gateWayIp) + "#");
		if (gateWayIp2 == null || gateWayIp2.equals("")) {
			configInfo.append(new String("") + "#");
		}
		else {
			configInfo.append(new String(gateWayIp2) + "#");
		}
		if (gateWayIp3 == null || gateWayIp3.equals("")) {
			configInfo.append(new String("") + "#");
		}
		else {
			configInfo.append(new String(gateWayIp3) + "#");
		}
		configInfo.append(gateWayPort + "#");
		
		configInfo.append(new String(pin) + "#");
		configInfo.append(role + "#");
		configInfo.append(cipherSuit + "#");
		configInfo.append(connectTimeOut + "#");
		configInfo.append(retryConnectCount + "#");
		configInfo.append(String.format("%02x%02x", certId[0], certId[1]) + "#");
		configInfo.append(String.format("%02x%02x", pubkeyId[0], pubkeyId[1]) + "#");
		configInfo.append(String.format("%02x%02x", prikeyId[0], prikeyId[1]) + "#");
		
		configInfo.append(new String(terminalInfo) + "#");
		
		configInfo.append(logSwitch + "#");
		configInfo.append(logLevel + "#");
		configInfo.append(logFileSize + "#");
		
		configInfo.append(mixNum + "#");
		configInfo.append(mixDeno + "#");
		
		configInfo.append(sdkVersion + "#");
		configInfo.append(new String(devPath) + "#");
		configInfo.append(devOpenFlag + "#");
		
		configInfo.append(new String(privDir) + "#");
		
		configInfo.append("\"");
		
		return configInfo.toString();
	}
}
