package com.xdja.safeclient.receiver;

import android.app.Service;
import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import android.widget.Toast;

import com.xdja.cc.CoverCard;
import com.xdja.key.KeyWrapper;
import com.xdja.key.covercard.CoverCardWrapper;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.GuardianHelper;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.StartVpnActivity;
import com.xdja.safeclient.TunVpnService;
import com.xdja.safeclient.VpnService;
import com.xdja.safeclient.event.EventManager;
import com.xdja.safeclient.event.SDCardStateChangeListener;
import com.xdja.safeclient.utils.Log;
import com.xdja.safeclient.utils.LogUtil;
import com.xdja.safeclient.wrapper.PinWrapper;
import com.xdja.sslvpn.CONSTANT;
import com.xdja.sslvpn.SSLVPN;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class    bootBroadcastReceiver extends BroadcastReceiver {
    private int autoStart = 0;
    private int disableWifi = 0; /* 禁止wifi，0 ：不禁止； 1：禁止 */
    private int disableBluetoolth = 0; /* 禁止wifi，0 ：不禁止； 1：禁止 */

    private String TAG = "bootBroadcastReceiver";

    public static final int DISABLE_RETRY_SSL = 1;
    public static final int ENABLE_RETRY_SSL = 0;

    public static final String ACTION_SDCARD_MOUNTED = "android.intent.action.MEDIA_MOUNTED";
    public static final String ACTION_SDCARD_EJECT = "android.intent.action.MEDIA_EJECT";



    @Override
    public void onReceive(Context context, Intent intent) {

        loadPropertiesConfig(context);

        String action = intent.getAction();

        Log.d(TAG, action);

        switch (action) {

            case ACTION_SDCARD_MOUNTED:
                Log.e(TAG, "SDCARD mounted event  device " + intent.getData().toString());
                EventManager.getInstance().onSDCardStateChanged(SDCardStateChangeListener.SDCARD_MOUNTED);
                break;
            case ACTION_SDCARD_EJECT:

                Log.d(TAG, "SDCARD eject event");
                if (intent.getData().toString().contains("udisk")) {
                    Log.d(TAG, "onReceive " + "igore second sdcard eject");
                    return;
                }
                EventManager.getInstance().onSDCardStateChanged(SDCardStateChangeListener.SDCARD_EJECT);
                break;

            case Intent.ACTION_BOOT_COMPLETED:
                Log.d(TAG, "device boot completed");
                startAutoStart(context);

//                MyApplication.myApplication.getHandler().postDelayed(new Runnable() {
//                    @Override
//                    public void run() {
//                        CoverCardWrapper.getInstance().init(true);
//                        CoverCardWrapper.getInstance().destroy();
//                        Function.exitApp(MyApplication.myApplication);
//                    }
//                }, 1000);

                break;

            case WifiManager.WIFI_STATE_CHANGED_ACTION:
//                Toast.makeText(context, "Wifi状态发生改变", Toast.LENGTH_SHORT).show();
                Log.d(TAG, "wifi state has changed");
                checkWifiState(context, intent);
                break;

            case BluetoothAdapter.ACTION_STATE_CHANGED:
                Log.d(TAG, "bluetooth state has changed");
                checkBluetoothState();
                break;

            case CONSTANT.STOP_COMMON_CLIENT_ACTION:
                Log.d(TAG, "outer call stop service");
                if (!context.getPackageName().equals(CONSTANT.VIDEO_CLIENT_PACKAGE_NAME)){
                    stopVpn();
                }
                break;

            case CONSTANT.STOP_VIDEO_CLIENT_ACTION:
                Log.d(TAG, "Stop video client");
                if (context.getPackageName().equals(CONSTANT.VIDEO_CLIENT_PACKAGE_NAME)) {
                    stopVpn();
                }
                break;
            // TODO: 2017/1/11 0011 这个广播暂时在IntentFilter里静态注册
            case GuardianHelper.ALARM_ACTION:

                break;

            // TODO: 2017/1/11 0011 这个广播暂时在IntentFilter里静态注册
            case CONSTANT.ALARM_WAKEUP_ACTION:

                break;

            default:

                break;

        }

    }

    private void startAutoStart(final Context context) {

//        Toast.makeText(context, "收到开机广播", Toast.LENGTH_SHORT).show();
        if (autoStart == 1) {
            Log.d(TAG, "prepare start automatically");

            //开机自启先判断是否保存过PIN码，如果没有保存PIN码，则不处理启动服务的工作
            if (PinWrapper.getPin(context) == null) {
                return;
            }

            if (Function.getSafeVpnState(context) == false) {
                new Thread(new Runnable() {
                    public void run() {
                        startVpn(context);
                    }

                }).start();
            }

        } else {
            Log.d(TAG, "no need to start automatically");
        }

    }

    private void startVpn(Context context) {

        MyApplication myApplication = MyApplication.myApplication;

        if (myApplication == null) {
            Log.e(TAG, "startVpn,myApplication == null");
        }

        if (myApplication.sslClientConfig.getTransportMode() == 0) {
            Intent intent = new Intent();
            intent.setClassName(MyApplication.packageName, "com.xdja.safeclient.VpnService");
            context.startService(intent);
        } else {
//            ComponentName componetName = new ComponentName(
//                    //这个是另外一个应用程序的包名
//                    "com.xdja.safeclient",
//                    //这个参数是要启动的Activity
//                    "com.xdja.safeclient.StartVpnActivity");
//
//            try {
//                Intent intent = new Intent();
//                intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
//                intent.setComponent(componetName);
//                context.startActivity(intent);
//            } catch (Exception e) {
//                e.printStackTrace();
//            }

            try {
                Intent intent = new Intent(context,StartVpnActivity.class);
                intent.setFlags(Intent.FLAG_ACTIVITY_BROUGHT_TO_FRONT
                        | Intent.FLAG_ACTIVITY_NEW_TASK);
                //intent.setComponent(componetName);
                context.startActivity(intent);
            } catch (Exception e) {
                e.printStackTrace();
                Log.e(TAG, "startActivity StartVpnActivity failed");
            }

        }

    }

    private void checkWifiState(Context context, Intent intent) {
        MyApplication myApplication = MyApplication.myApplication;

        WifiManager wifi = (WifiManager) context.getSystemService(Context.WIFI_SERVICE);

        if (wifi != null) {

            int wifiState = wifi.getWifiState();

            if (WifiManager.WIFI_STATE_ENABLING == wifiState
                    || WifiManager.WIFI_STATE_ENABLED == wifiState) {
                if (disableWifi == 1 && myApplication.disableFlag == 1) {
                    wifi.setWifiEnabled(false);//禁止使用WIFI
                    Log.d(TAG, "setWifiEnabled(false)");
                }
            }
        }
    }

    private void checkBluetoothState() {
        MyApplication myApplication = MyApplication.myApplication;

        BluetoothAdapter bluetooth = BluetoothAdapter.getDefaultAdapter();

        if (bluetooth != null) {
            int blueState = bluetooth.getState();

            if (BluetoothAdapter.STATE_TURNING_ON == blueState
                    || BluetoothAdapter.STATE_ON == blueState) {
                if (disableBluetoolth == 1 && myApplication.disableFlag == 1) {
                    try {
                        bluetooth.disable();//禁止使用蓝牙
                        Log.d("bootBroadcastReceiver", "bluetooth.disable");
                    } catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }

    }

    private void checkNetWorkState(Context context) {
        Log.d(TAG, "网络状态已经改变");
        ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo info = connectivityManager.getActiveNetworkInfo();
        if (info != null && info.isAvailable()) {
            String name = info.getTypeName();
            Log.d(TAG, "当前网络名称：" + name);
            enableRetrySSL(ENABLE_RETRY_SSL);
        } else {
            Log.d(TAG, "没有可用网络");
            enableRetrySSL(DISABLE_RETRY_SSL);
        }
    }

    private void enableRetrySSL(int value) {
        final MyApplication myApplication = MyApplication.myApplication;
        final String cmdValue;

        if (value == DISABLE_RETRY_SSL) {
            cmdValue = CONSTANT.CMD_DISABLE_RETRY_SSL;
        } else {
            cmdValue = CONSTANT.CMD_ENABLE_RETRY_SSL;
        }

        new Thread(new Runnable() {
            public void run() {
                if (VpnService.FORWARD_MODE == myApplication.sslClientConfig.transportMode) {
                    synchronized (VpnService.xlock) {
                        if (VpnService.sock != null) {
                            VpnService.sock.sendData(cmdValue);
                            byte[] state = new byte[1024];
                            int statelen = VpnService.sock.recvData(state);
                            if (statelen > 0) {
                                Log.d(TAG, "state = " + new String(state, 0, statelen));
                            }
                        }
                    }
                }
                //没有root权限的隧道模式
                else {
                    synchronized (TunVpnService.lock) {
                        if (TunVpnService.sock != null) {
                            TunVpnService.sock.sendData(cmdValue);
                            byte[] state = new byte[1024];
                            int statelen = TunVpnService.sock.recvData(state);
                            if (statelen > 0) {
                                Log.d(TAG, "state = " + new String(state, 0, statelen));
                            }
                        }
                    }
                }
            }

            ;
        }).start();

    }

    public void stopVpn() {
        MyApplication myApplication = MyApplication.myApplication;

        //转发模式
        if (VpnService.FORWARD_MODE == myApplication.sslClientConfig.transportMode) {
            stopVpnService(myApplication);
            Log.d(TAG, "TransMode to stop service");
        }
        //隧道模式
        else {
            stopTunVpnService(myApplication);
            Log.d(TAG, "TunMode to stop service");
        }
    }

    public void stopVpnService(MyApplication myApplication) {
        boolean res = false;

        Log.d(TAG, "stop VpnService...");
        Intent intent = new Intent(myApplication, VpnService.class);

        res = myApplication.stopService(intent);

        if (res == false) {
            Log.e(TAG, "stop VpnService failed");
        } else {
            Log.d(TAG, "stop VpnService success ");
        }
    }

    public void stopTunVpnService(MyApplication myApplication) {
        Log.d(TAG, "stop TunVpnService...");

        if (myApplication == null) {
            Log.e(TAG, "myApplication == null");
        }

        try {
            boolean res = false;
            try {
                if (TunVpnService.mInterface != null) {
                    Log.d(TAG, "TunVpnService.mInterface.close");
                    TunVpnService.mInterface.close();
                    TunVpnService.mInterface = null;
                    if (TunVpnService.tunVpnObj != null) {
                        TunVpnService.tunVpnObj.destroyBuilder();
                    }
                }
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }

            if (myApplication.sslvpn != null) {
                myApplication.sslvpn.closeTunFd();
            }

            Intent intent = new Intent();
            intent.setClassName(MyApplication.packageName, "com.xdja.safeclient.TunVpnService");

            res = myApplication.stopService(intent);

            if (res == false) {
                Log.e(TAG, "stop TunVpnService failed");
            } else {
                Log.d(TAG, "stop TunVpnService success ");
            }

        } catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    /**
     * 取配置文件中autoStart,wifi，bluetooth配置
     */
    private void loadPropertiesConfig(Context context) {

        String propertiesPath = "conf.properties";
        InputStream in = null;
        try {
            in = (InputStream) context.getResources().getAssets().open(propertiesPath);
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        Properties prop = new Properties();

        try {
            prop.load(in);
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

        String strAutoStart = (String) prop.get("autoStart");
        autoStart = Integer.parseInt(strAutoStart);
        Log.d(TAG, "loadProperties, autoStart = " + autoStart);

        String strDisableWifi = (String) prop.get("disableWifi");
        disableWifi = Integer.parseInt(strDisableWifi);
        Log.d(TAG, "loadProperties, disableWifi = " + disableWifi);

        String strDisableBluetoolth = (String) prop.get("disableBluetoolth");
        disableBluetoolth = Integer.parseInt(strDisableBluetoolth);
        Log.d(TAG, "loadProperties, disableBluetoolth = " + disableBluetoolth);
    }

}
