package com.xdja.safeclient.ui;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.WindowManager;

import com.xdja.safeclient.R;
import com.xdja.safeclient.utils.StringUtil;

/**
 * Description:
 * Created by zjc on 2017/1/16 0016.
 */
public class AlertUtil {

    public static void openCardFailed(Context context) {
        popAlert(context, StringUtil.getStringRes(context, R.string.alert), StringUtil.getStringRes(context, R.string.open_card_failed));
    }

    public static void popAlert(Context context, String title, String msg) {
        try {
            new AlertDialog.Builder(context).setTitle(title)
                    .setMessage(msg).setNeutralButton(StringUtil.getStringRes(context, R.string.positive),
                    new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dlg,
                                            int which) {

                        }
                    }).show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void popSystemAlert(Context context, String title, String msg, DialogInterface.OnClickListener clickListener) {
        try {
            AlertDialog.Builder builder = new AlertDialog.Builder(context);
            builder.setTitle(title);
            builder.setMessage(msg);
            builder.setNegativeButton(StringUtil.getStringRes(context, R.string.positive), clickListener);
            Dialog dialog = builder.create();
            dialog.getWindow().setType(WindowManager.LayoutParams.TYPE_SYSTEM_ALERT);
            dialog.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void popSystemAlert(Context context, String title, String msg, DialogInterface.OnClickListener clickListener, boolean cancleable) {
        try {
            AlertDialog.Builder builder = new AlertDialog.Builder(context);
            builder.setTitle(title);
            builder.setMessage(msg);
            builder.setNegativeButton(StringUtil.getStringRes(context, R.string.positive), clickListener);
            Dialog dialog = builder.create();
            dialog.getWindow().setType(WindowManager.LayoutParams.TYPE_SYSTEM_ALERT);
            dialog.setCancelable(cancleable);
            dialog.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
