package com.xdja.safeclient.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.RelativeLayout;

import com.xdja.safeclient.R;

/**
 * Created by hyh on 2018/7/12.
 */

public class WidthRatioRelativeLayout extends RelativeLayout {
    private float mRatio = 1f;

    public WidthRatioRelativeLayout(Context context) {
        this(context, null);
    }

    public WidthRatioRelativeLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WidthRatioRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = getContext().obtainStyledAttributes(attrs, R.styleable.WidthRatioRelativeLayout);
        mRatio = typedArray.getFloat(R.styleable.WidthRatioRelativeLayout_ratio, 1f);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        setMeasuredDimension(getDefaultSize(0, widthMeasureSpec), getDefaultSize(0, heightMeasureSpec));
        int childWidthSize = getMeasuredWidth();
        widthMeasureSpec = MeasureSpec.makeMeasureSpec(childWidthSize, MeasureSpec.EXACTLY);
        if (childWidthSize < 600) {
            mRatio=0.25f;
        }
        heightMeasureSpec = MeasureSpec.makeMeasureSpec(Math.round(childWidthSize * mRatio), MeasureSpec.EXACTLY);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }
}
