package com.xdja.safeclient.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

/**
 * Description:网络判断相关的工具类
 * Created by Administrator on 2017/3/1 0001.
 */
public class NetworkUtil {

    public static List<String> CHINA_MOBILE = new ArrayList<>();
    public static List<String> CHINA_UNICOM = new ArrayList<>();
    public static List<String> CHINA_TELECOM = new ArrayList<>();

    /**
     * 中国移动GPRS
     */
    public static final String CHINA_MOBILE_GPRS = "cmnet";
    /**
     * 中国移动WAP
     */
    public static final String CHINA_MOBILE_WAP = "cmwap";
    /**
     * 中国移动彩信
     */
    public static final String CHINA_MOBILE_MMS = "cmwap";

    /**
     * 中国电信GPRS
     */
    public static final String CHINA_TELECOM_GRPS = "ctnet";

    /**
     * 中国电信WAP
     */
    public static final String CHINA_TELECOM_WAP = "ctwap";

    /**
     * 中国电信ctlte
     */
    public static final String CHINA_TELECOM_CTLTE = "ctlte";

    /**
     * 中国电信彩信
     */
    public static final String CHINA_TELECOM_MMS = "ctwap";

    static {
        CHINA_MOBILE.add(CHINA_MOBILE_GPRS);
        CHINA_MOBILE.add(CHINA_MOBILE_WAP);
        CHINA_MOBILE.add(CHINA_MOBILE_MMS);

        CHINA_TELECOM.add(CHINA_TELECOM_GRPS);
        CHINA_TELECOM.add(CHINA_TELECOM_WAP);
        CHINA_TELECOM.add(CHINA_TELECOM_MMS);
        CHINA_TELECOM.add(CHINA_TELECOM_CTLTE);
    }

    /**
     * 获取APN接入点名称
     *
     * @param context context
     * @return 已知的GPRS模式接入点名称
     * 中国电信 - ctnet
     * 中国移动 - cmnet
     * 注意，同一个电信运营商在不同的APN选项下接入点是不一样的
     */
    public static String getAPNName(Context context) {
        ConnectivityManager cm =
                (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo ni = cm.getActiveNetworkInfo();

        return ni.getExtraInfo();//获取网络接入点，这里一般为cmwap和cmnet
    }

    /**
     * 是否是标准的移动APN接入点
     *
     * @param apnName 接入点名称
     * @return
     */
    public static boolean isChinaMobileAPN(String apnName) {
        return CHINA_MOBILE.indexOf(apnName) != -1;
    }

    /**
     * 是否是标准的电信APN接入点
     *
     * @param apnName 接入点名称
     * @return
     */
    public static boolean isChinaTelecomeAPN(String apnName) {
        return CHINA_TELECOM.indexOf(apnName) != -1;
    }

    /**
     * 获取当前IP地址
     *
     * @param context context
     * @return
     */
    public static String getIP(Context context) {
        try {
            for (Enumeration<NetworkInterface> en = NetworkInterface
                    .getNetworkInterfaces(); en.hasMoreElements(); ) {
                NetworkInterface ni = en.nextElement();
                for (Enumeration<InetAddress> enumIpAddr = ni
                        .getInetAddresses(); enumIpAddr.hasMoreElements(); ) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (!inetAddress.isLoopbackAddress() && !inetAddress.isLinkLocalAddress()) {
                        return inetAddress.getHostAddress();
                    }
                }
            }
        } catch (SocketException ex) {
            com.xdja.safeclient.utils.Log.e("WifiPreferenceIpAddress", ex.toString());
        }
        return "";
    }

    public static boolean netWorkisAvailable(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo info = connectivityManager.getActiveNetworkInfo();
        if (info != null && info.isConnected()) {
            // 当前网络是连接的
            if (info.getState() == NetworkInfo.State.CONNECTED) {
                // 当前所连接的网络可用
                return true;
            }
        }
        return false;
    }

}

