package com.xdja.sslvpn.api;

/**
 * Created by xingjianqiang on 2017/3/23.
 * Project : safeclient_android_apidemo
 * Email : xingjianqiang@xdja.com
 */

public interface VPNApi {

    /**
     * 安全客户端未安装
     */
    int APP_NOT_INSTALLED = -2;

    /**
     * 安全客户端未启动
     */
    int APP_NOT_STARTED = -1;

    /**
     * 安全客户端连接成功
     */
    int CONNECTED = 0;

    /**
     * 安全客户端正在连接
     */
    int CONNECTING = 1;

    /**
     * 安全客户端启动失败
     */
    int FAILED = 2;

    /**
     * 启动安全客户端
     *
     * @return -1 安全客户端未安装 0 成功
     */
    int start();


    /**
     * 停止安全客户端
     *
     * @return -1 失败 0 成功
     */
    int stop();

    /**
     * 获取当前安全客户端状态
     *
     * @return 状态结果
     */
    StateResult getStatus();

    /**
     * 获取卡ID
     *
     * @return
     */
    String getCardID();

    /**
     * 安全客户端查询状态返回结果的描述类
     */
    class StateResult {

        /**
         * 状态码
         */
        private int code;

        /**
         * 状态描述
         */
        private String comment;

        private int originalCode = -1;

        public int getCode() {
            return code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getComment() {
            return comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public void setOriginalCode(int originalCode) {
            this.originalCode = originalCode;
        }

        public int getOriginalCode() {
            return originalCode;
        }
    }

}
