package com.xdja.third.emm;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;

import com.xdja.emm.framework.binder.IEmmFunctionServer;
import com.xdja.safeclient.utils.Log;


/**
 * Created by niuguofu on 2017/5/13.
 */

public class SecManager {
    private final String TAG = "SecManager";
    private IEmmFunctionServer mEmmServer = null;
    private boolean mConnectServerFlag = false;
    private static final String SERVER_NAME = "xdja.emm.sec.service";

    private volatile static SecManager instance = null;

    private EmmServcieCallback callback = null;

    public static SecManager getInstance(){
        if(null == instance){
            synchronized (SecManager.class) {
                if(null == instance){
                    instance = new SecManager();
                }
            }
        }
        return instance;
    }

    ServiceConnection connection = new ServiceConnection() {

        @Override
        public void onServiceDisconnected(ComponentName name) {
            Log.v(TAG, "EmmSecManager onServiceDisconnected()");
            mConnectServerFlag = false;

            if (callback != null) {
                callback.onDisnnected();
            }
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            Log.v(TAG, "EmmSecManager onServiceConnected()");
            mEmmServer = IEmmFunctionServer.Stub.asInterface(service);
            mConnectServerFlag = true;

            if (callback != null) {
                callback.onConnected();
            }
        }
    };

    public void initServer(Context mContext, EmmServcieCallback callback){
        Log.v(TAG, "EmmSecManager initServer()");
        Intent intent = new Intent();
        intent.setAction(SERVER_NAME);
        intent.setPackage("com.xdja.emm.framework");
        mContext.bindService(intent, connection, mContext.BIND_AUTO_CREATE);

        this.callback = callback;
    }

    public void destroyService(Context mContext){
        Log.v(TAG, "EmmSecManager destroyService()");
        mContext.unbindService(connection);
    }

    public int silentInstall(String uri, int flags){
        Log.v(TAG, "EmmSecManager silentInstall() mConnectServerFlag = " + mConnectServerFlag);
        if (!isConnectServer()){
            return -101;
        }

        boolean flag = false;
        try {
            flag = mEmmServer.silentInstall(uri, flags);
        } catch (RemoteException e) {
            e.printStackTrace();
        }

        return flag ? 1 : 0;
    }

    public boolean isConnectServer(){
        return mConnectServerFlag;
    }

}
