package kl.cds.constant;

public enum TypePolicy {

    // 全局策略（100-199）
    G_TRUSTEDSITE(100,"信任站点"),
    G_CERTCHAINS(101,"证书链"),
    G_AUTH(102,"认证策略"),

    // 个人策略（200-299）
    P_CERT_TYPE(200,"证书类型"),
    P_DEVICE_TYPE(201,"介质类型"),
    P_CERT_UPDATE(202,"证书更新策略"),
    P_REVIEW(203,"审核策略"),
    P_UNLOCK(204,"解锁策略"),

    // 扩展策略（600-999）
    E_VPN(600,"VPN策略"),
    E_SSL(601,"SSL策略"),
    E_SSL_EX_INFO(602,"代理扩展信息策略");

    private int id;

    private String caption;

    TypePolicy(int id,String caption){
        this.id = id;
        this.caption = caption;
    }

    public int getId() {
        return id;
    }

    public String getCaption() {
        return caption;
    }

    public static String valueOf(int id){
        TypePolicy[] values = TypePolicy.values();
        for (TypePolicy one:values){
            if (one.id == id)
                return one.caption;
        }
        throw new IllegalArgumentException("No enum constant " + TypePolicy.class.getCanonicalName() + ".enum.id=" + id);
    }

    public static TypePolicy valueOfEnum(int id){
        TypePolicy[] values = TypePolicy.values();
        for (TypePolicy one:values){
            if (one.id == id)
                return one;
        }
        throw new IllegalArgumentException("No enum constant " + TypePolicy.class.getCanonicalName() + ".enum.id=" + id);
    }

    public static boolean isValidPolicy(int id){
        TypePolicy[] values = TypePolicy.values();
        for (TypePolicy one: values){
            if (one.id == id)
                return true;
        }
        return false;
    }

}
