/*
 * Decompiled with CFR 0.152.
 */
package com.hed.bluetooth.le;

import android.annotation.SuppressLint;
import android.util.Log;
import com.hed.bluetooth.le.GattError;
import com.hed.bluetooth.le.SyncBluetoothGatt;
import java.util.UUID;

@SuppressLint(value={"InlinedApi"})
public class RfcommGatt
implements SyncBluetoothGatt.Listener {
    public static int CONNECTION_PARAM_UPDATE_REQ_DELAY = 3000;
    private static final String TAG = "RfcommGatt";
    private SyncBluetoothGatt mSyncGatt;
    private byte[] mResponse;
    private int mMillis = 25000;
    private int mAsyncStatus = -1;

    protected RfcommGatt(SyncBluetoothGatt syncGatt) {
        this.mSyncGatt = syncGatt;
        this.mSyncGatt.setListener(this);
    }

    public int connect(int millis) throws InterruptedException, IllegalArgumentException {
        int retCode = this.mSyncGatt.connect(millis);
        if (retCode != 0) {
            return retCode;
        }
        Log.i((String)TAG, (String)("Connection param update delay " + CONNECTION_PARAM_UPDATE_REQ_DELAY));
        Thread.sleep(CONNECTION_PARAM_UPDATE_REQ_DELAY);
        retCode = this.prepare(millis);
        if (retCode != 0) {
            return retCode;
        }
        return retCode;
    }

    int prepare(int millis) throws InterruptedException, IllegalArgumentException {
        Log.i((String)TAG, (String)"Discovery Services...");
        int retCode = this.mSyncGatt.discoverServices(Service.ServiceUUID, millis);
        if (retCode != 0) {
            return retCode;
        }
        Log.i((String)TAG, (String)"Enable Notification...");
        retCode = this.mSyncGatt.setCharacteristicNotification(Service.Characteristic.NotifyUUID, true, millis);
        if (retCode != 0) {
            return retCode;
        }
        Log.i((String)TAG, (String)"Save Write Characteristic...");
        retCode = this.mSyncGatt.setCharacteristicWrite(Service.Characteristic.WriteUUID);
        if (retCode != 0) {
            return retCode;
        }
        return 0;
    }

    public int close(int millis) throws InterruptedException {
        if (this.mSyncGatt == null) {
            return 0;
        }
        int retCode = this.mSyncGatt.disconnect(millis);
        this.mSyncGatt.close();
        this.mAsyncStatus = -1;
        return retCode;
    }

    public byte[] transmit(byte[] buffer, int millis) throws InterruptedException, IllegalArgumentException, GattError {
        return this.transmit(buffer, 0, buffer.length, millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] transmit(byte[] buffer, int offset, int length, int millis) throws InterruptedException, IllegalArgumentException, GattError {
        this.mResponse = null;
        int retCode = this.mSyncGatt.write(buffer, offset, length, millis);
        if (retCode != 0) {
            throw new GattError("SyncBluetoothGatt.write failed", retCode);
        }
        RfcommGatt rfcommGatt = this;
        synchronized (rfcommGatt) {
            if (this.mResponse == null) {
                this.wait(this.mMillis);
            }
        }
        if (!this.mSyncGatt.isConnected()) {
            throw new GattError("Gatt Connection Broken", this.mAsyncStatus);
        }
        rfcommGatt = this;
        synchronized (rfcommGatt) {
            if (this.mResponse == null) {
                throw new GattError("Recv Response Timeout", 100000);
            }
        }
        return this.mResponse;
    }

    public void setRecvTimeout(int millis) throws IllegalArgumentException {
        if (millis < 0) {
            throw new IllegalArgumentException("millis<0");
        }
        this.mMillis = millis;
    }

    public void logOn(boolean on) {
        this.mSyncGatt.logOn(on);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConnectionStateChange(int status, int newState) {
        RfcommGatt rfcommGatt = this;
        synchronized (rfcommGatt) {
            this.mAsyncStatus = status;
            this.notifyAll();
        }
        Log.i((String)TAG, (String)("SyncGatt.onConnectionStateChange called, status=" + status + ", newState=" + newState));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReceiveData(byte[] data) {
        RfcommGatt rfcommGatt = this;
        synchronized (rfcommGatt) {
            this.mResponse = data;
            this.notifyAll();
        }
    }

    public static class Service {
        public static UUID ServiceUUID = UUID.fromString("0000CC01-0000-1000-8000-00805f9b34fb");

        public static class Characteristic {
            public static UUID WriteUUID = UUID.fromString("0000CD20-0000-1000-8000-00805f9b34fb");
            public static UUID NotifyUUID = UUID.fromString("0000CD01-0000-1000-8000-00805f9b34fb");
        }
    }
}

