/*
 * Decompiled with CFR 0.152.
 */
package com.ccore;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.util.Log;
import cn.org.bjca.wsecx.outter.encoder.Base64;
import com.ccore.CResult;
import com.ccore.CcArray;
import com.ccore.NameAddr;
import java.util.ArrayList;
import java.util.LinkedList;

public class CcoreBT {
    private final String tag = "SDCC";
    private final String sid = "ffe0";
    private final String cid = "ffe1";
    private final int scan_timeout = 2000;
    private final int connect_timeout = 2000;
    private final int connect_timeout_extra = 1000;
    private final int disconnect_timeout = 2000;
    private final int send_interval = 10;
    private final int recv_interval = 10;
    private final int recv_timeout = 3000;
    private final int bufSize = 65536;
    private final int packSize = 20;
    private boolean scanning;
    private LinkedList<byte[]> datBuf;
    private ArrayList<BluetoothDevice> mListDevice;
    private BluetoothGatt mBluetoothGatt;
    private BluetoothGattCharacteristic mCharacteristic;
    private Handler mhandler;
    private BluetoothAdapter mBluetoothAdapter;
    private BluetoothAdapter.LeScanCallback mLeScanCallback;
    private BluetoothGattCallback mGattCallback;
    public int errno;

    static {
        System.loadLibrary("ccore_midware");
    }

    private synchronized byte[] doBuf(boolean add, boolean tail, byte[] dat) {
        if (this.datBuf == null) {
            this.datBuf = new LinkedList();
        }
        if (add) {
            if (dat != null && this.datBuf.size() < 3276) {
                if (tail) {
                    this.datBuf.addLast(dat);
                } else {
                    this.datBuf.addFirst(dat);
                }
                return dat;
            }
            return null;
        }
        if (this.datBuf.size() > 0) {
            return this.datBuf.removeFirst();
        }
        return new byte[0];
    }

    public void sleep(int msec) {
        try {
            Thread.sleep(msec);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void clear() {
        this.mBluetoothGatt = null;
        this.mCharacteristic = null;
        this.scanning = false;
        this.datBuf = null;
    }

    public CcoreBT(PackageManager packageManager, BluetoothManager bluetoothManager) {
        this.clear();
        this.errno = 0;
        if (packageManager == null || bluetoothManager == null) {
            this.errno = -1;
            Log.e((String)"SDCC", (String)"bad parameters in constructor");
            return;
        }
        if (!packageManager.hasSystemFeature("android.hardware.bluetooth_le")) {
            this.errno = -3;
            Log.e((String)"SDCC", (String)"BLE is no supported");
            return;
        }
        this.mBluetoothAdapter = bluetoothManager.getAdapter();
        if (this.mBluetoothAdapter == null || !this.mBluetoothAdapter.isEnabled()) {
            this.errno = -4;
            Log.e((String)"SDCC", (String)"BLE is disabled");
            return;
        }
        this.mLeScanCallback = new BluetoothAdapter.LeScanCallback(){

            public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
                if (rssi < -75) {
                    Log.w((String)"SDCC", (String)("device \"" + device.getName() + ":" + device.getAddress().toString() + "\" is too far away"));
                    return;
                }
                if (device.getName().length() != 11 || device.getName().charAt(0) != '_') {
                    Log.w((String)"SDCC", (String)("device \"" + device.getName() + ":" + device.getAddress().toString() + "\" is not ccore's device"));
                    return;
                }
                if (CcoreBT.this.mListDevice.contains(device)) {
                    Log.i((String)"SDCC", (String)("device \"" + device.getName() + ":" + device.getAddress().toString() + "\" is already added, " + "rssi = " + rssi));
                    return;
                }
                Log.i((String)"SDCC", (String)("device \"" + device.getName() + ":" + device.getAddress().toString() + "\" is found, " + "rssi = " + rssi));
                CcoreBT.this.mListDevice.add(device);
            }
        };
        this.mGattCallback = new BluetoothGattCallback(){

            public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
                BluetoothDevice bd = gatt.getDevice();
                if (newState == 2) {
                    Log.i((String)"SDCC", (String)("device \"" + bd.getName() + ":" + bd.getAddress().toString() + "\" is connected"));
                    gatt.discoverServices();
                } else if (newState == 0) {
                    Log.i((String)"SDCC", (String)("device \"" + bd.getName() + ":" + bd.getAddress().toString() + "\" is disconnected"));
                    gatt.close();
                    CcoreBT.this.mBluetoothGatt = null;
                    CcoreBT.this.mCharacteristic = null;
                }
            }

            public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
                if (status != 0) {
                    Log.w((String)"SDCC", (String)"write fails");
                }
            }

            public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
                if (status != 0) {
                    Log.w((String)"SDCC", (String)"read fails");
                }
            }

            public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
                byte[] st = characteristic.getValue();
                if (CcoreBT.this.doBuf(true, true, st) != null) {
                    Log.v((String)"SDCC", (String)("total " + st.length + " bytes are received"));
                } else {
                    Log.v((String)"SDCC", (String)("total " + st.length + " bytes are discarded"));
                }
            }

            public void onServicesDiscovered(BluetoothGatt gatt, int status) {
                if (status == 0) {
                    for (BluetoothGattService bs : gatt.getServices()) {
                        if (bs.getUuid().toString().indexOf("ffe0") < 0) continue;
                        for (BluetoothGattCharacteristic cs : bs.getCharacteristics()) {
                            if (cs.getUuid().toString().indexOf("ffe1") < 0) continue;
                            CcoreBT.this.mBluetoothGatt.setCharacteristicNotification(cs, true);
                            CcoreBT.this.mCharacteristic = cs;
                        }
                    }
                } else {
                    Log.e((String)"SDCC", (String)("onServicesDiscovered: " + status));
                }
            }
        };
    }

    private void scanLeDevice() {
        if (!this.scanning) {
            this.mListDevice = new ArrayList();
            this.mListDevice.clear();
            this.mBluetoothAdapter.startLeScan(this.mLeScanCallback);
            this.scanning = true;
        } else {
            Log.w((String)"SDCC", (String)"it is already scanning now");
        }
    }

    public ArrayList<NameAddr> getDeviceList() {
        ArrayList<NameAddr> na = new ArrayList<NameAddr>();
        this.scanning = false;
        this.scanLeDevice();
        this.sleep(2000);
        this.mBluetoothAdapter.stopLeScan(this.mLeScanCallback);
        this.scanning = false;
        na.clear();
        for (BluetoothDevice bd : this.mListDevice) {
            na.add(new NameAddr(bd.getName(), bd.getAddress()));
        }
        return na;
    }

    private byte xor(byte a, byte b) {
        return (byte)(a & 0xFF ^ b & 0xFF);
    }

    public long connectDev(String addr) {
        if (this.mListDevice == null || this.mListDevice.isEmpty()) {
            Log.w((String)"SDCC", (String)"no devices are found");
            return 0xA000001L;
        }
        if (this.mBluetoothGatt != null && this.mCharacteristic != null) {
            Log.w((String)"SDCC", (String)"already connected");
            return 0xA00000DL;
        }
        this.clear();
        for (BluetoothDevice bd : this.mListDevice) {
            if (bd.getName() == null || bd.getAddress() == null || bd.getName().length() != 11 || bd.getName().charAt(0) != '_' || !bd.getName().equals(addr)) continue;
            this.mBluetoothGatt = bd.connectGatt(null, false, this.mGattCallback);
            this.sleep(2000);
            if (this.mBluetoothGatt != null && this.mCharacteristic != null) {
                return 0L;
            }
            if (this.mBluetoothGatt != null) {
                this.mBluetoothGatt.disconnect();
                this.sleep(2000);
                this.mBluetoothGatt.close();
            }
            this.clear();
            Log.w((String)"SDCC", (String)("device \"" + addr + "\" has no response"));
            return 0xA00000FL;
        }
        Log.w((String)"SDCC", (String)("device \"" + addr + "\" is not found"));
        return 0xA000001L;
    }

    public int connect(String addr, String pwd, boolean wait) {
        if (this.scanning) {
            Log.w((String)"SDCC", (String)"scanning is not end");
            return 1092;
        }
        if (this.mListDevice == null || this.mListDevice.isEmpty()) {
            Log.w((String)"SDCC", (String)"no devices are found");
            return 1092;
        }
        if (this.mBluetoothGatt != null && this.mCharacteristic != null) {
            Log.w((String)"SDCC", (String)"already connected");
            return 1;
        }
        this.clear();
        for (BluetoothDevice bd : this.mListDevice) {
            if (bd.getName() == null || bd.getAddress() == null || (bd.getName().length() != 11 || bd.getName().charAt(0) != '_' ? !bd.getAddress().equals(addr) : !("600520" + bd.getName().substring(1)).equals(addr))) continue;
            if (bd.getName().charAt(0) == '_') {
                int len = 16;
                byte[] dse = ("600520" + bd.getName().substring(1)).getBytes();
                byte[] msk = "BJCABLEWSE201408".getBytes();
                byte[] bpw = null;
                if (pwd == null) {
                    return 1020;
                }
                bpw = Base64.decode((String)pwd);
                if (bpw == null) {
                    return 1020;
                }
                if (bpw.length != len) {
                    return 1020;
                }
                int i = 0;
                while (i < len) {
                    if (this.xor(msk[i], dse[i]) != bpw[i]) break;
                    ++i;
                }
                if (i < len) {
                    return 1020;
                }
            }
            this.mBluetoothGatt = bd.connectGatt(null, false, this.mGattCallback);
            if (wait) {
                this.sleep(2000);
                if (this.mBluetoothGatt != null && this.mCharacteristic != null) {
                    return 1;
                }
                this.sleep(1000);
                if (this.mBluetoothGatt != null && this.mCharacteristic != null) {
                    return 1;
                }
                if (this.mBluetoothGatt != null) {
                    this.mBluetoothGatt.disconnect();
                    this.sleep(2000);
                    this.mBluetoothGatt.close();
                }
                this.clear();
                Log.w((String)"SDCC", (String)("device \"" + addr + "\" has no response"));
                return 1091;
            }
            return 1;
        }
        Log.w((String)"SDCC", (String)("device \"" + addr + "\" is not found"));
        return 1092;
    }

    public boolean disconnectDev() {
        if (this.mBluetoothGatt != null) {
            this.mBluetoothGatt.disconnect();
            this.sleep(2000);
            return true;
        }
        Log.w((String)"SDCC", (String)"no connection to disconnect");
        return false;
    }

    public boolean disconnect() {
        if (this.mBluetoothGatt != null) {
            this.mBluetoothGatt.disconnect();
            this.sleep(2000);
        } else {
            Log.w((String)"SDCC", (String)"no connection to disconnect");
        }
        return true;
    }

    public boolean isConnected() {
        return this.mCharacteristic != null && this.mBluetoothGatt != null;
    }

    public boolean write(byte[] dat) {
        if (this.mCharacteristic == null || this.mBluetoothGatt == null) {
            Log.e((String)"SDCC", (String)"device is not connected");
            return false;
        }
        int i = 0;
        while (i < dat.length) {
            byte[] td = new byte[20 < dat.length - i ? 20 : dat.length - i];
            int j = 0;
            while (j < td.length && i < dat.length) {
                td[j] = dat[i];
                ++j;
                ++i;
            }
            this.mCharacteristic.setValue(td);
            this.mBluetoothGatt.writeCharacteristic(this.mCharacteristic);
            this.sleep(10);
        }
        Log.i((String)"SDCC", (String)(i + " bytes are sent"));
        return true;
    }

    public synchronized void cLog(String s, int level) {
        switch (level) {
            case 0: {
                Log.v((String)"SDCC", (String)s);
                break;
            }
            case 1: {
                Log.d((String)"SDCC", (String)s);
                break;
            }
            case 2: {
                Log.i((String)"SDCC", (String)s);
                break;
            }
            case 3: {
                Log.w((String)"SDCC", (String)s);
                break;
            }
            case 4: {
                Log.e((String)"SDCC", (String)s);
                break;
            }
        }
    }

    public synchronized void java_chspd(int level) {
        byte[] byArray = new byte[20];
        byArray[0] = 68;
        byArray[1] = 69;
        byArray[2] = 77;
        byArray[3] = 79;
        byArray[7] = 2;
        byArray[12] = 18;
        byArray[13] = 52;
        byArray[14] = 86;
        byArray[15] = 120;
        byArray[16] = -86;
        byArray[17] = 85;
        byArray[18] = -113;
        byArray[19] = -89;
        byte[] cc = byArray;
        this.write(cc);
    }

    public synchronized void java_resend(int level) {
        byte[] byArray = new byte[20];
        byArray[0] = 68;
        byArray[1] = 69;
        byArray[2] = 77;
        byArray[3] = 79;
        byArray[7] = 2;
        byArray[12] = 18;
        byArray[13] = 52;
        byArray[14] = 86;
        byArray[15] = 120;
        byArray[16] = 85;
        byArray[17] = -86;
        byte[] cc = byArray;
        this.write(cc);
    }

    public CcArray read(int len) {
        byte[] ret;
        if (this.mCharacteristic == null || this.mBluetoothGatt == null) {
            Log.e((String)"SDCC", (String)"device is not connected");
            return null;
        }
        if (len < 0 || 4096 < len) {
            Log.e((String)"SDCC", (String)("len = " + len + " is invalid in read(), maybe some packs are lost."));
            return null;
        }
        int i = 0;
        int h = 0;
        int k = 0;
        byte[] td = new byte[len];
        while (i < len) {
            byte[] t = this.doBuf(false, true, null);
            if (t != null && t.length > 0) {
                h += t.length;
                int j = 0;
                while (j < t.length && i + j < len) {
                    td[j + i] = t[j];
                    ++j;
                }
                i += j;
                k = 0;
                if (j < t.length) {
                    byte[] rem = new byte[t.length - j];
                    System.arraycopy(t, j, rem, 0, t.length - j);
                    this.doBuf(true, false, rem);
                }
            } else if ((k += 10) > 3000) break;
            this.sleep(10);
        }
        if (i < len) {
            ret = new byte[i];
            System.arraycopy(td, 0, ret, 0, i);
        } else {
            ret = td;
        }
        Log.i((String)"SDCC", (String)(ret.length + " (of " + len + ") bytes are returned, " + h + " bytes are received"));
        if (this.mCharacteristic == null || this.mBluetoothGatt == null) {
            return null;
        }
        return new CcArray(ret);
    }

    public native long ccOpenApp();

    public native long ccCloseApp();

    public native long ccLogin(String var1);

    public native long ccLogout();

    public native long ccInitDevice(String var1, String var2, String var3, int var4);

    public native long ccModifyUserPin(String var1, String var2);

    public native long ccModifyAdminPin(String var1, String var2);

    public native long ccUnlockDevice(String var1, String var2);

    public native CResult ccGetDeviceInfo(int var1);

    public native long ccGenerateKeyPair(String var1, int var2);

    public native long ccImportCertificate(String var1, int var2, byte[] var3);

    public native long ccImportEncryptionKeyPair(String var1, byte[] var2, byte[] var3, byte[] var4, int var5);

    public native CResult ccExportCertificate(String var1, int var2);

    public native CResult ccExportPubKey(String var1, int var2);

    public native CResult ccGetContainerList();

    public native long ccDeleteContainer(String var1);

    public native CResult ccGetRandom(int var1);

    public native CResult ccPubKeyEncryption(String var1, int var2, byte[] var3, byte[] var4);

    public native CResult ccPriKeyDecryption(String var1, int var2, byte[] var3);

    public native CResult ccSignData(String var1, int var2, int var3, byte[] var4);

    public native long ccVerifySignedData(byte[] var1, byte[] var2, byte[] var3, int var4);

    public native CResult ccSymmEncrypt(byte[] var1, int var2, byte[] var3, byte[] var4);

    public native CResult ccSymmDecrypt(byte[] var1, int var2, byte[] var3, byte[] var4);

    public native long ccWriteFile(String var1, byte[] var2);

    public native CResult ccReadFile(String var1);

    public native long ccDeleteFile(String var1);

    public native CResult ccGetFileList();

    public native CResult nativeEnumDev(boolean var1);

    public native CResult nativeConnectDev(String var1);

    public native CResult nativeDisconnectDev();
}

