/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.key.chipmanager;

import android.content.Context;
import android.util.Pair;
import com.xdja.SafeKey.XDJA_SM2_PARAM;
import com.xdja.key.KeyDevInfo;
import com.xdja.multichip.jniapi.JarJniApiProxy;
import com.xdja.multichip.jniapi.JarMultiJniApiManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.utils.Log;
import java.util.ArrayList;
import java.util.List;

public class ChipManagerWrapper {
    private static ChipManagerWrapper instance = null;
    private JarMultiJniApiManager jniApiManager = JarMultiJniApiManager.getInstance();
    private MyApplication application = MyApplication.myApplication;
    private static final String THIS_FILE = "ChipManagerWrapper";
    private List<KeyDevInfo> keyList = new ArrayList<KeyDevInfo>();

    private ChipManagerWrapper() {
    }

    public static ChipManagerWrapper getInstance() {
        if (instance == null) {
            instance = new ChipManagerWrapper();
        }
        return instance;
    }

    private List<KeyDevInfo> enumDevice() {
        this.keyList.clear();
        Pair all = null;
        long timeout = 3000L;
        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                all = this.jniApiManager.getAll((Context)this.application);
            }
            catch (IllegalArgumentException e) {
                long currentTime;
                e.printStackTrace();
                Function.startChipManagerActivity((Context)MyApplication.myApplication);
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                if ((currentTime = System.currentTimeMillis()) - startTime < timeout) continue;
            }
            break;
        }
        if (all == null) {
            Log.e(THIS_FILE, "Invoke chip manager error");
            return this.keyList;
        }
        if ((Integer)all.first != 0) {
            Log.e(THIS_FILE, "Get devices error. ret " + all.first);
            return this.keyList;
        }
        Log.d(THIS_FILE, "Get devices total count " + ((List)all.second).size());
        for (JniApiParam jp : (List)all.second) {
            if (jp == null) continue;
            KeyDevInfo keyDevInfo = new KeyDevInfo();
            keyDevInfo.setDriver("chip_manager");
            keyDevInfo.setCardId(jp.cardId);
            Log.d(THIS_FILE, "Device card id " + jp.cardId);
            Log.d(THIS_FILE, "Device type = " + jp.chipType);
            if (jp.chipType == 1) {
                keyDevInfo.setType(0);
            } else if (jp.chipType == 4) {
                keyDevInfo.setType(5);
            } else if (jp.chipType == 2) {
                keyDevInfo.setType(1);
            } else if (jp.chipType == 8) {
                keyDevInfo.setType(3);
            }
            this.keyList.add(keyDevInfo);
        }
        return this.keyList;
    }

    JarJniApiProxy getProxy(String cardId) {
        Pair jniProxyPair = this.jniApiManager.make((Context)this.application, cardId);
        if ((Integer)jniProxyPair.first == 0) {
            return (JarJniApiProxy)jniProxyPair.second;
        }
        return null;
    }

    private int verifyPIN(JarJniApiProxy proxy, int role, byte[] pin) {
        Log.d(THIS_FILE, "role = " + role);
        return proxy.VerifyPIN(role, pin, pin.length);
    }

    private int getCardID(JarJniApiProxy proxy, byte[] cardId, int[] len) {
        Pair pair = proxy.getCardId();
        if ((Integer)pair.first != 0) {
            return (Integer)pair.first;
        }
        len[0] = ((String)pair.second).length();
        System.arraycopy(((String)pair.second).getBytes(), 0, cardId, 0, len[0]);
        return 0;
    }

    private int readCert(JarJniApiProxy proxy, byte[] fid, byte[] cert, int[] len) {
        return proxy.ReadCert(fid, cert, len);
    }

    private int readFile(JarJniApiProxy proxy, byte[] fid, int pos, int len, byte[] out) {
        return proxy.ReadFile(fid, pos, len, out);
    }

    private int RSAPrikeyCalc(JarJniApiProxy proxy, byte[] fid, int bits, byte[] data, int size, byte[] out, int[] outSize) {
        return proxy.RSAPriKeyCalc(fid, data, size, out, outSize);
    }

    private int SM2Sign(JarJniApiProxy proxy, byte[] pubfid, byte[] prifid, int dataType, byte[] dataIn, int inLen, byte[] signData, int[] signDataLen) {
        int ret = proxy.SM2Sign(pubfid, prifid, dataType, dataIn, inLen, signData, signDataLen);
        Log.d(THIS_FILE, "SM2 sign ret " + ret);
        return ret;
    }

    private int getSM2Param(JarJniApiProxy proxy, XDJA_SM2_PARAM sm2Param) {
        return proxy.GetSM2Param(sm2Param);
    }

    private int getSM2ID(JarJniApiProxy proxy, byte[] id, int[] len) {
        return proxy.GetSM2Id(id, len);
    }
}

