/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.SystemClock;
import com.xdja.safeclient.receiver.bootBroadcastReceiver;
import com.xdja.safeclient.utils.Log;

public class GuardianHelper {
    private static String TAG = "guardian-Helper";
    public static final String ALARM_ACTION = "com.xdja.safeclient.guardian_advise";

    public static void invokeOnceAlarm(Context context, int second) {
        Log.d(TAG, "invokeAlarm,  second = " + second);
        Intent intent = new Intent(context, bootBroadcastReceiver.class);
        intent.putExtra("Later", second);
        intent.setAction(ALARM_ACTION);
        PendingIntent sender = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
        long firstime = SystemClock.elapsedRealtime();
        AlarmManager am = (AlarmManager)context.getSystemService("alarm");
        am.set(2, firstime + (long)(1000 * second), sender);
    }

    public static void cancleOnceAlarm(Context context) {
        Log.d(TAG, "cancleAlarm");
        Intent intent = new Intent(context, bootBroadcastReceiver.class);
        intent.setAction(ALARM_ACTION);
        PendingIntent sender = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
        AlarmManager alarm = (AlarmManager)context.getSystemService("alarm");
        alarm.cancel(sender);
    }

    public static guardian_network getNetWorkType(Context context) {
        String name = "";
        guardian_network type = guardian_network.G_NETWORK_NONE;
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo info = cm.getActiveNetworkInfo();
            if (info == null) {
                name = "null";
                type = guardian_network.G_NETWORK_NONE;
                Log.i(TAG, "checkNetWork, info == null");
                return type;
            }
            if (!info.isConnected()) {
                name = "null";
                type = guardian_network.G_NETWORK_NONE;
                Log.i(TAG, "checkNetWork, ! isConnected");
                return type;
            }
            if (info.getState() != NetworkInfo.State.CONNECTED) {
                name = "null";
                type = guardian_network.G_NETWORK_NONE;
                Log.i(TAG, "checkNetWork, not CONNECTED");
                return type;
            }
            Log.d(TAG, "Current network type = " + info.getType());
            if (info.getType() == 1) {
                name = "wifi";
                type = guardian_network.G_NETWORK_WIFI;
                Log.i(TAG, "checkNetWork, wifi");
            } else if (info.getType() == 0 || info.getType() == 12) {
                int subType = info.getSubtype();
                Log.i(TAG, "checkNetWork, TYPE_MOBILE, subType = " + subType);
                if (subType == 1) {
                    type = guardian_network.G_NETWORK_2G;
                    Log.i(TAG, "checkNetWork, NETWORK_TYPE_2G");
                } else if (subType == 4 || subType == 2) {
                    name = "2g";
                    type = guardian_network.G_NETWORK_2G;
                    Log.i(TAG, "checkNetWork, G_NETWORK_2G");
                } else if (subType == 3 || subType == 14 || subType == 8 || subType == 10 || subType == 15 || subType == 9 || subType == 6 || subType == 5 || subType == 12) {
                    name = "3g";
                    type = guardian_network.G_NETWORK_3G;
                    Log.i(TAG, "checkNetWork, G_NETWORK_3G");
                } else if (subType == 13) {
                    name = "4g";
                    type = guardian_network.G_NETWORK_4G;
                    Log.i(TAG, "checkNetWork, G_NETWORK_4G");
                } else {
                    type = guardian_network.G_NETWORK_3G;
                    Log.i(TAG, "checkNetWork, unknow type, G_NETWORK_3G");
                }
            } else {
                name = "4g";
                type = guardian_network.G_NETWORK_4G;
                Log.i(TAG, "checkNetWork, other equals G_NETWORK_4G");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            name = "null";
            type = guardian_network.G_NETWORK_NONE;
            Log.i(TAG, "checkNetWork, Exception");
        }
        Log.i(TAG, "checkNetWork, type : " + (Object)((Object)type) + " name : " + name);
        return type;
    }

    public static enum guardian_option {
        G_OPT_CONNECTING,
        G_OPT_CONNECT_FAIL,
        G_OPT_CONNECTED,
        G_OPT_HANDSHAKE_BEGIN,
        G_OPT_HANDSHAKE_SUCCESS,
        G_OPT_HANDSHAKE_FAIL,
        G_OPT_DATA_SENT,
        G_OPT_DATA_RECVED,
        G_OPT_HEARTBEAT_SENT,
        G_OPT_HEARTBEAT_RECVED,
        G_OPT_CONNECTION_CLOSE,
        G_OPT_TIME_UPDATED,
        G_OPT_NETWORK_SWITCHED,
        G_OPT_SCREEN_ON,
        G_OPT_SCREEN_OFF,
        G_START_VPN,
        G_OPTIONS_NUM;

    }

    public static enum guardian_network {
        G_NETWORK_NONE,
        G_NETWORK_2G,
        G_NETWORK_3G,
        G_NETWORK_4G,
        G_NETWORK_5G,
        G_NETWORK_WIFI;

    }
}

