/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.activity;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.xdja.safeclient.R;
import com.xdja.safeclient.adapter.ListViewAdapter;
import com.xdja.safeclient.architecture.BaseActivity;
import com.xdja.safeclient.ui.HisRecDialog;
import com.xdja.safeclient.utils.FileUtil;
import com.xdja.safeclient.utils.Log;
import com.xdja.safeclient.utils.StringUtil;
import java.io.File;
import java.util.ArrayList;

public class HistoryRecordActivity
extends BaseActivity {
    private ListView mHistoryRecListView = null;
    private ListViewAdapter mAdapter = null;
    private ProgressBar progressBar = null;
    private String pathStr;
    private String mHistoryRecFilePath;
    private final String mHistoryRecFileName = "historyrecord.txt";
    private String mSDCardPath;
    private ArrayList<String> mStrArray = null;
    private final int READ_FILE_OK = 0;
    private final int EXPORT_HISREC_OK = 1;
    private final int EXPORT_HISREC_FAILED = 2;
    Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    HistoryRecordActivity.this.setListItems();
                    break;
                }
                case 1: {
                    Toast.makeText((Context)HistoryRecordActivity.this, (CharSequence)(StringUtil.getStringRes((Context)HistoryRecordActivity.this, R.string.export_to) + HistoryRecordActivity.this.mSDCardPath + "/" + "historyrecord.txt"), (int)0).show();
                    break;
                }
                case 2: {
                    Toast.makeText((Context)HistoryRecordActivity.this, (CharSequence)StringUtil.getStringRes((Context)HistoryRecordActivity.this, R.string.export_record_failed), (int)0).show();
                    break;
                }
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_history_record);
        Log.d("HistoryRecordActivity", "onCreate");
        this.pathStr = this.getFilesDir().getAbsolutePath() + "/";
        this.mHistoryRecFilePath = this.pathStr + "historyrecord.txt";
        File page = this.getExternalFilesDir(null);
        this.mSDCardPath = page != null ? page.getPath() : "";
        Log.d("initRightBtn", "mSDCardPath = " + this.mSDCardPath);
        this.progressBar = (ProgressBar)this.findViewById(R.id.history_rec_progressbar);
        this.mStrArray = new ArrayList();
        this.initListView();
        this.mLeftBtn = (ImageView)this.findViewById(R.id.titlebar_leftbtn);
        this.mRightBtn = (ImageView)this.findViewById(R.id.titlebar_rightbtn);
        this.mTitleText = (TextView)this.findViewById(R.id.titlebar_text);
        this.initLeftBtn();
        this.initTitleText();
        this.initRightBtn();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Log.d("HistoryRecordActivity", "onDestroy");
        this.mStrArray.clear();
        this.mStrArray = null;
        this.mAdapter = null;
    }

    @Override
    protected void initRightBtn() {
        super.initRightBtn();
        this.mRightBtn.setVisibility(0);
        this.mRightBtn.setBackgroundResource(R.drawable.save);
        this.mRightBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (HistoryRecordActivity.this.mSDCardPath == null) {
                    return;
                }
                final File sourceFile = new File(HistoryRecordActivity.this.mHistoryRecFilePath);
                final File targetFile = new File(HistoryRecordActivity.this.mSDCardPath + "/" + "historyrecord.txt");
                new Thread(){

                    @Override
                    public void run() {
                        Message msg = new Message();
                        msg.what = FileUtil.copeFile(sourceFile, targetFile) ? 1 : 2;
                        HistoryRecordActivity.this.mHandler.sendMessage(msg);
                    }
                }.start();
            }
        });
    }

    @Override
    protected void initTitleText() {
        super.initTitleText();
        this.mTitleText.setText(R.string.label_his_rec);
    }

    private void initListView() {
        this.mHistoryRecListView = (ListView)this.findViewById(R.id.history_record_listview);
        this.mHistoryRecListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View v, int position, long arg3) {
                final String msg = adapterView.getItemAtPosition(position).toString();
                HisRecDialog dialog = new HisRecDialog(adapterView.getContext(), R.style.MyDialog){

                    @Override
                    public void setMessage() {
                        this.setText(msg);
                    }
                };
                dialog.show();
            }
        });
        if (this.progressBar != null) {
            this.progressBar.setVisibility(0);
        }
        FileUtil.readFileByLines(this.mHistoryRecFilePath, this.mStrArray, this.mHandler);
        if (this.progressBar != null) {
            this.progressBar.setVisibility(4);
        }
    }

    private void setListItems() {
        if (this.mStrArray == null) {
            return;
        }
        this.mAdapter = new ListViewAdapter((Context)this, this.mStrArray, R.layout.list_item, R.id.listItemTextView){

            @Override
            public View setItemViewAttribute(View view) {
                if (view instanceof TextView) {
                    ((TextView)view).setMaxLines(1);
                    ((TextView)view).setEllipsize(TextUtils.TruncateAt.END);
                }
                return view;
            }
        };
        this.mHistoryRecListView.setAdapter((ListAdapter)this.mAdapter);
        if (this.progressBar != null) {
            this.progressBar.setVisibility(4);
        }
    }
}

