/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.ui;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xdja.safeclient.R;

public class MDialog {
    private boolean mCancel;
    private boolean mCancelable = true;
    private Context mContext;
    private AlertDialog mAlertDialog;
    private Builder mBuilder;
    private int mTitleResId;
    private CharSequence mTitle;
    private int mMessageResId;
    private CharSequence mMessage;
    private TextView mPositiveButton;
    private boolean positiveButtonExit;
    private TextView mNegativeButton;
    private boolean negativeButtonExit;
    private TextView mNeutralButton;
    private boolean neutralButtonIsShow;
    private LinearLayout buttonLayout;
    private LinearLayout mainView;
    private View mDialogView;
    private View mBtnLine;
    private View mBtnLine2;
    private int gravity = 16;
    private boolean mHasShow = false;
    private DialogInterface.OnDismissListener mOnDismissListener;
    private DialogInterface.OnKeyListener onKeyListener;
    private String mPositiveButtonTitle;
    private View.OnClickListener mPositiveButtonClick;
    private String mNegativeButtonTitle;
    private View.OnClickListener mNegativeButtonClick;
    private String mNeutralButtonTitle;
    private View.OnClickListener mNeutralButtonClick;
    private DialogInterface.OnShowListener onShowListener;

    public void setOnKeyListener(DialogInterface.OnKeyListener onKeyListener) {
        this.onKeyListener = onKeyListener;
    }

    public MDialog(Context context) {
        this.mContext = context;
    }

    public void show() {
        if (!this.mHasShow) {
            this.mBuilder = new Builder();
        } else {
            this.mAlertDialog.show();
        }
        this.mHasShow = true;
    }

    public MDialog setView(View view) {
        this.mDialogView = view;
        if (this.mBuilder != null) {
            this.mBuilder.setView(view);
        }
        return this;
    }

    public void dismiss() {
        this.mAlertDialog.dismiss();
    }

    public MDialog setTitle(int resId) {
        this.mTitleResId = resId;
        if (this.mBuilder != null) {
            this.mBuilder.setTitle(resId);
        }
        return this;
    }

    public MDialog setTitle(CharSequence title) {
        this.mTitle = title;
        if (this.mBuilder != null) {
            this.mBuilder.setTitle(title);
        }
        return this;
    }

    public MDialog setMessage(int resId) {
        this.mMessageResId = resId;
        if (this.mBuilder != null) {
            this.mBuilder.setMessage(resId);
        }
        return this;
    }

    public MDialog setMessage(CharSequence message) {
        this.mMessage = message;
        if (this.mBuilder != null) {
            this.mBuilder.setMessage(message);
        }
        return this;
    }

    public MDialog setMessageGravity(int gravity) {
        this.gravity = gravity;
        if (this.mBuilder != null) {
            this.mBuilder.setMessageGravity(gravity);
        }
        return this;
    }

    public MDialog setNeutralButton(String text, View.OnClickListener listener) {
        this.neutralButtonIsShow = true;
        this.mNeutralButtonTitle = text;
        this.mNeutralButtonClick = listener;
        if (this.mBuilder != null) {
            this.mBuilder.setNeutralButton(text, listener);
        }
        return this;
    }

    public MDialog setPositiveButton(String text, View.OnClickListener listener) {
        this.positiveButtonExit = true;
        this.mPositiveButtonTitle = text;
        this.mPositiveButtonClick = listener;
        if (this.mBuilder != null) {
            this.mBuilder.setPositiveButton(text, listener);
        }
        return this;
    }

    public MDialog setNegativeButton(String text, View.OnClickListener listener) {
        this.negativeButtonExit = true;
        this.mNegativeButtonTitle = text;
        this.mNegativeButtonClick = listener;
        if (this.mBuilder != null) {
            this.mBuilder.setNegativeButton(text, listener);
        }
        return this;
    }

    public MDialog setCanceledOnTouchOutside(boolean cancel) {
        this.mCancel = cancel;
        if (this.mBuilder != null) {
            this.mBuilder.setCanceledOnTouchOutside(this.mCancel);
        }
        return this;
    }

    public MDialog setCancelable(boolean cancelable) {
        this.mCancelable = cancelable;
        if (this.mBuilder != null) {
            this.mBuilder.setCancelable(this.mCancelable);
        }
        return this;
    }

    public MDialog setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
        return this;
    }

    private class Builder {
        private TextView mTitleView;
        private TextView mMessageView;
        private View contv;

        private Builder() {
            int v;
            MDialog.this.mAlertDialog = new AlertDialog.Builder(MDialog.this.mContext, R.style.Theme_Transparent).create();
            MDialog.this.mAlertDialog.getWindow().clearFlags(131080);
            MDialog.this.mAlertDialog.getWindow().setSoftInputMode(4);
            this.contv = LayoutInflater.from((Context)MDialog.this.mContext).inflate(R.layout.layout_mdialog, null);
            MDialog.this.mAlertDialog.setView(this.contv);
            this.mTitleView = (TextView)this.contv.findViewById(R.id.mDialog_title);
            this.mMessageView = (TextView)this.contv.findViewById(R.id.mDialog_message);
            MDialog.this.mPositiveButton = (TextView)this.contv.findViewById(R.id.mDialog_ok);
            MDialog.this.mNegativeButton = (TextView)this.contv.findViewById(R.id.mDialog_cancel);
            MDialog.this.mNeutralButton = (TextView)this.contv.findViewById(R.id.mDialog_neutral);
            MDialog.this.buttonLayout = (LinearLayout)this.contv.findViewById(R.id.mDialog_btn_layout);
            MDialog.this.mainView = (LinearLayout)this.contv.findViewById(R.id.mDialog_view);
            MDialog.this.mBtnLine = this.contv.findViewById(R.id.mDialog_btn_line);
            MDialog.this.mBtnLine2 = this.contv.findViewById(R.id.mDialog_btn_line_2);
            if (MDialog.this.mTitleResId != 0) {
                this.setTitle(MDialog.this.mTitleResId);
                this.mTitleView.setVisibility(0);
            }
            if (MDialog.this.mTitle != null) {
                this.setTitle(MDialog.this.mTitle);
                this.mTitleView.setVisibility(0);
            }
            if (MDialog.this.mMessageResId != 0) {
                this.setMessage(MDialog.this.mMessageResId);
                this.mMessageView.setVisibility(0);
            }
            if (MDialog.this.mMessage != null) {
                this.setMessage(MDialog.this.mMessage);
                this.mMessageView.setVisibility(0);
            }
            this.setMessageGravity(MDialog.this.gravity);
            if (MDialog.this.positiveButtonExit) {
                this.setPositiveButton(MDialog.this.mPositiveButtonTitle, MDialog.this.mPositiveButtonClick);
                MDialog.this.mPositiveButton.setVisibility(0);
            }
            if (MDialog.this.negativeButtonExit) {
                this.setNegativeButton(MDialog.this.mNegativeButtonTitle, MDialog.this.mNegativeButtonClick);
                MDialog.this.mNegativeButton.setVisibility(0);
            }
            if (MDialog.this.neutralButtonIsShow) {
                this.setNeutralButton(MDialog.this.mNeutralButtonTitle, MDialog.this.mNeutralButtonClick);
                MDialog.this.mNeutralButton.setVisibility(0);
                MDialog.this.mNeutralButton.setBackgroundResource(R.drawable.selector_dialog_btn);
            }
            if (MDialog.this.positiveButtonExit && !MDialog.this.negativeButtonExit) {
                MDialog.this.mPositiveButton.setBackgroundResource(R.drawable.bg_mdialog_one_btn);
            }
            if (MDialog.this.negativeButtonExit && !MDialog.this.positiveButtonExit) {
                MDialog.this.mNegativeButton.setBackgroundResource(R.drawable.bg_mdialog_one_btn);
            }
            if (MDialog.this.neutralButtonIsShow && !MDialog.this.positiveButtonExit && !MDialog.this.negativeButtonExit) {
                MDialog.this.mNeutralButton.setBackgroundResource(R.drawable.bg_mdialog_one_btn);
            }
            if (MDialog.this.negativeButtonExit && MDialog.this.positiveButtonExit) {
                MDialog.this.mBtnLine.setVisibility(0);
            }
            if (MDialog.this.negativeButtonExit && MDialog.this.positiveButtonExit && MDialog.this.neutralButtonIsShow) {
                MDialog.this.mBtnLine.setVisibility(0);
                MDialog.this.mBtnLine2.setVisibility(0);
            }
            if (MDialog.this.negativeButtonExit || MDialog.this.positiveButtonExit || MDialog.this.neutralButtonIsShow) {
                MDialog.this.buttonLayout.setVisibility(0);
            }
            if (MDialog.this.mDialogView != null) {
                this.setView(MDialog.this.mDialogView);
            }
            MDialog.this.mAlertDialog.setCanceledOnTouchOutside(MDialog.this.mCancel);
            if (MDialog.this.mOnDismissListener != null) {
                MDialog.this.mAlertDialog.setOnDismissListener(MDialog.this.mOnDismissListener);
            }
            if (MDialog.this.onKeyListener != null) {
                MDialog.this.mAlertDialog.setOnKeyListener(MDialog.this.onKeyListener);
            }
            if (MDialog.this.onShowListener != null) {
                MDialog.this.mAlertDialog.setOnShowListener(MDialog.this.onShowListener);
            }
            MDialog.this.mAlertDialog.setCancelable(MDialog.this.mCancelable);
            MDialog.this.mAlertDialog.getWindow().setType(2003);
            MDialog.this.mAlertDialog.show();
            Window window = MDialog.this.mAlertDialog.getWindow();
            WindowManager.LayoutParams attributes = window.getAttributes();
            attributes.width = v = MDialog.this.mContext.getApplicationContext().getResources().getDimensionPixelOffset(R.dimen.base_308);
            attributes.dimAmount = 0.65f;
            window.setAttributes(attributes);
        }

        public void setTitle(int resId) {
            this.mTitleView.setText(resId);
        }

        public void setTitle(CharSequence title) {
            this.mTitleView.setText(title);
        }

        public void setMessage(int resId) {
            this.mMessageView.setText(resId);
        }

        public void setMessage(CharSequence message) {
            this.mMessageView.setText(message);
        }

        public void setMessageGravity(int gravity) {
            this.mMessageView.setGravity(gravity);
        }

        public void setPositiveButton(String text, View.OnClickListener listener) {
            MDialog.this.mPositiveButton.setText((CharSequence)text);
            if (listener == null) {
                MDialog.this.mPositiveButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        MDialog.this.dismiss();
                    }
                });
            } else {
                MDialog.this.mPositiveButton.setOnClickListener(listener);
            }
        }

        public void setNegativeButton(String text, View.OnClickListener listener) {
            MDialog.this.mNegativeButton.setText((CharSequence)text);
            MDialog.this.mNegativeButton.setOnClickListener(listener);
        }

        public void setNeutralButton(String text, View.OnClickListener listener) {
            MDialog.this.mNeutralButton.setText((CharSequence)text);
            MDialog.this.mNeutralButton.setOnClickListener(listener);
        }

        public void setView(View view) {
            MDialog.this.mainView.removeAllViews();
            MDialog.this.mainView.addView(view);
        }

        public void setCanceledOnTouchOutside(boolean canceledOnTouchOutside) {
            MDialog.this.mAlertDialog.setCanceledOnTouchOutside(canceledOnTouchOutside);
        }

        public void setCancelable(boolean cancelable) {
            MDialog.this.mAlertDialog.setCancelable(cancelable);
        }
    }
}

