/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.autoupdate;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class SCUpdateSocket {
    private String ip = null;
    private int port = 0;
    private Socket conn = null;
    public InputStream sin = null;
    private OutputStream sou = null;
    private boolean connected = false;

    public SCUpdateSocket(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public int connect() {
        this.connected = false;
        Thread connThread = new Thread(new Connecter());
        connThread.start();
        long ctime = System.currentTimeMillis();
        while (!this.connected) {
            if (System.currentTimeMillis() - ctime > 5000L) {
                connThread = null;
                break;
            }
            if (connThread.isAlive()) continue;
        }
        if (this.connected) {
            return 0;
        }
        return -1;
    }

    public int sendData(String reqstr) {
        int dataLen = 0;
        byte[] data = null;
        try {
            dataLen = reqstr.getBytes().length;
            data = new byte[dataLen + 2];
            data[0] = (byte)(dataLen >> 8 & 0xFF);
            data[1] = (byte)(dataLen & 0xFF);
            System.arraycopy(reqstr.getBytes(), 0, data, 2, dataLen);
            this.sou.write(data);
            this.sou.flush();
            return 0;
        }
        catch (Exception e) {
            e.getStackTrace();
            return -1;
        }
    }

    public byte[] recvData() {
        try {
            byte[] data = null;
            int dataLen = 0;
            int currentLen = 0;
            int tempLen = 0;
            int headLen = 0;
            byte[] len = new byte[2];
            while (tempLen != -1 && (headLen += tempLen) < 2) {
                tempLen = this.sin.read(len, headLen, 2 - headLen);
            }
            if (tempLen == -1) {
                return null;
            }
            dataLen = SCUpdateSocket.Bytes2ToInt(len);
            data = new byte[dataLen];
            tempLen = 0;
            while (tempLen != -1 && (currentLen += tempLen) < dataLen) {
                tempLen = this.sin.read(data, currentLen, dataLen - currentLen);
            }
            if (tempLen == -1) {
                return null;
            }
            return data;
        }
        catch (IOException e) {
            e.getStackTrace();
            return null;
        }
    }

    public byte[] recvDataNolength(int dataLen) {
        try {
            byte[] data = new byte[dataLen];
            for (int currentLen = 0; currentLen < dataLen; currentLen += this.sin.read(data, currentLen, dataLen - currentLen)) {
            }
            return data;
        }
        catch (IOException e) {
            e.getStackTrace();
            return null;
        }
    }

    public static int Bytes2ToInt(byte[] b) {
        int mask = 255;
        int temp = 0;
        int res = 0;
        for (int i = 0; i < 2; ++i) {
            res <<= 8;
            temp = b[i] & mask;
            res |= temp;
        }
        return res;
    }

    public static byte[] IntToBytes2(int num) {
        byte[] b = new byte[2];
        for (int i = 0; i < 2; ++i) {
            b[i] = (byte)(num >> 8 - i * 8 & 0xFF);
        }
        return b;
    }

    public void close() {
        try {
            this.sin.close();
            this.sou.close();
            this.conn.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class Connecter
    implements Runnable {
        Connecter() {
        }

        @Override
        public void run() {
            this.connectNetwork();
        }

        private void connectNetwork() {
            try {
                SCUpdateSocket.this.conn = new Socket(SCUpdateSocket.this.ip, SCUpdateSocket.this.port);
                SCUpdateSocket.this.sin = SCUpdateSocket.this.conn.getInputStream();
                SCUpdateSocket.this.sou = SCUpdateSocket.this.conn.getOutputStream();
                SCUpdateSocket.this.connected = true;
                System.out.println("connect ok\uff1a");
            }
            catch (Exception e) {
                e.getMessage();
                SCUpdateSocket.this.connected = false;
                System.out.println("connect error\uff1a");
            }
        }
    }
}

