/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.key;

import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.xdja.SafeKey.XDJA_SM2_PARAM;
import com.xdja.key.KeyDevInfo;
import com.xdja.key.KeyModuleStateListener;
import com.xdja.key.KeySelector;
import com.xdja.key.covercard.CoverCardWrapper;
import com.xdja.key.koal.KoalCfg;
import com.xdja.key.longmai.LongmaiCfg;
import com.xdja.key.xdjakey.XdjaKeyCfg;
import com.xdja.key.zhongfu.ZhongfuCfg;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.event.EventManager;
import com.xdja.safeclient.event.SDCardStateChangeListener;
import com.xdja.safeclient.utils.Log;
import java.util.ArrayList;
import java.util.List;

public class KeyWrapper
implements SDCardStateChangeListener {
    public static final int XDJA_KEY = 1;
    public static final int ZHONGFU_KEY = 2;
    public static final int COVER_KEY = 4;
    public static final int CHIP_MANAGER_KEY = 8;
    public static final int CONTENT_PROVIDER_KEY = 16;
    public static final int LONGMAI_KEY = 32;
    public static final int SANWEI_KEY = 64;
    public static final int KOAL_KEY = 128;
    public static final int KEY_TYPE_CHIP = 0;
    public static final int KEY_TYPE_TF = 1;
    public static final int KEY_TYPE_USBKEY = 2;
    public static final int KEY_TYPE_SIM = 3;
    public static final int KEY_TYPE_SOFT = 4;
    public static final int KEY_TYPE_BLUETOOTH = 5;
    public static final String COVER_KEY_DRIVER_NAME = "cover_card";
    public static final String XDJA_KEY_DRIVER_NAME = "xdja_key";
    public static final String CHIP_MANAGER_DRIVER_NAME = "chip_manager";
    public static final String PROVIDER_DRIVER_NAME = "content_provider";
    public static final String LONGMAI_DRIVER_NAME = "longmai_key";
    public static final String SANWEI_DRIVER_NAME = "sanwei_key";
    public static final String KOAL_DRIVER_NAME = "koal_key";
    private static final String THIS_FILE = "KeyWrapper";
    public static int currentIndex = -1;
    public static String currentKeyTypeComment = null;
    public static long currentKey = 0L;
    private int currentKeyFlag = 0;
    private int state = 0;
    private boolean hasPendingReinit = false;
    private KeySelector keySelector = new KeySelector(){

        @Override
        public int select(ArrayList<KeyDevInfo> keyDevInfoArrayList) {
            if (keyDevInfoArrayList.size() > 0) {
                Log.d(KeyWrapper.THIS_FILE, "Default selector select first device.");
                return 0;
            }
            Log.e(KeyWrapper.THIS_FILE, "No key deivce in system.");
            return -1;
        }
    };
    private List<KeyModuleStateListener> listeners = new ArrayList<KeyModuleStateListener>();
    private static KeyWrapper instance;
    private Context context = null;
    private static final int INIT_DEVICE_AUTO = 1001;
    private static final int NOTIFY_NO_CARD = 1002;
    HandlerThread handlerThread = new HandlerThread("key_thread");
    MyHandler myHandler = null;

    public int getState() {
        return this.state;
    }

    public boolean isKeyError() {
        return this.state == 4 || this.state == 3;
    }

    public void setState(int state) {
        if (state != 1 && state != 2 && this.hasPendingReinit) {
            this.hasPendingReinit = false;
            return;
        }
        this.state = state;
        for (KeyModuleStateListener listener : this.listeners) {
            listener.onStateChanged(state);
        }
    }

    public String buildTypeComment(String driver, int type) {
        StringBuffer sb = new StringBuffer();
        switch (driver) {
            case "cover_card": {
                sb.append(this.context.getString(R.string.xdja_coverkey));
                break;
            }
            case "xdja_key": {
                if (type == 1) {
                    sb.append(this.context.getString(R.string.xdja_tf));
                    break;
                }
                if (type != 0) break;
                sb.append(this.context.getString(R.string.xdja_chip));
                break;
            }
            case "chip_manager": {
                if (type == 1) {
                    sb.append(this.context.getString(R.string.xdja_tf));
                    break;
                }
                if (type == 0) {
                    sb.append(this.context.getString(R.string.xdja_chip));
                    break;
                }
                if (type == 3) {
                    sb.append(this.context.getString(R.string.xdja_coverkey));
                    break;
                }
                sb.append(this.context.getString(R.string.chip_manager));
                break;
            }
            case "content_provider": {
                sb.append(this.context.getString(R.string.forward_client));
                break;
            }
            case "longmai_key": {
                sb.append(this.context.getString(R.string.longmai_card));
                break;
            }
            case "koal_key": {
                sb.append(this.context.getString(R.string.koal_card));
                break;
            }
            default: {
                sb.append(this.context.getString(R.string.unkown_device));
            }
        }
        return sb.toString();
    }

    @Override
    public void onSDCardStateChanged(int sdstate) {
        block9: {
            block8: {
                Log.e(THIS_FILE, "Detect sd card state changed, state = " + sdstate + " current key system state " + this.state);
                if (sdstate != 1001) break block8;
                switch (this.state) {
                    case 1: {
                        if ((this.currentKeyFlag & 1) == 1 && (!TextUtils.isEmpty((CharSequence)MyApplication.myApplication.getDevPath()) || Function.hasXdjaChip())) {
                            if ((this.currentKeyFlag & 4) == 4) {
                                CoverCardWrapper.getInstance().destroy();
                            }
                            this.hasPendingReinit = true;
                            Function.runOnMainThread(new Runnable(){

                                @Override
                                public void run() {
                                    KeyWrapper.this.sysDestroy();
                                    Function.initKeyModule(true);
                                }
                            });
                            break;
                        }
                        break block9;
                    }
                    default: {
                        Function.runOnMainThread(new Runnable(){

                            @Override
                            public void run() {
                                KeyWrapper.this.sysDestroy();
                                Function.initKeyModule(true);
                            }
                        });
                        break;
                    }
                }
                break block9;
            }
            if (currentIndex != -1) {
                KeyDevInfo keyDevInfo = new KeyDevInfo();
                int ret = KeyWrapper.getInstance().getDevInfo(currentIndex, keyDevInfo);
                if (ret != 0) {
                    Log.e(THIS_FILE, "Get key dev info failed. ret " + ret);
                    return;
                }
                if (keyDevInfo.getType() == 1 && keyDevInfo.getDriver().equals(XDJA_KEY_DRIVER_NAME) && sdstate == 1001) {
                    this.refreshDevice();
                }
            }
        }
    }

    private KeyWrapper() {
        this.handlerThread.start();
        this.myHandler = new MyHandler(this.handlerThread.getLooper());
    }

    public boolean addKeyModuleStateListener(KeyModuleStateListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeKeyModuleStateListener(KeyModuleStateListener listener) {
        return this.listeners.remove(listener);
    }

    private int initKeySystem() {
        KeyDevInfo keyDevInfo;
        this.setState(1);
        int ret = this.sysInit(this.currentKeyFlag);
        if (ret != 0) {
            Log.e(THIS_FILE, "Key sys init error. ret " + ret);
            this.setState(4);
            return ret;
        }
        ArrayList<KeyDevInfo> keyList = new ArrayList<KeyDevInfo>();
        int devCnt = KeyWrapper.getInstance().getDevCount();
        Log.d(THIS_FILE, "Total " + devCnt + " device in system.");
        if (devCnt > 0) {
            for (int i = 0; i < devCnt; ++i) {
                keyDevInfo = new KeyDevInfo();
                ret = KeyWrapper.getInstance().getDevInfo(i, keyDevInfo);
                if (ret != 0) {
                    Log.e(THIS_FILE, "Get device " + i + " info failed.");
                    break;
                }
                Log.d(THIS_FILE, "Device " + i + " : " + keyDevInfo);
                keyList.add(i, keyDevInfo);
            }
        }
        currentIndex = this.getKeySelector().select(keyList);
        keyDevInfo = new KeyDevInfo();
        ret = KeyWrapper.getInstance().getDevInfo(currentIndex, keyDevInfo);
        if (ret == 0) {
            currentKeyTypeComment = this.buildTypeComment(keyDevInfo.getDriver(), keyDevInfo.getType());
        }
        Log.d(THIS_FILE, "Selected key index = " + currentIndex);
        if (currentIndex == -1) {
            Log.e(THIS_FILE, "Select return -1 not valid.");
            this.setState(3);
            return -1;
        }
        this.setCurrentDevIndex(currentIndex);
        long[] handle = new long[1];
        ret = this.getKeyInstance(currentIndex, handle);
        if (ret != 0) {
            Log.e(THIS_FILE, "Get key instance " + currentIndex + " failed.");
            this.setState(4);
            return ret;
        }
        currentKey = handle[0];
        ret = this.keyOpen(currentKey);
        if (ret != 0) {
            Log.e(THIS_FILE, "Open key instance " + currentIndex + " failed.");
            this.setState(4);
        } else {
            Log.d(THIS_FILE, "Init key module success. State READY!");
            this.setState(2);
        }
        return ret;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public static KeyWrapper getInstance() {
        if (instance == null) {
            instance = new KeyWrapper();
            instance.setContext((Context)MyApplication.myApplication);
        }
        return instance;
    }

    public native int configXdjaKey(XdjaKeyCfg var1);

    public native int configZhongfuKey(ZhongfuCfg var1);

    public native int configLongmaiKey(LongmaiCfg var1);

    public native int configKoalKey(KoalCfg var1);

    public native int sysInit(int var1);

    public native int refreshDevice();

    public native int sysDestroy();

    public native int getDevCount();

    public native int getDevInfo(int var1, KeyDevInfo var2);

    public native int setCurrentDevIndex(int var1);

    private native int getCurrentDevIndex();

    public native int getKeyInstance(int var1, long[] var2);

    public native int keyOpen(long var1);

    public native int keyClose(long var1);

    private native int keyVerifyPin(long var1, String var3);

    private native int keyReadSignCert(long var1, byte[] var3, int[] var4);

    private native int keyGetSN(long var1, byte[] var3, int[] var4);

    private native int keyRSAPrikeyCalc(long var1, int var3, byte[] var4, int var5, byte[] var6, int[] var7);

    private native int keySM2Sign(long var1, int var3, byte[] var4, int var5, byte[] var6, int[] var7);

    private native int keyGetSM2Param(long var1, XDJA_SM2_PARAM var3);

    private native int keyGetSM2Id(long var1, byte[] var3, int[] var4);

    private native String keyGetError(int var1);

    private native int xdjaKeyReadCert(long var1, byte[] var3, byte[] var4, int[] var5);

    private native int xdjaKeyVerifyPin(long var1, String var3, int var4);

    private native int xdjaKeyRSAPrikeyCalc(long var1, byte[] var3, byte[] var4, int var5, byte[] var6, int[] var7);

    private native int xdjaKeySM2Sign(long var1, byte[] var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, int[] var9);

    private native int xdjaKeyReadFile(long var1, byte[] var3, int var4, int var5, byte[] var6);

    public int verifyPIN(String pin) {
        return new VerifyPINRunnable().run(pin);
    }

    public int xdjaKeyReadCert(byte[] fid, byte[] cert, int[] len) {
        return new XdjaReadCertRunnable().run(fid, cert, len);
    }

    public int xdjaKeyVerifyPIN(String pin, int role) {
        return new XdjaVerifyPINRunnable().run(pin, role);
    }

    public int getSN(byte[] sn, int[] length) {
        return new GetSNRunnable().run(sn, length);
    }

    public int readSignCert(byte[] certBuf, int[] certLen) {
        return new ReadSignCertRunnable().run(certBuf, certLen);
    }

    public int xdjaKeyReadFile(byte[] fid, int pos, int len, byte[] out) {
        return new XdjaReadFileRunnable().run(fid, pos, len, out);
    }

    public int RSAPrikeyCalc(int bits, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return new RSAPrikeyCalcRunnable().run(bits, dataIn, inLen, dataOut, outLen);
    }

    public int xdjaRSAPrikeyCalc(byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return new XdjaRSAPrikeyCalcRunnable().run(prifid, dataIn, inLen, dataOut, outLen);
    }

    public int SM2Sign(int isHashed, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return new SM2SignRunnable().run(isHashed, dataIn, inLen, dataOut, outLen);
    }

    public int xdjaSM2Sign(byte[] pubfid, byte[] prifid, int isHashed, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return new XdjaSM2SignRunnable().run(pubfid, prifid, isHashed, dataIn, inLen, dataOut, outLen);
    }

    public int getSM2Param(XDJA_SM2_PARAM sm2Param) {
        return new GetSM2ParamRunnable().run(sm2Param);
    }

    public int getSM2ID(byte[] id, int[] len) {
        return new GetSM2IDRunnable().run(id, len);
    }

    public KeySelector getKeySelector() {
        return this.keySelector;
    }

    public void setKeySelector(KeySelector keySelector) {
        this.keySelector = keySelector;
    }

    public void initDviceAuto(int keyFlag, KeySelector keySelector) {
        BluetoothAdapter bluetoothAdapter;
        this.currentKeyFlag = keyFlag;
        this.keySelector = keySelector;
        if ((keyFlag & 2) == 2 && !(bluetoothAdapter = BluetoothAdapter.getDefaultAdapter()).isEnabled()) {
            bluetoothAdapter.enable();
        }
        Message message = this.myHandler.obtainMessage();
        message.what = 1001;
        this.myHandler.sendEmptyMessage(1001);
    }

    static {
        System.loadLibrary("sm2");
        System.loadLibrary("key_mgr");
        System.loadLibrary("safekey");
        System.loadLibrary("key_xdja");
        System.loadLibrary("SM4");
        System.loadLibrary("SimKeyMCmdApi");
        System.loadLibrary("mSmart_SimKey");
        System.loadLibrary("mSmartAPI");
        System.loadLibrary("SymAlgSoftImp");
        System.loadLibrary("key_zhongfu");
        System.loadLibrary("key_covercard");
        System.loadLibrary("key_provider");
        System.loadLibrary("key_longmai");
        System.loadLibrary("swskf");
        System.loadLibrary("key_sanwei");
        System.loadLibrary("key_chipmanager");
        System.loadLibrary("key_koal");
        System.loadLibrary("key_wrapper");
        System.loadLibrary("key_jni");
        instance = null;
    }

    private class GetSM2IDRunnable
    extends KeyRunnable {
        private GetSM2IDRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return KeyWrapper.this.keyGetSM2Id(currentKey, (byte[])args[0], (int[])args[1]);
        }
    }

    private class GetSM2ParamRunnable
    extends KeyRunnable {
        private GetSM2ParamRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return KeyWrapper.this.keyGetSM2Param(currentKey, (XDJA_SM2_PARAM)args[0]);
        }
    }

    private class XdjaReadFileRunnable
    extends KeyRunnable {
        private XdjaReadFileRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return KeyWrapper.this.xdjaKeyReadFile(currentKey, (byte[])args[0], (Integer)args[1], (Integer)args[2], (byte[])args[3]);
        }
    }

    private class XdjaSM2SignRunnable
    extends KeyRunnable {
        private XdjaSM2SignRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return KeyWrapper.this.xdjaKeySM2Sign(currentKey, (byte[])args[0], (byte[])args[1], (Integer)args[2], (byte[])args[3], (Integer)args[4], (byte[])args[5], (int[])args[6]);
        }
    }

    private class SM2SignRunnable
    extends KeyRunnable {
        private SM2SignRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return KeyWrapper.this.keySM2Sign(currentKey, (Integer)args[0], (byte[])args[1], (Integer)args[2], (byte[])args[3], (int[])args[4]);
        }
    }

    private class XdjaRSAPrikeyCalcRunnable
    extends KeyRunnable {
        private XdjaRSAPrikeyCalcRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return KeyWrapper.this.xdjaKeyRSAPrikeyCalc(currentKey, (byte[])args[0], (byte[])args[1], (Integer)args[2], (byte[])args[3], (int[])args[4]);
        }
    }

    private class RSAPrikeyCalcRunnable
    extends KeyRunnable {
        private RSAPrikeyCalcRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return KeyWrapper.this.keyRSAPrikeyCalc(currentKey, (Integer)args[0], (byte[])args[1], (Integer)args[2], (byte[])args[3], (int[])args[4]);
        }
    }

    private class ReadSignCertRunnable
    extends KeyRunnable {
        private ReadSignCertRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return KeyWrapper.this.keyReadSignCert(currentKey, (byte[])args[0], (int[])args[1]);
        }
    }

    private class GetSNRunnable
    extends KeyRunnable {
        private GetSNRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return KeyWrapper.this.keyGetSN(currentKey, (byte[])args[0], (int[])args[1]);
        }
    }

    private class VerifyPINRunnable
    extends KeyRunnable {
        private VerifyPINRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return KeyWrapper.this.keyVerifyPin(currentKey, (String)args[0]);
        }
    }

    private class XdjaVerifyPINRunnable
    extends KeyRunnable {
        private XdjaVerifyPINRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return KeyWrapper.this.xdjaKeyVerifyPin(currentKey, (String)args[0], (Integer)args[1]);
        }
    }

    private class XdjaReadCertRunnable
    extends KeyRunnable {
        private XdjaReadCertRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return KeyWrapper.this.xdjaKeyReadCert(currentKey, (byte[])args[0], (byte[])args[1], (int[])args[2]);
        }
    }

    private abstract class KeyRunnable {
        private KeyRunnable() {
        }

        protected abstract int doRun(Object ... var1);

        public int run(Object ... args) {
            if (KeyWrapper.this.state == 0) {
                return 1001;
            }
            if (KeyWrapper.this.state == 4) {
                return 1002;
            }
            if (KeyWrapper.this.state == 2) {
                return this.doRun(args);
            }
            if (KeyWrapper.this.state == 1 && Function.isMainThread()) {
                return 1003;
            }
            while (KeyWrapper.this.state == 1) {
                Log.d(KeyWrapper.THIS_FILE, "Not main thread. Key module is not ready. Wait! Currnet state " + KeyWrapper.this.state);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (KeyWrapper.this.state == 2) {
                    Log.d(KeyWrapper.THIS_FILE, "Key module is ready. Call doRun!");
                    return this.doRun(args);
                }
                if (KeyWrapper.this.state != 3) continue;
                return 1000;
            }
            return 1000;
        }
    }

    class MyHandler
    extends Handler {
        public MyHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1001: {
                    if (MyApplication.myApplication.propertiesConfig.hasXdjaKey() == 1) {
                        EventManager.getInstance().removeSDCardStateChangedListener(instance);
                        EventManager.getInstance().addSDCardStateChangedListener(instance);
                    }
                    KeyWrapper.this.initKeySystem();
                }
            }
        }
    }

    public static class State {
        public static final int NULL = 0;
        public static final int INITIALIZING = 1;
        public static final int READY = 2;
        public static final int NO_KEY = 3;
        public static final int INIT_KEY_FAILED = 4;

        public static String getComment(int state) {
            switch (state) {
                case 0: {
                    return "NULL";
                }
                case 1: {
                    return "INITIALIZING";
                }
                case 2: {
                    return "READY";
                }
                case 3: {
                    return "NO KEY";
                }
                case 4: {
                    return "INIT_KEY_FAILED";
                }
            }
            return "UNKONW STATE";
        }
    }

    public static class StatusCode {
        public static final int SUCCESS = 0;
        public static final int NO_VALID_KEY = 1000;
        public static final int NOT_INITIALIZED = 1001;
        public static final int INIT_FAILED = 1002;
        public static final int INIT_IN_PROGRESS = 1003;

        public static String getComment(int code) {
            String comment = "";
            switch (code) {
                case 0: {
                    comment = "\u6210\u529f";
                    break;
                }
                case 1000: {
                    comment = "\u65e0\u53ef\u7528\u7684\u52a0\u5bc6\u5361";
                    break;
                }
                case 1001: {
                    comment = "\u5361\u6a21\u5757\u672a\u521d\u59cb\u5316";
                    break;
                }
                case 1002: {
                    comment = "\u521d\u59cb\u5316\u5361\u6a21\u5757\u5931\u8d25";
                    break;
                }
                case 1003: {
                    comment = "\u6b63\u5728\u68c0\u6d4b\u7cfb\u7edf\u4e2d\u7684\u52a0\u5bc6\u8bbe\u5907...";
                    break;
                }
                default: {
                    comment = KeyWrapper.getInstance().keyGetError(code);
                }
            }
            return comment;
        }
    }
}

