/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.key.covercard;

import android.content.Context;
import android.content.Intent;
import android.telephony.TelephonyManager;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.SafeKey.XDJA_FILE;
import com.xdja.SafeKey.XDJA_RSA_PUBKEY;
import com.xdja.SafeKey.XDJA_SM2_PARAM;
import com.xdja.SafeKey.XDJA_SM2_PUBKEY;
import com.xdja.key.KeyDevInfo;
import com.xdja.key.KeyWrapper;
import com.xdja.key.covercard.CoverCardStateChangedListener;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.event.EventManager;
import com.xdja.safeclient.event.SimStateChangedListener;
import com.xdja.safeclient.ui.AlertUtil;
import com.xdja.safeclient.utils.Log;
import com.xdja.tmc.TMCAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import opencard.core.util.HexString;

public class CoverCardWrapper
implements SimStateChangedListener,
TMCAPI.TMCAPICallBack {
    private static TMCAPI coverCard = null;
    private static final String THIS_FILE = "CoverCardWrapper";
    private int state = 0;
    private static CoverCardWrapper coverCardWrapper;
    private static int simState;
    private int connnectTimeout = 10;
    private int lastErrCode = 0;
    private boolean hasPendingInit = false;
    private List<CoverCardStateChangedListener> listenerList = new ArrayList<CoverCardStateChangedListener>();
    private static TelephonyManager telephonyManager;
    int rcvSimReadyEventCount = 0;
    private Timer noSimTimer = null;
    private Timer openServiceTimer = null;

    private CoverCardWrapper() {
    }

    public static CoverCardWrapper getInstance() {
        if (coverCardWrapper == null) {
            coverCardWrapper = new CoverCardWrapper();
            EventManager.getInstance().addSimStateChangedListener(coverCardWrapper);
            telephonyManager = (TelephonyManager)MyApplication.myApplication.getSystemService("phone");
            simState = telephonyManager.getSimState();
        }
        return coverCardWrapper;
    }

    private void setCardState(int curState) {
        int prevState = this.state;
        if (curState == -1 && (prevState == 1 || prevState == 2)) {
            this.destroy();
        }
        if (prevState != curState) {
            this.state = curState;
            this.notifyListeners(curState);
        }
    }

    private void notifyListeners(int state) {
        for (CoverCardStateChangedListener listener : this.listenerList) {
            listener.onCoverCardStateChanged(state);
        }
    }

    public boolean addStateListener(CoverCardStateChangedListener listener) {
        return this.listenerList.add(listener);
    }

    public boolean removeStateListener(CoverCardStateChangedListener listener) {
        return this.listenerList.remove(listener);
    }

    public void isSupported(boolean b) {
        if (this.openServiceTimer != null) {
            this.openServiceTimer.purge();
            this.openServiceTimer.cancel();
            this.openServiceTimer = null;
        }
        if (coverCard == null) {
            Log.d(THIS_FILE, "Covercard is destroyed already");
            return;
        }
        Log.d(THIS_FILE, "Is supported ? " + b);
        String strOtiType = coverCard.GetOtiType();
        if (strOtiType.equals("Not Support")) {
            Log.e(THIS_FILE, "Cover card init failed.");
            this.lastErrCode = -201;
            this.setCardState(-1);
        } else {
            Log.e(THIS_FILE, "Cover card init success. Ready to use");
            this.lastErrCode = 0;
            this.setCardState(2);
            Log.d(THIS_FILE, "Covercard open success, OTI type:" + strOtiType);
        }
    }

    public int getDevInfo(XDJA_DEVINFO devinfo) {
        return new GetDevInfoRunnable().run(devinfo);
    }

    public int genRandom(int len, byte[] random) {
        return new GenerateRandomRunnable().run(len, random);
    }

    public int changePIN(int role, byte[] oldpin, int oldlen, byte[] newpin, int newlen) {
        return new ChangePINRunnable().run(role, oldpin, oldlen, newpin, newlen);
    }

    public int createFile(XDJA_FILE file) {
        return new CreateFileRunnable().run(file);
    }

    public int writeFile(byte[] fid, int pos, int len, byte[] data) {
        return new WriteFileRunnable().run(fid, pos, len, data);
    }

    public int readRsaPubkey(byte[] fid, XDJA_RSA_PUBKEY pubkey) {
        return new ReadRSAPubkeyRunnable().run(fid, pubkey);
    }

    public int writeRsaPubkey(byte[] fid, XDJA_RSA_PUBKEY pubkey) {
        return new WriteRSAPubkeyRunnable().run(fid, pubkey);
    }

    public int writeCert(byte[] fid, byte[] cert, int len) {
        return new WriteCertRunnable().run(fid, cert, len);
    }

    public int genRsaKeyPair(int bits, byte[] pubfid, byte[] prifid) {
        return new GenerateRSAPairRunnable().run(bits, pubfid, prifid);
    }

    public int rsaPubkeyCalc(byte[] fid, int bits, byte[] datain, int inlen, byte[] out, int[] outlen) {
        return new RsaPubkeyCalcRunnable().run(fid, bits, datain, inlen, out, outlen);
    }

    public int rsaSign(byte[] fid, int bits, int datatype, byte[] datain, int inlen, byte[] sign, int[] signlen) {
        return new RsaSignRunnable().run(fid, bits, datatype, datain, inlen, sign, signlen);
    }

    public int rsaSignVerify(byte[] id, int bits, int datatype, byte[] datain, int inlen, byte[] sign, int signlen) {
        return new RsaSignVerifyRunnable().run(id, bits, datatype, datain, inlen, sign, signlen);
    }

    public int setSM2Param(XDJA_SM2_PARAM sm2_param) {
        return new SetSM2ParamRunnable().run(sm2_param);
    }

    public int setSM2Id(byte[] id, int len) {
        return new SetSM2ParamRunnable().run(id, len);
    }

    public int genSM2Keypair(byte[] pubfid, byte[] prifid) {
        return new GenSM2KeypairRunnable().run(pubfid, prifid);
    }

    public int readSM2Pubkey(byte[] fid, XDJA_SM2_PUBKEY pubkey) {
        return new ReadSM2PubkeyRunnable().run(fid, pubkey);
    }

    public int sm2Encrypt(byte[] id, byte[] data, int len, byte[] out, int[] outlen) {
        return new SM2EncryptRunnable().run(id, data, len, out, outlen);
    }

    public int sm2Decrypt(byte[] id, byte[] datain, int inlen, byte[] dataout, int[] outlen) {
        return new SM2DecryptRunnable().run(id, datain, inlen, dataout, outlen);
    }

    public int unlockPIN(int pukid, byte[] puk, int puklen, byte[] pin, int pinlen) {
        return new UnlockPinRunnable().run(pukid, puk, puklen, pin, pinlen);
    }

    public int writeSM2Pubkey(byte[] fid, XDJA_SM2_PUBKEY pubkey) {
        return new WriteSM2PubkeyRunnable().run(fid, pubkey);
    }

    public int sm2SignVerify(byte[] pubfid, int datatype, byte[] datain, int inlen, byte[] sign, int signlen) {
        return new SM2SignVerifyRunnable().run(pubfid, datatype, datain, inlen, sign, signlen);
    }

    @Override
    public void onSimStateChanged(int preState, int curState) {
        Log.e(THIS_FILE, "Current sim state " + curState);
        switch (curState) {
            case 0: 
            case 1: 
            case 6: {
                simState = curState;
                if (this.state != 2) {
                    return;
                }
                KeyDevInfo keyDevInfo = new KeyDevInfo();
                int ret = KeyWrapper.getInstance().getDevInfo(KeyWrapper.currentIndex, keyDevInfo);
                if (ret != 0 || !keyDevInfo.getDriver().equals("cover_card") || this.state != 2) break;
                this.destroy();
                if (Function.isPackageExist_v2((Context)MyApplication.myApplication, "com.xdja.safeclient.tun")) {
                    Intent intent = new Intent();
                    intent.setAction("com.xdja.safeclient.EXIT_TUN_CLIENT");
                    intent.putExtra("reason", "sim out");
                    MyApplication.myApplication.sendBroadcast(intent);
                }
                MyApplication.myApplication.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        AlertUtil.popSystemAlert((Context)MyApplication.myApplication, MyApplication.myApplication.getString(R.string.safe_client), MyApplication.myApplication.getString(R.string.detect_sim_change), null, false);
                        Function.stopVPN((Context)MyApplication.myApplication);
                        new Timer().schedule(new TimerTask(){

                            @Override
                            public void run() {
                                Function.exitApp((Context)MyApplication.myApplication);
                            }
                        }, 2000L);
                    }
                });
                break;
            }
            case 5: {
                Log.d(THIS_FILE, "Current sim state " + curState);
                simState = curState;
                if (this.noSimTimer != null) {
                    this.noSimTimer.purge();
                    this.noSimTimer.cancel();
                    this.noSimTimer = null;
                }
                if (this.hasPendingInit) {
                    this.hasPendingInit = false;
                    MyApplication.myApplication.getHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            if (CoverCardWrapper.this.state == 1) {
                                Log.e(CoverCardWrapper.THIS_FILE, "Sim ready now. Start to call cover card init");
                                coverCard = new TMCAPI();
                                coverCard.OpenSEService((Context)MyApplication.myApplication, (TMCAPI.TMCAPICallBack)CoverCardWrapper.getInstance());
                            }
                        }
                    });
                    return;
                }
                if (!KeyWrapper.getInstance().isKeyError()) break;
                Function.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        KeyWrapper.getInstance().sysDestroy();
                        Function.initKeyModule(true);
                    }
                });
            }
        }
    }

    public int getState() {
        return this.state;
    }

    private void openService() {
        Log.e(THIS_FILE, "Start to call cover card init");
        coverCard = new TMCAPI();
        coverCard.SetLogFlag(false);
        coverCard.OpenSEService((Context)MyApplication.myApplication, (TMCAPI.TMCAPICallBack)CoverCardWrapper.getInstance());
    }

    public int init() {
        MyApplication application = MyApplication.myApplication;
        boolean simReady = true;
        Log.e(THIS_FILE, "Get into cover card init");
        if (application == null) {
            Log.e(THIS_FILE, "Application NOT initialized!");
            return -200;
        }
        if (this.state == 1 || this.state == 2) {
            Log.d(THIS_FILE, "Cover card is init in porgess.");
            return 0;
        }
        TelephonyManager tm = (TelephonyManager)application.getSystemService("phone");
        int simState = tm.getSimState();
        if (simState != 5) {
            Log.d(THIS_FILE, "SIM init state = " + simState);
            simReady = false;
        }
        if (simReady) {
            application.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    CoverCardWrapper.this.openService();
                }
            });
            if (this.openServiceTimer != null) {
                this.openServiceTimer.purge();
                this.openServiceTimer.cancel();
            }
            this.openServiceTimer = new Timer();
            this.openServiceTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    CoverCardWrapper.this.lastErrCode = -201;
                    CoverCardWrapper.this.setCardState(-1);
                }
            }, 20000L);
        } else {
            this.hasPendingInit = true;
            if (this.noSimTimer != null) {
                this.noSimTimer.purge();
                this.noSimTimer.cancel();
            }
            this.noSimTimer = new Timer();
            this.noSimTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    CoverCardWrapper.this.hasPendingInit = false;
                    CoverCardWrapper.this.lastErrCode = -202;
                    CoverCardWrapper.this.setCardState(-1);
                }
            }, 10000L);
        }
        this.lastErrCode = -204;
        this.setCardState(1);
        return 0;
    }

    public void destroy() {
        Log.d(THIS_FILE, "Destroy cover card factory");
        if (this.state == 2 && coverCard != null) {
            coverCard.CloseSEService();
        }
        this.hasPendingInit = false;
        this.setCardState(0);
        coverCard = null;
    }

    public int getCardID(byte[] cardId, int[] len) {
        return new GetCardIDRunnable().run(cardId, len);
    }

    public int readCert(byte[] fid, byte[] cert, int[] len) {
        Log.d(THIS_FILE, "Read cert fid = " + fid[0] + "," + fid[1]);
        int ret = new ReadCertRunnable().run(fid, cert, len);
        Log.e(THIS_FILE, "Cover card read cert return " + ret + "cert len " + len[0]);
        if (len[0] < 0) {
            len[0] = 0;
            ret = -20;
        }
        return ret;
    }

    public int verifyPIN(int role, byte[] pin, int len) {
        return new VerifyPINRunnable().run(1, pin, len);
    }

    public int RSAPrikeyCalc(byte[] fid, int bits, byte[] data, int size, byte[] out, int[] outSize) {
        return new RSAPrikeyCalcRunnable().run(fid, bits, data, size, out, outSize);
    }

    public int SM2Sign(byte[] pubFid, byte[] priFid, int isHashed, byte[] dataIn, int inLen, byte[] signData, int[] signLen) {
        return new SM2SignRunnable().run(pubFid, priFid, isHashed, dataIn, inLen, signData, signLen);
    }

    public int readFile(byte[] fid, int pos, int len, byte[] dataout) {
        return new ReadFileRunnable().run(fid, pos, len, dataout);
    }

    public int getSM2Param(XDJA_SM2_PARAM sm2Param) {
        int ret = new GetSM2ParamRunnable().run(sm2Param);
        Log.d(THIS_FILE, "SM2 Parma p " + HexString.dump((byte[])sm2Param.p));
        Log.d(THIS_FILE, "SM2 Parma a " + HexString.dump((byte[])sm2Param.a));
        Log.d(THIS_FILE, "SM2 Parma b " + HexString.dump((byte[])sm2Param.b));
        Log.d(THIS_FILE, "SM2 Parma n " + HexString.dump((byte[])sm2Param.n));
        Log.d(THIS_FILE, "SM2 Parma x " + HexString.dump((byte[])sm2Param.x));
        Log.d(THIS_FILE, "SM2 Parma y " + HexString.dump((byte[])sm2Param.y));
        return ret;
    }

    public int getSM2ID(byte[] id, int[] len) {
        return new GetSM2IDRunnable().run(id, len);
    }

    public boolean checkDevice() {
        XDJA_DEVINFO xdja_devinfo = new XDJA_DEVINFO();
        int ret = new GetDevInfoRunnable().run(xdja_devinfo);
        return ret == 0;
    }

    static {
        simState = -1;
    }

    public static class CardState {
        public static final int INVALID = -1;
        public static final int NULL = 0;
        public static final int INITIALIZING = 1;
        public static final int READY = 2;

        public static String getComment(int state) {
            switch (state) {
                case -1: {
                    return "INVALID";
                }
                case 0: {
                    return "NULL";
                }
                case 1: {
                    return "INITIALIZING";
                }
                case 2: {
                    return "READY";
                }
            }
            return "UNKONW STATE";
        }
    }

    public static class StatusCode {
        public static final int SUCCESS = 0;
        public static final int APP_NOT_INITIALIZED = -200;
        public static final int INIT_FAILED = -201;
        public static final int SIM_NOT_VALID = -202;
        public static final int NOT_STARTED = -203;
        public static final int INIT_IN_PROGRESS = -204;
    }

    private class GetSM2IDRunnable
    extends CoverCardRunnable {
        private GetSM2IDRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            byte[] sm2id = (byte[])args[0];
            int[] len = (int[])args[1];
            return coverCard.GetSM2Id(sm2id, len);
        }
    }

    private class GetSM2ParamRunnable
    extends CoverCardRunnable {
        private GetSM2ParamRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            XDJA_SM2_PARAM sm2Param = (XDJA_SM2_PARAM)args[0];
            return coverCard.GetSM2Param(sm2Param);
        }
    }

    private class ReadFileRunnable
    extends CoverCardRunnable {
        private ReadFileRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            byte[] fid = (byte[])args[0];
            int pos = (Integer)args[1];
            int len = (Integer)args[2];
            byte[] outData = (byte[])args[3];
            return coverCard.ReadFile(fid, pos, len, outData);
        }
    }

    private class SM2SignRunnable
    extends CoverCardRunnable {
        private SM2SignRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            byte[] pubFid = (byte[])args[0];
            byte[] priFid = (byte[])args[1];
            int isHashed = (Integer)args[2];
            byte[] dataIn = (byte[])args[3];
            int inLen = (Integer)args[4];
            byte[] signData = (byte[])args[5];
            int[] signDataLen = (int[])args[6];
            return coverCard.SM2Sign(pubFid, priFid, isHashed == 0 ? 1 : 0, dataIn, inLen, signData, signDataLen);
        }
    }

    private class RSAPrikeyCalcRunnable
    extends CoverCardRunnable {
        private RSAPrikeyCalcRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            byte[] fid = (byte[])args[0];
            int bits = (Integer)args[1];
            byte[] inputData = (byte[])args[2];
            int inputDataSize = (Integer)args[3];
            byte[] outputData = (byte[])args[4];
            int[] outputDataSize = (int[])args[5];
            return coverCard.RSAPriKeyCalc(fid, bits, inputData, inputDataSize, outputData, outputDataSize);
        }
    }

    private class VerifyPINRunnable
    extends CoverCardRunnable {
        private VerifyPINRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            int role = (Integer)args[0];
            byte[] pin = (byte[])args[1];
            int len = (Integer)args[2];
            int ret = coverCard.VerifyPIN(role, pin, len);
            return ret;
        }
    }

    private class ReadCertRunnable
    extends CoverCardRunnable {
        private ReadCertRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            byte[] fid = (byte[])args[0];
            byte[] cert = (byte[])args[1];
            int[] len = (int[])args[2];
            return coverCard.ReadCert(fid, cert, len);
        }
    }

    private class SM2SignVerifyRunnable
    extends CoverCardRunnable {
        private SM2SignVerifyRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return coverCard.SM2SignVerify((byte[])args[0], ((Integer)args[1]).intValue(), (byte[])args[2], ((Integer)args[3]).intValue(), (byte[])args[4], ((Integer)args[5]).intValue());
        }
    }

    private class WriteSM2PubkeyRunnable
    extends CoverCardRunnable {
        private WriteSM2PubkeyRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return coverCard.WriteSm2PubKey((byte[])args[0], (XDJA_SM2_PUBKEY)args[1]);
        }
    }

    private class UnlockPinRunnable
    extends CoverCardRunnable {
        private UnlockPinRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return 0;
        }
    }

    private class SM2DecryptRunnable
    extends CoverCardRunnable {
        private SM2DecryptRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return coverCard.SM2Decrypt((byte[])args[0], (byte[])args[1], ((Integer)args[2]).intValue(), (byte[])args[3], (int[])args[4]);
        }
    }

    private class SM2EncryptRunnable
    extends CoverCardRunnable {
        private SM2EncryptRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return coverCard.SM2Encrypt((byte[])args[0], (byte[])args[1], ((Integer)args[2]).intValue(), (byte[])args[3], (int[])args[4]);
        }
    }

    private class ReadSM2PubkeyRunnable
    extends CoverCardRunnable {
        private ReadSM2PubkeyRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return coverCard.ReadSm2PubKey((byte[])args[0], (XDJA_SM2_PUBKEY)args[1]);
        }
    }

    private class GenSM2KeypairRunnable
    extends CoverCardRunnable {
        private GenSM2KeypairRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return coverCard.GenSM2KeyPair((byte[])args[0], (byte[])args[1]);
        }
    }

    private class SetSM2IdRunnable
    extends CoverCardRunnable {
        private SetSM2IdRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return coverCard.SetSM2Id((byte[])args[0], ((Integer)args[1]).intValue());
        }
    }

    private class SetSM2ParamRunnable
    extends CoverCardRunnable {
        private SetSM2ParamRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return coverCard.SetSM2Param((XDJA_SM2_PARAM)args[0]);
        }
    }

    private class RsaSignVerifyRunnable
    extends CoverCardRunnable {
        private RsaSignVerifyRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return coverCard.RSASignVerify((byte[])args[0], ((Integer)args[1]).intValue(), ((Integer)args[2]).intValue(), (byte[])args[3], ((Integer)args[4]).intValue(), (byte[])args[5], ((Integer)args[6]).intValue());
        }
    }

    private class RsaSignRunnable
    extends CoverCardRunnable {
        private RsaSignRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return coverCard.RSASign((byte[])args[0], ((Integer)args[1]).intValue(), ((Integer)args[2]).intValue(), (byte[])args[3], ((Integer)args[4]).intValue(), (byte[])args[5], (int[])args[6]);
        }
    }

    private class RsaPubkeyCalcRunnable
    extends CoverCardRunnable {
        private RsaPubkeyCalcRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return coverCard.RSAPubKeyCalc((byte[])args[0], ((Integer)args[1]).intValue(), (byte[])args[2], ((Integer)args[3]).intValue(), (byte[])args[4], (int[])args[5]);
        }
    }

    private class GenerateRSAPairRunnable
    extends CoverCardRunnable {
        private GenerateRSAPairRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return coverCard.GenRSAKeyPair(((Integer)args[0]).intValue(), (byte[])args[1], (byte[])args[2]);
        }
    }

    private class WriteCertRunnable
    extends CoverCardRunnable {
        private WriteCertRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return coverCard.WriteCert((byte[])args[0], (byte[])args[1], ((Integer)args[2]).intValue());
        }
    }

    private class WriteRSAPubkeyRunnable
    extends CoverCardRunnable {
        private WriteRSAPubkeyRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return coverCard.WriteRsaPubKey((byte[])args[0], (XDJA_RSA_PUBKEY)args[1]);
        }
    }

    private class ReadRSAPubkeyRunnable
    extends CoverCardRunnable {
        private ReadRSAPubkeyRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return coverCard.ReadRsaPubKey((byte[])args[0], (XDJA_RSA_PUBKEY)args[1]);
        }
    }

    private class WriteFileRunnable
    extends CoverCardRunnable {
        private WriteFileRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return coverCard.WriteFile((byte[])args[0], ((Integer)args[1]).intValue(), ((Integer)args[2]).intValue(), (byte[])args[3]);
        }
    }

    private class CreateFileRunnable
    extends CoverCardRunnable {
        private CreateFileRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return coverCard.CreateFile((XDJA_FILE)args[0]);
        }
    }

    private class ChangePINRunnable
    extends CoverCardRunnable {
        private ChangePINRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return coverCard.ChangePIN(((Integer)args[0]).intValue(), (byte[])args[1], ((Integer)args[2]).intValue(), (byte[])args[3], ((Integer)args[4]).intValue());
        }
    }

    private class GenerateRandomRunnable
    extends CoverCardRunnable {
        private GenerateRandomRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            return coverCard.GenRandom(((Integer)args[0]).intValue(), (byte[])args[1]);
        }
    }

    private class GetDevInfoRunnable
    extends CoverCardRunnable {
        private GetDevInfoRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            XDJA_DEVINFO xdja_devinfo = (XDJA_DEVINFO)args[0];
            return coverCard.GetDevInfo(xdja_devinfo);
        }
    }

    private class GetCardIDRunnable
    extends CoverCardRunnable {
        private GetCardIDRunnable() {
        }

        @Override
        protected int doRun(Object ... args) {
            byte[] cardId = (byte[])args[0];
            int[] cardIdLen = (int[])args[1];
            XDJA_DEVINFO deviceInfo = new XDJA_DEVINFO();
            int ret = coverCard.GetDevInfo(deviceInfo);
            if (ret == 0) {
                cardIdLen[0] = 32;
                Log.d(CoverCardWrapper.THIS_FILE, "Get dev info success.");
                System.arraycopy(deviceInfo.cardid, 0, cardId, 0, 32);
                return ret;
            }
            Log.e(CoverCardWrapper.THIS_FILE, "Get dev info failed. ret = " + ret);
            return ret;
        }
    }

    private abstract class CoverCardRunnable {
        private CoverCardRunnable() {
        }

        protected abstract int doRun(Object ... var1);

        public int run(Object ... args) {
            int retryCnt = 4;
            if (CoverCardWrapper.this.state == 0) {
                CoverCardWrapper.this.lastErrCode = -203;
                return CoverCardWrapper.this.lastErrCode;
            }
            if (CoverCardWrapper.this.state == -1) {
                return CoverCardWrapper.this.lastErrCode;
            }
            if (CoverCardWrapper.this.state == 2) {
                int ret = this.doRun(args);
                if (ret == 0) {
                    return ret;
                }
                if (ret == -100 || ret == -2 || ret == -18) {
                    coverCard.SetLogFlag(true);
                    do {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        ret = this.doRun(args);
                        if (ret != 0) continue;
                        return ret;
                    } while ((ret == -100 || ret == -2 || ret == -18) && --retryCnt > 0);
                    coverCard.SetLogFlag(false);
                    if (retryCnt == 0) {
                        CoverCardWrapper.this.destroy();
                        CoverCardWrapper.this.init();
                    }
                }
                return ret;
            }
            if (Function.isMainThread() && CoverCardWrapper.this.state == 1) {
                Log.d(CoverCardWrapper.THIS_FILE, "Main thread can't sleep here.");
                return CoverCardWrapper.this.lastErrCode;
            }
            long startTime = System.currentTimeMillis();
            while (CoverCardWrapper.this.state == 1) {
                Log.d(CoverCardWrapper.THIS_FILE, "Cover card is not ready. Wait!");
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (CoverCardWrapper.this.state == 2) {
                    int ret = this.doRun(args);
                    if (ret == 0) {
                        return ret;
                    }
                    if (ret == -100 || ret == -2 || ret == -18) {
                        coverCard.SetLogFlag(true);
                        do {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            ret = this.doRun(args);
                            if (ret != 0) continue;
                            return ret;
                        } while ((ret == -100 || ret == -2 || ret == -18) && --retryCnt > 0);
                        coverCard.SetLogFlag(false);
                        if (retryCnt == 0) {
                            CoverCardWrapper.this.destroy();
                            CoverCardWrapper.this.init();
                        }
                    }
                    return ret;
                }
                if (CoverCardWrapper.this.state == 0) {
                    return CoverCardWrapper.this.lastErrCode;
                }
                if (CoverCardWrapper.this.state != -1) continue;
                return CoverCardWrapper.this.lastErrCode;
            }
            return CoverCardWrapper.this.lastErrCode;
        }
    }
}

