/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.activity;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.safetf.SafeTF;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.activity.CertSetActivity;
import com.xdja.safeclient.activity.LogDebugActivity;
import com.xdja.safeclient.architecture.BaseActivity;
import com.xdja.safeclient.utils.Compatibility;
import com.xdja.safeclient.utils.Log;

public class AboutActivity
extends BaseActivity {
    private TextView mVersionName = null;
    private TextView mAPPABI = null;
    private TextView mDriverVersion = null;
    private TextView viewCert;
    private TextView declText = null;
    private ImageView aboutImage;
    int clickCount = 0;
    private Button exitDebug;
    MyApplication myApplication = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_about);
        this.myApplication = (MyApplication)this.getApplication();
        this.mVersionName = (TextView)this.findViewById(R.id.version_name_text);
        this.mAPPABI = (TextView)this.findViewById(R.id.APP_ABI);
        this.viewCert = (TextView)this.findViewById(R.id.view_cert);
        this.viewCert.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent((Context)AboutActivity.this, CertSetActivity.class);
                intent.putExtra("just_show", true);
                AboutActivity.this.startActivity(intent);
            }
        });
        this.mLeftBtn = (ImageView)this.findViewById(R.id.titlebar_leftbtn);
        this.mRightBtn = (ImageView)this.findViewById(R.id.titlebar_rightbtn);
        this.mTitleText = (TextView)this.findViewById(R.id.titlebar_text);
        this.declText = (TextView)this.findViewById(R.id.declaration_text);
        this.declText.setText((CharSequence)Compatibility.getDeclaration());
        String strVerName = this.getVersionName();
        if (strVerName != null) {
            this.mVersionName.setText((CharSequence)(this.getString(R.string.about_version_name) + strVerName));
        }
        if (this.myApplication.propertiesConfig.getmArmOrX86() == 1) {
            this.mAPPABI.setText(R.string.app_abi_x86);
        } else {
            this.mAPPABI.setText(R.string.app_abi_arm);
        }
        Log.d("AboutActivity", "driver version : " + this.getDriverVersion());
        this.mDriverVersion = (TextView)this.findViewById(R.id.driver_version);
        this.mDriverVersion.setText((CharSequence)(this.getString(R.string.driver_version) + this.getDriverVersion()));
        this.aboutImage = (ImageView)this.findViewById(R.id.about_image);
        this.exitDebug = (Button)this.findViewById(R.id.exit_debug);
        this.exitDebug.setVisibility(8);
        this.exitDebug.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AboutActivity.this.exitDebug.setVisibility(8);
            }
        });
        this.initLeftBtn();
        this.initTitleText();
        this.myApplication.activityList.add(this);
        this.myApplication.topActivity = this;
    }

    private void openLynxActivity() {
        Intent intent = new Intent((Context)this, LogDebugActivity.class);
        this.startActivity(intent);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.myApplication.activityList != null) {
            this.myApplication.activityList.remove((Object)this);
        }
    }

    private String getDriverVersion() {
        String version = "";
        SafeTF tf = new SafeTF();
        version = tf.GetVersion();
        return version;
    }

    private String getVersionName() {
        PackageManager packManager = null;
        PackageInfo packInfo = null;
        packManager = this.getPackageManager();
        try {
            packInfo = packManager.getPackageInfo(this.getPackageName(), 0);
            return packInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected void initTitleText() {
        super.initTitleText();
        this.mTitleText.setText(R.string.about);
    }

    private NotificationManager getNM() {
        NotificationManager nm = (NotificationManager)this.getSystemService("notification");
        return nm;
    }

    private void showNotification() {
        Notification.Builder builder = new Notification.Builder((Context)this);
        builder.setContentIntent(PendingIntent.getActivity((Context)this, (int)0, (Intent)new Intent((Context)this, LogDebugActivity.class), (int)0x10000000));
        builder.setSmallIcon(R.drawable.ic_launcher1);
        builder.setAutoCancel(false);
        builder.setOngoing(true);
        builder.setWhen(System.currentTimeMillis());
        builder.setContentTitle((CharSequence)"\u70b9\u51fb");
        builder.setContentText((CharSequence)"\u67e5\u770b\u65e5\u5fd7");
        Notification notification = builder.build();
        this.getNM().notify(888, notification);
    }

    private void cancelNotification() {
        this.getNM().cancel(888);
    }
}

