/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import com.xdja.safeclient.utils.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;

public class FileUtil {
    public static final String DATE_FORMATE = "YYYY.MM.DD";

    public static String getSDPath() {
        String sdDir = null;
        boolean sdCardExist = Environment.getExternalStorageState().equals("mounted");
        if (sdCardExist) {
            sdDir = Environment.getExternalStorageDirectory().getAbsolutePath();
            return sdDir;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copeFile(File sourceFile, File targetFile) {
        boolean result = false;
        BufferedInputStream inBuff = null;
        FilterOutputStream outBuff = null;
        try {
            int len;
            inBuff = new BufferedInputStream(new FileInputStream(sourceFile));
            outBuff = new BufferedOutputStream(new FileOutputStream(targetFile));
            byte[] buf = new byte[4096];
            while ((len = inBuff.read(buf)) != -1) {
                ((BufferedOutputStream)outBuff).write(buf, 0, len);
            }
            ((BufferedOutputStream)outBuff).flush();
            result = true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            result = false;
        }
        catch (IOException e) {
            e.printStackTrace();
            result = false;
        }
        finally {
            if (inBuff != null) {
                try {
                    inBuff.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outBuff != null) {
                try {
                    outBuff.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileEncoding(String strFilePath) {
        File file = null;
        FileInputStream fis = null;
        BufferedInputStream in = null;
        try {
            file = new File(strFilePath);
            fis = new FileInputStream(file);
            in = new BufferedInputStream(fis);
            in.mark(4);
            byte[] first3bytes = new byte[3];
            in.read(first3bytes);
            in.reset();
            in.close();
            if (first3bytes[0] == -17 && first3bytes[1] == -69 && first3bytes[2] == -65) {
                Log.d("getFileEncoding", "utf-8");
                String string2 = "utf-8";
                return string2;
            }
            if (first3bytes[0] == -1 && first3bytes[1] == -2) {
                Log.d("getFileEncoding", "unicode");
                String string3 = "unicode";
                return string3;
            }
            if (first3bytes[0] == -2 && first3bytes[1] == -1) {
                Log.d("getFileEncoding", "utf-16be");
                String string4 = "utf-16be";
                return string4;
            }
            if (first3bytes[0] == -1 && first3bytes[1] == -1) {
                Log.d("getFileEncoding", "utf-16le");
                String string5 = "utf-16le";
                return string5;
            }
            Log.d("getFileEncoding", "GBK");
            String string6 = "GBK";
            return string6;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static void readFileByLines(final String fileName, final ArrayList<String> strArray, final Handler handler) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Message msg = new Message();
                File file = null;
                FileInputStream fis = null;
                BufferedInputStream in = null;
                InputStreamReader isr = null;
                BufferedReader reader = null;
                String encoding = null;
                try {
                    file = new File(fileName);
                    fis = new FileInputStream(file);
                    in = new BufferedInputStream(fis);
                    encoding = FileUtil.getFileEncoding(fileName);
                    isr = new InputStreamReader((InputStream)in, encoding);
                    reader = new BufferedReader(isr);
                    String tempString = null;
                    while ((tempString = reader.readLine()) != null) {
                        if (tempString.equals("\n") || tempString.equals("")) continue;
                        strArray.add(tempString);
                    }
                    tempString = null;
                    msg.what = 0;
                    handler.sendMessage(msg);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {}
                    }
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }.start();
    }

    public static boolean isLogOfCurDay(String strLog, String strCurDate) {
        if (strLog == null || strLog.equals("")) {
            return false;
        }
        if (strLog.length() < DATE_FORMATE.length()) {
            return false;
        }
        return strLog.contains(strCurDate);
    }

    public static void readLogOfCurDay(final String fileName, final ArrayList<String> strArray, final Handler handler) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Message msg = new Message();
                File file = null;
                FileInputStream fis = null;
                BufferedInputStream in = null;
                InputStreamReader isr = null;
                BufferedReader reader = null;
                SimpleDateFormat sDateFormat = null;
                String strCurDate = null;
                sDateFormat = new SimpleDateFormat("yyyy.MM.dd", Locale.CHINA);
                strCurDate = sDateFormat.format(new Date());
                Log.d("readLogOfCurDay", "strCurDate = " + strCurDate);
                try {
                    file = new File(fileName);
                    fis = new FileInputStream(file);
                    in = new BufferedInputStream(fis);
                    isr = new InputStreamReader((InputStream)in, FileUtil.getFileEncoding(fileName));
                    reader = new BufferedReader(isr);
                    String strDate = null;
                    String strLog = null;
                    while ((strDate = reader.readLine()) != null) {
                        if (!FileUtil.isLogOfCurDay(strDate, strCurDate)) continue;
                        strLog = reader.readLine();
                        strArray.add(strDate + "\n" + strLog);
                    }
                    strDate = null;
                    strLog = null;
                    msg.what = 0;
                    handler.sendMessage(msg);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {}
                    }
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFile(String fileName, String message) {
        FileOutputStream fileOut = null;
        boolean result = false;
        File file = new File(fileName);
        try {
            fileOut = new FileOutputStream(file);
            byte[] buffer = message.getBytes();
            fileOut.write(buffer);
            result = true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            result = false;
        }
        catch (IOException e) {
            e.printStackTrace();
            result = false;
        }
        finally {
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    public static boolean copyAssetsToPrivatePath(Context context, String srcFileName, File toFile) {
        AssetManager am = null;
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            am = context.getAssets();
            is = am.open(srcFileName);
            fos = new FileOutputStream(toFile);
            byte[] buffer = new byte[1024];
            int count = 0;
            while ((count = is.read(buffer)) > 0) {
                fos.write(buffer, 0, count);
            }
            fos.flush();
            fos.close();
            is.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            return false;
        }
    }

    public static Properties loadProperties(InputStream in) {
        Properties properties = new Properties();
        try {
            Log.d("FileUtil", "properties.load");
            properties.load(in);
            Log.d("FileUtil", "properties.load success");
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return properties;
    }

    public static int saveProperties(String filename, Properties properties) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            properties.save(fos, "");
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return -1;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }
}

